﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Entities.EntitiesFieldsNames.Hr;

/// <summary>
/// Klasa przechowująca nazwy pól magazynu plantacji czytelne dla użytkownika.
/// </summary>
public static class PlantationStorageFieldsHrNames
{
    /// <summary>
    /// Nazwa pola opisującego bieżące doświadczenie plantacji.
    /// </summary>
    public const string CurrExp = "Bieżące doświadczenie";
    
    /// <summary>
    /// Nazwa pola opisującego doświadczenie potrzebne do osiągnięcia następnego poziomu plantacji.
    /// </summary>
    public const string ExpToNextLevel = "Doświadczenie do następnego poziomu";
    
    
    /// <summary>
    /// Nazwa pola opisującego żeton zadania w magazynie plantacji.
    /// </summary>
    public const string QuestToken = "Żeton zadania";
    
    /// <summary>
    /// Nazwa pola opisującego żeton dealera w magazynie plantacji.
    /// </summary>
    public const string DealerToken = "Żeton dealera";
    
    /// <summary>
    /// Nazwa pola opisującego żeton czarnego rynku w magazynie plantacji.
    /// </summary>
    public const string BlackMarketToken = "Żeton czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego żeton dona w magazynie plantacji.
    /// </summary>
    public const string DonToken = "Żeton dona";
    
    /// <summary>
    /// Nazwa pola opisującego żeton odblokowania w magazynie plantacji.
    /// </summary>
    public const string UnlockToken = "Żeton odblokowania";
    
    /// <summary>
    /// Nazwa pola opisującego prestiż plantacji.
    /// </summary>
    public const string Prestige = "Prestiż";
    
    
    /// <summary>
    /// Nazwa pola opisującego ilość używanych slotów na wzmocnienia w magazynie plantacji.
    /// </summary>
    public const string BuffSlotsInUse = "Używane sloty na wzmocnienia";
    
    /// <summary>
    /// Nazwa pola opisującego ilość używanych slotów na artefakty w magazynie plantacji.
    /// </summary>
    public const string ArtifactSlotsInUse = "Używane sloty na artefakty";
    
    /// <summary>
    /// Nazwa pola opisującego ilość rozpoczętych zadań dziennych w magazynie plantacji.
    /// </summary>
    public const string StartedDailyQuestsCount = "Ilość rozpoczętych zadań dziennych";
    
    /// <summary>
    /// Nazwa pola opisującego ilość rozpoczętych zadań tygodniowych w magazynie plantacji.
    /// </summary>
    public const string StartedWeeklyQuestsCount = "Ilość rozpoczętych zadań tygodniowych";
    
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną liczbę slotów na wzmocnienia w magazynie plantacji.
    /// </summary>
    public const string MaxBuffsSlots = "Maksymalne sloty na wzmocnienia";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną liczbę slotów na artefakty w magazynie plantacji.
    /// </summary>
    public const string MaxArtifactSlots = "Maksymalne sloty na artefakty";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną liczbę dziennych zadań w magazynie plantacji.
    /// </summary>
    public const string MaxDailyQuestsCount = "Maksymalna liczba dziennych zadań";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną liczbę tygodniowych zadań w magazynie plantacji.
    /// </summary>
    public const string MaxWeeklyQuestsCount = "Maksymalna liczba tygodniowych zadań";
    
    
    /// <summary>
    /// Nazwa pola opisującego odblokowane miejsca na wzmocnienia w magazynie plantacji.
    /// </summary>
    public const string UnlockedBuffsSlots = "Odblokowane miejsca na wzmocnienie";
    
    /// <summary>
    /// Nazwa pola opisującego odblokowane miejsca na artefakty w magazynie plantacji.
    /// </summary>
    public const string UnlockedArtifactSlots = "Odblokowane miejsca na artefakty";
    
    /// <summary>
    /// Nazwa pola opisującego liczbę odblokowanych dziennych zadań w magazynie plantacji.
    /// </summary>
    public const string UnlockedDailyQuestsCount = "Liczba odblokowanych codziennych zadań";
    
    /// <summary>
    /// Nazwa pola opisującego liczbę odblokowanych tygodniowych zadań w magazynie plantacji.
    /// </summary>
    public const string UnlockedWeeklyQuestsCount = "Liczba odblokowanych tygodniowych zadań";
}