﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Entities.EntitiesFieldsNames.Hr;

/// <summary>
/// Klasa przechowująca nazwy pól roślin czytelne dla użytkownika.
/// </summary>
public static class PlantFieldsHrNames
{
    /// <summary>
    /// Nazwa pola opisującego nazwę rośliny.
    /// </summary>
    public const string Name = "Nazwa";
    
    /// <summary>
    /// Nazwa pola opisującego opis rośliny.
    /// </summary>
    public const string Description = "Opis";
    
    /// <summary>
    /// Nazwa pola opisującego poziom wzrostu rośliny.
    /// </summary>
    public const string GrowingLevel = "Poziom wzrostu";
    
    /// <summary>
    /// Nazwa pola opisującego poziom więdnięcia rośliny.
    /// </summary>
    public const string WiltLevel = "Poziom więdnięcia";
    
    /// <summary>
    /// Nazwa pola opisującego adres URL zdjęcia rośliny.
    /// </summary>
    public const string ImageUrl = "Adres url zdjęcia rośliny";
    
    /// <summary>
    /// Nazwa pola opisującego szybkość wzrostu rośliny.
    /// </summary>
    public const string GrowingSpeed = "Szybkość wzrostu";
    
    /// <summary>
    /// Nazwa pola opisującego szansę na nasiona z rośliny.
    /// </summary>
    public const string ChanceForSeed = "Szansa na nasiona";
    
    /// <summary>
    /// Nazwa pola opisującego czas niewrażliwości rośliny.
    /// </summary>
    public const string TimeOfInsensitivity = "Czas niewrażliwości";
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanego suszu z rośliny.
    /// </summary>
    public const string DriedFruitAmount = "Ilość otrzymanego suszu";
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych nasion z rośliny.
    /// </summary>
    public const string SeedAmount = "Ilość otrzymanych nasion";
    
    /// <summary>
    /// Nazwa pola opisującego zdobyte doświadczenie z rośliny.
    /// </summary>
    public const string GainedExp = "Zdobyte doświadczenie";
    
    /// <summary>
    /// Nazwa pola opisującego pozostały czas do urośnięcia rośliny.
    /// </summary>
    public const string TimeRemaining = "Czas do urośnięcia";
    
    /// <summary>
    /// Nazwa pola opisującego dzielnik wzrostu rośliny.
    /// </summary>
    public const string GrowingSpeedDivider = "Dzielnik wzrostu rośliny";
    
    /// <summary>
    /// Nazwa pola opisującego prędkość więdnięcia rośliny.
    /// </summary>
    public const string WiltSpeed = "Prędkość więdnięcia";
    
    /// <summary>
    /// Nazwa pola opisującego wzmocnienie wzrostu rośliny z zestawów.
    /// </summary>
    public const string SetsBaf = "Wzmocnienie wzrostu z setów";
}