﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Entities.EntitiesFieldsNames.Hr;

/// <summary>
/// Klasa przechowująca nazwy pól nagród czytelnych dla użytkownika.
/// </summary>
public static class DropFieldsHrNames
{
    /// <summary>
    /// Nazwa pola opisującego nazwę nagrody.
    /// </summary>
    public const string Name = "Nazwa";
    
    /// <summary>
    /// Nazwa pola opisującego ilość przedmiotu w nagrodzie.
    /// </summary>
    public const string ItemAmount = "Ilość przedmiotu (w zadaniu i tak zawsze 1)";
    
    /// <summary>
    /// Nazwa pola opisującego szansę na otrzymanie nagrody.
    /// </summary>
    public const string ChanceForDrop = "Szansa na nagrodę (puste lub 0 to 100%)";
    
    /// <summary>
    /// Nazwa pola opisującego prestiż z nagrody.
    /// </summary>
    public const string Prestige = "Prestiż";
    
    /// <summary>
    /// Nazwa pola opisującego doświadczenie z nagrody.
    /// </summary>
    public const string Experience = "Doświadczenie";
    
    /// <summary>
    /// Nazwa pola opisującego ilość złota w nagrodzie.
    /// </summary>
    public const string Gold = "Złoto";
    
    /// <summary>
    /// Nazwa pola opisującego żeton zadania w nagrodzie.
    /// </summary>
    public const string QuestToken = "Żeton zadania";
    
    /// <summary>
    /// Nazwa pola opisującego żeton dealera w nagrodzie.
    /// </summary>
    public const string DealerToken = "Żeton dealera";
    
    /// <summary>
    /// Nazwa pola opisującego żeton czarnego rynku w nagrodzie.
    /// </summary>
    public const string BlackMarketToken = "Żeton czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego żeton dona w nagrodzie.
    /// </summary>
    public const string DonToken = "Żeton dona";
    
    /// <summary>
    /// Nazwa pola opisującego żeton odblokowania w nagrodzie.
    /// </summary>
    public const string UnlockToken = "Żeton odblokowania";
    
    /// <summary>
    /// Nazwa pola opisującego honor z nagrody.
    /// </summary>
    public const string Honor = "Honor";
}