﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Entities.EntitiesFieldsNames.Hr;

/// <summary>
/// Klasa przechowująca nazwy pól dzielnicy czytelne dla użytkownika.
/// </summary>
public static class DistrictFieldsHrNames
{
    /// <summary>
    /// Nazwa pola opisującego nazwę dzielnicy.
    /// </summary>
    public const string Name = "Nazwa";
    
    /// <summary>
    /// Nazwa pola opisującego czas startu dzielnicy.
    /// </summary>
    public const string StartTime = "Czas startu";
    
    /// <summary>
    /// Nazwa pola opisującego czas końca dzielnicy.
    /// </summary>
    public const string EndTime = "Czas końca";
    
    /// <summary>
    /// Nazwa pola opisującego czas cykliczności dzielnicy.
    /// </summary>
    public const string CyclicTime = "Czas cykliczności (minuty)";
    
    /// <summary>
    /// Nazwa pola opisującego prędkość więdnięcia dzielnicy.
    /// </summary>
    public const string WiltSpeed = "Prędkość więdnięcia";
    
    /// <summary>
    /// Nazwa pola opisującego dzielnik wzrostu dla dzielnicy.
    /// </summary>
    public const string GrowingSpeedDivider = "Dzielnik wzrostu dzielnicy";
    
    
    /// <summary>
    /// Nazwa pola opisującego cenę dziupli w dzielnicy.
    /// </summary>
    public const string HollowPrice = "Cena dziupli";
    
    /// <summary>
    /// Nazwa pola opisującego ilość startowej kasy.
    /// </summary>
    public const string StartGold = "Ilość startowej kasy";
    
    /// <summary>
    /// Nazwa pola opisującego wymagane doświadczenie do następnego poziomu.
    /// </summary>
    public const string StartExpToNextLevel = "Doświadczenie do następnego poziomu";
    
    /// <summary>
    /// Nazwa pola opisującego wymagany poziom gracza.
    /// </summary>
    public const string PlayerLevelRequirement = "Wymagany poziom gracza";
    
    /// <summary>
    /// Nazwa pola opisującego czy dzielnica jest zdefiniowana.
    /// </summary>
    public const string IsDefined = "Czy jest zdefiniowana";
    
    
    /// <summary>
    /// Nazwa pola opisującego ilość honoru za zajęcie pierwszego miejsca.
    /// </summary>
    public const string HonorForTakingFirstPlace = "Ilość honoru za zajęcie pierwszego miejsca";
    
    /// <summary>
    /// Nazwa pola opisującego ilość honoru za zajęcie drugiego miejsca.
    /// </summary>
    public const string HonorForTakingSecondPlace = "Ilość honoru za zajęcie drugiego miejsca";
    
    /// <summary>
    /// Nazwa pola opisującego ilość honoru za zajęcie trzeciego miejsca.
    /// </summary>
    public const string HonorForTakingThirdPlace = "Ilość honoru za zajęcie trzeciego miejsca";
    
    /// <summary>
    /// Nazwa pola opisującego ilość honoru jako nagroda pocieszenia.
    /// </summary>
    public const string HonorConsolationPrize = "Ilość honoru jako nagroda pocieszenia";
    
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną liczbę miejsc na wzmocnienia.
    /// </summary>
    public const string MaxBuffsSlots = "Maksymalna liczba miejsc na wzmocnienia";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną liczbę miejsc na artefakty.
    /// </summary>
    public const string MaxArtifactSlots = "Maksymalna liczba miejsc na artefakty";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną liczbę dziennych zadań.
    /// </summary>
    public const string MaxDailyQuestsCount = "Maksymalna liczba dziennych zadań";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną liczbę tygodniowych zadań.
    /// </summary>
    public const string MaxWeeklyQuestsCount = "Maksymalna liczba tygodniowych zadań";
        
    
    /// <summary>
    /// Nazwa pola opisującego odblokowane miejsca wzmocnień na starcie.
    /// </summary>
    public const string UnlockedBuffsSlotsOnStart = "Odblokowane miejsca wzmocnień na starcie";
    
    /// <summary>
    /// Nazwa pola opisującego odblokowane miejsca artefaktów na starcie.
    /// </summary>
    public const string UnlockedArtifactSlotsOnStart = "Odblokowane miejsca artefaktów na starcie";
    
    /// <summary>
    /// Nazwa pola opisującego odblokowane miejsca zadań dziennych na starcie.
    /// </summary>
    public const string UnlockedDailyQuestsOnStart = "Odblokowane miejsca zadań dziennych na starcie";
    
    /// <summary>
    /// Nazwa pola opisującego odblokowane miejsca zadań tygodniowych na starcie.
    /// </summary>
    public const string UnlockedWeeklyQuestsOnStart = "Odblokowane miejsca zadań tygodniowych na starcie";
    
    
    /// <summary>
    /// Nazwa pola opisującego kurs wymiany złota.
    /// </summary>
    public const string GoldExchangeRate = "Kurs wymiany złota";
    
    /// <summary>
    /// Nazwa pola opisującego kurs wymiany prestiżu.
    /// </summary>
    public const string PrestigeExchangeRate = "Kurs wymiany prestiżu";
    
    /// <summary>
    /// Nazwa pola opisującego kurs wymiany żetonu zadania.
    /// </summary>
    public const string QuestTokenExchangeRate = "Kurs wymiany żetonu zadania";
    
    /// <summary>
    /// Nazwa pola opisującego kurs wymiany żetonu dealera.
    /// </summary>
    public const string DealerTokenExchangeRate = "Kurs wymiany żetonu dealera";
    
    /// <summary>
    /// Nazwa pola opisującego kurs wymiany żetonu czarnego rynku.
    /// </summary>
    public const string BlackMarketTokenExchangeRate = "Kurs wymiany żetonu czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego kurs wymiany żetonu dona.
    /// </summary>
    public const string DonTokenExchangeRate = "Kurs wymiany żetonu dona";
    
    /// <summary>
    /// Nazwa pola opisującego kurs wymiany żetonu odblokowania.
    /// </summary>
    public const string UnlockTokenExchangeRate = "Kurs wymiany żetonu odblokowania";
    
    
    /// <summary>
    /// Nazwa pola opisującego szansę na żeton zadania z ukończonego zadania.
    /// </summary>
    public const string QuestTokenChanceFromCompleteQuest = "Szansa na żeton zadania z ukończonego zadania";
    
    /// <summary>
    /// Nazwa pola opisującego szansę na żeton dealera z strefy klienta.
    /// </summary>
    public const string DealerTokenChanceFromCustomerZone = "Szansa na żeton dealera z strefy klienta";
    
    /// <summary>
    /// Nazwa pola opisującego szansę na żeton czarnego rynku z transakcji na czarnym rynku.
    /// </summary>
    public const string BlackMarketTokenChanceForBlackMarketTransaction = "Szansa na żeton czarnego rynku z transakcji na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego szansę na żeton dona z transakcji sprzedaży na czarnym rynku.
    /// </summary>
    public const string DonTokenChanceFromSellBlackMarketTransaction = "Szansa na żeton Dona z transakcji sprzedaży na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego szansę na żeton odblokowania podczas zbierania roślin.
    /// </summary>
    public const string UnlockTokenChanceForCollectPlant = "Szansa na żeton odblokowania podczas zbierania roślin";
    
    
    /// <summary>
    /// Nazwa pola opisującego procent haraczu dla Dona.
    /// </summary>
    public const string DonCharityPercentage = "Procent haraczu dla Dona";
    
    /// <summary>
    /// Nazwa pola opisującego prestiż, aby zostać Donem.
    /// </summary>
    public const string PrestigeToBecomeDon = "Prestiż, aby zostać Donem";
    
    /// <summary>
    /// Nazwa pola opisującego, że zadania o tyle poziomów niższe nie będą już dostępne.
    /// </summary>
    public const string LessLevelDoNotTakeQuests = "Zadania o tyle poziomów niższe nie będą już dostępne";
    
    /// <summary>
    /// Nazwa pola opisującego szansę na specjalną ofertę w Strefie Klienta.
    /// </summary>
    public const string ChanceForSpecialOfferInCustomerZone = "Szansa na specjalną ofertę w Strefie Klienta";
    
    
    /// <summary>
    /// Nazwa pola opisującego standardową ilość oferty w strefie klienta. Dolny zakres.
    /// </summary>
    public const string StandardOfferQuantityLowerRangeInCustomerZone = "Standardowa ilość oferty w strefie klienta. Dolny zakres";
    
    /// <summary>
    /// Nazwa pola opisującego standardową ilość oferty w strefie klienta. Górny zakres.
    /// </summary>
    public const string StandardOfferQuantityHighRangeInCustomerZone = "Standardowa ilość oferty w strefie klienta. Górny zakres";
    
    /// <summary>
    /// Nazwa pola opisującego ilość oferty specjalnej w Strefie Klienta. Dolny zakres.
    /// </summary>
    public const string SpecialOfferQuantityLowerRangeInCustomerZone = "Ilość oferty specjalnej w Strefie Klienta. Dolny zakres";
    
    /// <summary>
    /// Nazwa pola opisującego ilość oferty specjalnej w Strefie Klienta. Górny zakres.
    /// </summary>
    public const string SpecialOfferQuantityHighRangeInCustomerZone = "Ilość oferty specjalnej w Strefie Klienta. Górny zakres";
    
    
    /// <summary>
    /// Nazwa pola opisującego czas oferty w strefie klienta.
    /// </summary>
    public const string OfferTimeInCustomerZone = "Czas oferty w strefie klienta (milisekundy)";
    
    /// <summary>
    /// Nazwa pola opisującego szansę na zapłatę haraczu don'owi przez pracownika czarnego rynku.
    /// </summary>
    public const string ChanceForPayDonTribute = "Szansa na zapłatę haraczu don'owi przez pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną liczbę transakcji na czarnym rynku.
    /// </summary>
    public const string MaxBlackMarketTransactionsCount = "Maksymalna liczba transakcji na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego szansę dodania transakcji do losowania w zakupie na czarnym rynku.
    /// </summary>
    public const string ChanceForAddBuyBlackMarketTransaction = "Szansa dodania transakcji do losowania w zakupie na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego szansę na wystawienie transakcji nasiona przeciwko suszowi na czarnym rynku.
    /// </summary>
    public const string ChanceForIssueSeedAgainstDriedFruitInBlackMarket = "Szansa na wystawienie transakcji nasiona przeciwko suszowi na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego szansę dodania transakcji do losowania w wystawieniu na czarnym rynku.
    /// </summary>
    public const string ChanceForAddIssueBlackMarketTransaction = "Szansa dodania transakcji do losowania w wystawieniu na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego czy pracownik czarnego rynku ma skupować wszystkie transakcje graczy.
    /// </summary>
    public const string BuyUsersTransactions = "Czy pracownik czarnego rynku ma skupować wszystkie transakcje graczy";
    
    /// <summary>
    /// Nazwa pola opisującego ile transakcji z wylosowanych ma zostać kupione przez pracownika czarnego rynku.
    /// </summary>
    public const string NumberDrawnTransactionsToBuy = "Ile transakcji z wylosowanych ma zostać kupione przez pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego ile transakcji z wylosowanych ma zostać wystawione przez pracownika czarnego rynku.
    /// </summary>
    public const string NumberDrawnTransactionsToIssue = "Ile transakcji z wylosowanych ma zostać wystawione przez pracownika czarnego rynku";
    
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną ilość wystawianego suszu przez pracownika czarnego rynku.
    /// </summary>
    public const string BlackMarketIssueQuantityForDriedFruit = "Maksymalna ilość wystawianego suszu przez pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną ilość wystawianych lamp przez pracownika czarnego rynku.
    /// </summary>
    public const string BlackMarketIssueQuantityForLamp = "Maksymalna ilość wystawianych lamp przez pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną ilość wystawianego nawozu przez pracownika czarnego rynku.
    /// </summary>
    public const string BlackMarketIssueQuantityForManure = "Maksymalna ilość wystawianego nawozu przez pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną ilość wystawianych doniczek przez pracownika czarnego rynku.
    /// </summary>
    public const string BlackMarketIssueQuantityForPot = "Maksymalna ilość wystawianych doniczek przez pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną ilość wystawianych nasion przez pracownika czarnego rynku.
    /// </summary>
    public const string BlackMarketIssueQuantityForSeed = "Maksymalna ilość wystawianych nasion przez pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną ilość wystawianej gleby przez pracownika czarnego rynku.
    /// </summary>
    public const string BlackMarketIssueQuantityForSoil = "Maksymalna ilość wystawianej gleby przez pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną ilość wystawianej wody przez pracownika czarnego rynku.
    /// </summary>
    public const string BlackMarketIssueQuantityForWater = "Maksymalna ilość wystawianej wody przez pracownika czarnego rynku";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną ilość wystawianych bonusów przez pracownika czarnego rynku.
    /// </summary>
    public const string BlackMarketIssueQuantityForBonus = "Maksymalna ilość wystawianych bonusów przez pracownika czarnego rynku";
    
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów za zadanie typu osiągnięcie/dzienne/inne.
    /// </summary>
    public const string QuestTokenForAchievementDailyOthersAmount = "Ilość otrzymanych żetonów za zadanie typu osiągnięcie/dzienne/inne";
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów za zadanie typu wydarzenie.
    /// </summary>
    public const string QuestTokenForEventAmount = "Ilość otrzymanych żetonów za zadanie typu wydarzenie";
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów za zadanie typu tygodniowe.
    /// </summary>
    public const string QuestTokenForWeeklyAmount = "Ilość otrzymanych żetonów za zadanie typu tygodniowe";
    
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów dealera w strefie klienta przy sprzedanej ilości większej niż 100.
    /// </summary>
    public const string DealerTokenWithItemAmountMoreThan100 = "Ilość otrzymanych żetonów dealera w strefie klienta przy sprzedanej ilości większej niż 100";
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów dealera w strefie klienta przy sprzedanej ilości większej niż 10.
    /// </summary>
    public const string DealerTokenWithItemAmountMoreThan10 = "Ilość otrzymanych żetonów dealera w strefie klienta przy sprzedanej ilości większej niż 10";
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów dealera w strefie klienta przy sprzedanej ilości mniejszej niż 11.
    /// </summary>
    public const string DealerTokenWithItemAmountLessThan11 = "Ilość otrzymanych żetonów dealera w strefie klienta przy sprzedanej ilości mniejszej niż 11";
    
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów czarnego rynku przy wartości sprzedaży większej niż 100 000.
    /// </summary>
    public const string BlackMarketTokenWithCostMoreThan100000 = "Ilość otrzymanych żetonów czarnego rynku przy wartości sprzedaży większej niż 100 000";
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów czarnego rynku przy wartości sprzedaży większej niż 10 000.
    /// </summary>
    public const string BlackMarketTokenWithCostMoreThan10000 = "Ilość otrzymanych żetonów czarnego rynku przy wartości sprzedaży większej niż 10 000";
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów czarnego rynku przy wartości sprzedaży większej niż 5 000.
    /// </summary>
    public const string BlackMarketTokenWithCostMoreThan5000 = "Ilość otrzymanych żetonów czarnego rynku przy wartości sprzedaży większej niż 5 000";
    
    /// <summary>
    /// Nazwa pola opisującego ilość otrzymanych żetonów czarnego rynku przy wartości sprzedaży mniejszej niż 5 001.
    /// </summary>
    public const string BlackMarketTokenWithCostLessThan5001 = "Ilość otrzymanych żetonów czarnego rynku przy wartości sprzedaży mniejszej niż 5 001";
    
    
    /// <summary>
    /// Nazwa pola opisującego imię opiekuna dzielnicy.
    /// </summary>
    public const string WardenName = "Opiekun";
}