﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Entities.EntitiesFieldsNames.Hr;

/// <summary>
/// Klasa przechowująca nazwy pól bonusów czytelne dla użytkownika.
/// </summary>
public static class BonusFieldsHrNames
{
    /// <summary>
    /// Nazwa pola opisującego czy bonus jest aktywny.
    /// </summary>
    public const string IsActive = "Czy jest aktywny";
    
    /// <summary>
    /// Nazwa pola opisującego pozostały aktywny czas bonusu.
    /// </summary>
    public const string RemainingActiveTime = "Pozostały aktywny czas";
    
    /// <summary>
    /// Nazwa pola opisującego czas aktywności bonusu po użyciu.
    /// </summary>
    public const string ActiveTimePerUse = "Czas aktywności po użyciu (sekundy)";
    
    /// <summary>
    /// Nazwa pola opisującego kolor bonusu.
    /// </summary>
    public const string Color = "Kolor (eng lub hex np. #00FF99)";
    
    /// <summary>
    /// Nazwa pola opisującego liczbę użyc bonusu.
    /// </summary>
    public const string Usages = "Użycia";
    
    /// <summary>
    /// Nazwa pola opisującego czy czas aktywności bonusu jest stakowalny.
    /// </summary>
    public const string IsStackable = "Czy czas jest stakowalny";
    
    /// <summary>
    /// Nazwa pola opisującego zwiększenie szansy na nagrody z zadań.
    /// </summary>
    public const string IncreaseDropChanceFromQuests = "Zwiększenie szansy na nagrody z zadań.";
    
    /// <summary>
    /// Nazwa pola opisującego czy bonus jest artefaktem.
    /// </summary>
    public const string IsArtifact = "Jest artefaktem";
    
    /// <summary>
    /// Nazwa pola opisującego koszt włożenia artefaktu.
    /// </summary>
    public const string ArtifactPutCost = "Koszt włożenia artefaktu";
    
    /// <summary>
    /// Nazwa pola opisującego koszt wyciągnięcia artefaktu.
    /// </summary>
    public const string ArtifactPullCost = "Koszt wyciągnięcia artefaktu";
}