﻿namespace CzuczenLand.ExtendingFunctionalities.Consts.Entities.EntitiesFieldsNames.Hr;

/// <summary>
/// Klasa przechowująca nazwy pól transakcji na czarnym rynku czytelne dla użytkownika.
/// </summary>
public static class BlackMarketTransactionFieldsHrNames
{
    /// <summary>
    /// Nazwa pola opisującego identyfikator przedmiotu.
    /// </summary>
    public const string ItemId = "Id przedmiotu";
    
    /// <summary>
    /// Nazwa pola opisującego nazwę przedmiotu.
    /// </summary>
    public const string ItemName = "Nazwa przedmiotu";
    
    /// <summary>
    /// Nazwa pola opisującego nazwę encji przedmiotu.
    /// </summary>
    public const string ItemEntityName = "Nazwa encji przedmiotu";
    
    /// <summary>
    /// Nazwa pola opisującego nazwę sprzedawcy.
    /// </summary>
    public const string SellerName = "Nazwa sprzedawcy";
    
    /// <summary>
    /// Nazwa pola opisującego cenę przedmiotu.
    /// </summary>
    public const string Price = "Cena";
    
    /// <summary>
    /// Nazwa pola opisującego ilość przedmiotów w transakcji.
    /// </summary>
    public const string Quantity = "Ilość";
    
    /// <summary>
    /// Nazwa pola opisującego identyfikator dzielnicy.
    /// </summary>
    public const string DistrictId = "Id dzielnicy";
    
    /// <summary>
    /// Nazwa pola opisującego maksymalną cenę sprzedaży na czarnym rynku.
    /// </summary>
    public const string BlackMarketMaxSellPrice = "Maksymalna cena na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego minimalną cenę sprzedaży na czarnym rynku.
    /// </summary>
    public const string BlackMarketMinSellPrice = "Minimalna cena na czarnym rynku";
    
    /// <summary>
    /// Nazwa pola opisującego ilość posiadanych przedmiotów.
    /// </summary>
    public const string OwnedAmount = "Posiadana ilość";
    
    /// <summary>
    /// Nazwa pola opisującego ilość miejsc po przecinku w polu ilości.
    /// </summary>
    public const string QuantityInputStep = "Ile pole ma mieć miejsc po przecinku";
}