# <a href="https://www.jschallenger.com/" target="_blank"><img src="./assets/logo.svg" alt="js challenger logo"></a>

## **Welcome !** 👋

Thanks for checking out this [js-challenger solutions repo](https://github.com/CyrusKabir/js-challenger).

## **What is JSchallenger ?** 🙂

JSchallenger is a cool and great site to practice most of the JS fundamentals and JS dom. It's a very helpful Javascript resource for beginners. JSchallenger created by [Erik Kückelheim](https://www.erik-kueckelheim.com/). thanks Erik.

## **Why this repo ?** 😶

In this repo, you can find available solutions for a challenge.

Also for leetcode challenges you can check this repo :
[Leetcode solutions](https://github.com/HamidMolareza/LeetCode/tree/main/README.md)

## **Table of solutions**
- **Javascript Basics**
    <details><summary>variables</summary>

    <!-- inject tos-variables start -->
    1. [Reassign a value to a variable](#reassign-a-value-to-a-variable)
    1. [Assign a value to a variable](#assign-a-value-to-a-variable)
    1. [Assign the value of another variable](#assign-the-value-of-another-variable)
    1. [Create the missing variable](#create-the-missing-variable)
    1. [Accessing a variable 1](#accessing-a-variable-1)
    1. [Accessing a variable 2](#accessing-a-variable-2)
    1. [Declare a variable and assign a number](#declare-a-variable-and-assign-a-number)
    1. [Reassign a value to a variable 2](#reassign-a-value-to-a-variable-2)
    <!-- inject tos-variables end -->
    </details>
    <details><summary>booleans</summary>

    <!-- inject tos-booleans start -->
    1. [Assign boolean to a variable](#assign-boolean-to-a-variable)
    1. [Convert Number to Boolean](#convert-number-to-boolean)
    <!-- inject tos-booleans end -->
    </details>
    <details><summary>operators</summary>

    <!-- inject tos-operators start -->
    1. [Comparison operators - Equal](#comparison-operators---equal)
    1. [Comparison operators - Not Equal](#comparison-operators---not-equal)
    1. [Comparison operators - Greater than](#comparison-operators---greater-than)
    1. [Comparison operators - Less than](#comparison-operators---less-than)
    1. [Comparison operators - Greater than or equal](#comparison-operators---greater-than-or-equal)
    1. [Comparison operators - Less than or equal](#comparison-operators---less-than-or-equal)
    <!-- inject tos-operators end -->
    </details>
    <details><summary>strings</summary>
    
    <!-- inject tos-strings start -->
    1. [Create a Javascript string](#create-a-javascript-string)
    1. [Different ways to create Javascript strings](#different-ways-to-create-javascript-strings)
    1. [Connect Javascript strings 1](#connect-javascript-strings-1)
    <!-- inject tos-strings end -->
    </details>
    <details><summary>conditionals</summary>

    <!-- inject tos-conditionals start -->
    1. [if statement - satisfy condition](#if-statement---satisfy-condition)
    1. [if statement - add missing condition](#if-statement---add-missing-condition)
    <!-- inject tos-conditionals end -->
    </details>
    <details><summary>functions I</summary>

    <!-- inject tos-functions I start -->
    1. [Function declaration](#function-declaration)
    1. [Function expression](#function-expression)
    1. [Correctly return value from function 1](#correctly-return-value-from-function-1)
    1. [Correctly return value from function 2](#correctly-return-value-from-function-2)
    <!-- inject tos-functions I end -->
    </details>
    <details><summary>arrays</summary>

    <!-- inject tos-arrays start -->
    <!-- inject tos-arrays end -->
    </details>
    <details><summary>loops</summary>

    <!-- inject tos-loops start -->
    <!-- inject tos-loops end -->
    </details>
    <details><summary>asynchronous javascript</summary>

    <!-- inject tos-asynchronous javascript start -->
    1. [Execute the code synchronously](#execute-the-code-synchronously)
    1. [Execute the code asynchronously](#execute-the-code-asynchronously)
    <!-- inject tos-asynchronous javascript end -->
    </details>
- **Javascript Practice**
    <details><summary>Javascript fundamentals</summary>

    <!-- inject tos-Javascript fundamentals start -->
    1. [Sum two numbers](#sum-two-numbers)
    1. [Comparison operators, strict equality](#comparison-operators,-strict-equality)
    1. [Get type of value](#get-type-of-value)
    1. [Get nth character of string](#get-nth-character-of-string)
    1. [Remove first n characters of string](#remove-first-n-characters-of-string)
    1. [Get first n characters of string](#get-first-n-characters-of-string)
    1. [Find the position of one string in another](#find-the-position-of-one-string-in-another)
    1. [Extract first half of string](#extract-first-half-of-string)
    1. [Remove last n characters of string](#remove-last-n-characters-of-string)
    1. [Return the percentage of a number](#return-the-percentage-of-a-number)
    1. [Basic JavaScript math operators](#basic-javascript-math-operators)
    1. [Check whether a string contains another string and concatenate](#check-whether-a-string-contains-another-string-and-concatenate)
    1. [Check if a number is even](#check-if-a-number-is-even)
    1. [How many times does a character occur?](#how-many-times-does-a-character-occur?)
    1. [Check if a number is a whole number](#check-if-a-number-is-a-whole-number)
    1. [Multiplication, division, and comparison operators](#multiplication,-division,-and-comparison-operators)
    1. [Round a number to 2 decimal places](#round-a-number-to-2-decimal-places)
    1. [Split a number into its digits](#split-a-number-into-its-digits)
    <!-- inject tos-Javascript fundamentals end -->
    </details>
    <details><summary>Javascript arrays</summary>

    <!-- inject tos-Javascript arrays start -->
    1. [Get nth element of array](#get-nth-element-of-array)
    1. [Remove first n elements of an array](#remove-first-n-elements-of-an-array)
    1. [Get last n elements of an array](#get-last-n-elements-of-an-array)
    1. [Get first n elements of an array](#get-first-n-elements-of-an-array)
    1. [Return last n array elements](#return-last-n-array-elements)
    1. [Remove a specific array element](#remove-a-specific-array-element)
    1. [Count number of elements in JavaScript array](#count-number-of-elements-in-javascript-array)
    1. [Count number of negative values in array](#count-number-of-negative-values-in-array)
    1. [Sort an array of strings alphabetically](#sort-an-array-of-strings-alphabetically)
    1. [Sort an array of numbers in descending order](#sort-an-array-of-numbers-in-descending-order)
    1. [Calculate the sum of an array of numbers](#calculate-the-sum-of-an-array-of-numbers)
    1. [Return the average of an array of numbers](#return-the-average-of-an-array-of-numbers)
    1. [Return the longest string from an array of strings](#return-the-longest-string-from-an-array-of-strings)
    1. [Check if all array elements are equal](#check-if-all-array-elements-are-equal)
    1. [Merge an arbitrary number of arrays](#merge-an-arbitrary-number-of-arrays)
    1. [Sort array by object property](#sort-array-by-object-property)
    1. [Merge two arrays with duplicate values](#merge-two-arrays-with-duplicate-values)
    <!-- inject tos-Javascript arrays end -->
    </details>
    <details><summary>Javascript objects</summary>

    <!-- inject tos-Javascript objects start -->
    1. [Accessing object properties one](#accessing-object-properties-one)
    1. [Accessing object properties two](#accessing-object-properties-two)
    1. [Accessing object properties three](#accessing-object-properties-three)
    1. [Check if property exists in object](#check-if-property-exists-in-object)
    1. [Check if property exists in object and is truthy](#check-if-property-exists-in-object-and-is-truthy)
    1. [Creating Javascript objects one](#creating-javascript-objects-one)
    1. [Creating Javascript objects two](#creating-javascript-objects-two)
    1. [Creating Javascript objects three](#creating-javascript-objects-three)
    1. [Extract keys from Javascript object](#extract-keys-from-javascript-object)
    1. [Return nested object property](#return-nested-object-property)
    1. [Sum object values](#sum-object-values)
    1. [Remove a property from an object](#remove-a-property-from-an-object)
    1. [Merge two objects with matching keys](#merge-two-objects-with-matching-keys)
    1. [Multiply all object values by x](#multiply-all-object-values-by-x)
    <!-- inject tos-Javascript objects end -->
    </details>
    <details><summary>Javascript dates</summary>

    <!-- inject tos-Javascript dates start -->
    1. [Check if two dates are equal](#check-if-two-dates-are-equal)
    1. [Return the number of days between two dates](#return-the-number-of-days-between-two-dates)
    1. [Check if two dates fall on the exact same day](#check-if-two-dates-fall-on-the-exact-same-day)
    1. [Check if two dates are within 1 hour from each other](#check-if-two-dates-are-within-1-hour-from-each-other)
    1. [Check if one date is earlier than another](#check-if-one-date-is-earlier-than-another)
    <!-- inject tos-Javascript dates end -->
    </details>
    <details><summary>Javascript Sets</summary>

    <!-- inject tos-Javascript Sets start -->
    1. [Check if value is present in Set](#check-if-value-is-present-in-set)
    1. [Convert a Set to Array](#convert-a-set-to-array)
    1. [Get union of two sets](#get-union-of-two-sets)
    1. [Creating Javascript Sets](#creating-javascript-sets)
    1. [Delete element from Set](#delete-element-from-set)
    <!-- inject tos-Javascript Sets end -->
    </details>
- **Javascript DOM**
    <details><summary>DOM selector methods</summary>

    <!-- inject tos-DOM selector methods start -->
    1. [Select the button element on the page](#select-the-button-element-on-the-page)
    1. [Query descendent HTML elements](#query-descendent-html-elements)
    1. [Select multiple HTML elements](#select-multiple-html-elements)
    <!-- inject tos-DOM selector methods end -->
    </details>
    <details><summary>Events and user interactions</summary>

    <!-- inject tos-Events and user interactions start -->
    1. [Execute function on button click](#execute-function-on-button-click)
    1. [Execute function when cursor moves onto element](#execute-function-when-cursor-moves-onto-element)
    1. [Cursor enters and leaves element](#cursor-enters-and-leaves-element)
    <!-- inject tos-Events and user interactions end -->
    </details>
    <details><summary>DOM manipulation</summary>

    <!-- inject tos-DOM manipulation start -->
    1. [Remove element from the DOM](#remove-element-from-the-dom)
    1. [Change id of HTML element](#change-id-of-html-element)
    <!-- inject tos-DOM manipulation end -->
    </details>
    <details><summary>DOM fundamentals</summary>

    <!-- inject tos-DOM fundamentals start -->
    1. [Check the checkbox](#check-the-checkbox)
    1. [Get full-name from input](#get-full-name-from-input)
    1. [Pop the balloons](#pop-the-balloons)
    <!-- inject tos-DOM fundamentals end -->
    </details>
    <details><summary>Recursive functions</summary>

    <!-- inject tos-Recursive functions start -->
    1. [Stop and restart the moving button](#stop-and-restart-the-moving-button)
    <!-- inject tos-Recursive functions end -->
    </details>

## **Javascript Basics :**
- ### variables
    <!-- inject variables start -->
    - #### Reassign a value to a variable
        scenario :
        ```python
        Assign a new value to the variable num. The code will not work the way it is. Find the 
        mistake and fix it. Execute the corrected code.
        ```
        
        code scenario :
        ```js
        let num = 1;
        let num = 2;
        console.log(num);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let num = 1;
        num = 2;
        console.log(num);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Assign a value to a variable
        scenario :
        ```python
        Here, we declare the variable num. But, it has no value yet. Assign a value to it and run 
        the code.
        ```
        
        code scenario :
        ```js
        let num;
        console.log(num);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let num;
        num = 2;
        console.log(num);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Assign the value of another variable
        scenario :
        ```python
        Here, we have two variables numOne and numTwo. numOne already has a value. Assign 
        numTwo the value of numOne and run the code.
        ```
        
        code scenario :
        ```js
        let numOne = 5;
        let numTwo;
        console.log(numTwo);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let numOne = 5;
        let numTwo = numOne;
        console.log(numTwo);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Create the missing variable
        scenario :
        ```python
        Below, we attempt to assign the value of a variable named numOne to the variable 
        numTwo. But, that variable has not been declared yet. Declare a variable named numOne 
        and run the code.
        ```
        
        code scenario :
        ```js
        let numTwo = numOne;
        console.log(numTwo);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let numOne = 5;
        let numTwo = numOne;
        console.log(numTwo);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Accessing a variable 1
        scenario :
        ```python
        In this simple exercise we declare a variable called num and assign it a value of 5. Then 
        we try to log the value of the variable using the console.log() method.
        But, the console.log() method contains a small mistake. If you try the run the code, you 
        will see an error message.
        Fix the mistake and run the code again.
        ```
        
        code scenario :
        ```js
        const num = 5;
        console.log(Num);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const num = 5;
        console.log(num);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Accessing a variable 2
        scenario :
        ```python
        This exercise is very similar to the previous one. We declare a variable called num, assign 
        it a value of 5, and try to log it. But again, we introduced a small mistake.
        Fix the code and run it.
        ```
        
        code scenario :
        ```js
        console.log(num);
        const num = 5;
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const num = 5;
        console.log(num);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Declare a variable and assign a number
        scenario :
        ```python
        In this exercise we practice how to declare a new variable and how to assign it a number. 
        The console.log() statement below attempts to log a variable named num.
        Declare a variable with this name and assign it a number of your choice. Run the code to 
        see if the number is being logged.
        ```
        
        code scenario :
        ```js
        console.log('The value of num is: ' + num);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const num = 5;
        console.log('The value of num is: ' + num);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Reassign a value to a variable 2
        scenario :
        ```python
        Here again, we want to assign a new value to a variable that we previously declared. Again, the code will not work the way it is. Find the mistake and fix it. Execute the corrected code.
        ```
        
        code scenario :
        ```js
        const text = 'hello';
        text = 'hello world';
        console.log(text);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let text = 'hello';
        text = 'hello world';
        console.log(text);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject variables end -->
- ### booleans
    <!-- inject booleans start -->
    - #### Assign boolean to a variable
        scenario :
        ```python
        Here, we declare the variable isTrue. But, it has no value yet. Assign a boolean value to it and run the code.
        ```
        
        code scenario :
        ```js
        let isTrue;

        console.log(isTrue);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let isTrue;
        isTrue = true;
        console.log(isTrue);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Convert Number to Boolean
        scenario :
        ```python
        Here, we declare the variable num and assign it the value 5. We also declare the variable bool which we assign the boolean 
        representation of num.
        Extend the code such that the console.log() statement logs false.
        ```
        
        code scenario :
        ```js
        let num = 5;
        
        const bool = Boolean(bool);
        console.log(bool);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let num = 5;
        num = 0;
        const bool = Boolean(bool);
        console.log(bool);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject booleans end -->
- ### operators
    <!-- inject operators start -->
    - #### Comparison operators - Equal
        scenario :
        ```python
        In the console.log() statement below we use the Equal operator to check whether numOne and numTwo have the same value. Change the code so that the console.log() statement logs true.
        ```
        
        code scenario :
        ```js
        const numOne = 5;
        const numTwo = 6;
        console.log(numOne == numTwo);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const numOne = 5;
        const numTwo = 5;
        console.log(numOne == numTwo);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Comparison operators - Not Equal
        scenario :
        ```python
        In the console.log() statement below we use the Not Equal operator to check whether numOne and numTwo have different values. Change the code so that the console.log() statement logs true.
        ```
        
        code scenario :
        ```js
        const numOne = 5;
        const numTwo = 5;
        console.log(numOne != numTwo);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const numOne = 5;
        const numTwo = 6;
        console.log(numOne != numTwo);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Comparison operators - Greater than
        scenario :
        ```python
        In the console.log() statement below we use the Greater Than operator to check whether the value of numOne is greater than the value of numTwo. Change the code so that the console.log() statement logs true.
        ```
        
        code scenario :
        ```js
        const numOne = 5;
        const numTwo = 6;
        console.log(numOne > numTwo);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const numOne = 6;
        const numTwo = 5;
        console.log(numOne > numTwo);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Comparison operators - Less than
        scenario :
        ```python
        In the console.log() statement below we use the Less Than operator to check whether the value of numOne is less than the value of numTwo. Change the code so that the console.log() statement logs true.
        ```
        
        code scenario :
        ```js
        const numOne = 2;
        const numTwo = 1;
        console.log(numOne < numTwo);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const numOne = 1;
        const numTwo = 2;
        console.log(numOne < numTwo);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Comparison operators - Greater than or equal
        scenario :
        ```python
        In the console.log() statement below we use the Greater Than Or Equal operator to check whether the value of numOne is greater than or equal the value of numTwo. It also checks whether the value of numTwo is greater than or equal the value of numThree. Change the code so that both expressions in the console.log() statement logs true.
        ```
        
        code scenario :
        ```js
        const numOne = 3;
        const numTwo = 4;
        const numThree = 2;
        console.log(numOne >= numTwo, numTwo >= numThree);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const numOne = 3;
        const numTwo = 2;
        const numThree = 2;
        console.log(numOne >= numTwo, numTwo >= numThree);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Comparison operators - Less than or equal
        scenario :
        ```python
        In the console.log() statement below we use the Less Than Or Equal operator to check whether the value of numOne is less than or equal the value of numTwo. It also checks whether the value of numTwo is less than or equal the value of numThree. Change the code so that both expressions in the console.log() statement logs true.
        ```
        
        code scenario :
        ```js
        const numOne = 1;
        const numTwo = 4;
        const numThree = 2;
        console.log(numOne <= numTwo, numTwo <= numThree);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const numOne = 1;
        const numTwo = 1;
        const numThree = 2;
        console.log(numOne <= numTwo, numTwo <= numThree);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject operators end -->
- ### strings
    <!-- inject strings start -->
    - #### Create a Javascript string
        scenario :
        ```python
        In this exercise the existing console.log() statement logs the value of the variable text. The variable text has already been declared with an empty string – as indicated by the two single quotes.
        Fill in the string with some characters and run the code to see if the string is being logged.
        ```
        
        code scenario :
        ```js
        const text = '';
        console.log('The value of text is: ' + text);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const text = 'hello world';
        console.log('The value of text is: ' + text);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Different ways to create Javascript strings
        scenario :
        ```python
        Here, we have declared 3 variables textOne, textTwo, and textThree. An empty string is assigned to all of them.
        Do you see how in each case different symbols are used to create the string? All three of them are valid methods to create a JavaScript string.
        Fill in all 3 strings with some characters and run the code to see if the values get logged.In this exercise the existing console.log() statement logs the value of the variable text. The variable text has already been declared with an empty string – as indicated by the two single quotes.
        Fill in the string with some characters and run the code to see if the string is being logged.
        ```
        
        code scenario :
        ```js
        const textOne = '';
        const textTwo = "";
        const textThree = ``;
        console.log(textOne, textTwo, textThree);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const textOne = 'Hello, ';
        const textTwo = "it's ";
        const textThree = `me`;
        console.log(textOne, textTwo, textThree);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Connect Javascript strings 1
        scenario :
        ```python
        After we have learnt how to create JavaScript strings, we will now connect 2 strings together. In the code below we use the Addition (+) operator to concatenate textOne and textTwo. The console.log() statement logs the resulting string. Currently, the result would be HelloWorld.
        Change the code below so that the value of res is Hello World
        ```
        
        code scenario :
        ```js
        const textOne = 'Hello';
        const textTwo = 'World';
        const combined = textOne + textTwo;
        console.log(combined);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const textOne = 'Hello';
        const textTwo = 'World';
        const combined = textOne + ' ' + textTwo;
        console.log(combined);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject strings end -->
- ### conditionals
    <!-- inject conditionals start -->
    - #### if statement - satisfy condition
        scenario :
        ```python
        In this exercise we will work with our first if-statement. In the code below we declare a variable num with a value 0. Then, we have an if-statement. The if-statement consists of a condition – the part inside the parentheses – and some code inside a pair of curly braces. The code will assign the variable num a new value 1. But it will only run if the condition is met.
        Adjust the condition such that the code inside the curly braces will execute and the console.log() statement logs true.
        ```
        
        code scenario :
        ```js
        let num = 0;
        if (1 > 2) {
           num = 1;
        }
        console.log(num === 1);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let num = 0;
        if (1 < 2) {
           num = 1;
        }
        console.log(num === 1);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### if statement - add missing condition
        scenario :
        ```python
        Time to practice what we've learnt so far. In the code below, the if...statement will assign a new value to the variable text. But only if its condition is met. Currently, the condition is missing.
        Add any condition that will be satisfied such that the console.log() statement logs true.
        ```
        
        code scenario :
        ```js
        let text = 'hello';
        if () {
           text = text + ' world';
        }
        console.log(text === 'hello world');
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let text = 'hello';
        if (text === 'hello') {
           text = text + ' world';
        }
        console.log(text === 'hello world');
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject conditionals end -->
- ### functions I
    <!-- inject functions I start -->
    - #### Function declaration
        scenario :
        ```python
        In this exercise we will work with our first JavaScript function. In the code below we create a function named func. This way of creating functions is called function declaration: the keyword function followed by the name of the function and a pair of parentheses. Then follows some JavaScript code wrapped by curly braces.
        Notice that we use the return keyword to make the function return a value, in this case a string.
        When we create a function in JavaScript, the statement inside the curly braces is exectued only when the function is called. You can call a function by using its name and a pair of parentheses func().
        Below, we call our function and assign its return value to the variable result. Then, we log the result. To solve this exercise simply have the console.log() statement log the words hello world.
        ```
        
        code scenario :
        ```js
        function func() {
            return 'hello';
        };
        const result = func();
        console.log(result);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function func() {
            return 'hello world';
        };
        const result = func();
        console.log(result);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Function expression
        scenario :
        ```python
        In this exercise, we use a slightly different way to create a function – a function expression. Here, we create a function and assign it to the variable func. Notice that we omit the name of the function after the function keyword. We call this function the same way as in the previous exercise. But, instead of using the name of the function itself, we call it using the name of the variable to which the function was assigned.
        In the code below, we introduced a small mistake when calling the function. Find the mistake and run the code to see if the words hello world are correctly logged.
        ```
        
        code scenario :
        ```js
        const func = function() {
            return 'hello world';
        };
        const result = func;
        console.log(result);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const func = function() {
            return 'hello world';
        };
        const result = func();
        console.log(result);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Correctly return value from function 1
        scenario :
        ```python
        In this exercise, we create a function func. Then, we call func and assign its return value to the variable result.
        When you run the code like this, you see that the value undefined is logged. This is the current return value of func because we do not explicitly define a return value ourselfs.
        Let func return the value of the variable text.
        ```
        
        code scenario :
        ```js
        const func = function() {
            let text = 'hello';
            text = text + ' world';
        };
        const result = func();
        console.log(result);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const func = function() {
            let text = 'hello';
            text = text + ' world';
            return text;
        };
        const result = func();
        console.log(result);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Correctly return value from function 2
        scenario :
        ```python
        In this exercise, func declares a variable text with the value hello. Then it returns the value of text. After that, it assigns a new value hello world to the variable text and returns the new value.
        But, when you run the code, you see that only the initial value of text (hello) is logged. This is because once a function call reaches a return statement, further function execution is stopped. All code after the return statement is ignored.
        Adjust the code so that the final value of text is logged.
        ```
        
        code scenario :
        ```js
        const func = function () {
            let text = 'hello';
            return text;
            text = text + ' world';
            return text;
        };
        const result = func();
        console.log(result);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const func = function () {
            let text = 'hello';
            text = text + ' world';
            return text;
        };
        const result = func();
        console.log(result);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject functions I end -->
- ### arrays
    <!-- inject arrays start -->
    <!-- inject arrays end -->
- ### loops
    <!-- inject loops start -->
    <!-- inject loops end -->
- ### asynchronous javascript
    <!-- inject asynchronous javascript start -->
    - #### Execute the code synchronously
        scenario :
        ```python
        Adjust the code snippet so that the console.log statement logs the value 2.
        ```
        
        code scenario :
        ```js
        let i = 0;
        function func() {
         i = 2;
        }
        setTimeout(func, 100)
        // expected output = 2
        console.log(i);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let i = 0;
        function func() {
         i = 2;
        }
        func();
        // expected output = 2
        console.log(i);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Execute the code asynchronously
        scenario :
        ```python
        Adjust the code snippet so that the value 0 is logged first and then the value 1.
        ```
        
        code scenario :
        ```js
        let count = 0;
        function increment() {
         count = count + 1;
        }
        increment();
        setTimeout(() => {

          console.log(count);
        }, 1000);

        console.log(count);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        let count = 0;
        function increment() {
         count = count + 1;
        }
        setTimeout(() => {
          increment();
          console.log(count);
        }, 1000);

        console.log(count);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject asynchronous javascript end -->    

## **Javascript Practice :**

- ### Javascript fundamentals
    <!-- inject Javascript fundamentals start -->
    - #### Sum two numbers
        scenario :
        ```python
        Write a function that takes two numbers (a and b) as argument
        Sum a and b
        Return the result
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a + b;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Comparison operators, strict equality
        scenario :
        ```python
        Write a function that takes two values, say a and b, as arguments
        Return true if the two values are equal and of the same type
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a === b;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Get type of value
        scenario :
        ```python
        Write a function that takes a value as argument
        Return the type of the value
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return typeof a;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Get nth character of string
        scenario :
        ```python
        Write a function that takes a string (a) and a number (n) as argument
        Return the nth character of 'a'
        ```
        
        code scenario :
        ```js
        function myFunction(a, n) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, n) {
            return a[n - 1];
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Remove first n characters of string
        scenario :
        ```python
        Write a function that takes a string (a) as argument
        Remove the first 3 characters of a
        Return the result
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.slice(3);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Get first n characters of string
        scenario :
        ```python
        Write a function that takes a string (a) as argument
        Get the first 3 characters of a
        Return the result
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.slice(0, 3);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Find the position of one string in another
        scenario :
        ```python
        Write a function that takes a string as argument
        The string contains the substring 'is'
        Return the index of 'is'
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.indexOf('is');
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Extract first half of string
        scenario :
        ```python
        Write a function that takes a string (a) as argument
        Extract the first half a
        Return the result
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.slice(0, a.length / 2);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Remove last n characters of string
        scenario :
        ```python
        Write a function that takes a string (a) as argument
        Remove the last 3 characters of a
        Return the result
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.slice(0, -3);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Return the percentage of a number
        scenario :
        ```python
        Write a function that takes two numbers (a and b) as argument
        Return b percent of a
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return b / 100 * a
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Basic JavaScript math operators
        scenario :
        ```python
        Write a function that takes 6 values (a,b,c,d,e,f) as arguments
        Sum a and b
        Then substract by c
        Then multiply by d and divide by e
        Finally raise to the power of f and return the result
        Tip: mind the order
        ```
        
        code scenario :
        ```js
        function myFunction(a, b, c, d, e, f) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b, c, d, e, f) {
            return (((a + b - c) * d) / e) ** f;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Check whether a string contains another string and concatenate
        scenario :
        ```python
        Write a function that takes two strings (a and b) as arguments. If a contains b, append b to the 
        beginning of a. If not, append it to the end. Return the concatenation
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a.indexOf(b) === -1 ? a + b : b + a
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a.includes(b) ? `${b}${a}` : `${a}${b}`
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Check if a number is even
        scenario :
        ```python
        Write a function that takes a number as argument. If the number is even, return true. Otherwise, 
        return false
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a % 2 === 0
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### How many times does a character occur?
        scenario :
        ```python
        Write a function that takes two strings (a and b) as arguments. Return the number of times a occurs in 
        b.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return b.split(a).length - 1
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Check if a number is a whole number
        scenario :
        ```python
        Write a function that takes a number (a) as argument. If a is a whole number (has no decimal place), 
        return true. Otherwise, return false.
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a - Math.floor(a) === 0
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return parseInt(a) === a
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Multiplication, division, and comparison operators
        scenario :
        ```python
        Write a function that takes two numbers (a and b) as arguments. If a is smaller than b, divide a by b. 
        Otherwise, multiply both numbers. Return the resulting value
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a < b ? a / b : a * b
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Round a number to 2 decimal places
        scenario :
        ```python
        Write a function that takes a number (a) as argument. Round a to the 2nd digit after the comma. 
        Return the rounded number
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return Number(a.toFixed(2));
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Split a number into its digits
        scenario :
        ```python
        Write a function that takes a number (a) as argument. Split a into its individual digits and return 
        them in an array. Tipp: you might want to change the type of the number for the splitting
        ```
        
        code scenario :
        ```js
        function myFunction( a ) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction( a ) {
            const string = a + '';
            const strings = string.split('');
            return strings.map(digit => Number(digit))
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.toString()
                    .split('')
                    .map(charNum => parseInt(charNum))
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject Javascript fundamentals end -->
- ### Javascript arrays
    <!-- inject Javascript arrays start -->
    - #### Get nth element of array
        scenario :
        ```python
        Write a function that takes an array (a) and a value (n) as argument. Return the nth element of 'a'
        ```
        
        code scenario :
        ```js
        function myFunction(a, n) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, n) {
            return a[n - 1];
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Remove first n elements of an array
        scenario :
        ```python
        Write a function that takes an array (a) as argument. Remove the first 3 elements of 'a'. Return the 
        result
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.slice(3);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Get last n elements of an array
        scenario :
        ```python
        Write a function that takes an array (a) as argument. Extract the last 3 elements of 'a'. Return the 
        resulting array
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.slice(-3);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Get first n elements of an array
        scenario :
        ```python
        Write a function that takes an array (a) as argument. Extract the first 3 elements of a. Return the 
        resulting array
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.slice(0, 3);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Return last n array elements
        scenario :
        ```python
        Write a function that takes an array (a) and a number (n) as arguments. It should return the last n 
        elements of a.
        ```
        
        code scenario :
        ```js
        function myFunction(a, n) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, n) {
            return a.slice(-n);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Remove a specific array element
        scenario :
        ```python
        Write a function that takes an array (a) and a value (b) as argument. The function should remove all 
        elements equal to 'b' from the array. Return the filtered array.
        ```
        
        code scenario :
        ```js
        function myFunction( a, b ) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction( a, b ) {
            return a.filter(arrItem => arrItem !== b)
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Count number of elements in JavaScript array
        scenario :
        ```python
        Write a function that takes an array (a) as argument. Return the number of elements in a.
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.length;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Count number of negative values in array
        scenario :
        ```python
        Write a function that takes an array of numbers as argument. Return the number of negative values 
        in the array.
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.filter((el) => el < 0).length;
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            const isNegative = num => num < 0;
            return a.filter(isNegative).length;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Sort an array of strings alphabetically
        scenario :
        ```python
        Write a function that takes an array of strings as argument. Sort the array elements alphabetically. 
        Return the result.
        ```
        
        code scenario :
        ```js
        function myFunction(arr) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(arr) {
            return arr.sort();
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Sort an array of numbers in descending order
        scenario :
        ```python
        Write a function that takes an array of numbers as argument. It should return an array with the 
        numbers sorted in descending order.
        ```
        
        code scenario :
        ```js
        function myFunction( arr ) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction( arr ) {
            // > 0 => sort a after b
            // < 0 => sort a before b
            // === 0 => keep original order of a and b
            return arr.sort((a, b) => b - a)
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Calculate the sum of an array of numbers
        scenario :
        ```python
        Write a function that takes an array of numbers as argument. It should return the sum of the 
        numbers.
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return a.reduce((acc, cur) => acc + cur, 0);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Return the average of an array of numbers
        scenario :
        ```python
        Write a function that takes an array of numbers as argument. It should return the average of the 
        numbers.
        ```
        
        code scenario :
        ```js
        function myFunction( arr ) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction( arr ) {
            return arr.reduce((acc, cur) => acc + cur, 0) / arr.length
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Return the longest string from an array of strings
        scenario :
        ```python
        Write a function that takes an array of strings as argument. Return the longest string.
        ```
        
        code scenario :
        ```js
        function myFunction( arr ) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction( arr ) {
            return arr.reduce((a, b) => a.length <= b.length ? b : a)
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Check if all array elements are equal
        scenario :
        ```python
        Write a function that takes an array as argument. It should return true if all elements in the array are 
        equal. It should return false otherwise.
        ```
        
        code scenario :
        ```js
        function myFunction( arr ) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction( arr ) {
            return new Set(arr).size === 1;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Merge an arbitrary number of arrays
        scenario :
        ```python
        Write a function that takes arguments an arbitrary number of arrays. It should return an array 
        containing the values of all arrays.
        ```
        
        code scenario :
        ```js
        function myFunction(...arrays) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(...arrays) {
            return arrays.flat();
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Sort array by object property
        scenario :
        ```python
        Write a function that takes an array of objects as argument. Sort the array by property b in ascending 
        order. Return the sorted array
        ```
        
        code scenario :
        ```js
        function myFunction(arr) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(arr) {
            // > 0 => sort a after b
            // < 0 => sort a before b
            // === 0 => keep original order of a and b
            const sort = (x, y) => x.b - y.b;
            return arr.sort(sort);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Merge two arrays with duplicate values
        scenario :
        ```python
        Write a function that takes two arrays as arguments. Merge both arrays and remove duplicate values. 
        Sort the merge result in ascending order. Return the resulting array
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return [...new Set([...a, ...b])].sort((x, y) => x - y);
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            let merged = a.concat(b);
            let noDuplicate = Array.from(new Set(merged));
            let sorted = noDuplicate.sort((a, b) => a - b);
            return sorted;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject Javascript arrays end -->
- ### Javascript objects  
    <!-- inject Javascript objects start -->
    - #### Accessing object properties one
        scenario :
        ```python
        Write a function that takes an object with two properties as argument. It should return the value of 
        the property with key country.
        ```
        
        code scenario :
        ```js
        function myFunction(obj) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(obj) {
            return obj.country;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Accessing object properties two
        scenario :
        ```python
        Write a function that takes an object with two properties as argument. It should return the value of 
        the property with key 'prop-2'. Tipp: you might want to use the square brackets property accessor
        ```
        
        code scenario :
        ```js
        function myFunction(obj) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(obj) {
            return obj['prop-2'];
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Accessing object properties three
        scenario :
        ```python
        Write a function that takes an object with two properties and a string as arguments. It should return 
        the value of the property with key equal to the value of the string
        ```
        
        code scenario :
        ```js
        function myFunction(obj, key) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(obj, key) {
            return obj[key]
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Check if property exists in object
        scenario :
        ```python
        Write a function that takes an object (a) and a string (b) as argument. Return true if the object has a 
        property with key 'b'. Return false otherwise. Tipp: test case 3 is a bit tricky because the value of 
        property 'z' is undefined. But the property itself exists.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            // The in operator returns true if the specified property is in 
            // the object or its prototype chain.
            return b in a;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Check if property exists in object and is truthy
        scenario :
        ```python
        Write a function that takes an object (a) and a string (b) as argument. Return true if the object has a 
        property with key 'b', but only if it has a truthy value. In other words, it should not be null or 
        undefined or false. Return false otherwise.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return Boolean(a[b]);
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a[b] ? true : false;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Creating Javascript objects one
        scenario :
        ```python
        Write a function that takes a string as argument. Create an object that has a property with key 'key' 
        and a value equal to the string. Return the object.
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return { key: a }
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Creating Javascript objects two
        scenario :
        ```python
        Write a function that takes two strings (a and b) as arguments. Create an object that has a property 
        with key 'a' and a value of 'b'. Return the object.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return { [a]: b }
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Creating Javascript objects three
        scenario :
        ```python
        WWrite a function that takes two arrays (a and b) as arguments. Create an object that has properties 
        with keys 'a' and corresponding values 'b'. Return the object.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a.reduce((acc, cur, i) => ({ ...acc, [cur]: b[i] }), {})
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Extract keys from Javascript object
        scenario :
        ```python
        Write a function that takes an object (a) as argument. Return an array with all object keys.
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return Object.keys(a);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Return nested object property
        scenario :
        ```python
        Write a function that takes an object as argument. In some cases the object contains other objects 
        with some deeply nested properties. Return the property 'b' of object 'a' inside the original object if it 
        exists. If not, return undefined
        ```
        
        code scenario :
        ```js
        function myFunction(obj) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(obj) {
            return obj?.a?.b;
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(obj) {
            return obj.a && obj.a.b ? obj.a.b : undefined
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Sum object values
        scenario :
        ```python
        Write a function that takes an object (a) as argument. Return the sum of all object values.
        ```
        
        code scenario :
        ```js
        function myFunction(a) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a) {
            return Object.values(a).reduce((sum, cur) => sum + cur, 0);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Remove a property from an object
        scenario :
        ```python
        Write a function that takes an object as argument. It should return an object with all original object 
        properties. except for the property with key 'b'
        ```
        
        code scenario :
        ```js
        function myFunction(obj) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(obj) {
            const { b, ...rest } = obj;
            return rest;
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(obj) {
            if("b" in obj) {
                return delete obj.b && obj;
            }
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Merge two objects with matching keys
        scenario :
        ```python
        Write a function that takes two objects as arguments. Unfortunately, the property 'b' in the second 
        object has the wrong key. It should be named 'd' instead. Merge both objects and correct the wrong 
        property name. Return the resulting object. It should have the properties 'a', 'b', 'c', 'd', and 'e'
        ```
        
        code scenario :
        ```js
        function myFunction(x, y) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(x, y) {
            const {b, ...rest} = y;
            return {...x, ...rest, d: b};
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(x, y) {
            y.d = y.b;
            delete y.b;
            return {...x, ...y};
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Multiply all object values by x
        scenario :
        ```python
        Write a function that takes an object (a) and a number (b) as arguments. Multiply all values of 'a' by 
        'b'. Return the resulting object.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return Object.entries(a).reduce((acc, [key, val]) => {
                return { ...acc, [key]: val * b };
            }, {});
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject Javascript objects end -->
- ### Javascript dates
    <!-- inject Javascript dates start -->
    - #### Check if two dates are equal
        scenario :
        ```python
        Sounds easy, but you need to know the trick. Write a function that takes two date instances as 
        arguments. It should return true if the dates are equal. It should return false otherwise.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a.getTime() === b.getTime();
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a - b === 0;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Return the number of days between two dates
        scenario :
        ```python
        Write a function that takes two date instances as argument. It should return the number of days that 
        lies between those dates.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            const dif = Math.abs(a - b);
            return dif / 1000 / 60 / 60 / 24
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        functiion myFunction(a, b) {
            return Math.abs( (a.getTime() / 86400000) - (b.getTime() / 86400000) )
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Check if two dates fall on the exact same day
        scenario :
        ```python
        Write a function that takes two date instances as argument. It should return true if they fall on the 
        exact same day. It should return false otherwise.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a.getFullYear() === b.getFullYear() &&
                   a.getMonth() === b.getMonth() &&
                   a.getDate()=== b.getDate()
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Check if two dates are within 1 hour from each other
        scenario :
        ```python
        Write a function that takes two date instances as argument. It should return true if the difference between the dates is less 
        than or equal to 1 hour. It should return false otherwise.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return Math.abs(a - b) / 1000 / 60 <= 60
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            const timeDiffLimitInMinutes = 60;
            let firstDateTime = a.getTime();
            let secondDateTime = b.getTime();
            let timeDiffInMiliSeconds = Math.abs(firstDateTime - secondDateTime);
            let timeDiffInMinutes = timeDiffInMiliSeconds / 60000;

            if(timeDiffInMinutes > timeDiffLimitInMinutes) return false;
            return true;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Check if one date is earlier than another
        scenario :
        ```python
        Write a function that takes two date instances (a and b) as arguments. It should return true if a is earlier than b. It should 
        return false otherwise.
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            return a < b
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject Javascript dates end -->
- ### Javascript Sets
    <!-- inject Javascript Sets start -->
    - #### Check if value is present in Set
        scenario :
        ```python
        Write a function that takes a Set and a value as arguments. Check if the value is present in 
        the Set
        ```
        
        code scenario :
        ```js
        function myFunction(set, val) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(set, val) {
            return set.has(val);
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Convert a Set to Array
        scenario :
        ```python
        Write a function that takes a Set as argument. Convert the Set to an Array. Return the Array
        ```
        
        code scenario :
        ```js
        function myFunction(set) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(set) {
            return [...set];
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Get union of two sets
        scenario :
        ```python
        Write a function that takes two Sets as arguments. Create the union of the two sets. Return 
        the result. Tipp: try not to switch to Arrays, this would slow down your code
        ```
        
        code scenario :
        ```js
        function myFunction(a, b) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b) {
            const result = new Set(a);
            b.forEach((el) => result.add(el));
            return result;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Creating Javascript Sets
        scenario :
        ```python
        Write a function that takes three elements of any type as arguments. Create a Set from 
        those elements. Return the result
        ```
        
        code scenario :
        ```js
        function myFunction(a, b, c) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(a, b, c) {
            const set = new Set();
            set.add(a);
            set.add(b);
            set.add(c);
            return set;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Delete element from Set
        scenario :
        ```python
        Write a function that takes a Set and a value as argument. If existing in the Set, remove the 
        value from the Set. Return the result
        ```
        
        code scenario :
        ```js
        function myFunction(set, val) {
            return 
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        function myFunction(set, val) {
            set.delete(val);
            return set;
        }
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        function myFunction(set, val) {
            return set.has(val) ? set.delete(val) && set : set;
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject Javascript Sets end -->
## **Javascript DOM :**

- ### DOM selector methods
    <!-- inject DOM selector methods start -->
    - #### Select the button element on the page
        scenario :
        ```python
        In this scenario, the existing code adds an eventListener for a click event on a variable buttonElem. It expects buttonElem to be the button element in the example UI. But, that element is not selected yet.
        Assign the button element to the variable buttonElem. Click the button to verify that the code is working.
        Hint: Make use of the unique id of the button element.
        ```
        html :
        ```html
        <button type="button" id="button">OFF</button>
        ```
        code scenario :
        ```js
        const buttonElem = 
  
        buttonElem.addEventListener('click', () => {
          const oldText = buttonElem.innerText;
          return button.innerText = oldText === "ON" ? "OFF" : "ON";
        });
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const buttonElem = document.getElementById("button");
  
        buttonElem.addEventListener('click', () => {
          const oldText = buttonElem.innerText;
          return button.innerText = oldText === "ON" ? "OFF" : "ON";
        });
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Query descendent HTML elements
        scenario :
        ```python
        Here, the existing code expects the variables 'buttonElem' and 'inputElem' to represent the button and input elements in the example UI.
        Assign the respective elements to the variables.
        In this case, the two elements do not have unique identifiers - like for example an id. Instead they are direct descendents of a div element with id 'wrapper'. Use an appropriate selector method!
        Click the button to verify that the code is working.
        ```
        html :
        ```html
        <div id="wrapper">
            <input type="text" value="OFF" readonly/>
            <button type="button">Click Me</button>
        </div>
        ```
        code scenario :
        ```js
        const buttonElem = 
        const inputElem = 

        buttonElem.addEventListener('click', () => {
          const oldText = inputElem.value;
            return inputElem.value = oldText === "ON" ? "OFF" : "ON";
        });
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const buttonElem = document.querySelector("#wrapper button");
        const inputElem = document.querySelector("#wrapper input");

        buttonElem.addEventListener('click', () => {
          const oldText = inputElem.value;
            return inputElem.value = oldText === "ON" ? "OFF" : "ON";
        });
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Select multiple HTML elements
        scenario :
        ```python
        In this scenario, we are looking for a list of elements gathered in one variable - rather than only one element.
        Assign the list items in the view to the variable 'listItems' by using an appropriate selector method.
        Once you have completed the code below, verify it by hovering over the list items until all items have the value 'ON'
        ```
        html :
        ```html
        <ul id="list">
            <li>OFF</li>
            <li>OFF</li>
            <li>OFF</li>
            <li>OFF</li>
            <li>OFF</li>
            <li>OFF</li>
        </ul>
        ```
        code scenario :
        ```js
        const listItems = 
  
        const handleHover = (event) => {
          return event.target.innerText = 'ON';
        };
        
        if(listItems.length > 1) {
          listItems.forEach(item => item.addEventListener('mouseover', handleHover));
        }
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const listItems = document.querySelectorAll("#list li");
  
        const handleHover = (event) => {
          return event.target.innerText = 'ON';
        };
        
        if(listItems.length > 1) {
          listItems.forEach(item => item.addEventListener('mouseover', handleHover));
        }
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject DOM selector methods end -->
- ### Events and user interactions
    <!-- inject Events and user interactions start -->
    - #### Execute function on button click
        scenario :
        ```python
        The Javascript function handleText fills the input field with the words Hello World. But, there is no code to execute this function.
        Complete the existing code below such that the function is called when the button is clicked. Verify by clicking the button.
        ```
        html :
        ```html
        <input type="text" id="input" readonly/>
        <button type="button" id="button">Click Me</button>
        ```
        code scenario :
        ```js
        const button = document.getElementById('button');
        const input = document.getElementById('input');

        const handleClick = () => {
          input.value = 'Hello World';
        };
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const button = document.getElementById('button');
        const input = document.getElementById('input');

        const handleClick = () => {
          input.value = 'Hello World';
        };

        button.addEventListener('click', handleClick);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Execute function when cursor moves onto element
        scenario :
        ```python
        The Javascript function changeText changes the text inside the circle. But again, there is no code to execute this function.
        Complete the existing code below such that the function is called when the cursor moves onto the circle. Verify that your code works by hovering over the circle.
        ```
        html :
        ```html
        <div id="element">
            Hover Me
        </div>
        ```
        code scenario :
        ```js
        const element = document.getElementById('element');
  
        const changeText = () => {
          element.innerText = 'Thanks!';
        };
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const element = document.getElementById('element');
  
        const changeText = () => {
          element.innerText = 'Thanks!';
        };

        element.addEventListener("mouseover", changeText);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Cursor enters and leaves element
        scenario :
        ```python
        In this scenario we want the color of the circle to change depending on the type of cursor movement. Use the function toggleColor to turn the circle orange when the cursor moves onto it. Reuse the same function to turn it black when the cursor leaves it.
        The tricky part is that you have to call toggleColor with different values for the parameter isEntering. Verify that your code is working by hovering the circle with the mouse cursor and leaving it again.
        ```
        html :
        ```html
        <div id="element">
            Hover Me
        </div>
        ```
        code scenario :
        ```js
        const element = document.querySelector('#element');
  
        const toggleColor = (isEntering) => {
          element.style.background = isEntering ? 'orange' : 'black';
        };
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const element = document.querySelector('#element');
  
        const toggleColor = (isEntering) => {
          element.style.background = isEntering ? 'orange' : 'black';
        };
        
        element.addEventListener('mouseover', () => toggleColor(true));
        element.addEventListener('mouseleave', () => toggleColor(false));
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject Events and user interactions end --> 
- ### DOM manipulation
    <!-- inject DOM manipulation start -->
    - #### Remove element from the DOM
        scenario :
        ```python
        You may not see it in the example UI, but underneath the red circle is a green circle. Extend the function removeRedCircle to remove the circle with id red from the DOM.
        Make sure that you really remove the element instead of just hiding it. Confirm that your code works by clicking the button.
        ```
        html :
        ```html
        <div id="green"/>
        <div id="red"/>
        <button type="button" id="button">Click Me</button>
        ```
        code scenario :
        ```js
        const button = document.querySelector('#button');
  
        const removeRedCircle = () => {
          
        };
        button.addEventListener('click', removeRedCircle);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const button = document.querySelector('#button');
  
        const removeRedCircle = () => {
          const redCircle = document.querySelector('#red');
          redCircle.parentNode.removeChild(redCircle);
        };
        button.addEventListener('click', removeRedCircle);
        ```
        </p>
        </details>
        <details><summary>Solution 2</summary>
        <p>

        js :
        ```js
        const button = document.querySelector('#button');
  
        const removeRedCircle = () => {
          document.getElementById("red").remove();
        };
        button.addEventListener('click', removeRedCircle);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Change id of HTML element
        scenario :
        ```python
        In this scenario the existing code listens to a click on the button. When the button is clicked, the function changeInput is triggered. changeInput tries to select an input field with id inputEl. But, the existing input field does not have this id. Add some Javascript code to add the id inputEl to the existing input field.
        Verify that your code works by clicking the button.
        ```
        html :
        ```html
        <div id="wrapper">
            <input type="text" placeholder="Text" readonly/>
            <button type="button">Click Me</button>
        </div>
        ```
        code scenario :
        ```js
        const button = document.querySelector('#wrapper button');
  
        const changeInput = () => {
          const input = document.querySelector('#inputEl');
          if(input) {
            input.value = 'Hello World';
          }
        };
        
        button.addEventListener('click', changeInput);
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const button = document.querySelector('#wrapper button');
  
        const changeInput = () => {
          const input = document.querySelector('#inputEl');
          if(input) {
            input.value = 'Hello World';
          }
        };
        
        button.addEventListener('click', changeInput);
        
        document.querySelector('#wrapper input').setAttribute('id', 'inputEl');
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject DOM manipulation end -->
- ### DOM fundamentals
    <!-- inject DOM fundamentals start -->
    - #### Check the checkbox
        scenario :
        ```python
        Your first JavaScript DOM exercise. Let's start simple.
        Extend the JavaScript code below to interact with the displayed HTML elements. Once you click the button, the checkbox should be checked.
        Confirm your code by clicking the button!
        ```
        html :
        ```html
        <input id="checkbox" disabled/>
        <label for="checkbox">checkbox</label>
        <button type="button" id="button">Verify Code</button>
        ```
        code scenario :
        ```js
        const button = document.getElementById('button');
        button.addEventListener('click', () => {
          
        });
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const button = document.getElementById('button');
        button.addEventListener('click', () => {
          const checkbox = document.getElementById('checkbox');
          checkbox.checked = true;
        });
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Get full-name from input
        scenario :
        ```python
        Extend the JavaScript code below to interact with the displayed HTML elements.
        This time we are looking for the full name. When the button is clicked, combine the names of the first two input fields. Insert the full name in the third input field.
        Hint: Check if your code still works if you change the first or last name.
        Confirm your code by clicking the button!
        ```
        html :
        ```html
        <input type="text" id="firstName" placeholder="Max" value="Max"/>
        <input type="text" id="lastName" placeholder="Musterman" value="Musterman"/>
        <input type="text" id="fullName" placeholder="full name" readonly/>
        <button type="button" id="button">Verify Code</button>
        ```
        code scenario :
        ```js
        const button = document.getElementById('button');
        button.addEventListener('click' , () => {
          
        });
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const button = document.getElementById('button');
        button.addEventListener('click' , () => {
          const firstName = document.getElementById('firstName');
          const lastName = document.getElementById('lastName');
          const fullName = document.getElementById('fullName');
          fullName.value = firstName.value + ' ' + lastName.value;
        });
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    - #### Pop the balloons
        scenario :
        ```python
        Make the balloons pop by hovering over them.
        Extend the JavaScript code below to interact with the displayed HTML elements. Every time you hover over a balloon, it should become invisible.
        Your goal is to pop all the balloons one after the other.
        ```
        html :
        ```html
        <ul id="list">
          <li/>
          <li/>
          <li/>
          <li/>
          <li/>
          <li/>
          <li/>
          <li/>
          <li/>
          <li/>
        </ul>
        ```
        code scenario :
        ```js
        const list = document.getElementById('list');
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const list = document.getElementById('list');
        const handleHover = event => {
          if(event.target !== list) {
            event.target.style.visibility = 'hidden';
          }
        };

        list.addEventListener('mouseover', handleHover);
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject DOM fundamentals end -->
- ### Recursive functions
    <!-- inject Recursive functions start -->
    - #### Stop and restart the moving button
        scenario :
        ```python
        This is a good exercise to learn about recursive functions. The function move in the code below moves the button 1px to the left or the right. It is recursive because it calls itself again and again. This keeps the button moving.
        Extend the JavaScript code. Once you click the button, it should stop moving. When you click it again, it should move again.
        Confirm your code by clicking the button twice.
        ```
        html :
        ```html
        <button type="button" id="button">Click Me</button>
        ```
        code scenario :
        ```js
        const button = document.getElementById('button');
        let stopped = false;
         
        function move(isReturning) {
         const width = button.parentNode.clientWidth;
         const left = parseInt(button.style.left , 10) || 0;
         if (!stopped) {
            button.style.left = (isReturning ? left - 1 : left + 1) + 'px';
            setTimeout(() => move ((isReturning && left > 0) || left === width - button.clientWidth), 10);
         };
        };
         
        move();
         
        button.addEventListener('click', () => {
          
        });
        ```
        <details><summary>Solution 1</summary>
        <p>

        js :
        ```js
        const button = document.getElementById('button');
        let stopped = false;
         
        function move(isReturning) {
         const width = button.parentNode.clientWidth;
         const left = parseInt(button.style.left , 10) || 0;
         if (!stopped) {
            button.style.left = (isReturning ? left - 1 : left + 1) + 'px';
            setTimeout(() => move ((isReturning && left > 0) || left === width - button.clientWidth), 10);
         };
        };
         
        move();
         
        button.addEventListener('click', () => {
          stopped = !stopped;
          move();
        });
        ```
        </p>
        </details>

        [Back to table ⬆](#table-of-solutions)
    <!-- inject Recursive functions end -->
