import { Box, Grid, useTheme } from "@mui/material";
import NavBar from "../../navigation/NavBar";
import CardRouting from "../../components/CardRouting";

const PersonalityDash = () => {
  const theme = useTheme();

  return (
    <Box
      sx={{
        flexGrow: 1,
        backgroundColor: theme.palette.background.default,
        minHeight: "110vh",
      }}
    >
      <NavBar link="/PersonalityDash" />
      <Grid container spacing={2} sx={{ p: 3 }}>
        <Grid item xs={12} sm={6} md={4} lg={3}>
          <CardRouting
            cardName="Quote Clear"
            navigateTo="PersonalityQuoteClear"
            tags="personality"
            description="Ever growing list of quotes from James Clear's 3-2-1 Newsletter."
            difficulty="easy"
          />
        </Grid>
      </Grid>
    </Box>
  );
};

export default PersonalityDash;
