# Awesome WPO [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[![GitHub contributors](https://img.shields.io/github/contributors/davidsonfellipe/awesome-wpo.svg)](https://github.com/correia-jpv/fucking-awesome-wpo/graphs/contributors)
[![MIT license](https://img.shields.io/github/license/mashape/apistatus.svg?style=flat)](https://davidsonfellipe.mit-license.org/)

Welcome to the curated list of Web Performance Optimization resources. This repository aims to gather the best tools, articles, blogs, books, and talks related to optimizing website performance. Whether you're a developer, designer, or performance enthusiast, you'll find valuable content here to supercharge your web projects.

## Categories

:memo: [Awesome WPO / Articles](#articles)

:newspaper: [Awesome WPO / Blogs](#blogs)

:books: [Awesome WPO / Books](#books)

:book: [Awesome WPO / Docs](#documentation)

:calendar: [Awesome WPO / Events](#events)

:movie_camera: [Awesome WPO / Talks](#talks)

## Table of Contents

Here's a quick overview of the categories covered in this collection:

- [Analyzers](#analyzers)
- [Analyzers API](#analyzers---api)
- [Application Performance Monitoring](#application-performance-monitoring)
- [Bundle Analyzer](#bundle-analyzer)
- [Benchmark - CSS](#benchmark---css)
- [Benchmark - JS](#benchmark---javascript)
- [Benchmark - PHP](#benchmark---php)
- [Bookmarklets](#bookmarklets)
- [CDN](#cdn)
- [CDN - Monitor](#cdn---monitor)
- [CDN - Utilities](#cdn---utilities)
- [Extensions](#extensions)
- [Image Optimizers](#image-optimizers)
- [Generators](#generators)
- [Lazyloaders](#lazyloaders)
- [Loaders](#loaders)
- [Metrics Monitor](#metrics-monitor)
- [Minifiers HTML](#minifiers---html)
- [Minifiers JS & CSS](#minifiers---js--css)
- [Miscellaneous](#miscellaneous)
- [SVG](#svg)
- [Web Components](#web-components)
- [Web server Benchmarks](#web-server-benchmarks)
- [Web server Modules](#web-server-modules)
- [Specs](#specs)
- [Stats](#stats)
- [Other Awesome Lists](#other-awesome-lists)
- [Contributing](#contributing)

## Articles

> Go to [ARTICLES.md](content/ARTICLES.md).

## Blogs

> Go to [BLOGS](content/BLOGS.md).

## Books

> Best books about WPO

- 🌎 [HTTP/2 in Action by Barry Pollard](www.manning.com/books/http2-in-action) - Barry Pollard
- 🌎 [Web Performance in Action by Jeremy Wagner](www.manning.com/books/web-performance-in-action) - Jeremy L. Wagner
- 🌎 [Book of Speed](www.bookofspeed.com/) - Stoyan Stefanov
- [Designing for Performance: Weighing Aesthetics and Speed](http://designingforperformance.com/) - Lara Callender Hogan
- [Even Faster Web Sites: Performance Best Practices for Web Developers](http://shop.oreilly.com/product/9780596522315.do) - Steve Souders
- [High Performance Browser Networking: What every web developer should know about networking and web performance](http://shop.oreilly.com/product/0636920028048.do) - Ilya Grigorik
- [High Performance JavaScript](http://shop.oreilly.com/product/9780596802806.do) - Nicholas C. Zakas
- [High Performance Web Sites: Essential Knowledge for frontend Engineers](http://books.google.de/books/about/High_Performance_Web_Sites.html?id=jRVlgNDOr60C&redir_esc=y) - Steve Souders
- [High Performance Responsive Design: Building Faster Sites Across Devices](http://shop.oreilly.com/product/0636920033103.do) – Tom Barker
- 🌎 [Lean sites](www.sitepoint.com/premium/books/lean-websites) – Barbara Bermes
- [Time Is Money: The Business Value of Web Performance](http://shop.oreilly.com/product/0636920041450.do) – Tammy Everts
- [Using WebPagetest](http://shop.oreilly.com/product/0636920033592.do) - Rick Viscomi, Andy Davies, Marcel Duran
- [Web Page Size, Speed, and Performance](http://www.oreilly.com/webops-perf/free/webpage-size-speed-perf.csp) - Terrence Dorsey
- 🌎 [Web Performance Daybook Volume 2](www.amazon.com/Web-Performance-Daybook-Stoyan-Stefanov-ebook/dp/B008CQA8BA/) - Stoyan Stefanov
- [Web Performance Tuning](http://shop.oreilly.com/product/9780596001728.do) - Patrick Killelea
- 🌎 [You Don't Know JS: Async & Performance](www.oreilly.com/library/view/you-dont-know/9781491905197/) - Kyle Simpson
- 🌎 [Linux, Apache, MySQL, PHP Performance end-to-end](play.google.com/store/books/details/Colin_McKinnon_Linux_Apache_MySQL_PHP_Performance?id=Z3ciBgAAQBAJ) - Colin McKinnon
- 🌎 [Web Components in Action](www.manning.com/books/web-components-in-action) - Ben Farrell
- 🌎 [Image Optimization](www.smashingmagazine.com/printed-books/image-optimization/) - Addy Osmani

## Case studies

- 🌎 [WPOStats](wpostats.com/) - Case studies and experiments demonstrating the impact of web performance optimization (WPO) on user experience and business metrics.
- 🌎 [Google Developers Case Studies](developers.google.com/web/showcase) - Learn why and how other developers have used the web to create amazing web experiences for their users.

## Documentation

- 🌎 [Browser Diet](browserdiet.com/en/) - A collaborative guide about frontend performance.
- 🌎 [PageSpeed Insights Rules](developers.google.com/speed/docs/insights/rules) - A guide created by PageSpeed Team.
  Deprecated. This is deprecated and will be shut down in May 2019. Version 5 is the latest and provides both real-world data from the Chrome User Experience Report and lab data from Lighthouse.
- 🌎 [Best Practices for Speeding Up Your site](developer.yahoo.com/performance/rules.html) - The list includes 35 best practices divided into 7 categories, created by Yahoo! Exceptional Performance team.

## Events

> Because community matters!

### Conferences

- 🌎 [We Love Speed](www.welovespeed.com/) – We Love Speed ​​was born from the desire to share knowledge and experiences in web performance as widely as possible.
- 🌎 [PWA Summit](pwasummit.org/) – A free, online, single-track conference focused on helping everyone succeed with Progressive Web Apps.
- [Velocity](http://conferences.oreilly.com/velocity) – At Velocity, web operations, performance, and DevOps professionals learn to build fast, resilient, and highly available sites and apps.
- 🌎 [performance.now()](perfnow.nl/) – The performance.now() conference will return to Amsterdam! We're a single-track conference with fourteen world-class speakers, covering today’s most important web performance insights.
- 🌎 [#PerfMatters](perfmattersconf.com/) – #PerfMatters Conference is the ONLINE web performance conference by internationally renowned performance developers.

### Meetups

> They are categorized into [content/MEETUPS.md](content/MEETUPS.md).

## Talks

> They are categorized into [content/TALKS.md](content/TALKS.md).

# Tools

## Analyzers

- 🌎 [Web.dev](web.dev/) - Get the web's modern capabilities on your own sites and apps with useful guidance and analysis from web.dev.
- <b><code>&nbsp;&nbsp;&nbsp;872⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;100🍴</code></b> [Confess](https://github.com/jamesgpearce/confess)) - Uses PhantomJS to headlessly analyze web pages and generate manifests.
- 🌎 [DebugBear](www.debugbear.com/) - DebugBear is a site monitoring tool based on Lighthouse. See how your scores and metrics changed over time, with a focus on understanding what caused each change. DebugBear is a paid product with a free 30-day trial.
- 🌎 [Page Speed](developers.google.com/speed/pagespeed/) - The PageSpeed family of tools is designed to help you optimize the performance of your site. PageSpeed Insights products will help you identify performance best practices that can be applied to your site, and PageSpeed optimization tools can help you automate the process.
- <b><code>&nbsp;28533⭐</code></b> <b><code>&nbsp;&nbsp;9406🍴</code></b> [Lighthouse](https://github.com/GoogleChrome/lighthouse)) - Auditing and performance metrics tool for Progressive Web Applications.
- 🌎 [Screpy](screpy.com) - AI-Based SEO Analysis & Monitoring Tool
- <b><code>&nbsp;&nbsp;2205⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;382🍴</code></b> [YSlow](https://github.com/marcelduran/yslow)) - YSlow analyzes web pages and suggests ways to improve their performance based on a set of rules for high-performance web pages.
- [YSlow for PhantomJS](http://yslow.org/phantomjs/) - YSlow for PhantomJS also introduces new output formats for automated test frameworks: TAP (Test Anything Protocol) and JUnit.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3🍴</code></b> [Grunt-WebPageTest](https://github.com/sideroad/grunt-wpt)) - Grunt plugin for continuous measurement of WebPageTest. ([Demo](http://sideroad.github.io/sample-wpt-page/))
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;91⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15🍴</code></b> [Grunt-yslow](https://github.com/andyshora/grunt-yslow)) - Grunt task for testing page performance using PhantomJS, a headless WebKit browser.
- <b><code>&nbsp;&nbsp;&nbsp;856⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [Grunt-perfbudget](https://github.com/tkadlec/grunt-perfbudget)) - A Grunt.js task for enforcing a performance budget  🌎 [more on performance budgets](timkadlec.com/2013/01/setting-a-performance-budget/)).
- <b><code>&nbsp;&nbsp;2641⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;200🍴</code></b> [Web Tracing Framework](https://github.com/google/tracing-framework)) - Web Tracing Framework is a set of libraries, tools, and visualizers for the tracing and investigation of complex web applications
- <b><code>&nbsp;&nbsp;2469⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;280🍴</code></b> [Yandex.Tank](https://github.com/yandex/yandex-tank)) - An extensible open-source load testing tool for advanced Linux users which is especially good as a part of an automated load testing suite.
- [Yellow Lab Tools](http://yellowlab.tools) - Online quick and easy tool that audits frontend bad practices, reveals performance issues, and profiles JavaScript.
- [Pagelocity](http://pagelocity.com/) - A web performance optimization and analysis tool.
- 🌎 [Varvy](varvy.com/pagespeed/) - Test your site to see if it follows the Google guidelines for speed.
- [Web Bloat Score Calculator](http://www.webbloatscore.com/) - Compare size of a page to a compressed image of the same page
- <b><code>&nbsp;&nbsp;1865⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;23🍴</code></b> [Speed Racer](https://github.com/ngryman/speedracer)) - Collect performance metrics for your library/application using Chrome headless.
- 🌎 [Speedrank](speedrank.app/) - Speedrank monitors the performance of your site in the background. It displays Lighthouse reports over time and delivers recommendations for improvement. Speedrank is a paid product with 14-day-trial.
- 🌎 [Lightest App](lightest.app/) - Webpage load time is extremely important for conversion and revenue. Visualize web performance against competitors.

## Analyzers - API

- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [Node-yslowjs](https://github.com/jmervine/node-yslowjs)) - YSlow.js on Node.js is a simple Node.js wrapper for programmatically running phantomjs yslow.js.
- <b><code>&nbsp;&nbsp;3105⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;126🍴</code></b> [PSI](https://github.com/addyosmani/psi)) - PageSpeed Insights for Node.js - with reporting.

# Application Performance Monitoring

- 🌎 [Datadog APM](www.datadoghq.com/product/apm/) - End-to-end distributed tracing and APM at scale, correlated to all telemetry.
- 🌎 [BetterUptime](betteruptime.com) - A good website monitoring tool (bundling status page, incident notification)
- 🌎 [Pingdom](pingdom.com) - A tool to get the uptime of your website (with probes from different locations)
- 🌎 [UptimeRobot](uptimerobot.com) - Another uptime monitoring tool (with a generous free plan)
- 🌎 [RoboMiri](robomiri.com) - RoboMiri is a stable Uptime Monitor that offers a wide range of monitors: cronjob, keyword, website, port, ping. 25 uptime checks with 3 minutes interval checks for free. Alerts via Phone Call, SMS, Email, and WebHook.
- 🌎 [StatusList](statuslist.app) - Uptime, performance monitoring with debug details, and hosted status page in one simple dashboard.

## Bundle Analyzer

- <b><code>&nbsp;&nbsp;4474⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;180🍴</code></b> [Bundlesize](https://github.com/siddharthkp/bundlesize)) - Keep your bundle size in check.
- <b><code>&nbsp;&nbsp;3846⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;101🍴</code></b> [source-map-explorer](https://github.com/danvk/source-map-explorer)) - Analyze and debug bundle space usage through source maps.
- 🌎 [Bundlephobia](bundlephobia.com/) - Helps you find the performance impact of adding an npm package to your frontend bundle.
- <b><code>&nbsp;12605⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;489🍴</code></b> [Webpack bundle analyzer](https://github.com/webpack-contrib/webpack-bundle-analyzer)) - webpack plugin and CLI utility that represents bundle content as a convenient interactive zoomable treemap.
- [Disc](http://hughsk.io/disc/) - Visualise the module tree of browserify project bundles and track down bloat.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [Lasso-analyzer](https://github.com/ajay2507/lasso-analyzer)) - analyze and Visualise project bundles created by Lasso.
- 🌎 [Packtracker.io](packtracker.io) - Check your webpack bundle stats on every pull request, and track them over time.
- <b><code>&nbsp;&nbsp;1413⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;108🍴</code></b> [Compression webpack plugin](https://github.com/webpack-contrib/compression-webpack-plugin)) - Prepare compressed versions of assets to serve them with Content-Encoding.
- <b><code>&nbsp;&nbsp;&nbsp;583⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;20🍴</code></b> [BundleStats](https://github.com/relative-ci/bundle-stats)) - Generate bundle report(bundle size, assets, modules, packages) and compare the results between different builds

## Benchmark - CSS

- <b><code>&nbsp;&nbsp;&nbsp;573⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;21🍴</code></b> [CSS-perf](https://github.com/mdo/css-perf)) - Completely unscientific way of testing CSS performance. Most of these tests will revolve around methodologies and techniques for determining effective CSS architecture. Put another way, I want to know what works best given a particular comparison of CSS strategies.

## Benchmark - JavaScript

> A set of tools for creating test cases and comparing different implementations in JavaScript.

- [JSPerf](http://jsperf.com/) - jsPerf aims to provide an easy way to create and share test cases, comparing the performance of different JavaScript snippets by running benchmarks. `Temporarily out, follow this issue for updates: https://github.com/jsperf/jsperf.com/issues/537`
- [Benchmark.js](http://benchmarkjs.com/) - A robust benchmarking library that works on nearly all JavaScript platforms, supports high-resolution timers, and returns statistically significant results.
- <b><code>&nbsp;&nbsp;&nbsp;166⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15🍴</code></b> [JSlitmus](https://github.com/broofa/jslitmus)) - JSLitmus is a lightweight tool for creating ad-hoc JavaScript benchmark tests.
- <b><code>&nbsp;&nbsp;&nbsp;563⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;37🍴</code></b> [Matcha](https://github.com/logicalparadox/matcha)) - Matcha allows you to design experiments that will measure the performance of your code. It is recommended that each bench focus on a specific point of impact in your application.
- <b><code>&nbsp;&nbsp;1496⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;113🍴</code></b> [Timing.js](https://github.com/addyosmani/timing.js)) - Timing.js is a small set of helpers for working with the Navigation Timing API to identify where your application is spending its time. Useful as a standalone script, DevTools Snippet, or bookmarklet.
- <b><code>&nbsp;&nbsp;8780⭐</code></b> <b><code>&nbsp;&nbsp;1201🍴</code></b> [Stats.js](https://github.com/mrdoob/stats.js)) - This class provides a simple info box that will help you monitor your code performance.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [PerfTests](https://github.com/kogarashisan/PerfTests)) - Performance tests of JavaScript inheritance models.
- <b><code>&nbsp;&nbsp;2094⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;105🍴</code></b> [Memory-stats.js](https://github.com/paulirish/memory-stats.js)) - minimal monitor for JS Heap Size via performance memory.

## Benchmark - PHP

- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;53⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4🍴</code></b> [PHPench](https://github.com/mre/PHPench)) - PHPench creates a graphical output for a PHP benchmark. Plot the runtime of any function in realtime with GnuPlot and create an image out of the result.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [php-bench](https://github.com/jacobbednarz/php-bench)) - Benchmark and profile PHP code blocks whilst measuring the performance footprint.

## Bookmarklets

- 🌎 [Yahoo YSlow for Mobile/Bookmarklet](developer.yahoo.com/yslow/) - YSlow analyzes web pages and suggests ways to improve their performance based on a set of rules for high-performance web pages.
- <b><code>&nbsp;&nbsp;3790⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;126🍴</code></b> [PerfMap](https://github.com/zeman/perfmap)) - A bookmarklet to create a frontend performance heatmap of resources loaded in the browser using the Resource Timing API.
- <b><code>&nbsp;&nbsp;&nbsp;559⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;52🍴</code></b> [DOM Monster](https://github.com/madrobby/dom-monster)) - A cross-platform, cross-browser bookmarklet that will analyze the DOM & other features of the page you're on, and give you its bill of health.
- [CSS Stress](http://andy.edinborough.org/CSS-Stress-Testing-and-Performance-Profiling) - CSS Stress is a Testing and Performance Profiling.
- <b><code>&nbsp;&nbsp;1143⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;86🍴</code></b> [Performance-Bookmarklet](https://github.com/micmro/performance-bookmarklet)) - Analyze the current page through the Resource Timing API, Navigation Timing API and User-Timing - Sort of a light live WebPageTest. As 🌎 [Chrome Extension](chrome.google.com/webstore/detail/performance-analyser/djgfmlohefpomchfabngccpbaflcahjf?hl=en) and 🌎 [Firefox Add-on](addons.mozilla.org/en-us/firefox/addon/performance-analyser/?src=cb-dl-created) under the name Performance-Analyser.

## CDN

> A content delivery network or content distribution network (CDN) is a large distributed system of servers deployed in multiple data centers across the Internet. The goal of a CDN is to serve content to end-users with high availability and high performance. See a large list of CDN in [Wikipedia](http://en.wikipedia.org/wiki/Content_delivery_network#Notable_content_delivery_service_providers).

- 🌎 [Cloudflare CDN](www.cloudflare.com/cdn/) - A content delivery network that uses next-gen tech to deliver fast, reliable, CDN services
- 🌎 [PageCDN](pagecdn.com/lib) - A state-of-the-art opensource CDN with aggressive content optimization using brotli-11 compression, HTTP/2 server push, better HTTP/2 multiplexing, and more. Supports 100s of libraries and 2000+ WordPress themes already. Easy to use, easy to link, and very fast.
- <b><code>&nbsp;&nbsp;5705⭐</code></b> <b><code>&nbsp;&nbsp;2060🍴</code></b> [jsDelivr](https://github.com/jsdelivr/jsdelivr)) - Similar to Google Hosted Libraries, jsDelivr is an open-source CDN that allows developers to host their own projects and anyone to link to our hosted files on their sites.
- 🌎 [Google Hosted Libraries](developers.google.com/speed/libraries/) - Google Hosted Libraries is a content distribution network for the most popular, open-source JavaScript libraries.
- 🌎 [CDNjs](cdnjs.com/) - An open-source CDN for JavaScript and CSS sponsored by CloudFlare that hosts everything from jQuery and Modernizr to Bootstrap.
- 🌎 [Amazon CloudFront](aws.amazon.com/cloudfront/) - A content delivery network by Amazon that integrates nicely with other Amazon services or can be used standalone.
- [jQuery](http://code.jquery.com/) - jQuery CDN – Latest Stable Versions, powered by MaxCDN.
- :cn: [UpYun CDN](http://jscdn.upai.com/) - CDN provided by upyun.
- :cn: [Bootstrap 中文网开放 CDN 服务](http://www.bootcdn.cn/) - Bootstrap Chinese net open CDN service (only HTTP).
- :ru: 🌎 [Yandex CDN](tech.yandex.ru/jslibs/) - Yandex Content Delivery Network hosts popular third-party JavaScript and CSS libraries (best for use in Russia).

> To find useful more information for you to make the right choice between paid CDNs, please visit [CDNPlanet](http://www.cdnplanet.com/).

## CDN - Monitor

- [CDNperf](http://www.cdnperf.com/) - finds you fast and reliable JavaScript CDNs that make your sites snappy and happy.

## CDN - Utilities

- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;82⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [Gulp-google-cdn](https://github.com/sindresorhus/gulp-google-cdn)) - Replaces script references with Google CDN ones.

## Extensions

- <b><code>&nbsp;&nbsp;&nbsp;131⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7🍴</code></b> [Browser Calories](https://github.com/zenorocha/browser-calories-chrome)) - The easiest way to measure your performance budget.

## Generators

- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2🍴</code></b> [AtBuild](https://github.com/jarred-sumner/atbuild)) - JavaScript code generation tool that lets you write JavaScript that outputs JavaScript. Good for unrolling loops and writing libraries that compile away the runtime
- <b><code>&nbsp;&nbsp;2550⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;169🍴</code></b> [Glue](https://github.com/jorgebastida/glue)) - Glue is a simple command-line tool to generate sprites:
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;19⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3🍴</code></b> [Pitomba-spriter](https://github.com/pitomba/spriter)) - Spriter is a simple and flexible dynamic sprite generator for CSS, using Python. It can process CSS both synchronous and asynchronous as it provides classes to be used in your Python code and also a watcher that listens to your filesystem and changes CSS and sprite as soon as a static is changed.
- <b><code>&nbsp;&nbsp;1133⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;92🍴</code></b> [Grunt-spritesmith](https://github.com/Ensighten/grunt-spritesmith)) - Grunt task for converting a set of images into a sprite sheet and corresponding CSS variables.
- 🌎 [Grunt-sprite-css-replace](www.npmjs.com/package/grunt-sprite-css-replace) - Grunt task that generates a sprite from images referenced in a style sheet and then updates the references with the new sprite image and positions.
- 🌎 [Grunt-svg-sprite](www.npmjs.com/package/grunt-svg-sprite) - SVG sprites & stacks galore — Grunt plugin wrapping around svg-sprite that reads in a bunch of SVG files, optimizes them and creates SVG sprites and CSS resources in various flavors.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [Gulp-sprite](https://github.com/aslansky/gulp-sprite)) - gulp task for creating an image sprite and the corresponding style sheets for Gulp.
- <b><code>&nbsp;&nbsp;&nbsp;334⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [Gulp-svg-sprites](https://github.com/shakyShane/gulp-svg-sprites)) - gulp task for creating SVG sprites.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [SvgToCSS](https://github.com/kajyr/SvgToCSS)) - Optimizes and renders SVG files in CSS / Sass sprites.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;36⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [Assetgraph-sprite](https://github.com/assetgraph/assetgraph-sprite)) - Assetgraph transform for auto-generating sprites based on the CSS dependency graph.
- [Sprite Cow](http://www.spritecow.com/) - Sprite Cow helps you get the background-position, width, and height of sprites within a spritesheet as a nice bit of copyable CSS.
- [ZeroSprites](http://zerosprites.com/) - ZeroSprites is a CSS sprites generator aimed at area minimization using algorithms used in the field of VLSI floorplanning.
- [CSS Sprite Generator](http://css.spritegen.com/) - CSS sprites allow you to combine multiple images into a single file.
- <b><code>&nbsp;&nbsp;&nbsp;481⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;72🍴</code></b> [Sprity](https://github.com/sprity/sprity)) - A modular image sprite generator with a lot of features: supports retina sprites, supports different output formats, generates sprites and proper style files out of a directory of images, etc...
- <b><code>&nbsp;&nbsp;&nbsp;621⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;76🍴</code></b> [Sprite Factory](https://github.com/jakesgordon/sprite-factory)) - The sprite factory is a ruby library that can be used to generate CSS sprites. It combines individual image files from a directory into a single unified sprite image and creates an appropriate CSS style sheet for use in your web application.

## Image Optimizers

> How to remove all this unnecessary data and give you a file without degrading quality.

- 🌎 [Shortpixel](shortpixel.com/online-image-compression) - Compress Your Image by removing unnecessary bytes of the image and Convert it into WebP/AVIF
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;83⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18🍴</code></b> [Grunt-smushit](https://github.com/heldr/grunt-smushit)) - Grunt plugin to remove unnecessary bytes of PNG and JPG using Yahoo Smushit.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;33⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2🍴</code></b> [Gulp-smushit](https://github.com/heldr/gulp-smushit)) - Gulp plugin to optimize PNG and JPG using Yahoo Smushit. Made on top of smosh.
- [Smush it](http://www.imgopt.com/) - Smush it uses optimization techniques specific to image format to remove unnecessary bytes from image files. It is a "lossless" tool, which means it optimizes the images without changing their look or visual quality.
- <b><code>&nbsp;&nbsp;5594⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;257🍴</code></b> [Imagemin](https://github.com/imagemin/imagemin)) - Minify images seamlessly with Node.js.
- <b><code>&nbsp;29505⭐</code></b> <b><code>&nbsp;&nbsp;1302🍴</code></b> [Sharp](https://github.com/lovell/sharp)) - The typical use case for this high-speed Node.js module is to convert large images of many formats to smaller, web-friendly JPEG, PNG, and WebP images of varying dimensions.
- <b><code>&nbsp;&nbsp;6966⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;616🍴</code></b> [Gm](https://github.com/aheckmann/gm)) - GraphicsMagick and ImageMagick for Node.js.
- <b><code>&nbsp;12734⭐</code></b> <b><code>&nbsp;&nbsp;1178🍴</code></b> [Exexif](https://github.com/h4cc/awesome-elixir)) - Pure elixir library to extract tiff and exif metadata from JPEG files.
- 🌎 [ExifCleaner](exifcleaner.com) - GUI app to remove EXIF metadata from images and video files with drag and drop. Free and open source.
- [OptiPNG](http://optipng.sourceforge.net/) - OptiPNG is a PNG optimizer that recompresses image files to a smaller size, without losing any information.
- <b><code>&nbsp;&nbsp;1215⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;175🍴</code></b> [Grunt-contrib-imagemin](https://github.com/gruntjs/grunt-contrib-imagemin)) - Minify PNG and JPEG images for Grunt.
- <b><code>&nbsp;&nbsp;1905⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;156🍴</code></b> [Gulp-imagemin](https://github.com/sindresorhus/gulp-imagemin)) - Minify PNG, JPEG, GIF and SVG images with imagemin for Gulp.
- <b><code>&nbsp;&nbsp;&nbsp;118⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;16🍴</code></b> [Grunt-WebP](https://github.com/somerandomdude/grunt-webp)) - Convert your images to WebP format.
- <b><code>&nbsp;&nbsp;&nbsp;220⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18🍴</code></b> [Gulp-WebP](https://github.com/sindresorhus/gulp-webp)) - Convert images to WebP for Gulp.
- 🌎 [Imageoptim](imageoptim.com/) - Free app that makes images take up less disk space and load faster, without sacrificing quality. It optimizes compression parameters, and removes junk metadata and unnecessary color profiles.
- <b><code>&nbsp;&nbsp;&nbsp;479⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18🍴</code></b> [Grunt-imageoptim](https://github.com/JamieMason/grunt-imageoptim)) - Make ImageOptim, ImageAlpha, and JPEGmini part of your automated build process.
- <b><code>&nbsp;&nbsp;3461⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;127🍴</code></b> [ImageOptim-CLI](https://github.com/JamieMason/ImageOptim-CLI)) - Automates ImageOptim, ImageAlpha, and JPEGmini for Mac to make batch optimization of images part of your automated build process.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;21⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3🍴</code></b> [Tapnesh-CLI](https://github.com/JafarAkhondali/Tapnesh)) - Tapnesh is a CLI tool that will optimize all your images in parallel easily and efficiently!
- 🌎 [Tinypng](tinypng.com/) - Advanced lossy compression for PNG images that preserves full alpha transparency.
- 🌎 [Kraken Web-interface](kraken.io/web-interface) - Optimize your images and will be available for download for 12 hours.
- 🌎 [Compressor](compressor.io/) - Online image compressor for JPG, PNG, SVG and GIF.
- 🌎 [Shrinkray](shrinkray.io) - One-click optimization for images in your GitHub repos
- <b><code>&nbsp;&nbsp;5495⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;417🍴</code></b> [mozjpeg](https://github.com/mozilla/mozjpeg)) - Improved JPEG encoder.
- <b><code>&nbsp;&nbsp;1608⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;120🍴</code></b> [Jpegoptim](https://github.com/tjko/jpegoptim)) - Utility to optimize/compress JPEG files.
- <b><code>&nbsp;&nbsp;3447⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;329🍴</code></b> [ZopfliPNG](https://github.com/google/zopfli)) - A command-line program to optimize PNG images.
- [AdvPNG](http://www.advancemame.it/doc-advpng.html) - Recompress PNG files to get the smallest possible size.
- <b><code>&nbsp;&nbsp;&nbsp;835⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;75🍴</code></b> [Leanify](https://github.com/JayXon/Leanify)) - Lightweight lossless file minifier/optimizer.
- [Trimage](http://trimage.org/) - A cross-platform tool for losslessly optimizing PNG and JPG files.
- 🌎 [ImageEngine](imageengine.io) - Cloud service for optimizing, resizing and caching images on the fly with great mobile support.
- 🌎 [ImageKit.io](imagekit.io) - Intelligent real-time image optimizations, image transformations with a global delivery network and storage.
- <b><code>&nbsp;&nbsp;&nbsp;944⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;24🍴</code></b> [Optimizt](https://github.com/funbox/optimizt)) - CLI image optimization tool. It can compress PNG, JPEG, GIF and SVG lossy and lossless and create WebP versions for raster images.

## Lazyloaders

- <b><code>&nbsp;&nbsp;&nbsp;938⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;158🍴</code></b> [lazyload](https://github.com/vvo/lazyload)) - Lazyload images, iframes, widgets with a standalone JavaScript lazyloader ~1kb
- <b><code>&nbsp;&nbsp;7466⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;448🍴</code></b> [lozad.js](https://github.com/ApoorvSaxena/lozad.js)) - Highly performant, light ~0.9kb, and configurable lazy loader in pure JS with no dependencies for responsive images, iframes, and more

## Loaders

- <b><code>&nbsp;&nbsp;4156⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;348🍴</code></b> [HeadJS](https://github.com/headjs/headjs))- The only script in your HEAD. for Responsive Design, Feature Detections, and Resource Loading.
- [RequireJS](http://requirejs.org/) - RequireJS is a JavaScript file and module loader. It is optimized for in-browser use, but it can be used in other JavaScript environments, like Rhino and Node.js.
- [Labjs](http://labjs.com/) - is an open-source (MIT license) project supported by Getify Solutions. The core purpose of LABjs is to be an all-purpose, on-demand JavaScript loader, capable of loading any JavaScript resource, from any location, into any page, at any time.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;69⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;9🍴</code></b> [Defer.js](https://github.com/wessman/defer.js)) - Async Everything: Make the meat of your pages load faster with this JS morsel.
- <b><code>&nbsp;&nbsp;5512⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;246🍴</code></b> [InstantClick](https://github.com/dieulot/instantclick)) - InstantClick makes the following links in your site instant.
- <b><code>&nbsp;&nbsp;&nbsp;509⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;32🍴</code></b> [JIT](https://github.com/shootaroo/jit-grunt)) - A JIT (Just In Time) plugin loader for Grunt. The load time of Grunt does not slow down even if there are many plugins.

## Metrics Monitor

- <b><code>&nbsp;&nbsp;2257⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;142🍴</code></b> [Phantomas](https://github.com/macbre/phantomas)) - PhantomJS-based web performance metrics collector and monitoring tool.
- [Showslow](http://www.showslow.com/) - open source tool that helps monitor various site performance metrics over time. It captures the results of YSlow, Page Speed Insights, WebPageTest and dynaTrace Ajax Edition.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4🍴</code></b> [Bench](https://github.com/jmervine/bench)) - Using Phantomas (a PhantomJS-backed client performance metrics scrapper). Benchmark a page, store results in MongoDB, and display results via the built-in server.
- <b><code>&nbsp;&nbsp;&nbsp;104⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;15🍴</code></b> [Keepfast](https://github.com/keepfast/keepfast)) - Tool to monitor indicators related to the performance of a web page.
- 🌎 [GTmetrix](gtmetrix.com/) - GTmetrix uses Google Page Speed and Yahoo! YSlow to grade your site's performance and provides actionable recommendations to fix these issues.
- 🌎 [Pingbreak.com](pingbreak.com/) - Free site and SSL Monitoring with response time alerting (on Slack, Twitter, Mattermost, Discord or custom Webhook).
- [Pingdom site Speed Test](http://tools.pingdom.com/fpt/) - Test the load time of that page, analyze it, and find bottlenecks.
- 🌎 [Dotcom-tools](www.dotcom-tools.com/website-speed-test.aspx) - analyze your website's speed in real browsers from 20 locations worldwide.
- [WebPageTest](http://www.webpagetest.org/) - Run a free site speed test from multiple locations around the globe using real browsers (IE and Chrome) and at real consumer connection speeds. You can run simple tests or perform advanced testing including multi-step transactions, video capture, content blocking and much more. Your results will provide rich diagnostic information including resource-loading waterfall charts, Page Speed optimization checks and suggestions for improvements.
- 🌎 [Sitespeed.io](www.sitespeed.io/documentation/) - Sitespeed.io is an open-source tool that will check your site against web performance best practice rules and use the Navigation Timing API to collect metrics. It will create XML & HTML output of the result.
- <b><code>&nbsp;&nbsp;&nbsp;284⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [Grunt-phantomas](https://github.com/stefanjudis/grunt-phantomas)) - Grunt plugin wrapping phantomas to measure frontend performance.
- 🌎 [Perfjankie](www.npmjs.com/package/perfjankie) - Runtime Browser Performance regression suite (<b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [Demo](https://github.com/asciidisco/perfjankie-test))).
- 🌎 [BrowserView Monitoring](www.dotcom-monitor.com/website-monitor/website-speed-monitoring/) - Continually checks web page load times in Internet Explorer, Chrome and Firefox from multiple points around the world.
- [New Relic Browser Monitoring](http://newrelic.com/browser-monitoring) - Monitor your browser-side applications in real time, with a focus on real end users’ experiences.
- 🌎 [DareBoost](www.dareboost.com/) - Real Browser Monitoring. Offers complete reports about web performance and quality using YSlow, Page Speed and numerous custom tips.
- 🌎 [Bytes Matter Real User Monitoring](www.bytesmatter.io) - Full featured Real User Monitoring solution. Free tier for smaller sites. Includes monitoring for Google's Core Web Vitals.

## Metrics Monitor - API

- <b><code>&nbsp;&nbsp;1641⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;173🍴</code></b> [WebPageTest API Wrapper for Node.js](https://github.com/marcelduran/webpagetest-api)) - WebPageTest API Wrapper is an npm package that wraps WebPageTest API for Node.js as a module and a command-line tool.

## Metrics Monitor - EMAIL

- 🌎 [WebPerformance Report](webperformancereport.com/) - Web performance report every week in your inbox. Get a Personalized Report on the Status of the E-commerce or Website that you want to monitor in terms of Web performance and Web optimization, Core Web Vitals are included.

## Minifiers - HTML

- 🌎 [HTMLCompressor](code.google.com/archive/p/htmlcompressor/) - HtmlCompressor is a small, fast, and very easy to use Java library that minifies given HTML or XML source by removing extra whitespaces, comments, and other unneeded characters without breaking the content structure. As a result page become smaller in size and load faster. A command-line version of the compressor is also available.
- <b><code>&nbsp;&nbsp;&nbsp;542⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;73🍴</code></b> [Django-htmlmin](https://github.com/cobrateam/django-htmlmin)) - django-html in an HTML minifier for Python with full support for HTML 5. It supports Django, Flask and any other Python web framework. It also provides a command-line tool that can be used for static sites or deployment scripts.
- <b><code>&nbsp;&nbsp;4962⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;576🍴</code></b> [HTMLMinifier](https://github.com/kangax/html-minifier)) - HTMLMinifier is a highly configurable, well-tested, Javascript-based HTML minifier, with lint-like capabilities.
- <b><code>&nbsp;&nbsp;&nbsp;424⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;68🍴</code></b> [Grunt-contrib-htmlmin](https://github.com/gruntjs/grunt-contrib-htmlmin)) - A grunt plugin to minify HTML that uses HTMLMinifier.
- <b><code>&nbsp;&nbsp;&nbsp;726⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;57🍴</code></b> [Gulp-htmlmin](https://github.com/jonschlinkert/gulp-htmlmin)) - A gulp plugin to minify HTML that uses HTMLMinifier.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [Grunt-htmlcompressor](https://github.com/jney/grunt-htmlcompressor)) - Grunt plugin for HTML compression, using htmlcompressor.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7🍴</code></b> [HTML_minifier](https://github.com/stereobooster/html_minifier)) - Ruby wrapper for kangax html-minifier.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;35⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;7🍴</code></b> [HTML_press](https://github.com/stereobooster/html_press)) - Ruby gem for compressing html, that removes all whitespace junk, and leaves only HTML.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;31⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6🍴</code></b> [Koa HTML Minifier](https://github.com/koajs/html-minifier)) - Middleware that minifies your HTML responses using html-minifier. It uses html-minifier's default options which are all turned off by default, so you have to set the options otherwise it's not going to do anything.
- [HTML Minifier Online](http://kangax.github.io/html-minifier/) - A HTML min tool by kangax (HTMLMinifier Creator).
- <b><code>&nbsp;&nbsp;&nbsp;162⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;18🍴</code></b> [Minimize](https://github.com/Swaagie/minimize)) - Minimize is an HTML minifier based on the node-htmlparser,currently, HTML minifier is only usable server-side. Client-side minification will be added in a future release.
- <b><code>&nbsp;&nbsp;&nbsp;133⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;86🍴</code></b> [Html-minifier](https://github.com/deanhume/html-minifier)) - A simple Windows command-line tool to minify your HTML, Razor views & Web Forms views

## Minifiers - JS & CSS

- <b><code>&nbsp;&nbsp;3016⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;665🍴</code></b> [YUI Compressor](https://github.com/yui/yuicompressor)) - JavaScript compressor which, in addition to removing comments and white-spaces, obfuscates local variables using the smallest possible variable name. This obfuscation is safe, even when using constructs such as 'eval' or 'with' (although the compression is not optimal is those cases) Compared to jsmin, the average savings is around 20%.
- <b><code>&nbsp;13204⭐</code></b> <b><code>&nbsp;&nbsp;1246🍴</code></b> [UglifyJS2](https://github.com/mishoo/UglifyJS2)) - UglifyJS is a JavaScript parser, minifier, compressor or beautifier toolkit, written in JavaScript.
- <b><code>&nbsp;&nbsp;3768⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;186🍴</code></b> [CSSO](https://github.com/css/csso)) - CSS minimizer unlike others. In addition to usual minification techniques, it can perform structural optimization of CSS files, resulting in smaller file size compared to other minifiers.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;76⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;36🍴</code></b> [CSSmin.js](https://github.com/stoyan/yuicompressor/blob/master/ports/js/cssmin.js)) - cssmin.js is a JavaScript port of YUICompressor's CSS minifier.
- <b><code>&nbsp;&nbsp;&nbsp;812⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;170🍴</code></b> [Grunt-contrib-concat](https://github.com/gruntjs/grunt-contrib-concat)) - A Grunt plugin to concatenate files.
- <b><code>&nbsp;&nbsp;1481⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;348🍴</code></b> [Grunt-contrib-uglify](https://github.com/gruntjs/grunt-contrib-uglify)) - A Grunt plugin to concatenate and minify JavaScript files.
- <b><code>&nbsp;&nbsp;4178⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;323🍴</code></b> [Clean-css](https://github.com/jakubpawlowicz/clean-css)) - A fast, efficient, and well-tested CSS minifier for node.js.
- <b><code>&nbsp;&nbsp;2811⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;601🍴</code></b> [Django-compressor](https://github.com/django-compressor/django-compressor)) - Compresses linked and inline JavaScript or CSS into a single cached file.
- <b><code>&nbsp;&nbsp;1520⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;371🍴</code></b> [Django-pipeline](https://github.com/cyberdelia/django-pipeline)) - Pipeline is an asset packaging library for Django, providing both CSS and JavaScript concatenation and compression, built-in JavaScript template support, and optional data-URI image and font embedding.
- <b><code>&nbsp;&nbsp;&nbsp;750⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;150🍴</code></b> [JShrink](https://github.com/tedious/JShrink)) - JShrink is a PHP class that minifies JavaScript so that it can be delivered to the client quicker.
- [JSCompress](http://jscompress.com/) - The most minimalistic online JS Compress tool.
- <b><code>&nbsp;&nbsp;1052⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;81🍴</code></b> [CSSshrink](https://github.com/stoyan/cssshrink)) - Because CSS is ospon the critical path to rendering pages. It must be small! Or else!
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;28⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4🍴</code></b> [Grunt-cssshrink](https://github.com/JohnCashmore/grunt-cssshrink)) - This is just a grunt wrapper for CSS Shrink.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [Gulp-cssshrink](https://github.com/torrottum/gulp-cssshrink)) - Shrinks CSS files using cssshrink for Gulp.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [Prettyugly](https://github.com/stoyan/prettyugly)) - Uglify (strip spaces) or prettify (add consistent spaces) CSS code.
- <b><code>&nbsp;&nbsp;&nbsp;795⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;138🍴</code></b> [Grunt-contrib-cssmin](https://github.com/gruntjs/grunt-contrib-cssmin)) - CSS Minifier for Grunt.
- <b><code>&nbsp;&nbsp;3825⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;174🍴</code></b> [Grunt-uncss](https://github.com/addyosmani/grunt-uncss)) - A grunt task for removing unused CSS from your projects.
- <b><code>&nbsp;&nbsp;&nbsp;938⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;40🍴</code></b> [Gulp-uncss](https://github.com/ben-eb/gulp-uncss)) - A gulp task for removing unused CSS from your projects.

## Miscellaneous

- [Socialite.js](http://socialitejs.com/) - Socialite provides a very easy way to implement and activate a plethora of social sharing buttons — any time you wish. On document load, on article hover, on any event.
- <b><code>&nbsp;&nbsp;1620⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;64🍴</code></b> [uCSS](https://github.com/oyvindeh/ucss)) - uCSS is made for crawling (large) sites to find unused CSS selectors, but not remove unused CSS.
- <b><code>&nbsp;&nbsp;&nbsp;343⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;21🍴</code></b> [HTTPinvoke](https://github.com/jakutis/httpinvoke))- A no-dependencies HTTP client library for browsers and Node.js with a promise-based or Node.js-style callback-based API to progress events, text, and binary file upload and download, partial response body, request and response headers, status code.
- <b><code>&nbsp;10052⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;372🍴</code></b> [Critical](https://github.com/addyosmani/critical)) - Extract & Inline Critical-path CSS in HTML pages (alpha).
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;12⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1🍴</code></b> [Csscolormin](https://github.com/stoyan/csscolormin)) - Utility that minifies CSS colors, example: min("white"); // minifies to "#fff".
- <b><code>&nbsp;17585⭐</code></b> <b><code>&nbsp;&nbsp;1731🍴</code></b> [Lazysizes](https://github.com/aFarkas/lazysizes)) - High-performance lazy loader for images (responsive and normal), iframes, and scripts, that detects any visibility changes triggered through user interaction, CSS or JavaScript without configuration.
- [Perf-Tooling](http://perf-tooling.today/) - Perf Tooling is a shared resource to keep track of new and existing performance tools.
- <b><code>&nbsp;&nbsp;1631⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;45🍴</code></b> [TMI](https://github.com/addyosmani/tmi)) - TMI (Too Many Images) - discover your image weight on the web.

## SVG

- <b><code>&nbsp;21150⭐</code></b> <b><code>&nbsp;&nbsp;1390🍴</code></b> [SVGO](https://github.com/svg/svgo)) - SVGO is a Nodejs-based tool for optimizing SVG vector graphics files.
- 🌎 [SVG OMG](jakearchibald.github.io/svgomg/) - SVGOMG is SVGO's Missing GUI, aiming to expose the majority, if not all the configuration options of SVGO.
- <b><code>&nbsp;&nbsp;&nbsp;433⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;40🍴</code></b> [Grunt-svgmin](https://github.com/sindresorhus/grunt-svgmin)) - Minify SVG using SVGO for Grunt.
- 🌎 [Gulp-svgmin](www.npmjs.com/package/gulp-svgmin) - Minify SVG with SVGO for Gulp.
- [Scour](http://www.codedread.com/scour/) - Scour is an open-source Python script that aggressively cleans SVG files, removing a lot of 'cruft' that certain tools or authors embed into their documents.
- <b><code>&nbsp;&nbsp;1634⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;93🍴</code></b> [SVG Cleaner](https://github.com/RazrFalcon/SVGCleaner)) - SVG Cleaner could help you to clean up your SVG files from unnecessary data. It has a lot of options for cleanup and optimization, works in batch mode, and provides threaded processing on multicore processors.

## Web Components

- <b><code>&nbsp;&nbsp;&nbsp;431⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;201🍴</code></b> [Polymer Bundler](https://github.com/Polymer/tools/tree/master/packages/bundler)) - Polymer-bundler is a library for packaging project assets for production to minimize network round-trips.
- <b><code>&nbsp;&nbsp;&nbsp;100⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [Gulp-vulcanize](https://github.com/sindresorhus/gulp-vulcanize)) - Concatenate a set of Web Components into one file that use Vulcanize.

## Web server Benchmarks

- <b><code>&nbsp;&nbsp;&nbsp;992⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;156🍴</code></b> [HTTPerf](https://github.com/httperf/httperf)) - httperf is a tool for measuring web server performance. It provides a flexible facility for generating various HTTP workloads and for measuring server performance.
- [Apache JMeter](http://jmeter.apache.org/download_jmeter.cgi) - Open source load testing tool: It is a Java platform application.
- [Locust](http://locust.io) - An open-source load testing tool. Define user behaviour with Python code, and swarm your system with millions of simultaneous users.
- <b><code>&nbsp;&nbsp;&nbsp;179⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;23🍴</code></b> [Autoperf](https://github.com/igrigorik/autoperf)) - Autoperf is a ruby driver for httperf, designed to help you automate load and performance testing of any web application - for a single endpoint, or through log replay.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;13⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4🍴</code></b> [HTTPerf.rb](https://github.com/jmervine/httperfrb)) - Simple Ruby interface for httperf, written in Ruby.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;5⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [PHP-httperf](https://github.com/jmervine/php-httperf)) - PHP Port of HTTPerf.rb.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2🍴</code></b> [HTTPerf.js](https://github.com/jmervine/httperfjs)) - JS Port of HTTPerf.rb.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;11⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8🍴</code></b> [HTTPerf.py](https://github.com/jmervine/httperfpy)) - Python Port of HTTPerf.rb.
- <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;0🍴</code></b> [Gohttperf](https://github.com/jmervine/gohttperf)) - Go Port of HTTPerf.rb.
- <b><code>&nbsp;38207⭐</code></b> <b><code>&nbsp;&nbsp;2955🍴</code></b> [wrk](https://github.com/wg/wrk)) - A HTTP benchmarking tool (with optional Lua scripting for request generation, response
  processing, and custom reporting)
- <b><code>&nbsp;&nbsp;6455⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;631🍴</code></b> [beeswithmachineguns](https://github.com/newsapps/beeswithmachineguns)) - A utility for arming (creating) many bees (micro EC2 instances) to attack (load test) targets (web applications).
- 🌎 [k6](k6.io/) - An open-source load testing tool built for developers. Easy to integrate into CI pipelines. Tests are written in ES6 JS and you can test APIs, microservices and sites using HTTP/1.1, HTTP/2 and WebSocket.

## Web server Modules

- 🌎 [PageSpeed Module](developers.google.com/speed/pagespeed/module/download) - PageSpeed speeds up your site and reduces page load time. This open-source web server module automatically applies web performance best practices to pages and associated assets (CSS, JavaScript, images) without requiring that you modify your existing content or workflow. PageSpeed is available as a module for Apache 2.x and Nginx 1.x.
- <b><code>&nbsp;&nbsp;&nbsp;244⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;22🍴</code></b> [WebP-detect](https://github.com/igrigorik/webp-detect)) - WebP with Accept negotiation.

# Specs

- [Web Performance Working Group](http://www.w3.org/2010/webperf/) - The mission of the Web Performance Working Group, part of the Rich Web Client Activity, is to provide methods to measure aspects of application performance of user agent features and APIs.
- [Page Visibility](http://www.w3.org/TR/page-visibility/) - This specification defines a means for site developers to programmatically determine the current visibility state of the page in order to develop power and CPU-efficient web applications.
- 🌎 [Navigation Timing](w3c.github.io/navigation-timing/) - This specification defines a unified interface to store and retrieve high resolution performance metric data related to the navigation of a document.
- [Resource Timing](http://www.w3.org/TR/resource-timing/) - This specification defines an interface for web applications to access the complete timing information for resources in a document.
- [User Timing](http://www.w3.org/TR/user-timing/) - This specification defines an interface to help web developers measure the performance of their applications by giving them access to high-precision timestamps.
- [Performance Timeline](http://www.w3.org/TR/performance-timeline/) - This specification defines a unified interface to store and retrieve performance metric data. This specification does not cover individual performance metric interfaces.
- 🌎 [CSS will-change](drafts.csswg.org/css-will-change/) - This specification defines the `will-change` CSS property which allows an author to declare ahead-of-time what properties are likely to change in the future, so the UA can set up the appropriate optimizations some time before they’re needed. This way, when the actual change happens, the page updates in a snappy manner.
- [Resource Hints](http://www.w3.org/TR/resource-hints/) - This specification defines the dns-prefetch, preconnect, prefetch, and prerender relationships of the HTML Link Element (&lt;link&gt;). These primitives enable the developer, and the server generating or delivering the resources, to assist the user agent in the decision process of which origins it should connect to, and which resources it should fetch and preprocess to improve page performance.

# Stats

- [HTTP Archive](http://httparchive.org/index.php) - It's a permanent repository of web performance information such as size of pages, failed requests, and technologies utilized. This performance information allows us to see trends in how the Web is built and provides a common data set from which to conduct web performance research.

# Other Awesome Lists

- <b><code>&nbsp;&nbsp;&nbsp;958⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;25🍴</code></b> [iamakulov/awesome-webpack-perf](https://github.com/iamakulov/awesome-webpack-perf)) - A curated list of webpack tools for web performance
- <b><code>&nbsp;32197⭐</code></b> <b><code>&nbsp;&nbsp;3561🍴</code></b> [bayandin/awesome-awesomeness](https://github.com/bayandin/awesome-awesomeness)).
- <b><code>338979⭐</code></b> <b><code>&nbsp;28117🍴</code></b> [sindresorhus/awesome](https://github.com/sindresorhus/awesome)).
- <b><code>&nbsp;&nbsp;&nbsp;823⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;&nbsp;61🍴</code></b> [imteekay/web-performance-research](https://github.com/imteekay/web-performance-research)) - Research in Web Performance

# Contributing

For contributing, [open an issue](https://github.com/correia-jpv/fucking-awesome-wpo/issues) and/or a [pull request](https://github.com/correia-jpv/fucking-awesome-wpo/pulls).

## Source
<b><code>&nbsp;&nbsp;8403⭐</code></b> <b><code>&nbsp;&nbsp;&nbsp;563🍴</code></b> [davidsonfellipe/awesome-wpo](https://github.com/davidsonfellipe/awesome-wpo))