# Contribution Guidelines
Awesome PHP aims to be a concise list of the best packages, frameworks, tools, and software the PHP ecosystem has to offer. Unfortunately, this means not everything can or should be included. The suggested software should ideally be one of the following:

* Widely known or recognised within the PHP community
* Established and mature
* Unique in its approach
* Fulfill a niche gap in the market

Where applicable, preference will be given to software that:

* Targets supported versions of PHP
* Can be installed using Composer
* Is PSR compliant
* Semantically versioned
* Thoroughly tested
* Actively maintained
* Well documented in English

Also, please ensure your pull request adheres to the following guidelines:

* Your suggestion will be closed if it has been previously rejected or is a duplicate
* Write a meaningful pull request description that includes a link to the project
* Adheres to the following Markdown format: `[LIBRARY](LINK) - DESCRIPTION.`
* Your description is short, clear, unbiased, and doesn't contain any jargon
* The description ends with a full stop/period and no trailing whitespace
* You've checked your spelling and grammar
* Your entry is added alphabetically to the category
* If your entry has the same name as another, it should be prefixed with the vendor (e.g., `Foo\Bar` becomes `Foo Bar`)
* Feel free to suggest new categories or organisational improvements

Please make sure your suggestion meets all the criteria before submitting a pull request, or it may be closed without review.

Thank you for your suggestions!
