import React from 'react';
import Layout from '@/layout/Layout';
import Footer from '@/layout/Footer/Footer';
import Navbar from '@/layout/Header/Navbar';
import PageHeader from '@/components/common/PageHeader';

import { privacyPolicy as metaData } from '@/utils/metaData';
import { privacyPolicy as pageHeader } from '@/utils/pageHeader';

const PrivacyPolicy = () => {
  return (
    <Layout title={metaData.title} description={metaData.description}>
      <Navbar classOption="navbar-light" />
      <PageHeader title={pageHeader.title} description={pageHeader.description} />

      <div className="container mt-100">

        <h4 className="mb-4">1. Introduction</h4>
        <p style={{ textAlign: "justify" }}>
          Welcome to&nbsp;<strong>CopywriterProAI</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          CopywriterProAI&nbsp;(“us”, “we”, or “our”)
          operates&nbsp;https://copywriterpro.ai&nbsp;(hereinafter referred to
          as “<strong>Service</strong>”).
        </p>
        <p style={{ textAlign: "justify" }}>
          Our Privacy Policy governs your visit
          to&nbsp;https://copywriterpro.ai, and explains how we collect,
          safeguard and disclose information that results from your use of our
          Service.&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          We use your data to provide and improve Service. By using Service, you
          agree to the collection and use of information in accordance with this
          policy. Unless otherwise defined in this Privacy Policy, the terms
          used in this Privacy Policy have the same meanings as in our Terms and
          Conditions.
        </p>
        <p style={{ textAlign: "justify" }}>
          Our Terms and Conditions (“<strong>Terms</strong>”) govern all use of
          our Service and together with the Privacy Policy constitutes your
          agreement with us (“<strong>Agreement</strong>”).
        </p>

        <h4 className="mt-5 mb-4">2. Definitions</h4>
        <p style={{ textAlign: "justify" }}>
          <strong>SERVICE&nbsp;</strong>means the&nbsp;https://copywriterpro.ai
          website&nbsp;operated by&nbsp;CopywriterProAI
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>PERSONAL DATA</strong>&nbsp;means data about a living
          individual who can be identified from those data (or from those and
          other information either in our possession or likely to come into our
          possession).
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>USAGE DATA</strong>&nbsp;is data collected automatically
          either generated by the use of Service or from Service infrastructure
          itself (for example, the duration of a page visit).
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>COOKIES</strong>&nbsp;are small files stored on your device
          (computer or mobile device).
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>DATA CONTROLLER</strong>&nbsp;means a natural or legal person
          who (either alone or jointly or in common with other persons)
          determines the purposes for which and the manner in which any personal
          data are, or are to be, processed. For the purpose of this Privacy
          Policy, we are a Data Controller of your data.
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>DATA PROCESSORS (OR SERVICE PROVIDERS)</strong>&nbsp;means any
          natural or legal person who processes the data on behalf of the Data
          Controller. We may use the services of various Service Providers in
          order to process your data more effectively.
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>DATA SUBJECT&nbsp;</strong>is any living individual who is the
          subject of Personal Data.
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>THE USER&nbsp;</strong>is the individual using our Service.
          The User corresponds to the Data Subject, who is the subject of
          Personal Data.
        </p>

        <h4 className="mt-5 mb-4">3. Information Collection and Use</h4>
        <p style={{ textAlign: "justify" }}>
          We collect several different types of information for various purposes
          to provide and improve our Service to you.
        </p>

        <h4 className="mt-5 mb-4">4. Types of Data Collected</h4>
        <p style={{ textAlign: "justify" }}>
          <strong>Personal Data</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          While using our Service, we may ask you to provide us with certain
          personally identifiable information that can be used to contact or
          identify you (“<strong>Personal Data</strong>”). Personally,
          identifiable information may include, but is not limited to:
        </p>
        <ol>(a) Email address</ol>
        <ol>(b) First name and last name</ol>
        <ol>(c) Cookies and Usage Data</ol>
        <p style={{ textAlign: "justify" }}>
          We may use your Personal Data to contact you with newsletters,
          marketing or promotional materials, and other information that may be
          of interest to you. You may opt out of receiving any, or all, of these
          communications from us by following the unsubscribe link or by
          emailing at support@copywriterpro.ai
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Usage Data</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          We may also collect information that your browser sends whenever you
          visit our Service or when you access Service by or through a mobile
          device (“<strong>Usage Data</strong>”).
        </p>
        <p style={{ textAlign: "justify" }}>
          This Usage Data may include information such as your computer&apos;s
          Internet Protocol address (e.g. IP address), browser type, browser
          version, the pages of our Service that you visit, the time and date of
          your visit, the time spent on those pages, unique device identifiers
          and other diagnostic data.
        </p>
        <p style={{ textAlign: "justify" }}>
          When you access Service with a mobile device, this Usage Data may
          include information such as the type of mobile device you use, your
          mobile device unique ID, the IP address of your mobile device, your
          mobile operating system, the type of mobile Internet browser you use,
          unique device identifiers and other diagnostic data.
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Tracking Cookies Data</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          We use cookies and similar tracking technologies to track the activity
          on our Service and we hold certain information.
        </p>
        <p style={{ textAlign: "justify" }}>
          Cookies are files with a small amount of data which may include an
          anonymous unique identifier. Cookies are sent to your browser from a
          website and stored on your device. Other tracking technologies are
          also used such as beacons, tags and scripts to collect and track
          information and to improve and analyze our Service.
        </p>
        <p style={{ textAlign: "justify" }}>
          You can instruct your browser to refuse all cookies or to indicate
          when a cookie is being sent. However, if you do not accept cookies,
          you may not be able to use some portions of our Service.
        </p>
        <p style={{ textAlign: "justify" }}>Examples of Cookies we use:</p>
        <ol>
          <strong>(a) Session Cookies:</strong>&nbsp;We use Session Cookies to
          operate our Service.
        </ol>
        <ol>
          <strong>(b) Preference Cookies:</strong>&nbsp;We use Preference
          Cookies to remember your preferences and various settings.
        </ol>
        <ol>
          <strong>(c) Security Cookies:</strong>&nbsp;We use Security Cookies
          for security purposes.
        </ol>
        <ol>
          <strong>(d) Advertising Cookies:</strong>&nbsp;Advertising Cookies are
          used to serve you with advertisements that may be relevant to you and
          your interests.
        </ol>

        <h4 className="mt-5 mb-4">5. Use of Data</h4>
        <p style={{ textAlign: "justify" }}>
          CopywriterProAI&nbsp;uses the collected data for various purposes:
        </p>
        <ol>(a) to provide and maintain our Service;</ol>
        <ol>(b) to notify you about changes to our Service;</ol>
        <ol>
          (c) to allow you to participate in interactive features of our Service
          when you choose to do so;
        </ol>
        <ol>(d) to provide customer support;</ol>
        <ol>
          (e) to gather analysis or valuable information so that we can improve
          our Service;
        </ol>
        <ol>(f) to monitor the usage of our Service;</ol>
        <ol>(g) to detect, prevent and address technical issues;</ol>
        <ol>(h) to fulfill any other purpose for which you provide it;</ol>
        <ol>
          (i) to carry out our obligations and enforce our rights arising from
          any contracts entered into between you and us, including for billing
          and collection;
        </ol>
        <ol>
          (j) to provide you with notices about your account and/or
          subscription, including expiration and renewal notices,
          email-instructions, etc.;
        </ol>
        <ol>
          (k) to provide you with news, special offers and general information
          about other goods, services and events which we offer that are similar
          to those that you have already purchased or enquired about unless you
          have opted not to receive such information;
        </ol>
        <ol>
          (l) in any other way we may describe when you provide the information;
        </ol>
        <ol>(m) for any other purpose with your consent;</ol>

        <h4 className="mt-5 mb-4">6. Retention of Data</h4>
        <p style={{ textAlign: "justify" }}>
          We will retain your Personal Data only for as long as is necessary for
          the purposes set out in this Privacy Policy. We will retain and use
          your Personal Data to the extent necessary to comply with our legal
          obligations (for example, if we are required to retain your data to
          comply with applicable laws), resolve disputes, and enforce our legal
          agreements and policies.
        </p>
        <p style={{ textAlign: "justify" }}>
          We will also retain Usage Data for internal analysis purposes. Usage
          Data is generally retained for a shorter period, except when this data
          is used to strengthen the security or to improve the functionality of
          our Service, or we are legally obligated to retain this data for
          longer time periods.
        </p>

        <h4 className="mt-5 mb-4">7. Transfer of Data</h4>
        <p style={{ textAlign: "justify" }}>
          Your information, including Personal Data, may be transferred to – and
          maintained on – computers located outside of your state, province,
          country or other governmental jurisdiction where the data protection
          laws may differ from those of your jurisdiction.
        </p>
        <p style={{ textAlign: "justify" }}>
          If you are located outside United States and choose to provide
          information to us, please note that we transfer the data, including
          Personal Data, to United States and process it there.
        </p>
        <p style={{ textAlign: "justify" }}>
          Your consent to this Privacy Policy followed by your submission of
          such information represents your agreement to that transfer.
        </p>
        <p style={{ textAlign: "justify" }}>
          CopywriterProAI&nbsp;will take all the steps reasonably necessary to
          ensure that your data is treated securely and in accordance with this
          Privacy Policy and no transfer of your Personal Data will take place
          to an organisation or a country unless there are adequate controls in
          place including the security of your data and other personal
          information.
        </p>

        <h4 className="mt-5 mb-4">8. Disclosure of Data</h4>
        <p style={{ textAlign: "justify" }}>
          We may disclose personal information that we collect, or you provide:
        </p>
        <ol>
          <strong>(a) Disclosure for Law Enforcement.</strong>
        </ol>
        <p style={{ textAlign: "justify" }}>
          Under certain circumstances, we may be required to disclose your
          Personal Data if required to do so by law or in response to valid
          requests by public authorities.
        </p>
        <ol>
          <strong>(b) Business Transaction.</strong>
        </ol>
        <p style={{ textAlign: "justify" }}>
          If we or our subsidiaries are involved in a merger, acquisition or
          asset sale, your Personal Data may be transferred.
        </p>
        <ol>
          <strong>
            (c) Other cases. We may disclose your information also:
          </strong>
        </ol>
        <ol>(a) to our subsidiaries and affiliates;</ol>
        <ol>
          (b) for the purpose of including your company’s logo on our website;
        </ol>
        <ol>
          (c) for any other purpose disclosed by us when you provide the
          information;
        </ol>
        <ol>(d) with your consent in any other cases;</ol>
        <ol>
          (e) if we believe disclosure is necessary or appropriate to protect
          the rights, property, or safety of the Company, our customers, or
          others.
        </ol>

        <h4 className="mt-5 mb-4">9. Security of Data</h4>
        <p style={{ textAlign: "justify" }}>
          The security of your data is important to us but remember that no
          method of transmission over the Internet or method of electronic
          storage is 100% secure. While we strive to use commercially acceptable
          means to protect your Personal Data, we cannot guarantee its absolute
          security.
        </p>

        <h4 className="mt-5 mb-4">10. Your Data Protection Rights Under General Data Protection
                Regulation (GDPR)</h4>
        <p style={{ textAlign: "justify" }}>
          If you are a resident of the European Union (EU) and European Economic
          Area (EEA), you have certain data protection rights, covered by GDPR.
          – See more at https://eur-lex.europa.eu/eli/reg/2016/679/oj&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          We aim to take reasonable steps to allow you to correct, amend,
          delete, or limit the use of your Personal Data.
        </p>
        <p style={{ textAlign: "justify" }}>
          If you wish to be informed what Personal Data we hold about you and if
          you want it to be removed from our systems, please email us at
          support@copywriterpro.ai.&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          In certain circumstances, you have the following data protection
          rights:
        </p>
        <ol>
          (a) the right to access, update or to delete the information we have
          on you;
        </ol>
        <ol>
          (b) the right of rectification. You have the right to have your
          information rectified if that information is inaccurate or incomplete;
        </ol>
        <ol>
          (c) the right to object. You have the right to object to our
          processing of your Personal Data;
        </ol>
        <ol>
          (d) the right of restriction. You have the right to request that we
          restrict the processing of your personal information;
        </ol>
        <ol>
          (e) the right to data portability. You have the right to be provided
          with a copy of your Personal Data in a structured, machine-readable
          and commonly used format;
        </ol>
        <ol>
          (f) the right to withdraw consent.&nbsp;You also have the right to
          withdraw your consent at any time where we rely on your consent to
          process your personal information;
        </ol>
        <p style={{ textAlign: "justify" }}>
          Please note that we may ask you to verify your identity before
          responding to such requests. Please note, we may not able to provide
          Service without some necessary data.
        </p>
        <p style={{ textAlign: "justify" }}>
          You have the right to complain to a Data Protection Authority about
          our collection and use of your Personal Data. For more information,
          please contact your local data protection authority in the European
          Economic Area (EEA).
        </p>

        <h4 className="mt-5 mb-4">11. Your Data Protection Rights under the California Privacy
                Protection Act (CalOPPA)</h4>
        <p style={{ textAlign: "justify" }}>
          CalOPPA is the first state law in the nation to require commercial
          websites and online services to post a privacy policy. The law’s reach
          stretches well beyond California to require a person or company in the
          United States (and conceivable the world) that operates websites
          collecting personally identifiable information from California
          consumers to post a conspicuous privacy policy on its website stating
          exactly the information being collected and those individuals with
          whom it is being shared, and to comply with this policy. – See more
          at:
          https://consumercal.org/about-cfc/cfc-education-foundation/california-online-privacy-protection-act-caloppa-3/&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          According to CalOPPA we agree to the following:
        </p>
        <ol>(a) users can visit our site anonymously;</ol>
        <ol>
          (b) our Privacy Policy link includes the word “Privacy”, and can
          easily be found on the page specified above on the home page of our
          website;
        </ol>
        <ol>
          (c) users will be notified of any privacy policy changes on our
          Privacy Policy Page;
        </ol>
        <ol>
          (d) users are able to change their personal information by emailing us
          at support@copywriterpro.ai
        </ol>
        <p style={{ textAlign: "justify" }}>
          Our Policy on “Do Not Track” Signals:
        </p>
        <p style={{ textAlign: "justify" }}>
          We honor Do Not Track signals and do not track, plant cookies, or use
          advertising when a Do Not Track browser mechanism is in place. Do Not
          Track is a preference you can set in your web browser to inform
          websites that you do not want to be tracked.&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          You can enable or disable Do Not Track by visiting the Preferences or
          Settings page of your web browser.
        </p>

        <h4 className="mt-5 mb-4">12. Your Data Protection Rights under the California Consumer
                Privacy Act (CCPA)</h4>
        <p style={{ textAlign: "justify" }}>
          If you are a California resident, you are entitled to learn what data
          we collect about you, ask to delete your data and not to sell (share)
          it. To exercise your data protection rights, you can make certain
          requests and ask us:
        </p>
        <ol>
          <strong>(a) What personal information we have about you</strong>. If
          you make this request, we will return to you:
        </ol>
        <ol>
          (i) The categories of personal information we have collected about
          you.
        </ol>
        <ol>
          (ii) The categories of sources from which we collect your personal
          information.
        </ol>
        <ol>
          (iii) The business or commercial purpose for collecting or selling
          your personal information.
        </ol>
        <ol>
          (iv) The categories of third parties with whom we share personal
          information.
        </ol>
        <ol>
          (v) The specific pieces of personal information we have collected
          about you.
        </ol>
        <ol>
          (vi) A list of categories of personal information that we have sold,
          along with the category of any other company we sold it to. If we have
          not sold your personal information, we will inform you of that fact.
        </ol>
        <ol>
          (vii) A list of categories of personal information that we have
          disclosed for a business purpose, along with the category of any other
          company we shared it with.
        </ol>
        <p style={{ textAlign: "justify" }}>
          Please note, you are entitled to ask us to provide you with this
          information up to two times in a rolling twelve-month period. When you
          make this request, the information provided may be limited to the
          personal information we collected about you in the previous
          12&nbsp;months.
        </p>
        <ol>
          <strong>(b) To delete your personal information</strong>. If you make
          this request, we will delete the personal information we hold about
          you as of the date of your request from our records and direct any
          service providers to do the same. In some cases, deletion may be
          accomplished through de-identification of the information. If you
          choose to delete your personal information, you may not be able to use
          certain functions that require your personal information to operate.
        </ol>
        <ol>
          <strong>(c) To stop selling your personal information</strong>. We
          don&apos;t sell or rent your personal information to any third parties
          for any purpose. You are the only owner of your Personal Data and can
          request disclosure or deletion at any time.
        </ol>
        <p style={{ textAlign: "justify" }}>
          Please note, if you ask us to delete or stop selling your data, it may
          impact your experience with us, and you may not be able to participate
          in certain programs or membership services which require the usage of
          your personal information to function. But in no circumstances, we
          will discriminate against you for exercising your rights.
        </p>
        <p style={{ textAlign: "justify" }}>
          To exercise your California data protection rights described above,
          please send your request(s) by one of the following means:
        </p>
        <p style={{ textAlign: "justify" }}>
          By email: support@copywriterpro.ai
        </p>
        <p style={{ textAlign: "justify" }}>
          By visiting this page on our website: https://copywriterpro.ai/contact
        </p>
        <p style={{ textAlign: "justify" }}>By phone number: +8801795200304</p>
        <p style={{ textAlign: "justify" }}>
          Your data protection rights, described above, are covered by the CCPA,
          short for the California Consumer Privacy Act. To find out more, visit
          the official California Legislative Information website. The CCPA took
          effect on 01/01/2020.&nbsp;
        </p>

        <h4 className="mt-5 mb-4">13. Service Providers</h4>
        <p style={{ textAlign: "justify" }}>
          We may employ third party companies and individuals to facilitate our
          Service (“<strong>Service Providers</strong>”), provide Service on our
          behalf, perform Service-related services or assist us in analysing how
          our Service is used.
        </p>
        <p style={{ textAlign: "justify" }}>
          These third parties have access to your Personal Data only to perform
          these tasks on our behalf and are obligated not to disclose or use it
          for any other purpose.
        </p>

        <h4 className="mt-5 mb-4">14. Analytics</h4>
        <p style={{ textAlign: "justify" }}>
          We may use third-party Service Providers to monitor and analyze the
          use of our Service.
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Google Analytics</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          Google Analytics is a web analytics service offered by Google that
          tracks and reports website traffic. Google uses the data collected to
          track and monitor the use of our Service. This data is shared with
          other Google services. Google may use the collected data to
          contextualise and personalise the ads of its own advertising network.
        </p>
        <p style={{ textAlign: "justify" }}>
          For more information on the privacy practices of Google, please visit
          the Google Privacy Terms web page:
          https://policies.google.com/privacy?hl=en
        </p>
        <p style={{ textAlign: "justify" }}>
          We also encourage you to review the Google&apos;s policy for
          safeguarding your data:
          https://support.google.com/analytics/answer/6004245.
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Cloudflare analytics</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          Cloudflare analytics is a web analytics service operated by Cloudflare
          Inc. Read the Privacy Policy here:
          https://www.cloudflare.com/privacypolicy/&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Segment.io</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          Segment.io is a web traffic analysis tool. You can read the Privacy
          Policy for Segment.io here: https://segment.com/legal/privacy/.
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Mixpanel</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          Mixpanel is provided by Mixpanel Inc.
        </p>
        <p style={{ textAlign: "justify" }}>
          You can prevent Mixpanel from using your information for analytics
          purposes by opting-out. To opt-out of Mixpanel service, please visit
          this page: https://mixpanel.com/optout/
        </p>
        <p style={{ textAlign: "justify" }}>
          For more information on what type of information Mixpanel collects,
          please visit the Terms of Use page of Mixpanel:
          https://mixpanel.com/terms/
        </p>

        <h4 className="mt-5 mb-4">15. CI/CD tools</h4>
        <p style={{ textAlign: "justify" }}>
          We may use third-party Service Providers to automate the development
          process of our Service.&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>GitLab CI/CD</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          GitLab CI/CD is provided by GitLab, Inc.
        </p>
        <p style={{ textAlign: "justify" }}>
          GitLab CI (Continuous Integration) service is a part of GitLab that
          build and test the software whenever developer pushes code to
          application.&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          GitLab CD (Continuous Deployment) is a software service that places
          the changes of every code in the production which results in every day
          deployment of production.&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          For more information on what data GitLab CI/CD collects for what
          purpose and how the protection of the data is ensured, please visit
          GitLab CI/CD Privacy Policy page: https://about.gitlab.com/privacy/.
        </p>

        <h4 className="mt-5 mb-4">16. Behavioral Remarketing</h4>
        <p style={{ textAlign: "justify" }}>
          CopywriterProAI&nbsp;uses remarketing services to advertise on third
          party websites to you after you visited our Service. We and our
          third-party vendors use cookies to inform, optimise and serve ads
          based on your past visits to our Service.
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Google Ads (AdWords)</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          Google Ads (AdWords) remarketing service is provided by Google Inc.
        </p>
        <p style={{ textAlign: "justify" }}>
          You can opt-out of Google Analytics for Display Advertising and
          customize the Google Display Network ads by visiting the Google Ads
          Settings page: http://www.google.com/settings/ads
        </p>
        <p style={{ textAlign: "justify" }}>
          Google also recommends installing the Google Analytics Opt-out Browser
          Add-on – https://tools.google.com/dlpage/gaoptout – for your web
          browser. Google Analytics Opt-out Browser Add-on provides visitors
          with the ability to prevent their data from being collected and used
          by Google Analytics.
        </p>
        <p style={{ textAlign: "justify" }}>
          For more information on the privacy practices of Google, please visit
          the Google Privacy Terms web page:
          https://policies.google.com/privacy?hl=en
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Bing Ads Remarketing</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          Bing Ads remarketing service is provided by Microsoft Inc.
        </p>
        <p style={{ textAlign: "justify" }}>
          You can opt-out of Bing Ads interest-based ads by following their
          instructions:
          https://advertise.bingads.microsoft.com/en-us/resources/policies/personalized-ads
        </p>
        <p style={{ textAlign: "justify" }}>
          You can learn more about the privacy practices and policies of
          Microsoft by visiting their Privacy Policy page:
          https://privacy.microsoft.com/en-us/PrivacyStatement
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Twitter</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          Twitter remarketing service is provided by Twitter Inc.
        </p>
        <p style={{ textAlign: "justify" }}>
          You can opt-out from Twitter&apos;s interest-based ads by following
          their instructions: https://support.twitter.com/articles/20170405
        </p>
        <p style={{ textAlign: "justify" }}>
          You can learn more about the privacy practices and policies of Twitter
          by visiting their Privacy Policy page: https://twitter.com/privacy
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Facebook</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          Facebook remarketing service is provided by Facebook Inc.
        </p>
        <p style={{ textAlign: "justify" }}>
          You can learn more about interest-based advertising from Facebook by
          visiting this page: https://www.facebook.com/help/164968693837950
        </p>
        <p style={{ textAlign: "justify" }}>
          To opt-out from Facebook&apos;s interest-based ads, follow these
          instructions from Facebook:
          https://www.facebook.com/help/568137493302217
        </p>
        <p style={{ textAlign: "justify" }}>
          Facebook adheres to the Self-Regulatory Principles for Online
          Behavioural Advertising established by the Digital Advertising
          Alliance. You can also opt-out from Facebook and other participating
          companies through the Digital Advertising Alliance in the USA
          http://www.aboutads.info/choices/, the Digital Advertising Alliance of
          Canada in Canada http://youradchoices.ca/ or the European Interactive
          Digital Advertising Alliance in Europe
          http://www.youronlinechoices.eu/, or opt-out using your mobile device
          settings.
        </p>
        <p style={{ textAlign: "justify" }}>
          For more information on the privacy practices of Facebook, please
          visit Facebook&apos;s Data Policy:
          https://www.facebook.com/privacy/explanation
        </p>
        <p style={{ textAlign: "justify" }}>
          <strong>Pinterest</strong>
        </p>
        <p style={{ textAlign: "justify" }}>
          Pinterest remarketing service is provided by Pinterest Inc.
        </p>
        <p style={{ textAlign: "justify" }}>
          You can opt-out from Pinterest&apos;s interest-based ads by enabling
          the “Do Not Track” functionality of your web browser or by following
          Pinterest instructions:
          http://help.pinterest.com/en/articles/personalization-and-data
        </p>
        <p>
          You can learn more about the privacy practices and policies of
          Pinterest by visiting their Privacy Policy page:
          https://about.pinterest.com/en/privacy-policy
        </p>

        <h4 className="mt-5 mb-4">17. Payments</h4>
        <p style={{ textAlign: "justify" }}>
          We may provide paid products and/or services within Service. In that
          case, we use third-party services for payment processing (e.g. payment
          processors).
        </p>
        <p style={{ textAlign: "justify" }}>
          We will not store or collect your payment card details. That
          information is provided directly to our third-party payment processors
          whose use of your personal information is governed by their Privacy
          Policy. These payment processors adhere to the standards set by
          PCI-DSS as managed by the PCI Security Standards Council, which is a
          joint effort of brands like Visa, Mastercard, American Express and
          Discover. PCI-DSS requirements help ensure the secure handling of
          payment information.
        </p>
        <p style={{ textAlign: "justify" }}>
          The payment processors we work with are:
        </p>
        <p>
          <strong>Stripe:</strong>
        </p>
        <p>
          Their Privacy Policy can be viewed at: https://stripe.com/us/privacy
        </p>

        <h4 className="mt-5 mb-4">18. Links to Other Sites</h4>
        <p style={{ textAlign: "justify" }}>
          Our Service may contain links to other sites that are not operated by
          us. If you click a third party link, you will be directed to that
          third party&apos;s site. We strongly advise you to review the Privacy
          Policy of every site you visit.
        </p>
        <p style={{ textAlign: "justify" }}>
          We have no control over and assume no responsibility for the content,
          privacy policies or practices of any third party sites or services.
        </p>

        <h4 className="mt-5 mb-4">19. Children&apos;s Privacy</h4>
        <p style={{ textAlign: "justify" }}>
          Our Services are not intended for use by children under the age of 13
          (“
          <strong>Children</strong>”).&nbsp;
        </p>
        <p style={{ textAlign: "justify" }}>
          We do not knowingly collect personally identifiable information from
          Children under 13. If you become aware that a Child has provided us
          with Personal Data, please contact us. If we become aware that we have
          collected Personal Data from Children without verification of parental
          consent, we take steps to remove that information from our servers.
        </p>

        <h4 className="mt-5 mb-4">20. Changes to This Privacy Policy</h4>
        <p style={{ textAlign: "justify" }}>
          We may update our Privacy Policy from time to time. We will notify you
          of any changes by posting the new Privacy Policy on this page.
        </p>
        <p style={{ textAlign: "justify" }}>
          We will let you know via email and/or a prominent notice on our
          Service, prior to the change becoming effective and update “effective
          date” at the top of this Privacy Policy.
        </p>
        <p style={{ textAlign: "justify" }}>
          You are advised to review this Privacy Policy periodically for any
          changes. Changes to this Privacy Policy are effective when they are
          posted on this page.
        </p>

        <h4 className="mt-5 mb-4">21. Contact Us</h4>
        <p style={{ textAlign: "justify" }}>
          If you have any questions about this Privacy Policy, please contact
          us:
        </p>
        <p>By email: support@copywriterpro.ai</p>
        <p>
          By visiting this page on our website:
          https://copywriterpro.ai/contact.
        </p>
        <br/><br/><br/>
      </div>

      <Footer />
    </Layout>
  );
};

export default PrivacyPolicy;
