<a name="readme-top"></a>

<!--
*** Thanks for checking out CopywriterProAI. If you have a suggestion
*** that would make this better, please fork the repo and create a pull request
*** or simply open an issue with the tag "enhancement".
*** Don't forget to give the project a star!
*** Thanks again! Now go create something AMAZING! :D
-->

<!-- PROJECT SHIELDS -->
<!--
*** I'm using markdown "reference style" links for readability.
*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).
*** See the bottom of this document for the declaration of the reference variables
*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.
*** https://www.markdownguide.org/basic-syntax/#reference-style-links
-->

<div align="center">
  <a href="https://github.com/CopywriterPro-ai/copywriterproai-frontend/graphs/contributors"><img src="https://img.shields.io/github/contributors/CopywriterPro-ai/copywriterproai-frontend?style=for-the-badge&color=blue" alt="Contributors"></a>
  <a href="https://github.com/CopywriterPro-ai/copywriterproai-frontend/network/members"><img src="https://img.shields.io/github/forks/CopywriterPro-ai/copywriterproai-frontend?style=for-the-badge&color=blue" alt="Forks"></a>
  <a href="https://github.com/CopywriterPro-ai/copywriterproai-frontend/stargazers"><img src="https://img.shields.io/github/stars/CopywriterPro-ai/copywriterproai-frontend?style=for-the-badge&color=blue" alt="Stargazers"></a>
  <a href="https://github.com/CopywriterPro-ai/copywriterproai-frontend/issues"><img src="https://img.shields.io/github/issues/CopywriterPro-ai/copywriterproai-frontend?style=for-the-badge&color=blue" alt="Issues"></a>
  <a href="https://github.com/CopywriterPro-ai/copywriterproai-frontend/blob/main/LICENSE"><img src="https://img.shields.io/github/license/CopywriterPro-ai/copywriterproai-frontend?style=for-the-badge&color=blue" alt="Apache-2.0 License"></a>
  <br/>
  <a href="https://discord.gg/qKu3qA8M"><img src="https://img.shields.io/badge/Discord-Join%20Us-purple?logo=discord&logoColor=white&style=for-the-badge" alt="Join our Discord community"></a>
</div>

<!-- PROJECT LOGO -->
<div align="center">
  <h1 align="center">CopywriterProAI: World's first open-source AI writing platform for SEO and Ad Copy</h1>
  <a href="https://copywriterpro-ai.github.io/CopywriterProAI/"><img src="https://img.shields.io/badge/Documentation-CopywriterProAI-blue?logo=googledocs&logoColor=white&style=for-the-badge" alt="Check out the documentation"></a>
</div>
<hr>

Welcome to CopywriterProAI, the world's first open-source AI writing platform for SEO and Ad Copy. CopywriterProAI helps you create great content in a snap. It’s like having your very own AI writing assistant online, always ready to lend a helping hand.

## ⚡ Getting Started

### Requirements

- Node v12.0+
- Yarn
- MongoDB Database


#### Install dependencies:

```bash
yarn
```

Set environment variables:
Copy from .env.example file and add new environment variables:

```bash
.env
```

# Frontend environment variables
```bash
NEXT_PUBLIC_APP_API_URL=http://localhost:8080
NEXT_PUBLIC_APP_STRIPE_PUBLIC_KEY=pk_live_randomkey1234567890abcdef
NEXT_PUBLIC_APP_URL=https://copywriterpro.ai
NEXT_PUBLIC_APP_GA4_CODE=G-XXXXXX
NEXT_PUBLIC_APP_SENTRY_DNS=https://randomsentrydsn@sentry.io/1234567
NEXT_PUBLIC_APP_HOTJAR_ID=1234567
NEXT_PUBLIC_APP_HOTJAR_VERSION=6
NEXT_PUBLIC_CHROME_EXTENSION_ID=randomchromeextensionid
UDDOKTAPAY_API=randomuddoktapayapi1234567
SENTRY_DSN=randomsentrydsn
SENTRY_URL=https://sentry.io/
SENTRY_ORG=randomsentryorg
SENTRY_PROJECT=randomsentryproject
SENTRY_AUTH_TOKEN=randomsentryauthtoken1234567
NEXT_PUBLIC_FACEBOOK_PIXEL_ID=1234567890123456
```

Running Locally

```bash
yarn dev
```
Running in Production

```bash

yarn start
```

## 🚀 Documentation

To learn more about the project, and for tips on using CopywriterProAI, check out our documentation.

There you'll find resources on how to use different LLM providers, troubleshooting resources, and advanced configuration options.

## 🤝 How to Contribute

CopywriterProAI is a community-driven project, and we welcome contributions from everyone. Whether you're a developer, a researcher, or simply enthusiastic about advancing the field of content creation with AI, there are many ways to get involved:

- **Code Contributions**: Help us develop new features, improve the UI, or optimize the backend.
- **Research and Evaluation**: Contribute to our understanding of AI in content creation, participate in evaluating models, or suggest improvements.
- **Feedback and Testing**: Use CopywriterProAI, report bugs, suggest features, or provide feedback on usability.

For details, please check [CONTRIBUTING.md](CONTRIBUTING.md).

## 🤖 Join Our Community

Whether you're a developer, a researcher, or simply enthusiastic about CopywriterProAI, we'd love to have you in our community. Let's make content creation better together!

- [Discord server](https://discord.gg/qKu3qA8M) - This is a community-run server for general discussion, questions, and feedback.
