// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Text.RegularExpressions;
using Microsoft.Graphics.Canvas;
using Microsoft.Graphics.Canvas.Brushes;

namespace Microsoft.Toolkit.Uwp.UI.Media.Geometry.Elements.Brush
{
    /// <summary>
    /// Interface for a Brush Element
    /// </summary>
    internal interface ICanvasBrushElement
    {
        /// <summary>
        /// Gets the Brush data defining the Brush Element
        /// </summary>
        string Data { get; }

        /// <summary>
        /// Gets the number of non-whitespace characters in
        /// the Brush Data
        /// </summary>
        int ValidationCount { get; }

        /// <summary>
        /// Initializes the Brush Element with the given Capture
        /// </summary>
        /// <param name="capture">Capture object</param>
        void Initialize(Capture capture);

        /// <summary>
        /// Creates the ICanvasBrush from the parsed data
        /// </summary>
        /// <param name="resourceCreator">ICanvasResourceCreator object</param>
        /// <returns>ICanvasBrush</returns>
        ICanvasBrush CreateBrush(ICanvasResourceCreator resourceCreator);
    }
}