// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Microsoft.Toolkit.Uwp.UI.Controls
{
    /// <summary>
    /// Specifies the Dock position of a child element that is inside a <see cref="DockPanel"/>.
    /// </summary>
    public enum Dock
    {
        /// <summary>
        /// Dock left
        /// </summary>
        Left,

        /// <summary>
        /// Dock Top
        /// </summary>
        Top,

        /// <summary>
        /// Dock Right
        /// </summary>
        Right,

        /// <summary>
        /// Dock Bottom
        /// </summary>
        Bottom
    }
}