// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Collections.Generic;

namespace Microsoft.Toolkit.Parsers.Markdown.Inlines
{
    /// <summary>
    /// Represents a span containing emoji symbol.
    /// </summary>
    public partial class EmojiInline
    {
        // Codes taken from https://gist.github.com/rxaviers/7360908
        // Ignoring not implemented symbols in Segoe UI Emoji font (e.g. :bowtie:)
        private static readonly Dictionary<string, int> _emojiCodesDictionary = new Dictionary<string, int>
        {
            { "smile", 0x1f604 },
            { "laughing", 0x1f606 },
            { "blush", 0x1f60a },
            { "smiley", 0x1f603 },
            { "relaxed", 0x263a },
            { "smirk", 0x1f60f },
            { "heart_eyes", 0x1f60d },
            { "kissing_heart", 0x1f618 },
            { "kissing_closed_eyes", 0x1f61a },
            { "flushed", 0x1f633 },
            { "relieved", 0x1f60c },
            { "satisfied", 0x1f606 },
            { "grin", 0x1f601 },
            { "wink", 0x1f609 },
            { "stuck_out_tongue_winking_eye", 0x1f61c },
            { "stuck_out_tongue_closed_eyes", 0x1f61d },
            { "grinning", 0x1f600 },
            { "kissing", 0x1f617 },
            { "kissing_smiling_eyes", 0x1f619 },
            { "stuck_out_tongue", 0x1f61b },
            { "sleeping", 0x1f634 },
            { "worried", 0x1f61f },
            { "frowning", 0x1f626 },
            { "anguished", 0x1f627 },
            { "open_mouth", 0x1f62e },
            { "grimacing", 0x1f62c },
            { "confused", 0x1f615 },
            { "hushed", 0x1f62f },
            { "expressionless", 0x1f611 },
            { "unamused", 0x1f612 },
            { "sweat_smile", 0x1f605 },
            { "sweat", 0x1f613 },
            { "disappointed_relieved", 0x1f625 },
            { "weary", 0x1f629 },
            { "pensive", 0x1f614 },
            { "disappointed", 0x1f61e },
            { "confounded", 0x1f616 },
            { "fearful", 0x1f628 },
            { "cold_sweat", 0x1f630 },
            { "persevere", 0x1f623 },
            { "cry", 0x1f622 },
            { "sob", 0x1f62d },
            { "joy", 0x1f602 },
            { "astonished", 0x1f632 },
            { "scream", 0x1f631 },
            { "tired_face", 0x1f62b },
            { "angry", 0x1f620 },
            { "rage", 0x1f621 },
            { "triumph", 0x1f624 },
            { "sleepy", 0x1f62a },
            { "yum", 0x1f60b },
            { "mask", 0x1f637 },
            { "sunglasses", 0x1f60e },
            { "dizzy_face", 0x1f635 },
            { "imp", 0x1f47f },
            { "smiling_imp", 0x1f608 },
            { "neutral_face", 0x1f610 },
            { "no_mouth", 0x1f636 },
            { "innocent", 0x1f607 },
            { "alien", 0x1f47d },
            { "yellow_heart", 0x1f49b },
            { "blue_heart", 0x1f499 },
            { "purple_heart", 0x1f49c },
            { "heart", 0x2764 },
            { "green_heart", 0x1f49a },
            { "broken_heart", 0x1f494 },
            { "heartbeat", 0x1f493 },
            { "heartpulse", 0x1f497 },
            { "two_hearts", 0x1f495 },
            { "revolving_hearts", 0x1f49e },
            { "cupid", 0x1f498 },
            { "sparkling_heart", 0x1f496 },
            { "sparkles", 0x2728 },
            { "star", 0x2b50 },
            { "star2", 0x1f31f },
            { "dizzy", 0x1f4ab },
            { "boom", 0x1f4a5 },
            { "collision", 0x1f4a5 },
            { "anger", 0x1f4a2 },
            { "exclamation", 0x2757 },
            { "question", 0x2753 },
            { "grey_exclamation", 0x2755 },
            { "grey_question", 0x2754 },
            { "zzz", 0x1f4a4 },
            { "dash", 0x1f4a8 },
            { "sweat_drops", 0x1f4a6 },
            { "notes", 0x1f3b6 },
            { "musical_note", 0x1f3b5 },
            { "fire", 0x1f525 },
            { "hankey", 0x1f4a9 },
            { "poop", 0x1f4a9 },
            { "+1", 0x1f44d },
            { "thumbsup", 0x1f44d },
            { "-1", 0x1f44e },
            { "thumbsdown", 0x1f44e },
            { "ok_hand", 0x1f44c },
            { "punch", 0x1f44a },
            { "facepunch", 0x1f44a },
            { "fist", 0x270a },
            { "v", 0x270c },
            { "wave", 0x1f44b },
            { "hand", 0x270b },
            { "raised_hand", 0x270b },
            { "open_hands", 0x1f450 },
            { "point_up", 0x261d },
            { "point_down", 0x1f447 },
            { "point_left", 0x1f448 },
            { "point_right", 0x1f449 },
            { "raised_hands", 0x1f64c },
            { "pray", 0x1f64f },
            { "point_up_2", 0x1f446 },
            { "clap", 0x1f44f },
            { "muscle", 0x1f4aa },
            { "metal", 0x1f918 },
            { "walking", 0x1f6b6 },
            { "runner", 0x1f3c3 },
            { "running", 0x1f3c3 },
            { "couple", 0x1f46b },
            { "family", 0x1f46a },
            { "two_men_holding_hands", 0x1f46c },
            { "two_women_holding_hands", 0x1f46d },
            { "dancer", 0x1f483 },
            { "dancers", 0x1f46f },
            { "ok_woman", 0x1f646 },
            { "no_good", 0x1f645 },
            { "information_desk_person", 0x1f481 },
            { "raising_hand", 0x1f64b },
            { "bride_with_veil", 0x1f470 },
            { "person_with_pouting_face", 0x1f64e },
            { "person_frowning", 0x1f64d },
            { "bow", 0x1f647 },
            { "couple_with_heart", 0x1f491 },
            { "massage", 0x1f486 },
            { "haircut", 0x1f487 },
            { "nail_care", 0x1f485 },
            { "boy", 0x1f466 },
            { "girl", 0x1f467 },
            { "woman", 0x1f469 },
            { "man", 0x1f468 },
            { "baby", 0x1f476 },
            { "older_woman", 0x1f475 },
            { "older_man", 0x1f474 },
            { "person_with_blond_hair", 0x1f471 },
            { "man_with_gua_pi_mao", 0x1f472 },
            { "man_with_turban", 0x1f473 },
            { "construction_worker", 0x1f477 },
            { "cop", 0x1f46e },
            { "angel", 0x1f47c },
            { "princess", 0x1f478 },
            { "smiley_cat", 0x1f63a },
            { "smile_cat", 0x1f638 },
            { "heart_eyes_cat", 0x1f63b },
            { "kissing_cat", 0x1f63d },
            { "smirk_cat", 0x1f63c },
            { "scream_cat", 0x1f640 },
            { "crying_cat_face", 0x1f63f },
            { "joy_cat", 0x1f639 },
            { "pouting_cat", 0x1f63e },
            { "japanese_ogre", 0x1f479 },
            { "japanese_goblin", 0x1f47a },
            { "see_no_evil", 0x1f648 },
            { "hear_no_evil", 0x1f649 },
            { "speak_no_evil", 0x1f64a },
            { "guardsman", 0x1f482 },
            { "skull", 0x1f480 },
            { "feet", 0x1f43e },
            { "lips", 0x1f444 },
            { "kiss", 0x1f48b },
            { "droplet", 0x1f4a7 },
            { "ear", 0x1f442 },
            { "eyes", 0x1f440 },
            { "nose", 0x1f443 },
            { "tongue", 0x1f445 },
            { "love_letter", 0x1f48c },
            { "bust_in_silhouette", 0x1f464 },
            { "busts_in_silhouette", 0x1f465 },
            { "speech_balloon", 0x1f4ac },
            { "thought_balloon", 0x1f4ad },
            { "sunny", 0x2600 },
            { "umbrella", 0x2614 },
            { "cloud", 0x2601 },
            { "snowflake", 0x2744 },
            { "snowman", 0x26c4 },
            { "zap", 0x26a1 },
            { "cyclone", 0x1f300 },
            { "foggy", 0x1f301 },
            { "ocean", 0x1f30a },
            { "cat", 0x1f431 },
            { "dog", 0x1f436 },
            { "mouse", 0x1f42d },
            { "hamster", 0x1f439 },
            { "rabbit", 0x1f430 },
            { "wolf", 0x1f43a },
            { "frog", 0x1f438 },
            { "tiger", 0x1f42f },
            { "koala", 0x1f428 },
            { "bear", 0x1f43b },
            { "pig", 0x1f437 },
            { "pig_nose", 0x1f43d },
            { "cow", 0x1f42e },
            { "boar", 0x1f417 },
            { "monkey_face", 0x1f435 },
            { "monkey", 0x1f412 },
            { "horse", 0x1f434 },
            { "racehorse", 0x1f40e },
            { "camel", 0x1f42b },
            { "sheep", 0x1f411 },
            { "elephant", 0x1f418 },
            { "panda_face", 0x1f43c },
            { "snake", 0x1f40d },
            { "bird", 0x1f426 },
            { "baby_chick", 0x1f424 },
            { "hatched_chick", 0x1f425 },
            { "hatching_chick", 0x1f423 },
            { "chicken", 0x1f414 },
            { "penguin", 0x1f427 },
            { "turtle", 0x1f422 },
            { "bug", 0x1f41b },
            { "honeybee", 0x1f41d },
            { "ant", 0x1f41c },
            { "beetle", 0x1f41e },
            { "snail", 0x1f40c },
            { "octopus", 0x1f419 },
            { "tropical_fish", 0x1f420 },
            { "fish", 0x1f41f },
            { "whale", 0x1f433 },
            { "whale2", 0x1f40b },
            { "dolphin", 0x1f42c },
            { "cow2", 0x1f404 },
            { "ram", 0x1f40f },
            { "rat", 0x1f400 },
            { "water_buffalo", 0x1f403 },
            { "tiger2", 0x1f405 },
            { "rabbit2", 0x1f407 },
            { "dragon", 0x1f409 },
            { "goat", 0x1f410 },
            { "rooster", 0x1f413 },
            { "dog2", 0x1f415 },
            { "pig2", 0x1f416 },
            { "mouse2", 0x1f401 },
            { "ox", 0x1f402 },
            { "dragon_face", 0x1f432 },
            { "blowfish", 0x1f421 },
            { "crocodile", 0x1f40a },
            { "dromedary_camel", 0x1f42a },
            { "leopard", 0x1f406 },
            { "cat2", 0x1f408 },
            { "poodle", 0x1f429 },
            { "paw_prints", 0x1f43e },
            { "bouquet", 0x1f490 },
            { "cherry_blossom", 0x1f338 },
            { "tulip", 0x1f337 },
            { "four_leaf_clover", 0x1f340 },
            { "rose", 0x1f339 },
            { "sunflower", 0x1f33b },
            { "hibiscus", 0x1f33a },
            { "maple_leaf", 0x1f341 },
            { "leaves", 0x1f343 },
            { "fallen_leaf", 0x1f342 },
            { "herb", 0x1f33f },
            { "mushroom", 0x1f344 },
            { "cactus", 0x1f335 },
            { "palm_tree", 0x1f334 },
            { "evergreen_tree", 0x1f332 },
            { "deciduous_tree", 0x1f333 },
            { "chestnut", 0x1f330 },
            { "seedling", 0x1f331 },
            { "blossom", 0x1f33c },
            { "ear_of_rice", 0x1f33e },
            { "shell", 0x1f41a },
            { "globe_with_meridians", 0x1f310 },
            { "sun_with_face", 0x1f31e },
            { "full_moon_with_face", 0x1f31d },
            { "new_moon_with_face", 0x1f31a },
            { "new_moon", 0x1f311 },
            { "waxing_crescent_moon", 0x1f312 },
            { "first_quarter_moon", 0x1f313 },
            { "waxing_gibbous_moon", 0x1f314 },
            { "full_moon", 0x1f315 },
            { "waning_gibbous_moon", 0x1f316 },
            { "last_quarter_moon", 0x1f317 },
            { "waning_crescent_moon", 0x1f318 },
            { "last_quarter_moon_with_face", 0x1f31c },
            { "first_quarter_moon_with_face", 0x1f31b },
            { "moon", 0x1f314 },
            { "earth_africa", 0x1f30d },
            { "earth_americas", 0x1f30e },
            { "earth_asia", 0x1f30f },
            { "volcano", 0x1f30b },
            { "milky_way", 0x1f30c },
            { "partly_sunny", 0x26c5 },
            { "bamboo", 0x1f38d },
            { "gift_heart", 0x1f49d },
            { "dolls", 0x1f38e },
            { "school_satchel", 0x1f392 },
            { "mortar_board", 0x1f393 },
            { "flags", 0x1f38f },
            { "fireworks", 0x1f386 },
            { "sparkler", 0x1f387 },
            { "wind_chime", 0x1f390 },
            { "rice_scene", 0x1f391 },
            { "jack_o_lantern", 0x1f383 },
            { "ghost", 0x1f47b },
            { "santa", 0x1f385 },
            { "christmas_tree", 0x1f384 },
            { "gift", 0x1f381 },
            { "bell", 0x1f514 },
            { "no_bell", 0x1f515 },
            { "tanabata_tree", 0x1f38b },
            { "tada", 0x1f389 },
            { "confetti_ball", 0x1f38a },
            { "balloon", 0x1f388 },
            { "crystal_ball", 0x1f52e },
            { "cd", 0x1f4bf },
            { "dvd", 0x1f4c0 },
            { "floppy_disk", 0x1f4be },
            { "camera", 0x1f4f7 },
            { "video_camera", 0x1f4f9 },
            { "movie_camera", 0x1f3a5 },
            { "computer", 0x1f4bb },
            { "tv", 0x1f4fa },
            { "iphone", 0x1f4f1 },
            { "phone", 0x260e },
            { "telephone", 0x260e },
            { "telephone_receiver", 0x1f4de },
            { "pager", 0x1f4df },
            { "fax", 0x1f4e0 },
            { "minidisc", 0x1f4bd },
            { "vhs", 0x1f4fc },
            { "sound", 0x1f509 },
            { "speaker", 0x1f508 },
            { "mute", 0x1f507 },
            { "loudspeaker", 0x1f4e2 },
            { "mega", 0x1f4e3 },
            { "hourglass", 0x231b },
            { "hourglass_flowing_sand", 0x23f3 },
            { "alarm_clock", 0x23f0 },
            { "watch", 0x231a },
            { "radio", 0x1f4fb },
            { "satellite", 0x1f4e1 },
            { "loop", 0x27bf },
            { "mag", 0x1f50d },
            { "mag_right", 0x1f50e },
            { "unlock", 0x1f513 },
            { "lock", 0x1f512 },
            { "lock_with_ink_pen", 0x1f50f },
            { "closed_lock_with_key", 0x1f510 },
            { "key", 0x1f511 },
            { "bulb", 0x1f4a1 },
            { "flashlight", 0x1f526 },
            { "high_brightness", 0x1f506 },
            { "low_brightness", 0x1f505 },
            { "electric_plug", 0x1f50c },
            { "battery", 0x1f50b },
            { "calling", 0x1f4f2 },
            { "email", 0x2709 },
            { "mailbox", 0x1f4eb },
            { "postbox", 0x1f4ee },
            { "bath", 0x1f6c0 },
            { "bathtub", 0x1f6c1 },
            { "shower", 0x1f6bf },
            { "toilet", 0x1f6bd },
            { "wrench", 0x1f527 },
            { "nut_and_bolt", 0x1f529 },
            { "hammer", 0x1f528 },
            { "seat", 0x1f4ba },
            { "moneybag", 0x1f4b0 },
            { "yen", 0x1f4b4 },
            { "dollar", 0x1f4b5 },
            { "pound", 0x1f4b7 },
            { "euro", 0x1f4b6 },
            { "credit_card", 0x1f4b3 },
            { "money_with_wings", 0x1f4b8 },
            { "e-mail", 0x1f4e7 },
            { "inbox_tray", 0x1f4e5 },
            { "outbox_tray", 0x1f4e4 },
            { "envelope", 0x2709 },
            { "incoming_envelope", 0x1f4e8 },
            { "postal_horn", 0x1f4ef },
            { "mailbox_closed", 0x1f4ea },
            { "mailbox_with_mail", 0x1f4ec },
            { "mailbox_with_no_mail", 0x1f4ed },
            { "door", 0x1f6aa },
            { "smoking", 0x1f6ac },
            { "bomb", 0x1f4a3 },
            { "gun", 0x1f52b },
            { "hocho", 0x1f52a },
            { "pill", 0x1f48a },
            { "syringe", 0x1f489 },
            { "page_facing_up", 0x1f4c4 },
            { "page_with_curl", 0x1f4c3 },
            { "bookmark_tabs", 0x1f4d1 },
            { "bar_chart", 0x1f4ca },
            { "chart_with_upwards_trend", 0x1f4c8 },
            { "chart_with_downwards_trend", 0x1f4c9 },
            { "scroll", 0x1f4dc },
            { "clipboard", 0x1f4cb },
            { "calendar", 0x1f4c6 },
            { "date", 0x1f4c5 },
            { "card_index", 0x1f4c7 },
            { "file_folder", 0x1f4c1 },
            { "open_file_folder", 0x1f4c2 },
            { "scissors", 0x2702 },
            { "pushpin", 0x1f4cc },
            { "paperclip", 0x1f4ce },
            { "black_nib", 0x2712 },
            { "pencil2", 0x270f },
            { "straight_ruler", 0x1f4cf },
            { "triangular_ruler", 0x1f4d0 },
            { "closed_book", 0x1f4d5 },
            { "green_book", 0x1f4d7 },
            { "blue_book", 0x1f4d8 },
            { "orange_book", 0x1f4d9 },
            { "notebook", 0x1f4d3 },
            { "notebook_with_decorative_cover", 0x1f4d4 },
            { "ledger", 0x1f4d2 },
            { "books", 0x1f4da },
            { "bookmark", 0x1f516 },
            { "name_badge", 0x1f4db },
            { "microscope", 0x1f52c },
            { "telescope", 0x1f52d },
            { "newspaper", 0x1f4f0 },
            { "football", 0x1f3c8 },
            { "basketball", 0x1f3c0 },
            { "soccer", 0x26bd },
            { "baseball", 0x26be },
            { "tennis", 0x1f3be },
            { "8ball", 0x1f3b1 },
            { "rugby_football", 0x1f3c9 },
            { "bowling", 0x1f3b3 },
            { "golf", 0x26f3 },
            { "mountain_bicyclist", 0x1f6b5 },
            { "bicyclist", 0x1f6b4 },
            { "horse_racing", 0x1f3c7 },
            { "snowboarder", 0x1f3c2 },
            { "swimmer", 0x1f3ca },
            { "surfer", 0x1f3c4 },
            { "ski", 0x1f3bf },
            { "spades", 0x2660 },
            { "hearts", 0x2665 },
            { "clubs", 0x2663 },
            { "diamonds", 0x2666 },
            { "gem", 0x1f48e },
            { "ring", 0x1f48d },
            { "trophy", 0x1f3c6 },
            { "musical_score", 0x1f3bc },
            { "musical_keyboard", 0x1f3b9 },
            { "violin", 0x1f3bb },
            { "space_invader", 0x1f47e },
            { "video_game", 0x1f3ae },
            { "black_joker", 0x1f0cf },
            { "flower_playing_cards", 0x1f3b4 },
            { "game_die", 0x1f3b2 },
            { "dart", 0x1f3af },
            { "mahjong", 0x1f004 },
            { "clapper", 0x1f3ac },
            { "memo", 0x1f4dd },
            { "pencil", 0x1f4dd },
            { "book", 0x1f4d6 },
            { "art", 0x1f3a8 },
            { "microphone", 0x1f3a4 },
            { "headphones", 0x1f3a7 },
            { "trumpet", 0x1f3ba },
            { "saxophone", 0x1f3b7 },
            { "guitar", 0x1f3b8 },
            { "shoe", 0x1f45e },
            { "sandal", 0x1f461 },
            { "high_heel", 0x1f460 },
            { "lipstick", 0x1f484 },
            { "boot", 0x1f462 },
            { "shirt", 0x1f455 },
            { "tshirt", 0x1f455 },
            { "necktie", 0x1f454 },
            { "womans_clothes", 0x1f45a },
            { "dress", 0x1f457 },
            { "running_shirt_with_sash", 0x1f3bd },
            { "jeans", 0x1f456 },
            { "kimono", 0x1f458 },
            { "bikini", 0x1f459 },
            { "ribbon", 0x1f380 },
            { "tophat", 0x1f3a9 },
            { "crown", 0x1f451 },
            { "womans_hat", 0x1f452 },
            { "mans_shoe", 0x1f45e },
            { "closed_umbrella", 0x1f302 },
            { "briefcase", 0x1f4bc },
            { "handbag", 0x1f45c },
            { "pouch", 0x1f45d },
            { "purse", 0x1f45b },
            { "eyeglasses", 0x1f453 },
            { "fishing_pole_and_fish", 0x1f3a3 },
            { "coffee", 0x2615 },
            { "tea", 0x1f375 },
            { "sake", 0x1f376 },
            { "baby_bottle", 0x1f37c },
            { "beer", 0x1f37a },
            { "beers", 0x1f37b },
            { "cocktail", 0x1f378 },
            { "tropical_drink", 0x1f379 },
            { "wine_glass", 0x1f377 },
            { "fork_and_knife", 0x1f374 },
            { "pizza", 0x1f355 },
            { "hamburger", 0x1f354 },
            { "fries", 0x1f35f },
            { "poultry_leg", 0x1f357 },
            { "meat_on_bone", 0x1f356 },
            { "spaghetti", 0x1f35d },
            { "curry", 0x1f35b },
            { "fried_shrimp", 0x1f364 },
            { "bento", 0x1f371 },
            { "sushi", 0x1f363 },
            { "fish_cake", 0x1f365 },
            { "rice_ball", 0x1f359 },
            { "rice_cracker", 0x1f358 },
            { "rice", 0x1f35a },
            { "ramen", 0x1f35c },
            { "stew", 0x1f372 },
            { "oden", 0x1f362 },
            { "dango", 0x1f361 },
            { "egg", 0x1f95a },
            { "bread", 0x1f35e },
            { "doughnut", 0x1f369 },
            { "custard", 0x1f36e },
            { "icecream", 0x1f366 },
            { "ice_cream", 0x1f368 },
            { "shaved_ice", 0x1f367 },
            { "birthday", 0x1f382 },
            { "cake", 0x1f370 },
            { "cookie", 0x1f36a },
            { "chocolate_bar", 0x1f36b },
            { "candy", 0x1f36c },
            { "lollipop", 0x1f36d },
            { "honey_pot", 0x1f36f },
            { "apple", 0x1f34e },
            { "green_apple", 0x1f34f },
            { "tangerine", 0x1f34a },
            { "lemon", 0x1f34b },
            { "cherries", 0x1f352 },
            { "grapes", 0x1f347 },
            { "watermelon", 0x1f349 },
            { "strawberry", 0x1f353 },
            { "peach", 0x1f351 },
            { "melon", 0x1f348 },
            { "banana", 0x1f34c },
            { "pear", 0x1f350 },
            { "pineapple", 0x1f34d },
            { "sweet_potato", 0x1f360 },
            { "eggplant", 0x1f346 },
            { "tomato", 0x1f345 },
            { "corn", 0x1f33d },
            { "house", 0x1f3e0 },
            { "house_with_garden", 0x1f3e1 },
            { "school", 0x1f3eb },
            { "office", 0x1f3e2 },
            { "post_office", 0x1f3e3 },
            { "hospital", 0x1f3e5 },
            { "bank", 0x1f3e6 },
            { "convenience_store", 0x1f3ea },
            { "love_hotel", 0x1f3e9 },
            { "hotel", 0x1f3e8 },
            { "wedding", 0x1f492 },
            { "church", 0x26ea },
            { "department_store", 0x1f3ec },
            { "european_post_office", 0x1f3e4 },
            { "city_sunrise", 0x1f307 },
            { "city_sunset", 0x1f306 },
            { "japanese_castle", 0x1f3ef },
            { "european_castle", 0x1f3f0 },
            { "tent", 0x26fa },
            { "factory", 0x1f3ed },
            { "tokyo_tower", 0x1f5fc },
            { "japan", 0x1f5fe },
            { "mount_fuji", 0x1f5fb },
            { "sunrise_over_mountains", 0x1f304 },
            { "sunrise", 0x1f305 },
            { "stars", 0x1f320 },
            { "statue_of_liberty", 0x1f5fd },
            { "bridge_at_night", 0x1f309 },
            { "carousel_horse", 0x1f3a0 },
            { "rainbow", 0x1f308 },
            { "ferris_wheel", 0x1f3a1 },
            { "fountain", 0x26f2 },
            { "roller_coaster", 0x1f3a2 },
            { "ship", 0x1f6a2 },
            { "speedboat", 0x1f6a4 },
            { "boat", 0x26f5 },
            { "sailboat", 0x26f5 },
            { "rowboat", 0x1f6a3 },
            { "anchor", 0x2693 },
            { "rocket", 0x1f680 },
            { "airplane", 0x2708 },
            { "helicopter", 0x1f681 },
            { "steam_locomotive", 0x1f682 },
            { "tram", 0x1f68a },
            { "mountain_railway", 0x1f69e },
            { "bike", 0x1f6b2 },
            { "aerial_tramway", 0x1f6a1 },
            { "suspension_railway", 0x1f69f },
            { "mountain_cableway", 0x1f6a0 },
            { "tractor", 0x1f69c },
            { "blue_car", 0x1f699 },
            { "oncoming_automobile", 0x1f698 },
            { "car", 0x1f697 },
            { "red_car", 0x1f697 },
            { "taxi", 0x1f695 },
            { "oncoming_taxi", 0x1f696 },
            { "articulated_lorry", 0x1f69b },
            { "bus", 0x1f68c },
            { "oncoming_bus", 0x1f68d },
            { "rotating_light", 0x1f6a8 },
            { "police_car", 0x1f693 },
            { "oncoming_police_car", 0x1f694 },
            { "fire_engine", 0x1f692 },
            { "ambulance", 0x1f691 },
            { "minibus", 0x1f690 },
            { "truck", 0x1f69a },
            { "train", 0x1f68b },
            { "station", 0x1f689 },
            { "train2", 0x1f686 },
            { "bullettrain_front", 0x1f685 },
            { "bullettrain_side", 0x1f684 },
            { "light_rail", 0x1f688 },
            { "monorail", 0x1f69d },
            { "railway_car", 0x1f683 },
            { "trolleybus", 0x1f68e },
            { "ticket", 0x1f3ab },
            { "fuelpump", 0x26fd },
            { "vertical_traffic_light", 0x1f6a6 },
            { "traffic_light", 0x1f6a5 },
            { "warning", 0x26a0 },
            { "construction", 0x1f6a7 },
            { "beginner", 0x1f530 },
            { "atm", 0x1f3e7 },
            { "slot_machine", 0x1f3b0 },
            { "busstop", 0x1f68f },
            { "barber", 0x1f488 },
            { "hotsprings", 0x2668 },
            { "checkered_flag", 0x1f3c1 },
            { "crossed_flags", 0x1f38c },
            { "izakaya_lantern", 0x1f3ee },
            { "moyai", 0x1f5ff },
            { "circus_tent", 0x1f3aa },
            { "performing_arts", 0x1f3ad },
            { "round_pushpin", 0x1f4cd },
            { "triangular_flag_on_post", 0x1f6a9 },
            { "keycap_ten", 0x1f51f },
            { "1234", 0x1f522 },
            { "symbols", 0x1f523 },
            { "arrow_backward", 0x25c0 },
            { "arrow_down", 0x2b07 },
            { "arrow_forward", 0x25b6 },
            { "arrow_left", 0x2b05 },
            { "capital_abcd", 0x1f520 },
            { "abcd", 0x1f521 },
            { "abc", 0x1f524 },
            { "arrow_lower_left", 0x2199 },
            { "arrow_lower_right", 0x2198 },
            { "arrow_right", 0x27a1 },
            { "arrow_up", 0x2b06 },
            { "arrow_upper_left", 0x2196 },
            { "arrow_upper_right", 0x2197 },
            { "arrow_double_down", 0x23ec },
            { "arrow_double_up", 0x23eb },
            { "arrow_down_small", 0x1f53d },
            { "arrow_heading_down", 0x2935 },
            { "arrow_heading_up", 0x2934 },
            { "leftwards_arrow_with_hook", 0x21a9 },
            { "arrow_right_hook", 0x21aa },
            { "left_right_arrow", 0x2194 },
            { "arrow_up_down", 0x2195 },
            { "arrow_up_small", 0x1f53c },
            { "arrows_clockwise", 0x1f503 },
            { "arrows_counterclockwise", 0x1f504 },
            { "rewind", 0x23ea },
            { "fast_forward", 0x23e9 },
            { "information_source", 0x2139 },
            { "ok", 0x1f197 },
            { "twisted_rightwards_arrows", 0x1f500 },
            { "repeat", 0x1f501 },
            { "repeat_one", 0x1f502 },
            { "new", 0x1f195 },
            { "top", 0x1f51d },
            { "up", 0x1f199 },
            { "cool", 0x1f192 },
            { "free", 0x1f193 },
            { "ng", 0x1f196 },
            { "cinema", 0x1f3a6 },
            { "koko", 0x1f201 },
            { "signal_strength", 0x1f4f6 },
            { "u5272", 0x1f239 },
            { "u5408", 0x1f234 },
            { "u55b6", 0x1f23a },
            { "u6307", 0x1f22f },
            { "u6708", 0x1f237 },
            { "u6709", 0x1f236 },
            { "u6e80", 0x1f235 },
            { "u7121", 0x1f21a },
            { "u7533", 0x1f238 },
            { "u7a7a", 0x1f233 },
            { "u7981", 0x1f232 },
            { "sa", 0x1f202 },
            { "restroom", 0x1f6bb },
            { "mens", 0x1f6b9 },
            { "womens", 0x1f6ba },
            { "baby_symbol", 0x1f6bc },
            { "no_smoking", 0x1f6ad },
            { "parking", 0x1f17f },
            { "wheelchair", 0x267f },
            { "metro", 0x1f687 },
            { "baggage_claim", 0x1f6c4 },
            { "accept", 0x1f251 },
            { "wc", 0x1f6be },
            { "potable_water", 0x1f6b0 },
            { "put_litter_in_its_place", 0x1f6ae },
            { "secret", 0x3299 },
            { "congratulations", 0x3297 },
            { "m", 0x24c2 },
            { "passport_control", 0x1f6c2 },
            { "left_luggage", 0x1f6c5 },
            { "customs", 0x1f6c3 },
            { "ideograph_advantage", 0x1f250 },
            { "cl", 0x1f191 },
            { "sos", 0x1f198 },
            { "id", 0x1f194 },
            { "no_entry_sign", 0x1f6ab },
            { "underage", 0x1f51e },
            { "no_mobile_phones", 0x1f4f5 },
            { "do_not_litter", 0x1f6af },
            { "non-potable_water", 0x1f6b1 },
            { "no_bicycles", 0x1f6b3 },
            { "no_pedestrians", 0x1f6b7 },
            { "children_crossing", 0x1f6b8 },
            { "no_entry", 0x26d4 },
            { "eight_spoked_asterisk", 0x2733 },
            { "eight_pointed_black_star", 0x2734 },
            { "heart_decoration", 0x1f49f },
            { "vs", 0x1f19a },
            { "vibration_mode", 0x1f4f3 },
            { "mobile_phone_off", 0x1f4f4 },
            { "chart", 0x1f4b9 },
            { "currency_exchange", 0x1f4b1 },
            { "aries", 0x2648 },
            { "taurus", 0x2649 },
            { "gemini", 0x264a },
            { "cancer", 0x264b },
            { "leo", 0x264c },
            { "virgo", 0x264d },
            { "libra", 0x264e },
            { "scorpius", 0x264f },
            { "sagittarius", 0x2650 },
            { "capricorn", 0x2651 },
            { "aquarius", 0x2652 },
            { "pisces", 0x2653 },
            { "ophiuchus", 0x26ce },
            { "six_pointed_star", 0x1f52f },
            { "negative_squared_cross_mark", 0x274e },
            { "a", 0x1f170 },
            { "b", 0x1f171 },
            { "ab", 0x1f18e },
            { "o2", 0x1f17e },
            { "diamond_shape_with_a_dot_inside", 0x1f4a0 },
            { "recycle", 0x267b },
            { "end", 0x1f51a },
            { "on", 0x1f51b },
            { "soon", 0x1f51c },
            { "clock1", 0x1f550 },
            { "clock130", 0x1f55c },
            { "clock10", 0x1f559 },
            { "clock1030", 0x1f565 },
            { "clock11", 0x1f55a },
            { "clock1130", 0x1f566 },
            { "clock12", 0x1f55b },
            { "clock1230", 0x1f567 },
            { "clock2", 0x1f551 },
            { "clock230", 0x1f55d },
            { "clock3", 0x1f552 },
            { "clock330", 0x1f55e },
            { "clock4", 0x1f553 },
            { "clock430", 0x1f55f },
            { "clock5", 0x1f554 },
            { "clock530", 0x1f560 },
            { "clock6", 0x1f555 },
            { "clock630", 0x1f561 },
            { "clock7", 0x1f556 },
            { "clock730", 0x1f562 },
            { "clock8", 0x1f557 },
            { "clock830", 0x1f563 },
            { "clock9", 0x1f558 },
            { "clock930", 0x1f564 },
            { "heavy_dollar_sign", 0x1f4b2 },
            { "copyright", 0x00a9 },
            { "registered", 0x00ae },
            { "tm", 0x2122 },
            { "x", 0x274c },
            { "heavy_exclamation_mark", 0x2757 },
            { "bangbang", 0x203c },
            { "interrobang", 0x2049 },
            { "o", 0x2b55 },
            { "heavy_multiplication_x", 0x2716 },
            { "heavy_plus_sign", 0x2795 },
            { "heavy_minus_sign", 0x2796 },
            { "heavy_division_sign", 0x2797 },
            { "white_flower", 0x1f4ae },
            { "100", 0x1f4af },
            { "heavy_check_mark", 0x2714 },
            { "ballot_box_with_check", 0x2611 },
            { "radio_button", 0x1f518 },
            { "link", 0x1f517 },
            { "curly_loop", 0x27b0 },
            { "wavy_dash", 0x3030 },
            { "part_alternation_mark", 0x303d },
            { "trident", 0x1f531 },
            { "white_check_mark", 0x2705 },
            { "black_square_button", 0x1f532 },
            { "white_square_button", 0x1f533 },
            { "black_circle", 0x26ab },
            { "white_circle", 0x26aa },
            { "red_circle", 0x1f534 },
            { "large_blue_circle", 0x1f535 },
            { "large_blue_diamond", 0x1f537 },
            { "large_orange_diamond", 0x1f536 },
            { "small_blue_diamond", 0x1f539 },
            { "small_orange_diamond", 0x1f538 },
            { "small_red_triangle", 0x1f53a },
            { "small_red_triangle_down", 0x1f53b },
        };
    }
}