// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;

namespace Microsoft.Toolkit.Uwp.UI.Controls.Design
{
    internal static partial class ControlTypes
    {
        internal const string MarkdownTextBlock = RootNamespace + "." + nameof(MarkdownTextBlock);
    }

    internal static class MarkdownTextBlock
    {
        internal const string CodeBackground = nameof(CodeBackground);
        internal const string CodeBorderBrush = nameof(CodeBorderBrush);
        internal const string CodeBorderThickness = nameof(CodeBorderThickness);
        internal const string CodeFontFamily = nameof(CodeFontFamily);
        internal const string CodeForeground = nameof(CodeForeground);
        internal const string CodeMargin = nameof(CodeMargin);
        internal const string CodePadding = nameof(CodePadding);
        internal const string HorizontalRuleBrush = nameof(HorizontalRuleBrush);
        internal const string HorizontalRuleMargin = nameof(HorizontalRuleMargin);
        internal const string HorizontalRuleThickness = nameof(HorizontalRuleThickness);
        internal const string ImageStretch = nameof(ImageStretch);
        internal const string IsTextSelectionEnabled = nameof(IsTextSelectionEnabled);
        internal const string LinkForeground = nameof(LinkForeground);
        internal const string ListBulletSpacing = nameof(ListBulletSpacing);
        internal const string ListGutterWidth = nameof(ListGutterWidth);
        internal const string ListMargin = nameof(ListMargin);
        internal const string ParagraphMargin = nameof(ParagraphMargin);
        internal const string QuoteBackground = nameof(QuoteBackground);
        internal const string QuoteBorderBrush = nameof(QuoteBorderBrush);
        internal const string QuoteBorderThickness = nameof(QuoteBorderThickness);
        internal const string QuoteForeground = nameof(QuoteForeground);
        internal const string QuoteMargin = nameof(QuoteMargin);
        internal const string QuotePadding = nameof(QuotePadding);
        internal const string TableBorderBrush = nameof(TableBorderBrush);
        internal const string TableBorderThickness = nameof(TableBorderThickness);
        internal const string TableCellPadding = nameof(TableCellPadding);
        internal const string TableMargin = nameof(TableMargin);
        internal const string Text = nameof(Text);
        internal const string TextWrapping = nameof(TextWrapping);
    }
}