// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Microsoft.Toolkit.Uwp.UI.Controls
{
    /// <summary>
    /// Image alignment
    /// </summary>
    public enum ImageAlignment
    {
        /// <summary>
        /// No alignment needed
        /// </summary>
        None,

        /// <summary>
        /// Align to Left when the property ScrollOrientation is Horizontal
        /// </summary>
        Left,

        /// <summary>
        /// Align to Right when the property ScrollOrientation is Horizontal
        /// </summary>
        Right,

        /// <summary>
        /// Align to Top when the property ScrollOrientation is Vertical
        /// </summary>
        Top,

        /// <summary>
        /// Align to Bottom when the property ScrollOrientation is Vertical
        /// </summary>
        Bottom
    }
}