// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Microsoft.Toolkit.Uwp.UI.Controls.TextToolbarButtons
{
    /// <summary>
    /// Specifies a Default ButtonType to Manipulate
    /// </summary>
    public enum ButtonType
    {
        /// <summary>
        /// Bold Button
        /// </summary>
        Bold,

        /// <summary>
        /// Italics Button
        /// </summary>
        Italics,

        /// <summary>
        /// Strikethrough Button
        /// </summary>
        Strikethrough,

        /// <summary>
        /// Code button
        /// </summary>
        Code,

        /// <summary>
        /// Quote Button
        /// </summary>
        Quote,

        /// <summary>
        /// Link Button
        /// </summary>
        Link,

        /// <summary>
        /// List Button
        /// </summary>
        List,

        /// <summary>
        /// Ordered List Button
        /// </summary>
        OrderedList,

        /// <summary>
        /// Header Selector
        /// </summary>
        Headers
    }
}