// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace Microsoft.Toolkit.Uwp.UI.Animations
{
    /// <summary>
    /// Indicates a side to animate in the bounds of a given element.
    /// </summary>
    public enum Side
    {
        /// <summary>
        /// Maps the top side of the target bounds.
        /// </summary>
        Top,

        /// <summary>
        /// Maps the bottom side of the target bounds.
        /// </summary>
        Bottom,

        /// <summary>
        /// Maps the left side of the target bounds.
        /// </summary>
        Left,

        /// <summary>
        /// Maps the right side of the target bounds.
        /// </summary>
        Right
    }
}