# AndroidLibs == 辅助工具类 Utils

包含：各种工具类、辅助类、管理类……

[<==返回首页==](https://github.com/XXApple/AndroidLibs)

---

**Awesome_API**: https://github.com/marktony/Awesome_API/blob/master/Chinese.md

收集中国国内可用API

---

**commons-lang**: https://github.com/apache/commons-lang

Apache Commons Lang, a package of Java utility classes for the classes that are in java.lang's hierarchy, or are considered to be so standard as to justify existence in java.lang.

---

**Lightweight-Stream-API**: https://github.com/aNNiMON/Lightweight-Stream-API

java 7 及以下使用Stream api

---

**okio**: https://github.com/square/okio

A modern I/O API for Java http://square.github.io/okio/1.x/okio

---

**Multiples**: https://github.com/MFlisar/Multiples

Based one Java Pair this library offers Triples, Quadriples and more (3 to 10 items)

---

**SQLite2XL**: https://github.com/androidmads/SQLite2XL

Library to Convert SQLite to Excel

---

**jsoup-annotations**: https://github.com/fcannizzaro/jsoup-annotations

Java JSOUP 标注方案，不用自己费劲解析了

---

**jOOR**: https://github.com/jOOQ/jOOR

简单易用的安卓反射库

---

**ARTIST**: https://github.com/Lukas-Dresel/ARTIST

The Android Runtime Instrumentation Toolkit

---

**PDD**: https://github.com/jparkie/PDD

Advanced Bloom Filter Based Algorithms for Efficient Approximate Data De-Duplication in Streams

---

**realjavascript**: https://github.com/sanjulr/realjavascript

RealJavaScript enables dynamic scripting in Java

---

**strman-java**: https://github.com/shekhargulati/strman-java

A Java 8 string manipulation library. It is inspired by https://github.com/dleitee/strman

---

**adbons**: https://github.com/dbaelz/adbons

A wrapper for the Android adb tool. It's just adb on steroids

---

**DateTimeUtils**: https://github.com/thunder413/DateTimeUtils

时间工具

---

**android-shake-detector**: https://github.com/safetysystemtechnology/android-shake-detector

Android 晃动检测小工具

---

**ScreenAdaptation**: https://github.com/wildma/ScreenAdaptation

一种非常好用的Android屏幕适配

---

**AndroidAutoSize**: https://github.com/JessYanCoding/AndroidAutoSize

今日头条屏幕适配方案终极版，一个极低成本的 Android 屏幕适配方案

<img src="https://github.com/JessYanCoding/AndroidAutoSize/blob/master/art/1440x2880_width.png" width="320"/>

---

**shortcut-helper**: https://github.com/marcoscgdev/shortcut-helper

An android library to create the new Android 7.1 shortcuts easily

<img src="https://raw.githubusercontent.com/marcoscgdev/shortcut-helper/master/screenshots/IMG_20170502_122417.jpg" width="320"/>

---

**CommonPrintProvider**: https://github.com/GrassQing/CommonPrintProvider

通用型热敏打印机接口（wifi，蓝牙）

---

**wcdb**: https://github.com/Tencent/wcdb

微信数据库组件

---

**SQLiteToExcel**: https://github.com/li-yu/SQLiteToExcel

SQLiteToExcel 库整合了 Apache POI 和一些基本的数据库查询操作，使得 SQLite 和 Excel 之间相互转换更加便捷

---

**AppDataReader**: https://github.com/Ansh1234/AppDataReader

应用中读取 sp 和数据库

<img src="https://raw.githubusercontent.com/Ansh1234/AppDataReader/master/appstoragereader.gif" width="320"/>

---

**AppMethodOrder**: https://github.com/zjw-swun/AppMethodOrder

一个能让你了解所有函数调用顺序的Android库（无需侵入式代码）

<img src="https://camo.githubusercontent.com/7f9fe86c1371f5435aafb998df2d6952fa2ea000/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f313835373838372d656236313962313831356436346261332e6769663f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970" width="320"/>

---

**StrictModeCompat**: https://github.com/kirich1409/StrictModeCompat

低版本使用StrictMode

---

**IsInstalled**: https://github.com/Morxander/IsInstalled

判断一个安卓应用是否安装

---

**AnalysisApp**: https://github.com/fengzhizi715/AnalysisApp

快速分析某个app使用哪些sdk的java小工具

---

**android-shell**: https://github.com/jrummyapps/android-shell

Execute shell commands on Android

<img src="https://raw.githubusercontent.com/jrummyapps/android-shell/master/demo/src/main/res/mipmap-xxxhdpi/ic_launcher.png" width="180"/>

---

**Encryption**: https://github.com/simbiose/Encryption

java 字符串加解密

---

**java-aes-crypto**: https://github.com/tozny/java-aes-crypto

java 字符串加解密

---

**Store**: https://github.com/NYTimes/Store

Store是一个异步数据加载和缓存数据的库

---

**BuildPropEditor**: https://github.com/jrummyapps/BuildPropEditor

Easily edit your build.prop file on Android

---

**ResourceInspector**: https://github.com/nekocode/ResourceInspector

从一个大型项目中快速找到当前页面元素用到的布局文件

<img src="https://github.com/nekocode/ResourceInspector/raw/master/img/screenshot.png" width="320"/>

---

**redexer**: https://github.com/plum-umd/redexer

The Redexer binary instrumentation framework for Dalvik bytecode

---

**adt4j**: https://github.com/sviperll/adt4j

adt4j - Algebraic Data Types for Java

---

**droidReverse**: https://github.com/Juude/droidReverse

android 逆向工程工具集

---

**AndroidProcesses**: https://github.com/jaredrummler/AndroidProcesses

Get running processes on Android

---

**HFunc**: https://github.com/TangXiaoLv/HFunc

Java实现高阶函数，类似Python，支持串行并行计算，适用于Java和Android

---

**r2d2**: https://github.com/moldedbits/r2d2

安卓数据加密解密

---

**android-api-SecureKeys**: https://github.com/saantiaguilera/android-api-SecureKeys

简单好用的安卓数据加密存储

---

**scytale**: https://github.com/yakivmospan/scytale

Android Key 生成，存储，加密工具库

---

**AccessibilityUtil**: https://github.com/xuyisheng/AccessibilityUtil

AccessibilityService Utils

---

**overlaypermission**: https://github.com/czy1121/overlaypermission

悬浮窗权限兼容库

<img src="https://raw.githubusercontent.com/czy1121/overlaypermission/master/screenshot2.png" width="320"/>

---

**XiaomiPJ**: https://github.com/CankingApp/XiaomiPJ

小米悬浮窗全自动完美一键开启

<img src="https://camo.githubusercontent.com/00207b0c98de0cec744b2c2a696cf4e4e5cc454c/687474703a2f2f63616e6b696e676170702e6769746875622e696f2f323031362f30362f30322f6163636573732d666c6f61742f616374696f6e2e676966" width="320"/>

---

**stf**: https://github.com/openstf/stf

浏览器控制管理手机引用

<img src="https://raw.githubusercontent.com/openstf/stf/master/doc/7s_usage.gif" width="700"/>

---

**smart-scheduler-android**: https://github.com/hypertrack/smart-scheduler-android

Android 智能 Scheduler，根据用户手机场景，决定任务执行方式

<img src="https://camo.githubusercontent.com/32f13ca5e698e3a40fa04b4f83df9240dbbee063/687474703a2f2f692e696d6775722e636f6d2f5835336b6c555a2e6769663f31" width="320"/>

---

**ijkplayer**: https://github.com/l123456789jy/ijkplayer

在ijkplayer编译的bilibili开源编译版本上，去掉失败的依赖，增加对https支持

<img src="https://raw.githubusercontent.com/l123456789jy/ijkplayer/master/66.png" width="320"/>

---

**MemoryMonitor**: https://github.com/Kyson/MemoryMonitor

内存监控器

<img src="https://raw.githubusercontent.com/Kyson/MemoryMonitor/master/ART/mm_preview.gif" width="320"/>

---

**mathjs-android**: https://github.com/niltonvasques/mathjs-android

An android wrapper library to mathjs.org javascript library

---

**ThinRPlugin**: https://github.com/mogujie/ThinRPlugin

apk 瘦身之去除android中的R.class

---

**Prevent-Screen-Off**: https://github.com/kevalpatel2106/Prevent-Screen-Off

用户盯着屏幕时保持屏幕常亮

<img src="https://raw.githubusercontent.com/kevalpatel2106/Prevent-Screen-Off/master/assets/Prevent_screen_off.gif" width="540"/>

---

**ForceTouch**: https://github.com/michelelacorte/ForceTouch

Simple implementation of ForceTouch on Android

<img src="https://camo.githubusercontent.com/ba1666aa84ec083accb9fc982e961e7a05fd0361/68747470733a2f2f7331342e706f7374696d672e6f72672f3573337363716639742f73637265656e2e706e67" width="320"/>

---

**soter**: https://github.com/Tencent/soter

腾讯开源的可信指纹认证，获得与微信指纹支付一致的安全快捷认证体验

<img src="https://github.com/WeMobileDev/article/raw/master/assets/soter/SoterFramework.png" width="600"/>

---

**FingerprintIdentify**: https://github.com/uccmawei/FingerprintIdentify

APP一秒接入指纹识别SDK，0奔溃，0闪退，炒鸡稳定！额外支持三星和魅族6.0以下系统

<img src="https://github.com/uccmawei/FingerprintIdentify/raw/master/other/QRCode_en.png" width="320"/>

---

**Fingerprint2Sleep**: https://github.com/ztc1997/Fingerprint2Sleep

自定义 Android 指纹识别快捷方式

---

**RootHelper**: https://github.com/AndroidDeveloperLB/RootHelper

An extension to use libsuperuser library more easily

---

**AndroidPush**: https://github.com/jiang111/AndroidPush

更方便的将各个rom厂商自己的推送服务进行集成,并统一管理

---

**SQLiteParser**: https://github.com/jrvansuita/SQLiteParser

This project comes in handy when you want to write a sql statement easily and smarter

---

**AndroidMapperObject**: https://github.com/Gperez88/AndroidMapperObject

MapperObject which it is a library that allows you to transfer data between two objects

---

**SensorAnnotations**: https://github.com/dvoiss/SensorAnnotations

Sensor 注解：实现当传感器参数发生变化的时候，自动调用特定函数

---

**MaterialValues**: https://github.com/AoDevBlue/MaterialValues

Material Design 中那些标准的设计常量

---

**libretorrent**: https://github.com/proninyaroslav/libretorrent

基于 libtorrent 实现的种子下载客户端

---

**StanKoUtils**: https://github.com/stan-ko/StanKoUtils

Set of handy classes

---

**intentbuilder**: https://github.com/Trikke/intentbuilder

IntentBuilder is a type safe way of creating intents and populating them with extras. Use them with your Activities and Services

---

**HybridBridge**: https://github.com/YouJZ/HybridBridge

A basic framework for Android hybrid development, bridge between JavaScript and java

<img src="https://raw.githubusercontent.com/YouJZ/HybridBridge/master/demo.gif" width="320" />

---

**WebViewJavascriptBridge**: https://github.com/jesse01/WebViewJavascriptBridge

WebViewJavascriptBridge for Android

---

**SimpleJavaJsBridge**: https://github.com/niuxiaowei/SimpleJavaJsBridge

JS 与 Java 通信的简单桥梁

---

**stag-java**: https://github.com/vimeo/stag-java

Stag improves Gson performance by automatically generating reflection-less TypeAdapters for your model objects

---

**medium-android-sdk-unofficial**: https://github.com/KingsMentor/medium-android-sdk-unofficial

Unoffical implementation of medium api for android

---

**PhoneNumberValidator**: https://github.com/KingsMentor/PhoneNumberValidator

This library helps make sure the number is valid for the selected country

---

**ButterKnifeLite**: https://github.com/janishar/ButterKnifeLite

Light version of the concept of ButterKnife

---

**apk-dependency-graph**: https://github.com/alexzaitsev/apk-dependency-graph

解析apk包，图表展示依赖及结构

---

**truetime-android**: https://github.com/instacart/truetime-android

获取当前时间，可自定义时间服务器

---

**location-tracker-background**: https://github.com/safetysystemtechnology/location-tracker-background

后台实时获取追踪

---

**SamLocationAndGeocoding**: https://github.com/kingsammalik/SamLocationAndGeocoding

跟踪用户位置地址

---

**LocationManager**: https://github.com/yayaa/LocationManager

Simplify getting user's location for Android

---

**AppAuth-Android**: https://github.com/openid/AppAuth-Android

Android client SDK for communicating with OAuth 2.0 and OpenID Connect providers

---

**Pury**: https://github.com/NikitaKozlov/Pury

测量多事件耗时

---

**maoni-email**: https://github.com/rm3l/maoni-email

Android 收集用户基本信息利器，比如 App 崩溃后的地理位置，GPS网络状态，当前页面截屏等

---

**maoni**: https://github.com/rm3l/maoni

Android 收集用户基本信息利器，比如 App 崩溃后的地理位置，GPS网络状态，当前页面截屏等

<img src="https://raw.githubusercontent.com/rm3l/maoni/master/doc/screenshots/raw/maoni_2.3.1.gif" width="320"/>

---

**XTML**: https://github.com/metalurgus/XTML

GSON analog for serialization/deserialization of Java objects into HTML code and back

---

**DBC-Android**: https://github.com/busybusy/DBC-Android

Fluent design by contract constructs for android

---

**NetMonitor**: https://github.com/GHdeng/NetMonitor

使用广播监听网络变化更新UI

<img src="https://raw.githubusercontent.com/GHdeng/NetMonitor/master/NetMonitor2.gif" width="320"/>

---

**WifiConnHelper**: https://github.com/BirdGuo/WifiConnHelper

Wifi扫描和连接

---

**WiseFy**: https://github.com/isuPatches/WiseFy

Wrapper around WifiManager and ConnectivityManager for Android

---

**LocalNetwork**: https://github.com/itsJoKr/LocalNetwork

两设备通过 Wifi 通信

---

**AnalyticsKit-Android**: https://github.com/busybusy/AnalyticsKit-Android

Analytics framework for Android

---

**icepick**: https://github.com/frankiesardo/icepick

好用的状态保存库

---

**SyncIt**: https://github.com/jineshfrancs/SyncIt

SyncIt will call a method implemented in your activity to notify data connection changes

<img src="https://raw.githubusercontent.com/jineshfrancs/SyncIt/master/screens/screen1.gif" width="270"/>

---

**SafelyAndroid**: https://github.com/Piasy/SafelyAndroid

打造健壮的安卓APP，从此告别 Activity Not Found、Activity State Loss 和 fragment transaction 中的 NPE

---

**FragmentStateManager**: https://github.com/okaybroda/FragmentStateManager

An Android library that holds fragment states for bottom navigation view even when activity rotates

---

**ActivityCommWithFragment**: https://github.com/niuxiaowei/ActivityCommWithFragment

解决activity与fragment之间互相通信的一种方案

---

**AirCycle**: https://github.com/simonpercic/AirCycle

Flexible binding of Android Activity lifecycle callbacks to fields

---

**fragment-back**: https://github.com/skoumalcz/fragment-back

Fragment 回退处理库

---

**Fragmentation**: https://github.com/YoKeyword/Fragmentation

为"单Activity ＋ 多Fragment","多模块Activity + 多Fragment"架构而生，帮你大大简化使用过程，轻松解决各种复杂嵌套等问题，修复了官方Fragment库中存在的一些BUG

<img src="https://raw.githubusercontent.com/YoKeyword/Fragmentation/master/gif/demo.gif" width="270"/> <img src="https://raw.githubusercontent.com/YoKeyword/Fragmentation/master/gif/wechat.gif" width="270"/> <img src="https://raw.githubusercontent.com/YoKeyword/Fragmentation/master/gif/nested.gif" width="270"/>

---

**FragmentArgs**: https://github.com/itsJoKr/FragmentArgs

Fragment 参数传递

---

**FingerprintIdentify**: https://github.com/uccmawei/FingerprintIdentify

安卓指纹识别库（安卓官方+三星SDK+魅族SDK）

<img src="https://raw.githubusercontent.com/uccmawei/FingerprintIdentify/master/demo.png" width="320"/>

---

**android-fingerprint-authentication**: https://github.com/multidots/android-fingerprint-authentication

指纹集成，管理工具

<img src="https://raw.githubusercontent.com/multidots/android-fingerprint-authentication/master/screens/screen-capture.gif" width="320"/>

---

**FingerprintManager**: https://github.com/JesusM/FingerprintManager

简洁的指纹管理工具

<img src="https://raw.githubusercontent.com/JesusM/FingerprintManager/master/resources/images/sample_light_theme.png" width="320"/> <img src="https://raw.githubusercontent.com/JesusM/FingerprintManager/master/resources/images/sample_dark_theme.png" width="320"/>

---

**FingerprintAuthHelper**: https://github.com/pro100svitlo/FingerprintAuthHelper

指纹认证

<img src="https://raw.githubusercontent.com/pro100svitlo/FingerprintAuthHelper/master/screenshots/sc_0.png" width="320"/> <img src="https://raw.githubusercontent.com/pro100svitlo/FingerprintAuthHelper/master/screenshots/sc_1.png" width="320"/>

---

**FingerprintAuthDemo**: https://github.com/pro100svitlo/FingerprintAuthDemo

指纹认证

---

**fingerlock**: https://github.com/aitorvs/fingerlock

指纹认证

---

**java-object-diff**: https://github.com/SQiShER/java-object-diff

Library to diff and merge Java objects with ease http://sqisher.github.io/java-object-diff/

---

**ActiveHashTag**: https://github.com/mugku/ActiveHashTag

Android HashTag Lib

<img src="https://raw.githubusercontent.com/mugku/ActiveHashTag/master/pic/pic.gif" width="600"/>

---

**Save-to-Activity**: https://github.com/Metroxe/Save-to-Activity

This library is an easy to use series of commands to interact with a hashmap across multiple fragments attached to any running activity

---

**DataAutoAccess**: https://github.com/ThirtyDegreesRay/DataAutoAccess

Android由于系统内存不足时，activity被杀死时的数据存取方案

---

**Preservely**: https://github.com/samiuelson/Preservely

安卓横竖屏变化处理库

---

**java-error-handler**: https://github.com/Workable/java-error-handler

异常处理

---

**java-object-diff**: https://github.com/SQiShER/java-object-diff

Library to diff and merge Java objects with ease http://sqisher.github.io/java-object-diff/

---

**Android-ORM**: https://github.com/Jamling/Android-ORM

Android ORM (Aorm) in an ORM implementation on Android platform

---

**ResourcesPoet**: https://github.com/Commit451/ResourcesPoet

Like JavaPoet, but for Android XML Resources

---

**root-tools**: https://github.com/rarnu/root-tools

RootTools 是一款专注于给 root 后的用户提供方便的软件

---

**android-autoprovider**: https://github.com/futuresimple/android-autoprovider

Utility for creating ContentProviders without boilerplate and with heavy customization options

---

**spek**: https://github.com/JetBrains/spek

A specification framework for Kotlin

---

**ktlint**: https://github.com/shyiko/ktlint

An anti-bikeshedding Kotlin linter with built-in formatter

---

**tiger**: https://github.com/google/tiger

java依赖注入

---

**DaggerAutoInject**: https://github.com/florent37/DaggerAutoInject

DaggerAutoInject

---

**Napkin**: https://github.com/AleksanderMielczarek/Napkin

Common scopes and qualifiers for Dagger 2

---

**dagger**: https://github.com/google/dagger

传说中的 dagger2，依赖注入

---

**Splitties**: https://github.com/LouisCAD/Splitties

安卓复制粘贴工具类

---

**android-priority-jobqueue**: https://github.com/yigit/android-priority-jobqueue

A Job Queue specifically written for Android to easily schedule jobs (tasks) that run in the background

---

**concurrent**: https://github.com/onehilltech/concurrent

安卓并发解决方案库

---

**NinePatchChunk**: https://github.com/Anatolii/NinePatchChunk

Simple Android library which allows you to create a chunk for NinePatchDrawable at runtime

---

**mock-api**: https://github.com/shanbay/mock-api

A json-api-mock framework for Android

---

**MidiDroid**: https://github.com/pdrogfer/MidiDroid

MIDI library for Android, ready to use in Android Studio projects

---

**AdBlockerDetector**: https://github.com/Swisyn/AdBlockerDetector

This project proposes an open source library that can detect most of ad blockers

---

**SugarTask**: https://github.com/mthli/SugarTask

Android lifecycle safety task with sugar code style

---

**fastlane**: https://github.com/fastlane/fastlane

The easiest way to automate building and releasing your iOS and Android apps https://fastlane.tools

---

**MyOpenGL**: https://github.com/redknotmiaoyuqiao/MyOpenGL

Android 上使用 NDK 编写 OpenGL ES 3.0

<img src="https://raw.githubusercontent.com/redknotmiaoyuqiao/MyOpenGL/master/img/one.gif" width="320"/> <img src="https://raw.githubusercontent.com/redknotmiaoyuqiao/MyOpenGL/master/img/ten.gif" width="320"/>

---

**usb-serial-for-android**: https://github.com/mik3y/usb-serial-for-android

Android USB host serial driver library for CDC, FTDI, Arduino and other devices

---

**USB-Device-Info---Android**: https://github.com/alt236/USB-Device-Info---Android

从linux层和android层获取usb设备信息的应用

---

**AndroidUsbCamera**: https://github.com/quanhua92/AndroidUsbCamera

Use USB Webcam on non-rooted Android devices with UVCCamera library from saki4510t(above)

---

**libaums**: https://github.com/magnusja/libaums

在非root设备上访问usb大容量存储设备

---

**UsbSerial**: https://github.com/felHR85/UsbSerial

Usb serial controller for Android

---

**OkDeepLink**: https://github.com/HongJun2046/OkDeepLink

Android 轻量级 DeepLink 解决方案

<img src="https://raw.githubusercontent.com/HongJun2046/OkDeepLink/master/snapshot/intercept_preview.png" width="320"/>

---

**AntCaves**: https://github.com/themores/AntCaves

Android Router 框架，取名为AntCaves，中文名”蚁穴“

<img src="https://raw.githubusercontent.com/themores/AntCaves/master/img/IMG_3063(20170311-183321).jpg" width="320"/>

---

**Meepo**: https://github.com/nekocode/Meepo

实现仿 Retrofit 的跳转路由

---

**Router**: https://github.com/chenenyu/Router

简单、灵活的路由框架

<img src="https://raw.githubusercontent.com/chenenyu/Router/master/static/screenshot.gif" width="320"/>

---

**krouter**: https://github.com/denisidoro/krouter

A lightweight Android activity router

---

**Router**: https://github.com/yjfnypeu/Router

一款简单的Android端用于Activity跳转的路由框架

---

**router**: https://github.com/eyeem/router

Dynamic in app URL router for Android

---

**KeyHide**: https://github.com/Hamadakram/KeyHide

KeyHide

---

**keyboard-dismisser**: https://github.com/GabrielSamojlo/keyboard-dismisser

Dismiss your keyboard by tapping anywhere outside it

<img src="https://camo.githubusercontent.com/e3fa7baf5a19bbd47d2cdede656262c9d300e791/687474703a2f2f692e67697068792e636f6d2f6c33765261764e4c306151664c327476612e676966" width="260"/>

---

**Teleprinter**: https://github.com/Commit451/Teleprinter

Android keyboard helper

---

**AnySoftKeyboard**: https://github.com/AnySoftKeyboard/AnySoftKeyboard

Android (f/w 1.5+) on screen keyboard for multiple languages http://anysoftkeyboard.github.io/

---

**decorator**: https://github.com/eyeem/decorator

Dynamic inheritance library

---

**Tabbels**: https://github.com/FireZenk/Tabbels

A crazy idea about bringing functional programming to Java, in an elegant way

---

**android-selfsigned**: https://github.com/onehilltech/android-selfsigned

A simple library for supporting self-signed certificates in Android

---

**AndroidDecompiler**: https://github.com/dirkvranckaert/AndroidDecompiler

Decompile any APK

---

**apk-decompiler**: https://github.com/dwatling/apk-decompiler

Android APK Decompiler

---

**RTMPCHybirdEngine-Android**: https://github.com/AnyRTC/RTMPCHybirdEngine-Android

基于RTMP和RTC混合引擎的在线视频连麦互动直播

---

**Endoscope**: https://github.com/hypeapps/Endoscope

Endoscope - RTSP live video streamer for android devices via Wi-Fi

<img src="https://camo.githubusercontent.com/ce665f81a40ad2e6be1b8c3eb2c8846e59e4f347/68747470733a2f2f7333322e706f7374696d672e6f72672f7273666974677039782f656e646f73636f70655f62616e6e65722e706e67" width="800"/>

---

**LayoutFormatter**: https://github.com/drakeet/LayoutFormatter

安卓布局格式化

<img src="https://camo.githubusercontent.com/72bcb530f4ba53173de534350e61d8b410bfaa12/687474703a2f2f7777342e73696e61696d672e636e2f6c617267652f3836653266663835677731663274326434307765346a32316765306d35677a312e6a7067" width="800"/>

---

**ResourceInspector**: https://github.com/nekocode/ResourceInspector

类似 Stetho 的 Layout 资源视察工具

<img src="https://camo.githubusercontent.com/fca4d6ebedcef761b39f3f4fda56c5cbef1a45ac/68747470733a2f2f6f6f6f2e306f302e6f6f6f2f323031362f31322f31332f353834663761303434653166612e706e67" width="600"/>

---

**Dream-Catcher**: https://github.com/misakuo/Dream-Catcher

在Chrome DevTools内查看Android设备上所有HTTP(S)流量

<img src="https://camo.githubusercontent.com/fca4d6ebedcef761b39f3f4fda56c5cbef1a45ac/68747470733a2f2f6f6f6f2e306f302e6f6f6f2f323031362f31322f31332f353834663761303434653166612e706e67" width="320"/> <img src="https://camo.githubusercontent.com/ffff627417220fc33fd868a092a7419db48d476c/68747470733a2f2f6f6f6f2e306f302e6f6f6f2f323031362f31322f31332f353834663761343233306162612e706e67" width="540"/>

---

**Stetho-Couchbase**: https://github.com/RobotPajamas/Stetho-Couchbase

Stetho-Couchbase is a plugin for Stetho to enable visualizing and debugging Android Couchbase databases in Chrome

<img src="https://raw.githubusercontent.com/amitshekhariitbhu/Android-Debug-Database/master/assets/debugdb.png" width="640"/>

---

**MMKV**: https://github.com/Tencent/MMKV

腾讯出品的MMKV——基于 mmap 的高性能通用 key-value 组件

<img src="https://raw.githubusercontent.com/wiki/Tencent/MMKV/assets/profile_android_mini.jpg" width="480"/>

---

**SessionManager-Android**: https://github.com/Chingiz/SessionManager-Android

Small Shared Preference Library for Android

---

**SimpleConfig**: https://github.com/BCsl/SimpleConfig

这是一个基于 SharePreference 简化应用配置信息读取和保存的库, 灵感来自于 retrofit

---

**tray**: https://github.com/grandcentrix/tray

多进程安全的SharedPreferences

---

**binaryprefs**: https://github.com/iamironz/binaryprefs

Rapidly fast implementation of SharedPreferences which stores each preference in files separately, performs disk IO via NIO with memory mapped byte buffers and works IPC (between processes)

---

**prefdata**: https://github.com/xelevra/prefdata

Pref Data – the Android SharedPreferences wrapper

---

**ProbeTools**: https://github.com/pavel163/ProbeTools

ProbeTools displays the data from the Database and SharedPreferences in the browser

<img src="https://raw.githubusercontent.com/pavel163/ProbeTools/master/1.png" width="640"/>

---

**Android-Debug-Database**: https://github.com/amitshekhariitbhu/Android-Debug-Database

通过网页来查看 Android 本机数据库和 SharedPreference 数据

<img src="https://raw.githubusercontent.com/amitshekhariitbhu/Android-Debug-Database/master/assets/debugdb.png" width="640"/>

---

**SQLiteOnWeb-Android**: https://github.com/skyhacker2/SQLiteOnWeb-Android

通过浏览器管理sqlite数据库

<img src="https://raw.githubusercontent.com/skyhacker2/SQLiteOnWeb-Android/master/screenshots/2.png" width="640"/>

---

**LitePal**: https://github.com/LitePalFramework/LitePal

Android Sqlite ORM，让数据库操作更便捷 

---

**droitatedDB**: https://github.com/arconsis/droitatedDB

droitatedDB is a lightweight framework, which frees you from the burden of dealing with the Android SQLite database directly 

---

**CopyExternalDB**: https://github.com/emrekose26/CopyExternalDB

数据库复制

---

**AutoGo**: https://github.com/TellH/AutoGo

Ease your code, easy go

---

**AndroidMiscUtils**: https://github.com/nillith/AndroidMiscUtils

Android Utils for context and thread

---

**Versionberg**: https://github.com/rockerhieu/Versionberg

每次 commit 自动生成版本号

---

**AutoVersion**: https://github.com/nillith/AutoVersion

根据 commit 数自动生成版本号

---

**UniPinyin**: https://github.com/nillith/UniPinyin

Java 汉语拼音查询工具。支持CJK基本字符集及扩充区A的中文汉字，共26679个，其中多音字6769个。

---

**essentials**: https://github.com/greenrobot/essentials

General purpose utilities and hash functions for Android and Java (aka java-common)

---

**ContentManager**: https://github.com/stfalcon-studio/ContentManager

Library what helps getting photo or video from device gallery, from a cloud or from a camera

---

**InputValidator**: https://github.com/jordanterry/InputValidator

An Android library helps to validate input content

---

**Scripto**: https://github.com/ImangazalievM/Scripto

Library for easy call JS-functions from Java

---

**AutoInstaller**: https://github.com/a-voyager/AutoInstaller

应用自动静默更新安装库

<img src="https://raw.githubusercontent.com/a-voyager/AutoInstaller/master/imgs/GIF.gif" width="320"/>

---

**AndroidStudioTemplates**: https://github.com/WanAndroid/AndroidStudioTemplates

Templates for Android Studio

---

**FlatBuffer**: https://github.com/amitshekhariitbhu/FlatBuffer

This app shows how fast flat buffer works when we compare it with json

---

**Knight**: https://github.com/zjutkz/Knight

使用 java apt and javapoet 技术实现的安卓换肤库

---

**AES256PasswordBasedEncryption-Decryption**: https://github.com/rishelarora/AES256PasswordBasedEncryption-Decryption

AES256 加解密

---

**featured**: https://github.com/beworker/featured

Simple yet powerful composition library for Android

<img src="https://raw.githubusercontent.com/beworker/featured/master/web/diagram.png" width="800"/>

---

**Blorm**: https://github.com/daniel-martins-IR/Blorm

Blorm is a field validation lib for android

<img src="https://camo.githubusercontent.com/1c2ab552211f7a0e78eaed76488916e1c9d1fac9/687474703a2f2f7777772e636c6970617274626573742e636f6d2f636c6970617274732f6463372f6564372f6463376564373447692e706e67" width="320"/>

---

**IpcEventBus**: https://github.com/NewtronLabs/IpcEventBus

进程通信事件总线

<img src="https://github.com/NewtronLabs/IpcEventBus/raw/master/Diagram.png" width="400"/>

---

**Hermes**: https://github.com/Xiaofei-it/Hermes

简单易用的安卓进程间通信IPC框架

---

**ToyRoom**: https://github.com/eleme/ToyRoom

饿了么开发的一套面向业务逻辑的编程库-ToyRoom

---

**HermesEventBus**: https://github.com/eleme/HermesEventBus

饿了么开源的Android跨进程事件分发框架

---

**gimBUS**: https://github.com/PGSSoft/gimBUS

Event bus for Android with fine-grained delivery thread control

---

**AndroidEventBus**: https://github.com/hehonghui/AndroidEventBus

A lightweight eventbus library for android, simplifies communication between Activities, Fragments, Threads, Services, etc

---

**eventbus3-intellij-plugin**: https://github.com/likfe/eventbus3-intellij-plugin

eventbus3 可用事件跳转 Android Studio 插件

---

**EventBus**: https://github.com/greenrobot/EventBus

Android optimized event bus that simplifies communication between Activities, Fragments, Threads, Services, etc. Less code, better quality. http://greenrobot.org/eventbus/

---

**sdk3rd**: https://github.com/czy1121/sdk3rd

第三方SDK集成库，授权/分享/支付

---

**EasyPay**: https://github.com/xiong-it/EasyPay

简单易用的第三方可扩展支付框架

---

**Android-Pay**: https://github.com/mayubao/Android-Pay

支持微信和支付宝两种主流支付的集成库， 两行代码实现微信支付， 三行代码实现支付宝支付

---

**AndroidPay**: https://github.com/hanbaokun/AndroidPay

微信支付和支付宝支付快速接入，可以直接拷贝代码到项目中使用

---

**blankapp-validation**: https://github.com/lijy91/blankapp-validation

Android 表单验证库，用方法链构建你的验证规则

---

**artdumper**: https://github.com/Qihoo360/artdumper

android5.0之后，从oat文件中dump出来dex的工具

---

**WHC_ScanUnreferenceImageTool**: https://github.com/netyouli/WHC_ScanUnreferenceImageTool

扫描项目里没有使用的图片工具，删除没有引用的图片以减小打包体积

---

**packagehunter**: https://github.com/nisrulz/packagehunter

捕获安卓应用信息

<img src="https://raw.githubusercontent.com/nisrulz/packagehunter/master/img/sc1.png" width="300"/> <img src="https://raw.githubusercontent.com/nisrulz/packagehunter/master/img/sc2.png" width="300"/>

---

**NavigationViewFragmentAdapters**: https://github.com/patloew/NavigationViewFragmentAdapters

Fragment 管理

---

**PullSwitcher**: https://github.com/loopeer/PullSwitcher

方便 Fragment 切换的工具

---

**Jolyglot**: https://github.com/VictorAlbertos/Jolyglot

Agnostic Json abstraction to perform data binding operations for Android and Java

---

**EasyWeather**: https://github.com/code-crusher/EasyWeather

天气，Easy and quick weather fetching from OpenWeatherMap API for Android

---

**OpenWeatherMap-Android**: https://github.com/seventhmoon/OpenWeatherMap-Android

天气，OpenWeatherMap Library and Sample

---

**RemoveButterKnife**: https://github.com/u3shadow/RemoveButterKnife

帮助去掉 ButterKnife 库的 android studio 插件

<img src="https://camo.githubusercontent.com/0327cda5b531ab6f2b803abe295c42225668d28d/687474703a2f2f7777772e7533636f64696e672e636f6d2f77702d636f6e74656e742f75706c6f6164732f323031362f30362f312e676966" width="600"/>

---

**MaterialDesignIcons**: https://github.com/MrBIMC/MaterialDesignIcons

Lib that imports all the vector drawables from www.materialdesignicons.com into your R.drawable/

---

**network-connection-class**: https://github.com/facebook/network-connection-class

facebook 出品的网速监测

<img src="https://raw.githubusercontent.com/facebook/network-connection-class/master/docs/images/bandwidth_averaging.png" width="640"/>

---

**AndroidRandom**: https://github.com/slmyldz/AndroidRandom

Simple random data generator for Android

---

**Lyra**: https://github.com/Fondesa/Lyra

安卓组件状态保存及恢复

---

**reminder**: https://github.com/OneCodeLabs/reminder

保持 View 状态直到下次数据更新

---

**GroupOfX**: https://github.com/blipinsk/GroupOfX

When Android's Pair class is just not enough

---

**user-validator**: https://github.com/ShootrNetwork/user-validator

Library to validate username, email and passwords

---

**agera-event-bus**: https://github.com/drakeet/agera-event-bus

一个关于 Agera 的裤子 用法和 RxBus 基本一样的 Agera Event Bus

---

**AppUpdate**: https://github.com/fccaikai/AppUpdate

app更新

<img src="https://camo.githubusercontent.com/7a478c9eb83af712d69eec9cea62f7e0f74222f6/68747470733a2f2f7777332e73696e61696d672e636e2f6c617267652f303036744e62527767793166646875673136646e686a33306b6d306234676c752e6a7067" width="600"/>

---

**LessCode-Update**: https://github.com/openproject/LessCode-Update

兼容 Android7.0+ app更新

---

**force-update**: https://github.com/skoumalcz/force-update

app 强制更新

---

**UpdateApp**: https://github.com/yaming116/UpdateApp

开箱即用的app更新，主要负责软件下载、软件安装等

---

**update**: https://github.com/czy1121/update

清晰灵活简单易用的应用更新库

<img src="https://github.com/czy1121/update/raw/master/screenshot1.png" width="320"/> <img src="https://github.com/czy1121/update/raw/master/screenshot4.png" width="320"/>

---

**MAHAndroidUpdater**: https://github.com/hummatli/MAHAndroidUpdater

Android app update checker

<img src="https://github.com/hummatli/MAHAndroidUpdater/blob/master/imgs/updater_dlg.png" width="200px"/> <img src="https://github.com/hummatli/MAHAndroidUpdater/blob/master/imgs/restricter_dlg.png" width="200px"/>

---

**UpdatePlugin**: https://github.com/yjfnypeu/UpdatePlugin

可任意定制的app更新组件

<img src="https://raw.githubusercontent.com/yjfnypeu/UpdatePlugin/master/screenshots/default_strategy.gif" width="270" /> <img src="https://raw.githubusercontent.com/yjfnypeu/UpdatePlugin/master/screenshots/default_all_dialog_show.gif" width="270" /> <img src="https://raw.githubusercontent.com/yjfnypeu/UpdatePlugin/master/screenshots/default_auto_install.gif" width="270" />

---

**android-auto-update**: https://github.com/feicien/android-auto-update

Android 应用自动更新

<img src="https://camo.githubusercontent.com/8e0be231005184234cf715c5fc40bfbc0dac5bbb/68747470733a2f2f7261772e6769746875622e636f6d2f6665696369656e2f616e64726f69642d6175746f2d7570646174652f6d61737465722f73637265656e73686f74732f73616d706c652e706e67" width="320" /> <img src="https://camo.githubusercontent.com/039c92955ce092a2e81cd6d4cd5203f31bf32c92/68747470733a2f2f7261772e6769746875622e636f6d2f6665696369656e2f616e64726f69642d6175746f2d7570646174652f6d61737465722f73637265656e73686f74732f6469616c6f672e706e67" width="320" />

---

**RainbowBridge**: https://github.com/Sunzxyong/RainbowBridge

A safe JsBridge framework!

<img src="https://camo.githubusercontent.com/0c8c7c906d9cc6d517ae05c501920864add59c32/687474703a2f2f3778737778662e636f6d322e7a302e676c622e636c6f7564646e2e636f6d2f626c6f672f6a732e676966" width="320"/>

---

**android-proguards**: https://github.com/yongjhih/android-proguards

AAR proguards

---

**AndroidProguardPlugin**: https://github.com/zhonghanwen/AndroidProguardPlugin

生成混淆代码的 Android Studio 插件

---

**RealmRepository**: https://github.com/AleksanderMielczarek/RealmRepository

Generate Realm repositories

---

**Kolumbus**: https://github.com/MGaetan89/Kolumbus

浏览应用 Realm 数据库

---

**RealmContactsForAndroid**: https://github.com/SergioDim3nsions/RealmContactsForAndroid

This is an example for realm database in android

---

**RebDroid**: https://github.com/Snakeice/RebDroid

Realm DB browser and editor

---

**requery**: https://github.com/requery/requery

轻量但功能强大的ORM和SQL查询生成， 支持RxJava和Java8

---

**material-design-dimens**: https://github.com/DmitryMalkovich/material-design-dimens

MD 设计中的尺寸和颜色指导

---

**BleDemo**: https://github.com/Alex-Jerry/BleDemo

android BLE蓝牙项目

---

**FastBle**: https://github.com/Jasonchenlijian/FastBle

Android BLE 蓝牙开发框架，使用回调方式处理，搜索、连接、notify、indicate、读、写等一系列蓝牙操作

---

**android-lite-bluetoothLE**: https://github.com/litesuits/android-lite-bluetoothLE

Android低功耗蓝牙便捷操作框架，基于回调，完成蓝牙设备交互就像发送网络请求一样简单

---

**UReflection**: https://github.com/mnayef95/UReflection

A light-weight android library that can be quickly integrated into any app to use android utils

---

**android-utility**: https://github.com/aaabidunique/android-utility

A handy set of utility for android

---

**android-utils**: https://github.com/nisrulz/android-utils

Repository consisting of utility scripts/classes/packages

---

**AndroidUtilCode**: https://github.com/Blankj/AndroidUtilCode

AndroidUtilCode

---

**NonViewUtils**: https://github.com/android-quick-dev/NonViewUtils

Android常用工具类

---

**AndroidUtils**: https://github.com/fengjingyu/AndroidUtils

Android常用工具类

---

**AndroidUtils**: https://github.com/HJXANDHMR/AndroidUtils

Android常用工具类

---

**AndroidUtils**: https://github.com/WuXiaolong/AndroidUtils

Android常用工具类

---

**android-common**: https://github.com/litesuits/android-common

安卓开发通用类、辅助类、工具类的集合

---

**Lazy**: https://github.com/l123456789jy/Lazy

整理的常用的工具类，值得收藏

---

**android-lite-go**: https://github.com/litesuits/android-lite-go

LiteGo是一款基于Java语言的「异步并发类库」

---

**ECTranslation**: https://github.com/Skykai521/ECTranslation

Android Studio 翻译插件,可以将英文翻译为中文.

<img src="https://raw.githubusercontent.com/Skykai521/ECTranslation/master/img/translation_img.png" width="640" />

---

**Aria**: https://github.com/AriaLyy/Aria

文件下载管理

<img src="https://github.com/AriaLyy/DownloadUtil/raw/master/img/download_img.gif" width="640" />

---

**lib_download**: https://github.com/wangdanlizhiyun/lib_download

处理异步下载的库

---

**Fuse**: https://github.com/kittinunf/Fuse

Kotlin 语言编写的安卓 cache 库

---

**ShareUtil**: https://github.com/shaohui10086/ShareUtil

简单的Android社会化分享登录库，一行代码搞定

<img src="https://raw.githubusercontent.com/shaohui10086/ShareUtil/master/preview/shareutil_share.gif" width="320" /> <img src="https://raw.githubusercontent.com/shaohui10086/ShareUtil/master/preview/shareutil_login.gif" width="320" />

---

**IntentShare**: https://github.com/tvbarthel/IntentShare

提升"分享"体验的库 

---

**Sensey**: https://github.com/nisrulz/Sensey

手势检测

---

**AsyncTaskScheduler**: https://github.com/SilenceDut/AsyncTaskScheduler

AsyncTask 替代者

---

**thinr**: https://github.com/bjoernQ/thinr

AsyncTask 替代者

---

**android-hidden-api**: https://github.com/anggrayudi/android-hidden-api

可直接查看、访问安卓 hide 与 internal API

---

**RNCryptorNative**: https://github.com/TGIO/RNCryptorNative

安卓加解密

---

**PiracyChecker**: https://github.com/javiersantos/PiracyChecker

保护你的 app 以防破解

---

**multibackstack**: https://github.com/JetradarMobile/multibackstack

安卓 回退栈管理

---

**phrase**: https://github.com/square/phrase

安卓 格式化字符串的库

---

**ParcelCheck**: https://github.com/Commit451/ParcelCheck

Simple test to see if all models in project correctly implement Parcelable

---

**SimpleNFC**: https://github.com/tawaasalage/SimpleNFC

This is a sample project that include NFC value reading using insanely easy way

---

**nordpol**: https://github.com/fidesmo/nordpol

The Android Support Library for NFC

---

**ASimpleCache**: https://github.com/yangfuhai/ASimpleCache

一个为android制定的 轻量级的 开源缓存框架

---

**android-UCToast**: https://github.com/liaohuqiu/android-UCToast

开机自动启动的 Service 监听剪切板。复制之后，在屏幕顶部显示一个悬浮窗，显示剪贴板内容。点击悬浮窗，跳转到 Activity 页面显示

---

**HideKeyboard**: https://github.com/yingLanNull/HideKeyboard

仿iOS输入法点击输入框以外区域 自动隐藏软键盘轻量级库

<img src="https://raw.githubusercontent.com/yingLanNull/HideKeyboard/master/show/show.gif" width="320" />

---

**AwesomeKeyboard**: https://github.com/hoanganhtuan95ptit/AwesomeKeyboard

emoticons, sticker, photo and color keyboard

<img src="https://github.com/hoanganhtuan95ptit/AwesomeKeyboard/raw/master/output/Screenshot_2017-07-06-12-54-22.png" width="320" /> <img src="https://github.com/hoanganhtuan95ptit/AwesomeKeyboard/raw/master/output/Screenshot_2017-07-06-12-55-15.png" width="320" />

---

**KeyBoardDemo**: https://github.com/wobiancao/KeyBoardDemo

Android 软键盘和emoji表情切换方案，和微信几乎一样的体验

<img src="https://camo.githubusercontent.com/df05b7b65a599ff861770b06e2d78f459defc0da/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f313231363033322d396363316635393663353835643433642e6769663f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970" width="320" />

---

**AndroidKeyboardWatcher**: https://github.com/AzimoLabs/AndroidKeyboardWatcher

Software keyboard open/close watcher for Android

<img src="https://raw.githubusercontent.com/AzimoLabs/AndroidKeyboardWatcher/master/art/keyboard_shown.png" width="320" />

---

**android-keyboardlistener**: https://github.com/ravindu1024/android-keyboardlistener

An Android Keyboard visibility listener 

---

**JKeyboardPanelSwitch**: https://github.com/Jacksgong/JKeyboardPanelSwitch

Android键盘面板冲突 布局闪动处理方案

<img src="https://raw.githubusercontent.com/Jacksgong/JKeybordPanelSwitch/master/art/non-fullscreen_resolved.gif" width="320" /> <img src="https://raw.githubusercontent.com/Jacksgong/JKeybordPanelSwitch/master/art/adjust_resolved.gif" width="320" />

---

**redex**: https://github.com/facebook/redex

facebook 出品的 apk 包优化工具 —— [Optimizing Android bytecode with ReDex](https://code.facebook.com/posts/1480969635539475/optimizing-android-bytecode-with-redex)

---

**enjarify**: https://github.com/google/enjarify

Enjarify is a tool for translating Dalvik bytecode to equivalent Java bytecode

---

**CompositeAndroid**: https://github.com/passsy/CompositeAndroid

Composition over inheritance for Android components like Activity or Fragment

---

**Dexer**: https://github.com/zjutkz/Dexer

一个轻量级的dex解析器

---

**kstools**: https://github.com/fourbrother/kstools

Android中自动爆破签名工具

---

**android-classyshark**: https://github.com/google/android-classyshark

apk 反编译工具

---

**EasySharedPreference**: https://github.com/kingfisherphuoc/EasySharedPreference

简单易用的可存储任意对象的 SharedPreference

---

**CipherSharedPrefs**: https://github.com/Ufkoku/CipherSharedPrefs

Android shared preferences 加解密

---

**secure-preferences**: https://github.com/HussainDerry/secure-preferences

Android shared preferences AES 加解密

---

**easyPrefs**: https://github.com/Xstar97/easyPrefs

easily use android preferences(the easy way!)

---

**preferator**: https://github.com/Sloy/preferator

开发辅助工具，帮助你快速的在 Android 端修改 SharedPreference，以达到测试的目的

---

**UniversalPreferences**: https://github.com/Zookey/UniversalPreferences

use Shared Preferences in an easy way

---

**tiamat**: https://github.com/hotchemi/tiamat

Reactive SharedPreferences code generator for Android

---

**EncryptedPreferences**: https://github.com/PDDStudio/EncryptedPreferences

SharedPreferences AES-256 加密

---

**Secured-Preference-Store**: https://github.com/iamMehedi/Secured-Preference-Store

SharedPreferences 加密

---

**Secured-Preference-Store**: https://github.com/iamMehedi/Secured-Preference-Store

Easy SharedPreference 封装库A SharedPreference wrapper for Android that encrypts the content with 256 bit AES encryption. The Encryption key is securely stored in device's KeyStore

---

**Android-Shared-Preferences-TinyDB-**: https://github.com/mukeshsolanki/Android-Shared-Preferences-TinyDB-

Easy SharedPreference 封装库

---

**esperandro**: https://github.com/dkunzler/esperandro

Easy SharedPreference Engine foR ANDROid http://dkunzler.github.io/esperandro

---

**AnyPref**: https://github.com/NashLegend/AnyPref

SharedPreferences实用工具类，可直接保存与读取实例对象，SharedPreferences中的ORM

---

**Prefs**: https://github.com/GrenderG/Prefs

Simple Android SharedPreferences wrapper

---

**TurboDex**: https://github.com/asLody/TurboDex

在Android瞬间加载Dex

---

**legend**: https://github.com/asLody/legend

A framework for hook java methods

---

**deviceinfo**: https://github.com/eyeem/deviceinfo

Easy info about Android device

---

**easydeviceinfo**: https://github.com/nisrulz/easydeviceinfo

Android library to get device information in a super easy way

<img src="https://lh3.googleusercontent.com/AP5TSBhKZPshN1XR_0ifvU6D0_sU7rL6GJb3Pn0Czlwp4EhwW69adKGh_8558_L_2A=h900-rw" width="320" />

---

**NavigationViewManager**: https://github.com/rubensousa/NavigationViewManager

A simple helper library to separate navigation logic from your MainActivity and reduce boilerplate

---

**ActivityRouter**: https://github.com/mzule/ActivityRouter

Router activities

<img src="https://raw.githubusercontent.com/mzule/ActivityRouter/master/gif/router.gif" width="320" /> <img src="https://raw.githubusercontent.com/mzule/ActivityRouter/master/gif/http.gif" width="320" />

---

**UIBlock**: https://github.com/tianzhijiexian/UIBlock

代替 fragment 的轻量级解耦UI的类，解决 fragment 嵌套问题

<img src="https://raw.githubusercontent.com/tianzhijiexian/UiBlock/master/images/demo02.png" width="480" /> <img src="https://raw.githubusercontent.com/tianzhijiexian/UiBlock/master/images/demo03.jpg" width="480" />

---

**PermissionManager**:https://github.com/karanchuri/PermissionManager

搜索清单权限并动态申请

<img src="https://github.com/karanchuri/PermissionManager/raw/master/demo.gif?raw=true" width="320" />

---

**PermissionGrantor**: https://github.com/dfqin/PermissionGrantor

一行代码搞定Android6.0动态权限授权

<img src="https://raw.githubusercontent.com/dfqin/PermissionGrantor/master/grant1.gif" width="270" /> <img src="https://raw.githubusercontent.com/dfqin/PermissionGrantor/master/grant2.gif" width="270" /> <img src="https://raw.githubusercontent.com/dfqin/PermissionGrantor/master/grant3.gif" width="270" />

---

**PermissionManager**: https://github.com/TheBrownArrow/PermissionManager

Permission Manager is easily manage Android Marshmallow and nougat runtime permissions

---

**PermissionsWrapper**: https://github.com/lolucosmin/PermissionsWrapper

PermissionsWrapper is the easiest way to manage Android Marshmallow and Nougat runtime permissions

---

**PermissionManager**: https://github.com/AdamMc331/PermissionsManager

PermissionsManager library that has base activity and fragment that extend from AppCompatActivity to ease with the handling of runtime permissions

---

**PermissionHelper**: https://github.com/pankaj89/PermissionHelper

PermissionHelper for Android M

---

**PermissionHelper**: https://github.com/nirav-tukadiya/PermissionHelper

6.0 运行时权限助手

---

**Simplify-Permissions**: https://github.com/anshulagarwal06/Simplify-Permissions

Framework to simplify android marshmallow permission support

---

**permissionHelper**: https://github.com/firetrap/permissionHelper

Android 6.0 Permission Helper

---

**Kotlin-Android-Permissions-DeviceInfo**: https://github.com/AnirudhLoya/Kotlin-Android-Permissions-DeviceInfo

Android 6.0权限管理 Kotlin way

<img src="https://raw.githubusercontent.com/AnirudhLoya/Kotlin-Android-Permissions-DeviceInfo/master/device-2016-09-24-183505.png" width="320" /> <img src="https://raw.githubusercontent.com/AnirudhLoya/Kotlin-Android-Permissions-DeviceInfo/master/call_permission.png" width="320" />

---

**Permissify**: https://github.com/holidaycheck/Permissify

Android 又一个6.0权限管理

<img src="https://raw.githubusercontent.com/holidaycheck/Permissify/master/art/sample_record.gif" width="290" />

---

**allowme**: https://github.com/aitorvs/allowme

Simple library to handle Android M permissions

---

**permissive**: https://github.com/jksiezni/permissive

A lightweight Android library for permissions handling at runtime

<img src="https://raw.githubusercontent.com/jksiezni/permissive/gh-pages/images/screenshots/educate_up_front.png" width="270" /> <img src="https://raw.githubusercontent.com/jksiezni/permissive/gh-pages/images/screenshots/educate_in_context.png" width="270" /> <img src="https://raw.githubusercontent.com/jksiezni/permissive/gh-pages/images/screenshots/ask_in_context.png" width="270" />

---

**FcPermissions**: https://github.com/lypeer/FcPermissions

6.0权限管理

<img src="https://camo.githubusercontent.com/b0d132cc990213eb71ac0139163ff5f60efd71d1/687474703a2f2f61632d636e797634376c612e636c6f7564646e2e636f6d2f646162313765333731343630313138372e676966" width="230" />

---

**PermissionDispatcher**: https://github.com/a1018875550/PermissionDispatcher

6.0权限管理，适配 miui 系统

---

**HeiPermission**: https://github.com/forJrking/HeiPermission

一句代码搞定 Android M 动态权限检测

---

**PrivilegedTask**: https://github.com/nillith/PrivilegedTask

An android runtime permissions utility simplifies the requesting and decoupling tasks from Activity and Fragment

---

**PermissionUtils**: https://github.com/rebus007/PermissionUtils

Check marshmallow permission easily https://rebus007.github.io/PermissionUtils/

---

**permissionHelper**: https://github.com/ayz4sci/permissionHelper

permissionHelper for Android M

---

**EasyPermissions**: https://github.com/lalosoft/EasyPermissions

A simple android library to request permissions in runtime

---

**EffortlessPermissions**: https://github.com/DreaminginCodeZH/EffortlessPermissions

An Android permission library extending Google's EasyPermissions with convenient additions.

---

**easypermissions**: https://github.com/googlesamples/easypermissions

Simplify Android M system permissions

---

**permissions-dispatcher-plugin**:https://github.com/shiraji/permissions-dispatcher-plugin

IntelliJ plugin for supporting PermissionsDispatcher

<img src="https://raw.githubusercontent.com/shiraji/permissions-dispatcher-plugin/master/website/images/pd.gif" width="600" />

---

**TedPermission**: https://github.com/ParkSangGwon/TedPermission

Easy check permission library for Android Marshmallow

<img src="https://raw.githubusercontent.com/ParkSangGwon/TedPermission/master/Screenshot.png" width="480" />

---

**App-Runtime-Permissions-Android**: https://github.com/mukeshsolanki/App-Runtime-Permissions-Android

Speed up your work with new Runtime Permissions introduced in Android M

<img src="https://camo.githubusercontent.com/6863a1cb3f7e3fb57a8f70d99e8bcc8d00b4f0bb/687474703a2f2f7069632e796f756d6f62696c652e6f72672f696d6763646e2f4170702d7065726d697373696f6e732d636f6d696e672d696e2d416e64726f69642d4d2e6a7067" width="300" />

---

**Dexter**: https://github.com/Karumi/Dexter

Android library that simplifies the process of requesting permissions at runtime. http://karumi.com

<img src="https://github.com/Karumi/Dexter/blob/master/art/sample.gif" width="320" />

---

**Ask**: https://github.com/00ec454/Ask

Android runtime permission make easy

<img src="https://github.com/00ec454/Ask/blob/master/asset/permission_1.png" width="320" /> <img src="https://github.com/00ec454/Ask/blob/master/asset/rationale.png" width="320" />

---

**AndroidPopWinPermission**: https://github.com/bunnyblue/AndroidPopWinPermission

Android SYSTEM_ALERT PERMISSION CHECK

---

**PermissionEverywhere**: https://github.com/kaknazaveshtakipishi/PermissionEverywhere

Library enables to request a permission from any Context(Service, IntentService, etc)

<img src="https://github.com/kaknazaveshtakipishi/PermissionEverywhere/blob/master/art/screenshot.png" width="320" />

---

**keytool-importkeypair**: https://github.com/getfatday/keytool-importkeypair

为已存在的签名文件添加系统权限签名，可直接编译运行

---

**apkReSign**: https://github.com/pengwei1024/apkReSign

安卓一键重签名工具

<img src="https://github.com/pengwei1024/apkReSign/blob/master/screenshots/screenshot01.png" width="320" />

---

**AndroidKeyboardWatcher**: https://github.com/AzimoLabs/AndroidKeyboardWatcher

Software keyboard open/close watcher for Android

<img src="https://raw.githubusercontent.com/AzimoLabs/AndroidKeyboardWatcher/master/art/keyboard_shown.png" width="320" />

---

**Treasure**: https://github.com/baoyongzhang/Treasure

Very easy to use wrapper library for Android SharePreferences

`Treasure`是一个Android平台上基于`SharePreferences`的偏好存储库，只需要定义接口，无需编写实现。运行时0反射，不仅使用方便而且性能和原生写法几乎无差别。

---

**Favor**: https://github.com/soarcn/Favor

A easy way to use android sharepreference http://cocosw.com/Favor/

---

**android-sql-logging**：https://github.com/explodes/android-sql-logging

App-local sql logging with viewer activity

<img src="https://camo.githubusercontent.com/9b5fc15a1484dddcf4d86b646b3896ea368926a6/687474703a2f2f692e696d6775722e636f6d2f746e65415541462e706e67" width="400" />

---

**Daffodil**：https://github.com/saymagic/Daffodil

基于注解的日志库

---

**ALog**：https://github.com/Blankj/ALog

一个精简、全面、方便的AndroidLog库--ALog

<img src="https://raw.githubusercontent.com/Blankj/ALog/master/img/detail.png" width="640" />

---

**EzyLogger**：https://github.com/afiqiqmal/EzyLogger

Simple Logger for Android

---

**FLogger**：https://github.com/cyfonly/FLogger

基于双缓冲队列、多刷盘机制的超轻量级 java 日志

---

**LogFilter**：https://github.com/smart-fun/LogFilter

Simple Android library which filters Logs, for example by keeping only ERROR LOGS in RELEASE MODE

---

**XLog**：https://github.com/Qiu800820/XLog

追踪上线BUG,自动保存,管理LOG,一键上传

---

**xLog**：https://github.com/elvishew/xLog

Android logger, simple and pretty, powerful and flexible, all you need is here

<img src="https://raw.githubusercontent.com/elvishew/XLog/master/images/classic_log.png" width="640" />

---

**debugkit**：https://github.com/hulab/debugkit

Android 浮动 Debug 工具箱，直接在浮动窗口执行 Android 测试功能

<img src="https://github.com/hulab/debugkit/raw/master/resources/screenshot.png" width="320" />

---

**DebugOverlay-Android**：https://github.com/Manabu-GT/DebugOverlay-Android

App 端，查看 Logcat 信息

<img src="https://raw.githubusercontent.com/Manabu-GT/DebugOverlay-Android/master/art/overlay_with_configurations.png" width="320" />

---

**LogcatTextView**：https://github.com/munix/LogcatTextView

帮助你在 App 端，查看 Logcat 输出信息

<img src="https://raw.githubusercontent.com/munix/LogcatTextView/master/screenshots/example.png" width="400" />

---

**Console**：https://github.com/jraska/Console

可在手机上查看 `logcat`

<img src="https://raw.githubusercontent.com/jraska/Console/master/images/sample_screen.png" width="400" />

---

**Lynx**：https://github.com/pedrovgs/Lynx

可在手机上查看 `logcat`

<img src="https://github.com/pedrovgs/Lynx/blob/master/art/screenshot_demo_1.gif" width="320" />

---

**LogcatViewer**: https://github.com/fatangare/LogcatViewer

可在手机上查看 `logcat`

<img src="https://github.com/fatangare/LogcatViewer/blob/master/Images/mainview.png" width="240" /> <img src="https://github.com/fatangare/LogcatViewer/blob/master/Images/filter.png" width="320" />

---

**jlog**: https://github.com/JiongBull/jlog

jlog是一款针对Android开发者的日志工具

<img src="https://camo.githubusercontent.com/753ce906b6ba7cff9d2d0c3e66c783139e934bfd/687474703a2f2f3778697a65382e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f6a6c6f675f73616d706c652e676966" width="640" />

---

**Android-PLog**: https://github.com/JumeiRdGroup/Android-PLog

A Pure, Pretty and Powerful logging library for android

<img src="https://github.com/JumeiRdGroup/Android-PLog/raw/master/ScreenShot.png" width="640" />

---

**Android-PLog**: https://github.com/Muyangmin/Android-PLog

Android 专用日志封装库，轻巧易用，高扩展性

<img src="https://raw.githubusercontent.com/Muyangmin/Android-PLog/master/ScreenShot.png" width="640" />

---

**KLog**: https://github.com/ZhaoKaiQiang/KLog

Android LogCat 工具类，支持行号、所在函数、点击自动跳转、Json格式自定解析打印等功能。

<img src="https://github.com/ZhaoKaiQiang/KLog/blob/master/image/demo.gif" width="640" />

---

**logger**: https://github.com/orhanobut/logger

Simple, pretty and powerful logger for android

<img src="https://github.com/orhanobut/logger/blob/master/images/custom-tag.png" width="480" />

---

**shelly**: https://github.com/jtribe/shelly

Fluent API for common **Intent** use-cases for Android

This library wraps Intents with a clean and simple to understand interface for a number of specific use-cases.

eg: Sharing some text and a url, the url is appended onto the text such that this shares "text with url http://www.jtribe.com.au":

```java
Shelly.share(context)
  .text("text with url")
  .url("http://www.jtribe.com.au")
  .send();
```

---

**LoganSquare**: https://github.com/bluelinelabs/LoganSquare

Screaming fast JSON parsing and serialization library for Android.

<img src="https://github.com/bluelinelabs/LoganSquare/blob/master/docs/benchmarks.jpg" width="640" />

---

**Cockroach**: https://github.com/android-notes/Cockroach

降低Android非必要crash

---

**SpiderMan**: https://github.com/simplepeng/SpiderMan

崩溃日志手机端显示 ，测试妹妹的最爱，开发哥哥的小棉袄

<img src="https://camo.githubusercontent.com/710f18aa8b5248c33100e74b03cd25c6f4743371/68747470733a2f2f73696d706c652d6275636b65742d313235373034343336352e636f732e61702d63686f6e6771696e672e6d7971636c6f75642e636f6d2f64656275672e676966" width="320" />

---

**Recovery**: https://github.com/Sunzxyong/Recovery

App 崩溃后，帮助你恢复现场并查看崩溃信息的库，在开发阶段相当实用，建议大家集成进去节省些开发时间

<img src="https://camo.githubusercontent.com/679c1c2da9b22e690b99de8c232408b52fcc8639/687474703a2f2f3778737778662e636f6d322e7a302e676c622e71696e697563646e2e636f6d2f626c6f672f5265636f766572792e706e67" width="640" />

---

**FireCrasher**: https://github.com/osama-raddad/FireCrasher

FireCrasher is a Uncaught Exceptions handler library for android

---

**CustomActivityOnCrash**: https://github.com/Ereza/CustomActivityOnCrash

Android library that allows launching a custom activity when your app crashes, instead of showing the hated "Unfortunately, X has stopped" dialog.

<img src="https://github.com/Ereza/CustomActivityOnCrash/blob/master/images/frontpage.png" width="640" />

---

**Sherlock**: https://github.com/ajitsing/Sherlock

异常捕获

<img src="https://github.com/ajitsing/ScreenShots/blob/master/sherlock/sherlock_demo.gif" width="320" />

---

**AutoCrashReporter**: https://github.com/devsideal/AutoCrashReporter

ACR is an android library to simplify crash detection while your app is under development, crash will be automatically detect by the library then app tester/user can easily send the crash report on one click to developer that will help him to fix the issue

<img src="https://raw.githubusercontent.com/devsideal/AutoCrashReporter/master/assets/acr_demo.gif" width="280" />

---

**android-easy-crash-handle**: https://github.com/Mauiie/android-easy-crash-handle

一个很容易使用的Android异常捕获、收集、提交的组件

---

**Bugtags-Android**: https://github.com/bugtags/Bugtags-Android

Simple and effective bug & crash reporting tool for Android apps http://bugtags.com/

<img src="https://github.com/bugtags/Bugtags-Android/blob/master/screenshot/usage.gif" width="320" />

---

**bee**: https://github.com/orhanobut/bee

Debug and QA tool for android

<img src="https://github.com/orhanobut/bee/blob/master/images/bee_settings.png" width="320" /> <img src="https://github.com/orhanobut/bee/blob/master/images/bee_info.png" width="320" />

---

**walle**: https://github.com/Meituan-Dianping/walle

Android Signature V2 Scheme签名下的新一代渠道包打包神器

---

**ApkMultiChannelPlugin**: https://github.com/nukc/ApkMultiChannelPlugin

Android 多渠道打包的 Android Studio / IDEA 插件

<img src="https://raw.githubusercontent.com/nukc/ApkMultiChannelPlugin/master/art/setting.png" width="320" />

---

**ApkChannelBuilder**: https://github.com/baoyongzhang/ApkChannelBuilder

一个 Mac App，用于 Apk 多渠道打包

<img src="https://raw.githubusercontent.com/baoyongzhang/ApkChannelBuilder/master/Screenshots/storyboard.png" width="480" />

---

**ApkCustomizationTool**: https://github.com/SSOOnline/ApkCustomizationTool

apk多渠道打包定制工具

<img src="https://raw.githubusercontent.com/SSOOnline/ApkCustomizationTool/master/screenshot/2.png" width="480" />

---

**LessCode**: https://github.com/openproject/LessCode

less code, more efficient for android

---

**JustWeTools**: https://github.com/lfkdsk/JustWeTools

Some useful tools

<img src="https://raw.githubusercontent.com/lfkdsk/JustWeTools/master/picture/markdown.png" width="320" /> <img src="https://raw.githubusercontent.com/lfkdsk/JustWeTools/master/picture/VerTextView.png" width="320" /> <img src="https://raw.githubusercontent.com/lfkdsk/JustWeTools/master/picture/gif.gif" width="480" /> <img src="https://raw.githubusercontent.com/lfkdsk/JustWeTools/master/picture/clock.png" width="240" /> 

--

**FileDownloader**: https://github.com/lingochamp/FileDownloader

Multitask、Breakpoint-resume、High-concurrency、Simple to use、Single-process

<img src="https://raw.githubusercontent.com/lingochamp/FileDownloader/master/art/serial_tasks_demo.gif" width="320" />

---

**freeline**: https://github.com/alibaba/freeline

阿里开源的Android平台上的秒级编译方案

---

**leakcanary**: https://github.com/square/leakcanary

A memory leak detection library for Android and Java.

<img src="https://github.com/square/leakcanary/blob/master/assets/screenshot.png" width="480" />

---

**AndroidPerformanceTools**: https://github.com/D-clock/AndroidPerformanceTools

检测ANR

---

**ANR-WatchDog**: https://github.com/SalomonBrys/ANR-WatchDog

ANR 卡顿检测

---

**BlockCanaryEx**: https://github.com/lqcandqq13/BlockCanaryEx

blockcanary 升级版

<img src="https://raw.githubusercontent.com/lqcandqq13/BlockCanaryEx/master/sample.png" width="320" />

---

**AndroidPerformanceMonitor**: https://github.com/markzhai/AndroidPerformanceMonitor

(blockcanary)安卓卡顿检测. http://blog.zhaiyifan.cn/2016/01/16/BlockCanaryTransparentPerformanceMonitor/

<img src="https://github.com/moduth/blockcanary/blob/master/art/shot1.png" width="320" />

---

**GT**: https://github.com/TencentOpen/GT

GT（随身调）是APP的`随身调试`平台，它是直接运行在手机上的“集成调试环境”(IDTE, Integrated Debug Environment)。

<img src="https://cloud.githubusercontent.com/assets/7868514/12535227/6b03940a-c2b7-11e5-91c7-c0c71d76295d.png" width="320" />

---

**moshi**: https://github.com/square/moshi

A modern JSON library for Android and Java.

---

**MarsDaemon**: https://github.com/Marswin/MarsDaemon

一个轻量级的库，配置几行代码，就可以实现在 android 上实现进程常驻，也就是在系统强杀下，以及 360 获取 root 权限下，clean master 获取 root 权限下都无法杀死进程

---

**AndroidBluetoothLibrary**: https://github.com/douglasjunior/AndroidBluetoothLibrary

AndroidBluetoothLibrary

---

**BluetoothHelper**: https://github.com/a-voyager/BluetoothHelper

Bluetooth Helper Library.—-蓝牙操作库

---

**Bleep**: https://github.com/tamir7/Bleep

Thin wrapper around the Android Bluetooth LE API

---

**AndroidDevMetrics**: https://github.com/frogermcs/AndroidDevMetrics

Performance metrics library for Android development (includes dagger2metrics)

<img src="https://raw.githubusercontent.com/frogermcs/androiddevmetrics/master/art/activities_metrics.png" width="480" />

---

**MAHAds**: https://github.com/hummatli/MAHAds

Library for advertisement own apps through your other apps

<img src="https://github.com/hummatli/MAHAds/blob/master/imgs/exit_dlg.png" width="200px"/> <img src="https://github.com/hummatli/MAHAds/blob/master/imgs/programs_dlg.png" width="200px"/>
---
