# AndroidLibs == 文本 Label

包含：各种文本相关的 `TextView`, `EditText`, pdf 文档， 自定义控件 ……

[<==返回首页==](https://github.com/XXApple/AndroidLibs)

---

**PhoneMask**: https://github.com/vacxe/PhoneMask

根据掩码友好的显示手机号码

---

**Android-WordToSpan**: https://github.com/bachors/Android-WordToSpan

TextView 上显示链接，@某人，标签等

<img src="https://camo.githubusercontent.com/7a6d4ab6371248bc1ae5e04e11204f05fe5182d5/687474703a2f2f692e67697068792e636f6d2f336f377169567a76347047416242614355552e676966" width="320"/>

---

**HTextView: https://github.com/hanks-zyh/HTextView

给文本加上动画

<img src="https://github.com/hanks-zyh/HTextView/blob/master/screenshot/demo3.gif" width="320"/>

---

**ProgressTextView**: https://github.com/JackDinealKIM/ProgressTextView

ProgressTextView

<img src="https://github.com/JackDinealKIM/ProgressTextView/raw/master/first.png" width="320"/>

---

**Android-Prefix-Input**: https://github.com/bachors/Android-Prefix-Input

Android-Prefix-Input

<img src="https://camo.githubusercontent.com/e2d965c9ea35a0b9b087d27411ec93434153661e/687474703a2f2f692e67697068792e636f6d2f6c34434430625642304b576c3550584c712e676966" width="320"/>

---

**RippleValidatorEditText**: https://github.com/omidheshmatinia/RippleValidatorEditText

RippleValidatorEditText

<img src="https://github.com/omidheshmatinia/RippleValidatorEditText/raw/master/sample/sample1.gif" width="320"/>

---

**ClickDrawableTextView**: https://github.com/matpag/ClickDrawableTextView

ClickDrawableTextView

<img src="https://camo.githubusercontent.com/69019c8c81299b0589652c35353a9fcf5d8559f1/68747470733a2f2f6d656469612e67697068792e636f6d2f6d656469612f785541376158716d70704c523761304a66472f67697068792e676966" width="320"/>

---

**GradientTextView**: https://github.com/livesun/GradientTextView

一个颜色逐渐改变的textview，类似歌词效果

<img src="https://cloud.githubusercontent.com/assets/27534854/26811851/e7ca915a-4aa6-11e7-993a-0f60f53132fa.gif" width="320"/>

---

**TagViewGroup**: https://github.com/shellljx/TagViewGroup

Android 仿小红书图片标签Group

<img src="https://camo.githubusercontent.com/5c7618004034e41b5eea5cca839d23ba3f11da59/687474703a2f2f37767a7066642e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f657a6769662e636f6d2d646339663232313539302e676966" width="320"/>

---

**CompoundIconTextView**: https://github.com/AAkira/CompoundIconTextView

支持矢量图展示的 TextView

<img src="https://github.com/AAkira/CompoundIconTextView/raw/master/arts/preview.png" width="320"/>

---

**HorizontalScrollSelectedView**: https://github.com/385841539/HorizontalScrollSelectedView

横向滚动的，可以支持大量文本选择的 自定义View ，一行代码 ， 简单易用 ， 无OOM情况

<img src="https://github.com/385841539/HorizontalScrollSelectedView/raw/master/horizontalselectedviewlibrary/src/main/res/drawable/xiaoguo2.gif" width="320"/>

---

**ParticleTextView**: https://github.com/Yasic/ParticleTextView

一个用粒子动画显示文字的 Android 自定义 View

<img src="https://github.com/Yasic/ParticleTextView/raw/master/Screenshot/Total.gif?raw=true" width="320"/>

---

**MaterialChipsInput**: https://github.com/pchmn/MaterialChipsInput

Implementation of Material Design Chips component for Android

<img src="https://raw.githubusercontent.com/pchmn/MaterialChipsInput/master/docs/demo2.gif" width="320"/>

---

**android-round-textview**: https://github.com/apg-mobile/android-round-textview

android-round-textview

<img src="https://raw.githubusercontent.com/apg-mobile/android-round-textview/master/preview.png" width="320"/>

---

**AdaptiveTableLayout**: https://github.com/Cleveroad/AdaptiveTableLayout

利用 TabLayout 实现的 CSV 文件加载和预览

<img src="https://raw.githubusercontent.com/Cleveroad/AdaptiveTableLayout/master/images/demo.gif" width="600"/>

---

**CharCountTextView**: https://github.com/xbroak/CharCountTextView

Twitter 风格 TextView 输入字数统计

<img src="https://camo.githubusercontent.com/b390d94864e09e4c888becbbd99c1ea43529873e/687474703a2f2f692e696d6775722e636f6d2f566770467766792e706e67" width="400"/> <img src="https://camo.githubusercontent.com/c34a91e575c0b34425bcaeb39f8bb94e7ee4af4f/687474703a2f2f692e696d6775722e636f6d2f41334e4b3477432e706e67" width="400"/>

---

**Text-Length-Bar**: https://github.com/minube/Text-Length-Bar

统计 TextView 输入字数

<img src="https://raw.githubusercontent.com/minube/Text-Length-Bar/master/art/text_length_bar.gif" width="320"/>

---

**SimpleNumberPicker**: https://github.com/StephaneBg/SimpleNumberPicker

A customisable decimal and hexadecimal material picker view for Android

<img src="https://raw.githubusercontent.com/StephaneBg/SimpleNumberPicker/master/artwork/decimal_picker.png" width="225"/> <img src="https://raw.githubusercontent.com/StephaneBg/SimpleNumberPicker/master/artwork/hexa_picker.png" width="225"/>

---

**TextCounter**: https://github.com/BullyBoo/TextCounter

TextCounter 动画

---

**HtmlCompat**: https://github.com/Pixplicity/HtmlCompat

让 Android HTML 类支持显示更多 Tag，极大的丰富了 TextView 可以展示的 Tag 类型

---

**QueryHighlighter**: https://github.com/cyrilmottier/QueryHighlighter

Android 查询高亮辅助组件

<img src="https://raw.githubusercontent.com/cyrilmottier/QueryHighlighter/master/art/query-highlighter.png" width="320"/>

---

**HorizontalPicker**: https://github.com/GoodieBag/HorizontalPicker

A HorizontalPicker view for android, which supports both text and icon

<img src="https://raw.githubusercontent.com/GoodieBag/HorizontalPicker/master/gif/HPtap.gif" width="270"/>

---

**tailor**: https://github.com/lovoo/tailor

EditText 一键清空

<img src="https://raw.githubusercontent.com/lovoo/tailor/master/tailor-demo.gif" width="320"/>

---

**MRichEditor**: https://github.com/Even201314/MRichEditor

Android 富文本（HTML）解析库，渲染的非常漂亮

<img src="https://github.com/Even201314/MRichEditor/raw/master/gif/Screenshot_2.gif" width="320"/> <img src="https://github.com/Even201314/MRichEditor/raw/master/gif/Screenshot_3.png" width="320"/>

---

**dante**: https://github.com/fourlastor/dante

Android 富文本（HTML）解析库，渲染的非常漂亮

<img src="https://raw.githubusercontent.com/fourlastor/dante/master/images/screencast.gif" width="320"/>

---

**stencil**: https://github.com/thoughtbot/stencil

Android library, written exclusively in kotlin, for animating the path created from text

<img src="https://camo.githubusercontent.com/41d6dc7159f7a925efee4007a9b4b2e69da8b1c2/68747470733a2f2f696d616765732e74686f75676874626f742e636f6d2f626c6f672d76656c6c756d2d696d6167652d75706c6f6164732f6a5a707677715552386d757968444954355353755f7374656e63696c2e676966" width="150"/>

---

**ValidationUtilsLibrary**: https://github.com/sgaikar1/ValidationUtilsLibrary

Android 表单校验功能

<img src="https://raw.githubusercontent.com/sgaikar1/ValidationUtilsLibrary/master/screen/ezgif.com-resize%20(1).gif" width="150"/>

---

**TagViewGroup**: https://github.com/shellljx/TagViewGroup

Android 仿小红书图片标签Group

<img src="https://camo.githubusercontent.com/5c7618004034e41b5eea5cca839d23ba3f11da59/687474703a2f2f37767a7066642e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f657a6769662e636f6d2d646339663232313539302e676966" width="300"/>

---

**FadingTextView**: https://github.com/rosenpin/FadingTextView

Android Textview Fading 动画效果

<img src="https://camo.githubusercontent.com/ce4876c7895bc08b7920d584f7809536b569299c/68747470733a2f2f6c68332e676f6f676c6575736572636f6e74656e742e636f6d2f56473545594374746d7330357a5246724f78526b38464c7a397433727652305169316458313271365043695f5a736c7258306c6165474145494731754e59466f754b52456e46724a354855534e726f6138474f5f4e354648704c73526c4477306f7444496f555f475250393039664641386c4e586f346d7775615a6b64756f6d654f553754654e49644439564d374332374879745651685a696766477872464939724444512d3266457837417041384c5f62716c496646343934664e66344473362d497148656974616b5a5333754679617a736b6968596d6d4a4a6377746f3270396b75556e706f7533625474454e4d6630345a6556334446743750696b59477542564231337a792d3054504a645f7731526b47783741533261634e69476f347867596b7350385042726d76385478576d3477584839754438324262654467737a6757427a4f4137314c6e54304268344f41576d386c6e3775515448475839634f686d317135375f4b526e52704c46694f525f614b566f614a624441796c7a6f667341584c51655369394a4d6568366971485741554a6357454a7351346a527335722d49447a59575a787a4e324e384f41686f4363564a615852315935486b705a467070736f3853384f4264574a7253394a3944463466694d4e774568692d71512d4c4269746a3876564e334776387855413565396352773444756632626f7154756d6850386a49356e39382d7270446d587632556f5a47424571536e394778785f6d30623846446d7043426a6c30346c4576636a32304b4d38544c52696a4c78656552664e66436f6374704b424f474c4a52516a386c4d71537a5651566b5031706779776552417248632d5f3272737567526954423552597631474e3958684e4d3075704c7352487648766271465a31714a4f523071414b6a6b747966766342637646754e397a6a59673d773830302d683233312d6e6f" width="400"/>

---

**text-decorator**: https://github.com/nntuyen/text-decorator

简单易用的TextView装饰库

<img src="https://raw.githubusercontent.com/nntuyen/text-decorator/master/screenshot/screenshot2.gif" width="320"/>

---

**LyricViewDemo**: https://github.com/zhengken/LyricViewDemo

歌词显示控件，支持多行显示、拖曳播放、自动识别歌词文件的编码 

<img src="https://raw.githubusercontent.com/zhengken/LyricViewDemo/master/screenshot/lyricview.png" width="640"/>

---

**html-builder**: https://github.com/jrummyapps/html-builder

Android HTML to TextView Builder 辅助工具库

<img src="https://raw.githubusercontent.com/jrummyapps/html-builder/master/art/screenshot.png" width="320"/>

---

**TextLayoutBuilder**: https://github.com/facebookincubator/TextLayoutBuilder

Facebook 开源文本布局库

---

**autofittextview**: https://github.com/mniami/autofittextview

Android Autofiting view content into the boundaries

---

**BufferTextInputLayout**: https://github.com/bufferapp/BufferTextInputLayout

MD 风格的 EditText，精致

<img src="https://raw.githubusercontent.com/bufferapp/BufferTextInputLayout/master/art/standard.gif" width="270"/> <img src="https://raw.githubusercontent.com/bufferapp/BufferTextInputLayout/master/art/descending.gif" width="270"/>

---

**AndroidDigitClassifier**: https://github.com/harjot-oberai/AndroidDigitClassifier

Android 手写体数字识别

<img src="https://raw.githubusercontent.com/harjot-oberai/AndroidDigitClassifier/master/screenshots/app_2.jpg" width="320"/> <img src="https://raw.githubusercontent.com/harjot-oberai/AndroidDigitClassifier/master/screenshots/app_3.jpg" width="320"/>

---

**Zaman**: https://github.com/Morxander/Zaman

The library provides a custom TextView and Helper for Android to convert timestamp to time String

<img src="https://raw.githubusercontent.com/Morxander/Zaman/master/screenshot.png" width="300"/>

---

**TagEditText**: https://github.com/limedroid/TagEditText

类似微博标签的文本控件

<img src="https://raw.githubusercontent.com/limedroid/TagEditText/master/art/tagedittext.png" width="320"/>

---

**NumberAnimTextView**: https://github.com/Bakumon/NumberAnimTextView

数字增加动画的 TextView

<img src="https://raw.githubusercontent.com/Bakumon/NumberAnimTextView/master/gif/GIF.gif" width="300"/>

---

**PinchZoomTextView**: https://github.com/androidessence/PinchZoomTextView

支持放大缩小的 TextView

<img src="https://raw.githubusercontent.com/androidessence/PinchZoomTextView/master/sample.gif" width="320"/>

---

**ExpandableTextView**: https://github.com/Chen-Sir/ExpandableTextView

支持展开的 TextView

<img src="https://raw.githubusercontent.com/Chen-Sir/ExpandableTextView/master/art/sample.gif" width="320"/>

---

**SRML**: https://github.com/jasonwyatt/SRML

String Resource Markup Language. Style your localized strings for Android

<img src="https://raw.githubusercontent.com/jasonwyatt/SRML/develop/docs/srml.gif" width="320"/>

---

**SimpleText**: https://github.com/jaychang0917/SimpleText

A simple spannable string helper

<img src="https://raw.githubusercontent.com/jaychang0917/SimpleText/master/SimpleText_v1_2_0.gif" width="320"/>

---

**GetWordTextView**: https://github.com/burgessjp/GetWordTextView

一个支持选词的 TextView，类似与单词 app 中点击单词翻译的效果

<img src="https://raw.githubusercontent.com/burgessjp/GetWordTextView/master/capture/capture.gif" width="320"/>

---

**TyperEditText**: https://github.com/andyxialm/TyperEditText

Android 仿业问 打字机效果

<img src="https://raw.githubusercontent.com/andyxialm/TyperEditText/master/art/screenshot.gif" width="265"/>

---

**TextHighlighter**: https://github.com/akshay-naik/TextHighlighter

TextHighlighter is a simple android API for developers to show highlighted and styled text in android apps

<img src="https://raw.githubusercontent.com/akshay-naik/TextHighlighter/master/screenshot.png" width="270"/>

---

**SuperTextView**: https://github.com/lygttpod/SuperTextView

一个功能强大的TextView，可以满足日常大部分布局方式

<img src="https://raw.githubusercontent.com/lygttpod/SuperTextView/master/screenshot.png" width="320"/>

---

**BigBang**: https://github.com/baoyongzhang/BigBang

模仿 Smartisan OS 的 BigBang 功能

<img src="https://raw.githubusercontent.com/baoyongzhang/BigBang/master/design/bigbang_demo.gif" width="320"/>

---

**AutoFillEmailEditText**: https://github.com/wangshaolei/AutoFillEmailEditText

自定义 自动补充 email 的 EditText

<img src="https://raw.githubusercontent.com/wangshaolei/AutoFillEmailEditText/master/img/1.png" width="320"/>

---

**AnFQNumEditText**: https://github.com/FTandJYQ/AnFQNumEditText

自定义EditText实现右下角计数控件

<img src="https://camo.githubusercontent.com/07d924eb9645dc9a7485992707b08bf4e5f27fe5/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f323037313736342d376265333762653437323531623764342e676966" width="320"/>

---

**linkable-text-android**: https://github.com/fobid/linkable-text-android

Clickable @mentions, #hashtags and links

---

**Better-Link-Movement-Method**: https://github.com/Saketme/Better-Link-Movement-Method

TextViews 中处理超链接

<img src="https://raw.githubusercontent.com/Saketme/Better-Link-Movement-Method/master/EXAMPLE.gif" width="640"/>

---

**MentionEditText**: https://github.com/luckyandyzhang/MentionEditText

支持 at 别人效果的 EditText

<img src="https://raw.githubusercontent.com/luckyandyzhang/MentionEditText/master/art/demo.gif" width="320"/>

---

**PercentBarView**: https://github.com/aykuttasil/PercentBarView

百分比显示

<img src="https://cloud.githubusercontent.com/assets/3179872/18619207/44e432da-7dff-11e6-8988-91d1faf4eed0.gif" width="320"/>

---

**Material-UpVote**: https://github.com/hiteshsahu/Material-UpVote

Material Design 风格的投票效果

<img src="https://raw.githubusercontent.com/hiteshsahu/Material-UpVote/master/Art/demo_upvote.gif" width="320"/>

---

**colortextview**: https://github.com/apocalx/colortextview

Colors for TextViews

<img src="https://raw.githubusercontent.com/apocalx/colortextview/master/screenshot.png" width="320"/>

---

**AutoFormatEditText**: https://github.com/aldoKelvianto/AutoFormatEditText

数字自动添加分割 EditText

<img src="https://camo.githubusercontent.com/df9757767f491bed46b18bb6f2575ccf4f09f950/687474703a2f2f696d672e796f75747562652e636f6d2f76692f384566373955717748666b2f302e6a7067" width="480"/>

---

**AutoTypingTextView**: https://github.com/krsticdragan/AutoTypingTextView

带动画、加密、解密 EditText

<img src="https://camo.githubusercontent.com/e075cf282998a371e6c988adc055b3b2a06a6a9a/687474703a2f2f7777772e64726167616e6b72737469632e636f6d2f6175746f7479706574657874766965772f616c6c616e696d6174696f6e2e676966" width="320"/>

---

**EllipsizeTextView**: https://github.com/dinuscxj/EllipsizeTextView

可显示省略号的 EditText

<img src="https://raw.githubusercontent.com/dinuscxj/EllipsizeTextView/master/Preview/EllipsizeTextView.gif?width=300" width="320"/>

---

**HintAnim-EditText**: https://github.com/cctanfujun/HintAnim-EditText

提示可变化的 EditText

<img src="https://raw.githubusercontent.com/cctanfujun/HintAnim-EditText/master/img/Hint-Anim.gif" width="320"/>

---

**SmsVerifyCatcher**: https://github.com/stfalcon-studio/SmsVerifyCatcher

获取短信验证码

<img src="https://camo.githubusercontent.com/64fdbaf413bcb5dc688e6112fee2353535008870/687474703a2f2f692e696d6775722e636f6d2f374b7a7a6b357a2e676966" width="320"/>

---

**SmsCodeHelper**: https://github.com/RikkaW/SmsCodeHelper

识别短信中的验证码并复制

<img src="https://raw.githubusercontent.com/RikkaW/SmsCodeHelper/master/app/src/main/res/mipmap-xxxhdpi/ic_launcher.png" width="180"/>

---

**XRichText**: https://github.com/limedroid/XRichText

显示富文本的TextView

<img src="https://github.com/limedroid/XRichText/raw/master/art/xrichtext.gif" width="320"/>

---

**richeditor-android**: https://github.com/wasabeef/richeditor-android

目前来看 Android 上最棒的一款富文本编辑器

<img src="https://raw.githubusercontent.com/wasabeef/richeditor-android/master/art/demo2.gif" width="270"/>

---

**medium-textview**: https://github.com/angebagui/medium-textview

仿 medium 富文本展示

<img src="https://raw.githubusercontent.com/angebagui/medium-textview/master/screenshot/Screenshot_2016-08-14-19-59-48.png" width="200"/>

---

**RoublePriceView**: https://github.com/VyacheslavShmakin/RoublePriceView

represent any prices in Russian rouble currency

---

**amber**: https://github.com/hanuor/amber

识别文本中的特定名词

---

**FormattEditText**: https://github.com/PaXLiCh/FormattEditText

支持自动格式化的 EditText，比如货币、电话号码等等

---

**android-EmojiCompat**: https://github.com/googlesamples/android-EmojiCompat

Android Emoji 兼容包，彻底解决 Android Emoji 不一致问题

<img src="https://github.com/googlesamples/android-EmojiCompat/raw/master/screenshots/1-main.png" width="270" />

---

**emojiconize**: https://github.com/rockerhieu/emojiconize

一行代码渲染 emoji

<img src="https://raw.githubusercontent.com/rockerhieu/emojiconize/master/assets/sample.jpg" width="640" />

---

**EmojiEverywhere**: https://github.com/chathudan/EmojiEverywhere

Emoji in TextView, EditText for Android (like Android KitKat Emoji Keyboard)

<img src="https://raw.githubusercontent.com/chathudan/EmojiEverywhere/master/EmojiEverywhereAndroid.png" width="320" />

---

**Emojix**: https://github.com/nekocode/Emojix

One line of code to implement emoji to your whole android application

<img src="https://raw.githubusercontent.com/nekocode/Emojix/master/art/preview.png" width="400" />

---

**RoundedCornersBackgroundSpan**: https://github.com/Iojjj/RoundedCornersBackgroundSpan

Implementation of LineBackgroundSpan that adds rounded rectangle backgrounds to text

<img src="https://raw.githubusercontent.com/Iojjj/RoundedCornersBackgroundSpan/master/images/demo.png" width="320" />

---

**ticker**: https://github.com/robinhood/ticker

滚动效果 TextView

<img src="https://raw.githubusercontent.com/robinhood/ticker/master/assets/ticker_main.gif" width="350" />

---

**LongTextView**: https://github.com/metalurgus/LongTextView

Very long text support for Android

---

**StickTextView**: https://github.com/hanbaokun/StickTextView

图片文字贴纸功能

<img src="https://raw.githubusercontent.com/hanbaokun/StickTextView/master/Screenshot_2016-06-20.png" width="320" />

---

**Stepper-Touch**: https://github.com/DanielMartinus/Stepper-Touch

一款萌萌的计数器组件

<img src="https://raw.githubusercontent.com/DanielMartinus/Stepper-Touch/master/media/demo.gif" width="320" />

---

**BadgeHolderView**: https://github.com/steelkiwi/BadgeHolderView

购物车

<img src="https://github.com/steelkiwi/BadgeHolderView/raw/master/assets/animation.gif" width="320" />

---

**AnimShopButton**: https://github.com/mcxtzhang/AnimShopButton

一个带伸缩位移旋转动画的购物车按钮

<img src="https://raw.githubusercontent.com/mcxtzhang/AnimShopButton/master/gif/new.gif" width="320" /> <img src="https://raw.githubusercontent.com/mcxtzhang/AnimShopButton/master/gif/testAttr.gif" width="320" />

---

**ElemeShoppingView**: https://github.com/JeasonWong/ElemeShoppingView

仿饿了么点击购物效果

<img src="https://camo.githubusercontent.com/bcf966b31e9d2cb16ad81341fed16627dc2f30e9/687474703a2f2f69322e7069696d672e636f6d2f313037302f303232353766393331366262646362362e676966" width="300" />

---

**IncrementProductView**: https://github.com/steelkiwi/IncrementProductView

有趣的购物车按钮

<img src="https://github.com/steelkiwi/IncrementProductView/raw/master/assets/animation.gif" width="320" />

---

**ElegantNumberButton**: https://github.com/ashik94vc/ElegantNumberButton

Brought to you by cepheuen http://www.cepheuen.com

<img src="https://raw.githubusercontent.com/ashik94vc/ElegantNumberButton/master/screens/screen01.gif" width="320" />

---

**android-textoverlay**: https://github.com/saschpe/android-textoverlay

Provides a simple service that allows to display arbitrary text as a system-window overlay

<img src="https://raw.githubusercontent.com/saschpe/android-textoverlay/master/doc/img/default.png" width="320" /> <img src="https://raw.githubusercontent.com/saschpe/android-textoverlay/master/doc/img/updated.png" width="320" />

---

**BankCardFormat**: https://github.com/smuyyh/BankCardFormat

自动格式化银行卡号的EditText，每四位增加一个空格，并根据银行卡号判断该银行卡归属的银行及卡别

<img src="https://raw.githubusercontent.com/smuyyh/BankCardFormat/master/screenshot/device.png" width="320" />

---

**MoneyTextView**: https://github.com/fabiomsr/MoneyTextView

A simple Android TextView to display amounts of money in different formats

<img src="https://raw.githubusercontent.com/fabiomsr/MoneyTextView/develop/art/screenshot1.png" width="320" /> <img src="https://raw.githubusercontent.com/fabiomsr/MoneyTextView/develop/art/screenshot2.png" width="320" />

---

**etiyabadgetab**: https://github.com/egemenmede/etiyabadgetab

Badge 徽章

<img src="https://camo.githubusercontent.com/75d8641010dca7f47d0726a288f5381c57844406/687474703a2f2f7777772e64656c6970656e6775656e2e636f6d2f77702d636f6e74656e742f75706c6f6164732f323031372f30332f62616467655f73616d706c652e706e67" width="480" />

---

**MaterialBadgeTextView**: https://github.com/matrixxun/MaterialBadgeTextView

Badge 风格的 TextView，支持 Shadow 和 Elevation

<img src="https://raw.githubusercontent.com/matrixxun/MaterialBadgeTextView/master/MaterialBadgeTextView/art/device-2016-11-17-171018.png" width="320" />

---

**BadgeView**: https://github.com/qstumn/BadgeView

一个可以自由定制外观、支持拖拽消除的MaterialDesign风格Android BadgeView

<img src="https://raw.githubusercontent.com/qstumn/BadgeView/master/demo_gif.gif" width="320" />

---

**BadgeView**: https://github.com/AlexLiuSheng/BadgeView

a BadeView base on android

<img src="https://raw.githubusercontent.com/AlexLiuSheng/BadgeView/master/library/gif.png" width="320" />

---

**badgebutton**: https://github.com/czy1121/badgebutton

带有徽标(数字，小红点)的按钮

<img src="https://raw.githubusercontent.com/czy1121/badgebutton/master/screenshot.png" width="640" />

---

**ShortcutBadger**: https://github.com/leolin310148/ShortcutBadger

为你的应用程序加上数字角标

<img src="https://camo.githubusercontent.com/8d6b5fc29b1c73689def6598b144a70bf3a0c2eb/68747470733a2f2f7261772e6769746875622e636f6d2f6c656f6c696e3331303134382f53686f72746375744261646765722f6d61737465722f73637265656e73686f74732f73735f617375732e706e67" width="120" />

---

**AvatarLabelView**: https://github.com/yanbober/AvatarLabelView

一个可配置的迷你版轻量级 Label 辅助类，支持多种配置效果

<img src="https://raw.githubusercontent.com/yanbober/AvatarLabelView/master/.picture/demo.png" width="320" />

---

**cornerlabelview**: https://github.com/czy1121/cornerlabelview

Android 角标组件效果

<img src="https://raw.githubusercontent.com/czy1121/cornerlabelview/master/screenshot_corner_label_view.png" width="320" />

---

**SlantedTextView**: https://github.com/HeZaiJin/SlantedTextView

倾斜的 TextView，可做标签

<img src="https://raw.githubusercontent.com/HeZaiJin/SlantedTextView/master/screen_shot/screenshot.png" width="320" />

---

**labelview**: https://github.com/linger1216/labelview

Sometimes, we need to show a label above an ImageView or any other views. Well, LabelView will be able to help you

<img src="https://github.com/linger1216/labelview/blob/master/img/img1.png" width="320" />

---

**MaterialTextField**: https://github.com/florent37/MaterialTextField

好看的 Floating EditText

<img src="https://camo.githubusercontent.com/d5eb5d6991d4bde93d8ac0e0c958e3ce66c75082/687474703a2f2f692e67697068792e636f6d2f6c34316c566b4130596b615a574e5430492e676966" width="320" />

---

**elegant-underline**: https://github.com/romainguy/elegant-underline

精美文本下划线

<img src="https://raw.githubusercontent.com/romainguy/elegant-underline/master/art/elegant-underline.png" width="320" />

---

**AndroidEdit**: https://github.com/qinci/AndroidEdit

可撤销、恢复的 EditText

<img src="https://raw.githubusercontent.com/qinci/AndroidEdit/master/image/image.gif" width="270" />

---

**MarkdownView**: https://github.com/tiagohm/MarkdownView

Makrdown 显示 

<img src="https://raw.githubusercontent.com/tiagohm/MarkdownView/master/3.png" width="270" /> <img src="https://raw.githubusercontent.com/tiagohm/MarkdownView/master/4.png" width="270" /> <img src="https://raw.githubusercontent.com/tiagohm/MarkdownView/master/5.png" width="270" />

---

**MarkdownIME**: https://github.com/laobubu/MarkdownIME

实时预览的线上 Makrdown 编辑器

<img src="https://camo.githubusercontent.com/1b03ccd2c170b030d4b61753203b3df8e9f94989/687474703a2f2f6c616f627562752e6769746875622e696f2f4d61726b646f776e494d452f64656d6f2e6769663f636163686533" width="400" />

---

**MarkdownView**: https://github.com/fiskurgit/MarkdownView

Display Markdown in your apps, useful for FAQs, Help, Size Guides, About screens etc

<img src="https://raw.githubusercontent.com/fiskurgit/MarkdownView/master/Screenshot.png" width="800" />

---

**MarkdownView-Android**: https://github.com/mukeshsolanki/MarkdownView-Android

MarkdownView is an Android webview with the capability of loading Markdown text or file and display it as HTML, it extends Android webview

<img src="https://raw.githubusercontent.com/mukeshsolanki/MarkdownView-Android/master/Screenshots/demo.gif" width="270" />

---

**Markdown**: https://github.com/zzhoujay/Markdown

Android平台下的原生Markdown解析器

<img src="https://raw.githubusercontent.com/zzhoujay/Markdown/master/image/img1.jpg" width="320" />

---

**MarkedView-for-Android**: https://github.com/mittsuu/MarkedView-for-Android

markdown text viewer

<img src="https://raw.githubusercontent.com/mittsuu/MarkedView-for-Android/master/sample-sc.gif" width="320" />

---

**SlickForm**: https://github.com/AlburIvan/SlickForm

SlickForm is an Android library that let you define a custom array of EditTexts with the purpose of handling a form in a cool animated way

<img src="https://raw.githubusercontent.com/AlburIvan/SlickForm/master/slick_form_demo.gif" width="320" />

---

**WhatsappFormatter**: https://github.com/cooltechworks/WhatsappFormatter

Simple formatting options for TextView and EditText in the same way Whatsapp provides

<img src="https://raw.githubusercontent.com/cooltechworks/WhatsappFormatter/master/screenshot/whatsappformattingdemo.gif" width="320" />

---

**KeyboardNumber**: https://github.com/policante/KeyboardNumber

KeyboardNumber

<img src="https://raw.githubusercontent.com/policante/KeyboardNumber/master/resource/dialog1.png" width="320" /> <img src="https://raw.githubusercontent.com/policante/KeyboardNumber/master/resource/dialog4.png" width="320" />

---

**NumberKeyboard**: https://github.com/wangshaolei/NumberKeyboard

仿美团和糯米商家验证版的一个数字校验键盘

<img src="https://raw.githubusercontent.com/wangshaolei/NumberKeyboard/master/img/1.png" width="320" />

---

**AdvancedTextSwitcher**: https://github.com/SumiMakito/AdvancedTextSwitcher

仿照Google+在卡片上滚动显示最新评论的TextSwitcher

<img src="https://raw.githubusercontent.com/SumiMakito/AdvancedTextSwitcher/master/art/snapshot.gif" width="480" />

---

**MarkupAndroid**: https://github.com/shree-vastava/MarkupAndroid

文本高亮

---

**codeview-android**: https://github.com/Softwee/codeview-android

代码格式高亮 in native way

<img src="https://camo.githubusercontent.com/b4924dc4d61df4ae4716aa65bff1329bd170f4d5/68747470733a2f2f7331302e706f7374696d672e6f72672f636b7a7639786d6d312f436f64655f566965775f416e64726f69645f53637265656e73686f742e706e67" width="320" />

---

**Codeview**: https://github.com/tiagohm/CodeView

代码格式高亮

<img src="https://raw.githubusercontent.com/tiagohm/CodeView/master/1.png" width="320" /> <img src="https://raw.githubusercontent.com/tiagohm/CodeView/master/3.png" width="320" />

---

**Codeview**: https://github.com/avraampiperidis/Codeview

代码格式高亮 in webview

<img src="https://raw.githubusercontent.com/avraampiperidis/Codeview/master/readmepics/pic2.png" width="320" /> <img src="https://raw.githubusercontent.com/avraampiperidis/Codeview/master/readmepics/pic3.png" width="320" />

---

**highlightjs-android**: https://github.com/PDDStudio/highlightjs-android

代码格式高亮

<img src="https://raw.githubusercontent.com/PDDStudio/highlightjs-android/master/gfx/demo.png" width="800" />

---

**SyntaxView**: https://github.com/fiskurgit/SyntaxView

代码格式着色

<img src="https://raw.githubusercontent.com/fiskurgit/SyntaxView/master/screenshot.png" width="800" />

---

**ChipCloud**: https://github.com/fiskurgit/ChipCloud

尺码标签

<img src="https://raw.githubusercontent.com/fiskurgit/ChipCloud/master/images/trainer_sizes.png" width="800" />

---

**Hash-Tags-Android**: https://github.com/rameshvoltella/Hash-Tags-Android

含可点击的标签 TextView

<img src="https://raw.githubusercontent.com/rameshvoltella/Hash-Tags-Android/master/Screenshot_2014-07-23-20-41-05.png" width="270" /> <img src="https://raw.githubusercontent.com/rameshvoltella/Hash-Tags-Android/master/Screenshot_2014-07-23-20-41-27.png" width="270" /> <img src="https://raw.githubusercontent.com/rameshvoltella/Hash-Tags-Android/master/Screenshot_2014-07-23-23-06-04.png" width="270" />

---

**Lettrine**: https://github.com/rpradal/Lettrine

首字母大写的 TextView

| <img style="float: center;" src="http://i.imgur.com/ivgH1gZ.jpg" width="400">  | <img style="float: right;" src="http://i.imgur.com/hHVzvXR.jpg" width="400">  | <img style="float: right;" src="http://i.imgur.com/6RL4AeR.jpg" width="400">  | <img style="float: right;" src="http://i.imgur.com/3MsIm3t.jpg" width="400">  | <img style="float: right;" src="http://i.imgur.com/VuaW6pA.jpg" width="400">  |
|:-------:|:------:|:------:|:------:|:------:|
| Lettrine with a three lines height | Lettrine with a two lines height | Font customization | Html balisis inclusion | Custom text color |

---

**wATL**: https://github.com/suwhs/wATL

换行自动添加后缀 “-” 的 TextView

<img src="https://camo.githubusercontent.com/94927da9d104e30f2d55260b22b256ce7f2f5ab0/687474703a2f2f696d672e796f75747562652e636f6d2f76692f756933484c6b454b3954302f302e6a7067" width="480" />

---

**PinEntryEditText**: https://github.com/alphamu/PinEntryEditText

带动画的类似 PIN 的 EditText

<img src="https://camo.githubusercontent.com/7a8eedea25a992c1a0192eb179ad4feeeebf57fa/687474703a2f2f692e67697068792e636f6d2f336f3771445641705354466c3844435534452e676966" width="240" />

---

**AnimatedEditText**: https://github.com/alphamu/AnimatedEditText

有输入动画的 EditText

<img src="https://camo.githubusercontent.com/004e3593da1a874dab3c0e9ea95c01217b7dad06/687474703a2f2f692e67697068792e636f6d2f783141735a4a79705436726d772e676966" width="210" />

---

**android-ago**: https://github.com/curioustechizen/android-ago

自动刷新时间的 TextView

<img src="https://raw.githubusercontent.com/curioustechizen/android-ago/master/screenshots/android-ago-sample-screenshot.png" width="270" />

---

**countingtextview**: https://github.com/uguratar/countingtextview

带动画的计数 TextView

<img src="https://camo.githubusercontent.com/30a57e0df2f29e4b3dd8172dff5bbdbee877eefc/687474703a2f2f692e696d6775722e636f6d2f6e6f58774b47372e676966" width="270" />

---

**BubbleView**: https://github.com/cpiz/BubbleView

BubbleView是带箭头的气泡控件/容器类，支持在布局中通过自定义属性或代码进行丰富的定制，包括箭头朝向、箭头位置、气泡弧角、边线颜色、边线粗细、颜色填充、填充Padding等等

<img src="https://raw.githubusercontent.com/cpiz/BubbleLayout/master/screenshots/2.png" width="400" /> <img src="https://raw.githubusercontent.com/cpiz/BubbleLayout/master/screenshots/3.png" width="400" />

---

**KerningViews**: https://github.com/aritraroy/KerningViews

可设置字符间距的 TextView

<img src="https://raw.githubusercontent.com/aritraroy/KerningViews/master/images/screenshot.png" width="270" />

---

**JumpingBeans**:  https://github.com/frakbot/JumpingBeans

 A Span-based library to make your text jump like Mexican beans. Oh, and the "..."s in Hangouts.

<img src="https://github.com/frakbot/JumpingBeans/blob/master/art/jumpingdots.gif" width="320" />
<img src="https://github.com/frakbot/JumpingBeans/blob/master/art/jumpingword.gif" width="320" />

---

**RotatingText**: https://github.com/sdsmdg/RotatingText

记分牌效果的单词轮换

<img src="https://github.com/sdsmdg/RotatingText/raw/master/screens/gif_example_3.gif" width="400" />

---

**MarqueeViewLibrary**: https://github.com/gongwen/MarqueeViewLibrary

一个帮您快速实现跑马灯效果的library

<img src="https://raw.githubusercontent.com/gongwen/MarqueeViewLibrary/master/screenshot/screen_shot.gif" width="300" />

---

**MarqueeViewDemo**: https://github.com/gongwen/MarqueeViewDemo

为跑马灯效果而写的View

<img src="https://raw.githubusercontent.com/gongwen/MarqueeViewDemo/master/screenshot/screen_shot.gif" width="300" />

---

**noticeview**: https://github.com/czy1121/noticeview

滚动播放的公告控件

<img src="https://raw.githubusercontent.com/czy1121/noticeview/master/screenshot.png" width="320" />

---

**MarqueeView**: https://github.com/sfsheng0322/MarqueeView

垂直跑马灯 —— 垂直翻页公告

<img src="https://raw.githubusercontent.com/sfsheng0322/MarqueeView/master/screenshot/MarqueeView_Gif.gif" width="320" />

---

**Android-Lib-VerticalMarqueeTextView**: https://github.com/ayltai/Android-Lib-VerticalMarqueeTextView

竖向跑马灯效果

<img src="https://raw.github.com/ayltai/Android-Lib-VerticalMarqueeTextView/master/screenshots/device-2014-02-22-000150.png" width="270" height="400" alt="Screenshot-1" />&nbsp;
<img src="https://raw.github.com/ayltai/Android-Lib-VerticalMarqueeTextView/master/screenshots/device-2014-02-22-000158.png" width="270" height="400" alt="Screenshot-2" />&nbsp;
<img src="https://raw.github.com/ayltai/Android-Lib-VerticalMarqueeTextView/master/screenshots/device-2014-02-22-000208.png" width="270" height="400" alt="Screenshot-3" />

---

**mask-edittext**: https://github.com/santalu/mask-edittext

支持格式自动识别和展示的 EditBox

<img src="https://github.com/santalu/mask-edittext/raw/master/screens/sample.png" width="320" />

---

**input-mask-android**: https://github.com/RedMadRobot/input-mask-android

给用户输入自动加上特定格式

<img src="https://raw.githubusercontent.com/RedMadRobot/input-mask-android/assets/assets/gif-animations/direct-input.gif" width="320" />

---

**MaskedEditText**: https://github.com/VicMikhailau/MaskedEditText

包含隐藏文本的 EditText，可快速输入电话，网址等文本

<img src="https://raw.githubusercontent.com/VicMikhailau/MaskedEditText/master/resources/masked_edit_text.gif" width="320" />

---

**android-edittextpassword**: https://github.com/pucamafra/android-edittextpassword

密码的显示隐藏

<img src="https://raw.githubusercontent.com/pucamafra/android-edittextpassword/master/screenshots/sample.png" width="320" />

---

**MultiFontView-Android**: https://github.com/shashkiranr/MultiFontView-Android

Multifont library can be used to select custom fonts for the view dynamically in your XML

<img src="https://github.com/shashkiranr/MultiFontView-Android/raw/master/Screenshot.png?raw=true" width="320" />

---

**CustomFontView**: https://github.com/anitaa1990/CustomFontView

CustomFontView

<img src="https://user-images.githubusercontent.com/22608780/29374593-9d9f71d4-82cf-11e7-915d-dcead8093d40.png" width="320" />

---

**fonttools**: https://github.com/fonttools/fonttools

A library to manipulate font files from Python

---

**android-DownloadableFonts**: https://github.com/googlesamples/android-DownloadableFonts

This sample demonstrates how to use the Downloadable Fonts feature introduced in Android O

<img src="https://github.com/googlesamples/android-DownloadableFonts/raw/master/screenshots/screenshot-1.png" width="300" />

---

**Fonty**: https://github.com/MarcinOrlowski/Fonty

Android library allowing you to easily change the typeface of your UI elements

<img src="https://raw.githubusercontent.com/MarcinOrlowski/Fonty/master/img/shot.png" width="360" />

---

**CustomTypeface**: https://github.com/TheBrownArrow/CustomTypeface

Custom-Typeface is a library to add custom fonts in android

<img src="https://raw.githubusercontent.com/thebrownarrow/CustomTypeface/master/screenshot.png" width="320" />

---

**FontZip**: https://github.com/forJrking/FontZip

字体资源文件压缩神器

---

**EasyFont**: https://github.com/natiginfo/EasyFont

Android Library to set font of TextView, Button, EditText, and RadioButton in XML without editing Java code to set Typeface

<img src="https://github.com/natiginfo/EasyFont/blob/master/screenshots/screenshot1.png" width="270" />

---

**EasyFont**: https://github.com/vishal259/EasyFont

Easy Font for Android is a Library which makes it easy to use Custom Fonts in Android Application

---

**AACustomFont**: https://github.com/EngrAhsanAli/AACustomFont

AACustomFont is a lightweight custom font binder in XML directly in TextView, Button, EditText, RadioButton, CheckBox tags

<img src="https://github.com/EngrAhsanAli/AACustomFont/raw/master/Screenshots/demo.png" width="270" />

---

**ontometricsLibrary**: https://github.com/Ishmeetsingh97/FontometricsLibrary

更方便的调整 Android 中的字体，这个库自带了一些第三方英文字体

<img src="https://raw.githubusercontent.com/Ishmeetsingh97/FontometricsLibrary/master/FontometricsArtwork.jpg" width="640" />

---

**SmartFonts**: https://github.com/smart-fun/SmartFonts

Smart Fonts for Android is a Library which makes it easy to use Custom Fonts in Apps

<img src="https://raw.githubusercontent.com/smart-fun/SmartFonts/master/app/extras/editor_screenshot.png" width="320" />

---

**AndroidFontsManager**: https://github.com/GcsSloop/AndroidFontsManager

字体管理器，方便快速的为应用内所有组件更换字体。

<img src="https://github.com/GcsSloop/AndroidFontsManager/blob/master/Pic/fontsmanagerdemo.gif" width="320" />

---

**font-utils**: https://github.com/mattsilber/font-utils

A library to help with custom fonts and text sizes

---

**FontBinder**: https://github.com/nitrico/FontBinder

布局里自定义字体，配合 databinding

---

**fontbinding**: https://github.com/lisawray/fontbinding

给布局自定义字体，配合 databinding

<img src="https://raw.githubusercontent.com/lisawray/fontbinding/master/screenshot_land.png" width="640" />

---

**CustomFontLib**: https://github.com/daniribalbert/CustomFontLib

给布局自定义字体

<img src="https://raw.githubusercontent.com/daniribalbert/CustomFontLib/master/website/static/screenshot.png" width="320" />

---

**Calligraphy**: https://github.com/chrisjenx/Calligraphy

简单的自定义文本字体

<img src="https://raw.githubusercontent.com/chrisjenx/Calligraphy/master/screenshot.png" width="320" />

---

**HRichEditor**: https://github.com/huangdali/HRichEditor

Android端富文本编辑器HEichEditor

<img src="https://github.com/huangdali/HRichEditor/raw/master/images/changitem.gif" width="320" />

---

**ScrollNumber**: https://github.com/a-voyager/ScrollNumber

自定义滚动数字

<img src="https://raw.githubusercontent.com/a-voyager/ScrollNumber/master/imgs/01.gif" width="320" />

---

**NumberMorphView**: https://github.com/me-abhinav/NumberMorphView

数字变形的 View

<img src="https://raw.githubusercontent.com/me-abhinav/NumberMorphView/dev/sample.gif" width="320" />

---

**NumberMorphView4Android**: https://github.com/Even201314/NumberMorphView4Android

又一个数字变形的 View

<img src="https://raw.githubusercontent.com/Even201314/NumberMorphView4Android/master/raw/master/screenshot/sample.gif" width="320" />

---

**advancedtextview**: https://github.com/oktayayr/advancedtextview

AdvancedTextView provides advanced features that simplifies complicated UI processes

<img src="https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/justifytext_ss.png" width="320" /> <img src="https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/autofit_ss.png" width="480" />

![Aller](https://raw.githubusercontent.com/oktayayr/advancedtextview/master//arts/aller.png)

![Bebas](https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/bebas.png)

![Capture It](https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/capture.png)

![Caviar Dreams](https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/caviar_dreams.png)

![Droid Sans](https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/droid_sans.png)

![Journal](https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/journal.png)

![Open Sans](https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/open_sans.png)

![Pacifico](https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/pacifico.png)

![Roboto](https://raw.githubusercontent.com/oktayayr/advancedtextview/master/arts/roboto.png)

---

**icarus-android**: https://github.com/mr5/icarus-android

The best rich text editor for android platform

<img src="https://raw.githubusercontent.com/mr5/icarus-android/master/demo.gif" width="240" />

---

**ImageTextView**: https://github.com/vipinagrahari/ImageTextView

A Library to show Round ImageView with text labels on right side

<img src="https://raw.githubusercontent.com/vipinagrahari/ImageTextView/master/screenshots/screen1.png" width="320" />

---

**ColorPhrase**: https://github.com/THEONE10211024/ColorPhrase

Phrase is an Android string resource color setting library

<img src="https://github.com/THEONE10211024/ColorPhrase/blob/master/screenshot/Screenshot_2015-05-16-18-12-23.jpeg" width="320" />

---

**CallMeMaybe**: https://github.com/MichaelRocks/CallMeMaybe

电话号码格式的 TextView

<img src="https://raw.githubusercontent.com/MichaelRocks/CallMeMaybe/master/callmemaybe.gif" width="320" />

---

**android-phone-field**: https://github.com/lamudi-gmbh/android-phone-field

电话号码归属国家识别库

<img src="https://raw.githubusercontent.com/lamudi-gmbh/android-phone-field/master/raw/phone-field.gif" width="320" />

---

**justified**: https://github.com/programingjd/justified

Android TextView or EditText with justified text.

<img src="https://github.com/programingjd/justified/blob/master/screenshot.jpg" width="320" />

---

**EditTag**: https://github.com/qiugang/EditTag

a view to edit tag just like EditText edit text

<img src="https://raw.githubusercontent.com/qiugang/EditTag/master/screenshots/s01.jpg" width="320" />

---

**TagsEditText**: https://github.com/mabbas007/TagsEditText

Android EditText for view tags

<img src="https://camo.githubusercontent.com/3a26ca3308d07d4040d9b6bea3dd65b0cc605516/687474703a2f2f692e696d6775722e636f6d2f5a4a596c734e4c2e706e673f33" width="320" />

---

**Spanny**: [https://github.com/binaryfork/Spanny](https://github.com/binaryfork/Spanny)

A helper class that extends SpannableStringBuilder and adds methods to easily mark the text with multiple spans.

<img src="https://camo.githubusercontent.com/16b6d49cf7481709a8bb43803489e6f43e26c1ac/687474703a2f2f692e696d6775722e636f6d2f4e506e6c3079792e706e673f31" width="320" />

---

**LicenseTextView**: https://github.com/jgabrielfreitas/LicenseTextView

Easy License View for Android

<img src="https://raw.githubusercontent.com/jgabrielfreitas/LicenseTextView/master/img/license_print.jpg" width="320" />

---

**Shimmer-android**: https://github.com/RomainPiel/Shimmer-android

An Android TextView with a shimmering effect

<img src="https://raw.githubusercontent.com/RomainPiel/Shimmer-android/master/shimmer.gif" width="480" />

---

**shimmer-android**: https://github.com/facebook/shimmer-android

An easy, flexible way to add a shimmering effect to any view in an Android app

<img src="https://github.com/facebook/shimmer-android/blob/master/shimmer.gif?raw=true" width="480" />

---

**MaterialEditText**: https://github.com/rengwuxian/MaterialEditText

EditText in Material Design

<img src="https://github.com/rengwuxian/MaterialEditText/blob/master/images/material_edittext.png" width="320" />

---

**Titanic**: https://github.com/RomainPiel/Titanic

Android experiment showing a sinking TextView

<img src="https://github.com/RomainPiel/Titanic/blob/master/titanic.gif" width="320" />

---

**easyfonts**: [https://github.com/vsvankhede/easyfonts](https://github.com/vsvankhede/easyfonts)

Useful library to use custom fonts in your android app

<img src="https://github.com/vsvankhede/easyfonts/blob/master/images/fontface_list.png" width="270" />
<img src="https://github.com/vsvankhede/easyfonts/blob/master/images/banner.png" width="480" />

---

**MatchView**: https://github.com/Rogero0o/MatchView

Include MatchTextView and MatchButton..Come..you will like it

<img src="https://camo.githubusercontent.com/a71e9d26a7f90ea70270b3681d99785a29f83be5/687474703a2f2f7777312e73696e61696d672e636e2f6d773639302f6136393561636465677731656d79746e6b347334356732306567306d6b3439302e676966" width="320" />

---

**android-autofittextview**: https://github.com/grantland/android-autofittextview

A TextView that automatically resizes text to fit perfectly within its bounds

<img src="https://github.com/grantland/android-autofittextview/blob/master/website/static/autofittextview.gif?raw=true" width="480" />

---

**SecretTextView**: https://github.com/matthewrkula/SecretTextView

A TextView that simulates the effect from the app Secret where the characters fade in/out at different speeds

<img src="https://camo.githubusercontent.com/bbb38412d3ae652f565556711e7aa6db67ebb4c7/68747470733a2f2f692e696d67666c69702e636f6d2f39356d39312e676966" width="200" />

---

**TextJustify-Android**: https://github.com/bluejamesbond/TextJustify-Android

Android Text Full Jusiftication / Wrapping / Justify / Hyphenate - V2.0

<img src="https://camo.githubusercontent.com/061a4a460340c26422b2a2f43d7fe39e73246297/687474703a2f2f692e696d6775722e636f6d2f6b3662415764302e6a7067" width="480" />

---

**RoundedLetterView**: https://github.com/pavlospt/RoundedLetterView

RoundedLetterView like the one in Android 5.0 Contacts app

<img src="https://github.com/pavlospt/RoundedLetterView/blob/master/Screenshots/device-2014-11-13-191000.png" width="320" />

---

**TextDrawable**: https://github.com/amulyakhare/TextDrawable

This light-weight library provides images with letter/text like the Gmail app

<img src="https://github.com/amulyakhare/TextDrawable/blob/master/screens/screen1-material.png" width="320" /> <img src="https://github.com/amulyakhare/TextDrawable/blob/master/screens/screen2-material.png" width="320" />

---

**BabushkaText**: https://github.com/quiqueqs/BabushkaText

A simpler way to style your TextViews

<img src="https://github.com/quiqueqs/BabushkaText/blob/master/images/example.png" width="320" />

---

**material-code-input**: https://github.com/glomadrian/material-code-input

A material style input for codes

<img src="https://github.com/glomadrian/material-code-input/blob/master/art/codeInput1.gif" width="320" /> <img src="https://github.com/glomadrian/material-code-input/blob/master/art/codeInput2.gif" width="240" />

---

**TextViewExpandableAnimation**: https://github.com/freecats/TextViewExpandableAnimation

Expandable TextView With Smooth Transition Animation

<img src="https://raw.githubusercontent.com/freecats/TextViewExpandableAnimation/master/preview.gif" width="144" />

---

**ExpandableTextView**: https://github.com/Manabu-GT/ExpandableTextView

Android's TextView that can expand/collapse like the Google Play's app description

<img src="https://github.com/Manabu-GT/ExpandableTextView/blob/master/art/readme_demo.gif?raw=true" width="320" />

---

**KMPAutoCompleteTextView**:  https://github.com/andyxialm/KMPAutoCompleteTextView

AutoCompleteTextView for android with KMP algorithm

<img src="https://raw.githubusercontent.com/andyxialm/KMPAutoCompleteTextView/master/art/Screenshot_sample.png" width="320" />

---

**AutoCompleteBubbleText**:  https://github.com/FrederickRider/AutoCompleteBubbleText

Android AutoCompleteTextView with attached ListView, and drawable background

<img src="https://github.com/FrederickRider/AutoCompleteBubbleText/blob/master/images/Screenshot_1.png" width="320" />

---

**floatlabelededittext**: [https://github.com/wrapp/floatlabelededittext](https://github.com/wrapp/floatlabelededittext)

Floating hint from edit text - inspired by Matt D. Smith's design:[http://dribbble.com/shots/1254439--GIF-Mobile-Form-Interaction?list=users](http://dribbble.com/shots/1254439--GIF-Mobile-Form-Interaction?list=users)

<img src="https://camo.githubusercontent.com/9b15f9bfcdacc9bf053fff9d06e7a91a0d1b5070/687474703a2f2f692e696d6775722e636f6d2f75635264316a6d2e676966" width="320" />

---

**SizeAdjustingTextView**: [https://github.com/erchenger/SizeAdjustingTextView](https://github.com/erchenger/SizeAdjustingTextView)

This is based on an open source autosizing textview for Android.

---

**ReadMoreTextView**: https://github.com/borjabravo10/ReadMoreTextView

A Custom TextView with trim text

<img src="https://github.com/borjabravo10/ReadMoreTextView/blob/master/screenshots/expanded.png" width="320" /> <img src="https://github.com/borjabravo10/ReadMoreTextView/blob/master/screenshots/collapsed.png" width="320" />

---

**ParkedTextView**: https://github.com/gotokatsuya/ParkedTextView

A editable text with a constant text/placeholder for Android

<img src="https://github.com/gotokatsuya/ParkedTextView/blob/master/doc/demo-gif.gif" width="320" />

---

**AnimTextView**: https://github.com/z56402344/AnimTextView

一个textView的动画

<img src="https://camo.githubusercontent.com/928419dd3d300081d975c51b2a6ad293b9624ab7/687474703a2f2f696d672e626c6f672e6373646e2e6e65742f3230313531323134323233363431303631" width="320" />

---

**HTextView**: https://github.com/hanks-zyh/HTextView

Animation effects to TextView

![demo](https://github.com/hanks-zyh/HTextView/blob/master/screenshot/demo5.gif)

---

**showhidepasswordedittext**: https://github.com/scottyab/showhidepasswordedittext

Show/Hide Password EditText is a very simple extension of Android's EditText that puts a clickable hide/show icon in the right hand side of the EditText that allows showing of the password.

<img src="https://github.com/scottyab/showhidepasswordedittext/blob/master/docs/sample_screen_shot.png" width="320" />

---

**EasyCountDownTextureView**: https://github.com/CaMnter/EasyCountDownTextureView

Easy count down by TextureView

![TextureView](https://raw.githubusercontent.com/CaMnter/EasyCountDownTextureView/master/screenshot/textureview_1.gif)

---

**TextSurface**: https://github.com/elevenetc/TextSurface

A little animation framework which could help you to show message in a nice looking way

<img src="https://github.com/elevenetc/TextSurface/blob/master/docs/demo.gif" width="480" />

---

**RichTextView**: https://github.com/androidessence/RichTextView

A library that enhances the TextView and allows the user to format various spans of the string

<img src="https://camo.githubusercontent.com/60fbf17a28013bcb7e5c1b925a5c2713e74a44e5/687474703a2f2f692e696d6775722e636f6d2f6d6e666b4d62772e706e67" width="320" />

---

**EmailAutoCompleteTextView**: https://github.com/tasomaniac/EmailAutoCompleteTextView

An AutoCompleteTextView with builtin Adapter with the emails in the device

<img src="https://github.com/tasomaniac/EmailAutoCompleteTextView/blob/master/demo.gif" width="320" />

---

**android-pdfview**: [https://github.com/JoanZapata/android-pdfview](https://github.com/JoanZapata/android-pdfview)

A fast PDF reader component for Android development.[http://joanzapata.com/android-pdfview/](http://joanzapata.com/android-pdfview/)

<img src="https://camo.githubusercontent.com/7712406b4e86c0260f6fd35ed4a1fb77a73a29ce/68747470733a2f2f7261772e6769746875622e636f6d2f4a6f616e5a61706174612f616e64726f69642d706466766965772f6d61737465722f6465766963652e706e67" width="320" />

---

**AndroidPdfViewer**: https://github.com/barteksc/AndroidPdfViewer

pdf 文档查看

---

**PdfViewPager**: https://github.com/voghDev/PdfViewPager

可以读取SD卡，asset文件夹，或者网络下载的pdf文件的widget

<img src="https://raw.githubusercontent.com/voghDev/PdfViewPager/master/screenshots/local.gif" width="270" /> <img src="https://raw.githubusercontent.com/voghDev/PdfViewPager/master/screenshots/remote.gif" width="270" /> <img src="https://raw.githubusercontent.com/voghDev/PdfViewPager/master/screenshots/zooming.gif" width="270" />

---
