# AndroidLibs == 完整开源项目

包含一些完整的开源项目

[<==返回首页==](https://github.com/XXApple/AndroidLibs)

---

**iosched**: https://github.com/google/iosched

Google I/O 大会 App 的最新源代码

---

**giffun**: https://github.com/guolindev/giffun

一款开源的GIF在线分享App，乐趣就要和世界分享

<img src = "https://github.com/guolindev/giffun/raw/master/screenshots/screenshot3.gif" width = "320"/> <img src = "https://github.com/guolindev/giffun/raw/master/screenshots/giffun_demo.gif" width = "320"/>

---

**Todo**: https://github.com/xujiaji/Todo

简洁清爽的Todo清单工具，MVP+okhttp3+retrofit+gson，Api来自玩Android

<img src = "https://raw.githubusercontent.com/xujiaji/xujiaji.github.io/pictures/todo/screen/20181203103804.png" width = "320"/>

---

**android-sunflower**: https://github.com/googlesamples/android-sunflower

A gardening app illustrating Android development best practices with Android Jetpack

<img src = "https://github.com/googlesamples/android-sunflower/blob/master/screenshots/jetpack_donut.png" width = "480"/>

---

**NoticeDog**: https://github.com/bunnyblue/NoticeDog

一个基于NotificationListenerService 的Android通知管理app，可以防止微信消息撤回

---

**LifeHelper**: https://github.com/yangchong211/LifeHelper

综合案例训练，包含新闻，视频，图片，音乐，记事本等等模块。架构模式：采用MVP+Rx+Retrofit+Desgin+Dagger2+阿里VLayout+腾讯X5+腾讯bugly

<img src = "https://camo.githubusercontent.com/674dcb17dd8230923c657902077535bb10fc6002/687474703a2f2f70307536326730306e2e626b742e636c6f7564646e2e636f6d2f53637265656e73686f745f323031372d30392d33302d31372d31322d35362e706e67" width = "270"/> <img src = "https://camo.githubusercontent.com/7caa6c4e3a7d109489986e693ca71d65b80f6af1/687474703a2f2f70307536326730306e2e626b742e636c6f7564646e2e636f6d2f53637265656e73686f745f323031372d30392d33302d31372d31332d35322e706e67" width = "270"/>

---

**android-permission-checker-app**: https://github.com/Arjun-sna/android-permission-checker-app

识别应用中的各种权限

<img src = "https://camo.githubusercontent.com/ea2bd2a4d471b587fb1ee28dfc7a5bda208d7f97/68747470733a2f2f7261776769742e636f6d2f41726a756e2d736e612f41726a756e2d736e612e6769746875622e696f2f6d61737465722f7261772f7065726d697373696f6e5f6170705f73322e706e67" width = "320"/> <img src = "https://camo.githubusercontent.com/48edd1405c89172e9640030c6f4a369f166d2d88/68747470733a2f2f7261776769742e636f6d2f41726a756e2d736e612f41726a756e2d736e612e6769746875622e696f2f6d61737465722f7261772f7065726d697373696f6e5f6170705f73332e706e67" width = "320"/>

---

**DarkCalculator**: https://github.com/HK-SHAO/DarkCalculator

一款支持复数运算等功能的计算器

<img src = "https://camo.githubusercontent.com/d32b4ee63f4afcdb207b25e89a0ac83ed1df4baf/687474703a2f2f696d6167652e636f6f6c61706b2e636f6d2f61706b5f696d6167652f323031372f303831352f53637265656e73686f745f313530323737353635382d666f722d3135353237372d6f5f31626e696231303971313735396c6a61316b3168713663316531302d7569642d3631363234372e706e67" width = "320"/> <img src = "https://camo.githubusercontent.com/655002da7547c6dd9c2add98b32cd9bd2455cadf/687474703a2f2f696d6167652e636f6f6c61706b2e636f6d2f61706b5f696d6167652f323031372f303831352f53637265656e73686f745f313530323737353831342d666f722d3135353237372d6f5f31626e696231366768726e32316c65393171676e3973343164696f31632d7569642d3631363234372e706e67" width = "320"/>

---

**CNode-android**: https://github.com/shellljx/CNode-android

https://cnodejs.org/ 非官方客户端

<img src = "https://raw.githubusercontent.com/shellljx/CNode-android/master/art/01.jpg" width = "270"/> <img src = "https://raw.githubusercontent.com/shellljx/CNode-android/master/art/01.jpg" width = "270"/> <img src = "https://raw.githubusercontent.com/shellljx/CNode-android/master/art/01.jpg" width = "270"/>

---

**Now**: https://github.com/XunMengWinter/Now

Jsoup + MaterialViewPager + RxAndroid + Retrofit + Realm + Fresco + Retrolambda example 一款Android图文精选app，通过抓取网页获得图文列表。目前包含站酷（Zcool）精选、国家地理（National Geographic）每日一图、知乎日报、豆瓣一刻（Moment）

---

**Anti-recall**: https://github.com/JasonQS/Anti-recall

QQ，微信防撤回神器

<img src = "https://github.com/JasonQS/Anti-recall/raw/master/demo/demo01.gif" width = "320"/> <img src = "https://github.com/JasonQS/Anti-recall/raw/master/demo/demo02.gif" width = "320"/>

---

**codeKK-Android**: https://github.com/7449/codeKK-Android

codeKK-Android

<img src = "https://github.com/7449/codeKK-Android/raw/master/screenshots/opa_image.gif" width = "270"/> <img src = "https://github.com/7449/codeKK-Android/raw/master/screenshots/blog_image.gif" width = "270"/> <img src = "https://github.com/7449/codeKK-Android/raw/master/screenshots/job_image.gif" width = "270"/>

---

**MessageRelayer**: https://github.com/HaoFeiWang/MessageRelayer

短信转发工具

<img src = "https://raw.githubusercontent.com/HaoFeiWang/MessageRelayer/master/screen/screen_main2.jpg" width = "210"/> <img src = "https://raw.githubusercontent.com/HaoFeiWang/MessageRelayer/master/screen/screen_email.jpg" width = "210"/> <img src = "https://raw.githubusercontent.com/HaoFeiWang/MessageRelayer/master/screen/screen_key.jpg" width = "210"/>

---

**Espresso**: https://github.com/TonnyL/Espresso

快递查询App, 基于MVP架构和Material Design设计风格，采用RxJava2, Retrofit2, Realm and ZXing开发

<img src = "https://raw.githubusercontent.com/TonnyL/Espresso/master/art/screenshot0.png" width = "600"/>

---

**FlipsideCamera**: https://github.com/andyb129/FlipsideCamera

从两个摄像头同时拍下某一个瞬间的 app

<img src = "https://raw.githubusercontent.com/andyb129/FlipsideCamera/master/screenshots/flipside_camera_screen_1.png" width = "320"/> <img src = "https://raw.githubusercontent.com/andyb129/FlipsideCamera/master/screenshots/flipside_camera_screen_3.png" width = "320"/>

---

**rebase-android**: https://github.com/drakeet/rebase-android

日常 是一款由 drakeet 负责推荐和分享各种好玩新鲜的栏目应用，基于 Rebase 服务， 学习型非常强

<img src = "https://camo.githubusercontent.com/e94868f1f6f224e3478a7a1a26eafac258e3330f/687474703a2f2f7777312e73696e61696d672e636e2f6c617267652f38366532666638356779316663726a3332366e67796a32313869307830313032" width = "640"/>

---

**MinimalistWeather**: https://github.com/BaronZ88/MinimalistWeather

Android平台开源天气App，采用MVP+RxJava+Retrofit2+OKHttp3+Dagger2+RetroLambda等开源库来实现

<img src = "https://raw.githubusercontent.com/BaronZ88/MinimalistWeather/master/framework_minimalist_weather.png" width = "320"/>

---

**LQRWeChat**: https://github.com/GitLqr/LQRWeChat

高仿微信6.3.31，使用网易云信SDK 3.2.0版本完成主要的聊天功能（单聊、群聊）、好友关系管理、群组管理等功能

<img src = "https://raw.githubusercontent.com/GitLqr/LQRWeChat/master/screenshots/main/1.gif" width = "320"/>

---

**Minimal-Todo**: https://github.com/avjinder/Minimal-Todo

Minimal-Todo

<img src = "https://raw.githubusercontent.com/avjinder/Minimal-Todo/master/screenshots/main_full_light.png" width = "320"/> <img src = "https://raw.githubusercontent.com/avjinder/Minimal-Todo/master/screenshots/todo_time_dark.png" width = "320"/> <img src = "https://raw.githubusercontent.com/avjinder/Minimal-Todo/master/screenshots/main_empty_light.png" width = "320"/>

---

**BusyBox**: https://github.com/jrummyapps/BusyBox

Install BusyBox on an Android device

<img src = "https://raw.githubusercontent.com/jrummyapps/BusyBox/master/app/src/main/res/mipmap-xxhdpi/ic_launcher.png" width = "140"/>

---

**GDG**: https://github.com/peekler/GDG

一些不常用的安卓api示例

---

**wechat_no_revoke**: https://github.com/rarnu/wechat_no_revoke

最新可用防止微信撤回xposed插件

---

**Hijacker**: https://github.com/chrisk44/Hijacker

Aircrack-ng Android GUI程序，用于攻击无线网络

---

**MovieHub**: https://github.com/lawloretienne/MovieHub

非常漂亮的一款 Android Movie 工具

<img src="https://raw.githubusercontent.com/lawloretienne/MovieHub/master/images/MovieHub_Screenshot_1.png" width="320" /> <img src="https://raw.githubusercontent.com/lawloretienne/MovieHub/master/images/MovieHub_Screenshot_10.png" width="320" />

---

**QQ**: https://github.com/HuTianQi/QQ

一款高仿腾讯QQ的IM软件，主UI框架采用侧滑菜单+底部导航的方式，核心聊天功能基于bmob SDK，已经实现文本，表情，图片，位置，语音等信息的发送

<img src="https://github.com/HuTianQi/QQ/raw/master/QQ.gif" width="320" />

---

**wifi-bruteforcer-fsecurify**: https://github.com/faizann24/wifi-bruteforcer-fsecurify

Android 下实现的 Wifi 暴力破解工具

<img src="https://raw.githubusercontent.com/faizann24/wifi-bruteforcer-fsecurify/master/1280.jpg" width="640" />
---

**ZhiHu-TopAnswer**: https://github.com/jiang111/ZhiHu-TopAnswer

知乎热门榜

<img src="https://raw.githubusercontent.com/jiang111/ZhiHu-TopAnswer/master/art/1.png" width="320" /> <img src="https://raw.githubusercontent.com/jiang111/ZhiHu-TopAnswer/master/art/3.png" width="320" />

---

**ActivityLauncher**: https://github.com/jp1017/ActivityLauncher

打开任意app的任意Activity并可创建快捷方式，非系统应用会因权限问题失败

<img src="https://cloud.githubusercontent.com/assets/7868514/21418384/dca2a876-c85b-11e6-9e7a-9d42096341ec.png" width="320" /> <img src="https://cloud.githubusercontent.com/assets/7868514/21418385/dcb032ac-c85b-11e6-9b27-1bf03baa5696.png" width="320" />

---

**android-oss**: https://github.com/kickstarter/android-oss

Kickstarter Android 源码开源

<img src="https://raw.githubusercontent.com/kickstarter/android-oss/master/.github/app.png" width="800" />

---

**MyDiary**: https://github.com/erttyy8821/MyDiary

In the Movie "-your name.-" (君の名は。, 你的名字) , "My Diary" of android version is

<img src="https://raw.githubusercontent.com/erttyy8821/MyDiary/master/screenshot/s_2.png" width="240" /> <img src="https://raw.githubusercontent.com/erttyy8821/MyDiary/master/screenshot/s_3.png" width="240" /> <img src="https://raw.githubusercontent.com/erttyy8821/MyDiary/master/screenshot/s_5.png" width="240" />

---

**FingerColoring-Android**: https://github.com/SwiftyWang/FingerColoring-Android

一个自己做的填图应用

<img src="https://raw.githubusercontent.com/SwiftyWang/FingerColoring-Android/master/screenshot/S61118-20264887.jpg" width="320" /> <img src="https://raw.githubusercontent.com/SwiftyWang/FingerColoring-Android/master/screenshot/S61118-20275245.jpg" width="320" />

---

**u2020**: https://github.com/JakeWharton/u2020

A sample Android app which showcases advanced usage of Dagger among other open source libraries

<img src="https://github.com/JakeWharton/u2020/raw/master/u2020.gif" width="320" />

---

**wally**: https://github.com/Musenkishi/wally

简洁易用的壁纸应用

---

**LoveWallpaper**: https://github.com/LiuGuiLinAndroid/LoveWallpaper

高仿爱壁纸App | Material Design

<img src="https://github.com/LiuGuiLinAndroid/LoveWallpaper/raw/master/preview/preview1.0.png?raw=true" width="800" />

---

**Mysplash**: https://github.com/WangDaYeeeeee/Mysplash

一款轻量化的第三方Unsplash客户端

<img src="https://raw.githubusercontent.com/WangDaYeeeeee/Mysplash/master/preview/thumbnails/preview_home.png" width="320" /> <img src="https://raw.githubusercontent.com/WangDaYeeeeee/Mysplash/master/preview/thumbnails/preview_drawer.png" width="320" /> 

---

**wallsplash-android**: https://github.com/mikepenz/wallsplash-android

android client for the awesome unsplash.com

<img src="https://camo.githubusercontent.com/46eab443adaf9ab0064ea6d7a01c62b182ac6247/687474703a2f2f77616c6c73706c6173686170702e636f6d2f696d616765732f73637265656e73686f74732f312e706e67" width="320" /> <img src="https://camo.githubusercontent.com/1662c6a55b5ee068b302cc799e5c77b77b336114/687474703a2f2f77616c6c73706c6173686170702e636f6d2f696d616765732f73637265656e73686f74732f362e706e67" width="320" /> 

---

**DrawView**: https://github.com/ByoxCode/DrawView

Android 画板 View，随心所欲的画画

<img src="https://raw.githubusercontent.com/ByoxCode/DrawView/master/2016.11.10_17.57.50.gif" width="240" /> <img src="https://raw.githubusercontent.com/ByoxCode/DrawView/master/2016.11.10_18.00.25.gif" width="240" /> <img src="https://raw.githubusercontent.com/ByoxCode/DrawView/master/2016.11.10_18.03.14.gif" width="240" />

---

**RecordWave**: https://github.com/CarGuo/RecordWave

MP3音频录制，支持类似IOS原生的单边或者双边波形显示，低版本音频权限兼容，本地或者在线音频播放的波形显示，录制波形和播放波形会根据声音频率变色的功能

<img src="https://raw.githubusercontent.com/CarGuo/RecordWave/master/02.gif" width="320" />

---

**AlgorithmVisualizer-Android**: https://github.com/naman14/AlgorithmVisualizer-Android

Android 实现的算法可是工具，随时随地帮助学习算法

<img src="https://raw.githubusercontent.com/naman14/AlgorithmVisualizer-Android/master/screenshots/screen1.png" width="320" /> <img src="https://raw.githubusercontent.com/naman14/AlgorithmVisualizer-Android/master/screenshots/screen4.png" width="320" />

---

**android-TopActivity**: https://github.com/109021017/android-TopActivity

Android 逆向实用小插件：展示页面 Top Activity 的名称和包名

---

**AcClient**: https://github.com/Thereisnospon/AcClient

杭电OJ客户端

<img src="https://camo.githubusercontent.com/6e33f148de972eb67326b2e1ea83c6123d6bbc28/687474703a2f2f696d672e626c6f672e6373646e2e6e65742f3230313631313035313933363031343638" width="640" />

---

**ABR-App-Backup-Restore**: https://github.com/samanyougarg/ABR-App-Backup-Restore

App 备份和恢复，做的很完整

<img src="https://raw.githubusercontent.com/samanyougarg/ABR-App-Backup-Restore/master/screenshots.png" width="600" />

---

**FastAccess**: https://github.com/k0shk0sh/FastAccess

仿三星桌面的浮动工具

<img src="https://raw.githubusercontent.com/k0shk0sh/FastAccess/master/art/1024x500.png" width="640" />

---

**monotweety**: https://github.com/yshrsmz/monotweety

Simple Twitter Client just for tweeting, written in Kotlin with reactive MVVM-like approach

<img src="https://raw.githubusercontent.com/yshrsmz/monotweety/master/assets/screenshots/screenshot_setting.png" width="320" /> <img src="https://raw.githubusercontent.com/yshrsmz/monotweety/master/assets/screenshots/screenshot_editor_1.png" width="320" />

---

**Villains-and-Heroes**: https://github.com/andremion/Villains-and-Heroes

App using Marvel Comics API that allows developers everywhere to access information about Marvel's vast library of comics

<img src="https://raw.githubusercontent.com/andremion/Villains-and-Heroes/master/art/home-github.png" width="320" /> <img src="https://raw.githubusercontent.com/andremion/Villains-and-Heroes/master/art/detail-github.png" width="320" />

---

**mirror**: https://github.com/zhihu/mirror

一款 Android 第三方 Sketch Mirror 软件

<img src="https://raw.githubusercontent.com/zhihu/mirror/master/example.png" width="800" />

---

**NotificationBox**: https://github.com/gavinliu/NotificationBox

实现系统通知拦截功能的 App

<img src="https://raw.githubusercontent.com/gavinliu/NotificationBox/master/screenshots.png" width="800" />

---

**leanback-showcase**: https://github.com/googlesamples/leanback-showcase

Showcases different components that come with the Leanback library for Android TV

<img src="https://raw.githubusercontent.com/googlesamples/leanback-showcase/master/screenshots/Showcase-Snapshots.png" width="800" />

---

**LivePlayback**: https://github.com/hejunlin2013/LivePlayback

Android TV直播电视节目 ,包含各央视频道及卫视频道

<img src="https://raw.githubusercontent.com/hejunlin2013/LivePlayback/master/images/device-2016-10-28-183212.jpg" width="400" /> <img src="https://raw.githubusercontent.com/hejunlin2013/LivePlayback/master/images/device-2016-10-28-190258.jpg" width="400" />

---

**AndroidShortcuts**: https://github.com/pcevikogullari/AndroidShortcuts

Android Support 25.0 中 Shortcut Demo

<img src="https://raw.githubusercontent.com/pcevikogullari/AndroidShortcuts/master/shortcut1.gif" width="320" /> <img src="https://raw.githubusercontent.com/pcevikogullari/AndroidShortcuts/master/shortcut2.gif" width="320" />

---

**dns66**: https://github.com/julian-klode/dns66

基于 DNS 实现的 Android 广告拦截

---

**debug-bottle**: https://github.com/kiruto/debug-bottle

Android Java 程序员开发调试与测试工具

<img src="https://raw.githubusercontent.com/kiruto/debug-bottle/1.0.1/screenshots/introduction.gif" width="220" /> <img src="https://raw.githubusercontent.com/kiruto/debug-bottle/1.0.1/screenshots/quick-toggles.png" width="220" /> <img src="https://raw.githubusercontent.com/kiruto/debug-bottle/1.0.1/screenshots/features-2.png" width="220" />

---

**AndroidHttpCapture**: https://github.com/JZ-Darkal/AndroidHttpCapture

AndroidHttpCapture网络诊断工具 是一款针对于移动流量劫持而开发的手机抓包软件

<img src="https://camo.githubusercontent.com/de9a8164ae568b36825852bf924b7485c3e9eea2/68747470733a2f2f7777772e6461726b616c2e636e2f696d67642e7068703f7372633d2f323031362f30392f576563686174494d4737372e6a7065672677696474683d333530" width="270" /> <img src="https://camo.githubusercontent.com/6bd818e68a72c48d1f4a23d8a1528dda64fde11f/68747470733a2f2f7777772e6461726b616c2e636e2f696d67642e7068703f7372633d2f323031362f30392f3233303638363636333934373738373932382e6a70672677696474683d333530" width="270" /> <img src="https://camo.githubusercontent.com/24b3bfa8fc78d622eba26d9b6bc2680c714309ca/68747470733a2f2f7777772e6461726b616c2e636e2f696d67642e7068703f7372633d2f323031362f30392f576563686174494d4738312e6a7065672677696474683d333530" width="270" />

---

**DylanStepCount**: https://github.com/linglongxin24/DylanStepCount

Android精准计步器

<img src="https://raw.githubusercontent.com/linglongxin24/DylanStepCount/master/screenshots/%E4%B8%BB%E9%A1%B5.jpg" width="270" /> <img src="https://raw.githubusercontent.com/linglongxin24/DylanStepCount/master/screenshots/%E9%94%BB%E7%82%BC%E8%AE%A1%E5%88%92.jpg" width="270" /> <img src="https://raw.githubusercontent.com/linglongxin24/DylanStepCount/master/screenshots/%E5%8E%86%E5%8F%B2%E8%AE%B0%E5%BD%95.jpg" width="270" />

---

**Sprayscape**: https://github.com/googlecreativelab/Sprayscape

Google 开源了一个专为 VR 设计的相机 App

<img src="https://raw.githubusercontent.com/googlecreativelab/Sprayscape/master/sprayscape.jpg" width="640" />

---

**SqliteLookup**: https://github.com/YeDaxia/SqliteLookup

Sqlite 数据库查看

<img src="https://raw.githubusercontent.com/YeDaxia/SqliteLookup/master/jietu-1.png" width="320" /> <img src="https://raw.githubusercontent.com/YeDaxia/SqliteLookup/master/jietu-2.png" width="320" />

---

**Bgm38**: https://github.com/zubinxiong/Bgm38

番剧记录工具Bgm38( bangumi 第三方客户端 ),采用 RxJava + Retrofit + MVP, 设计上采用 Material Design

<img src="https://raw.githubusercontent.com/zubinxiong/Bgm38/master/art/art0.jpg" width="270" /> <img src="https://raw.githubusercontent.com/zubinxiong/Bgm38/master/art/art1.jpg" width="270" /> <img src="https://raw.githubusercontent.com/zubinxiong/Bgm38/master/art/art3.jpg" width="270" />

---

**Currency-Converter-Android**: https://github.com/samanyougarg/Currency-Converter-Android

一款完整的货币转换的 App

<img src="https://raw.githubusercontent.com/samanyougarg/Currency-Converter-Android/master/screenshots.png" width="640" />

---

**Currency**: https://github.com/yiyuanliu/Currency

一个简洁的汇率转换软件，使用 kotlin 编写，通过 anko 框架编写 UI 并实现漂亮的主题动态切换效果

<img src="https://raw.githubusercontent.com/yiyuanliu/Currency/master/screenshots/Screenshot.png" width="320" />

---

**NetGuard**: https://github.com/M66B/NetGuard

非root禁止应用联网

<img src="https://raw.githubusercontent.com/M66B/NetGuard/master/screenshots/01-main.png" width="320" /> <img src="https://raw.githubusercontent.com/M66B/NetGuard/master/screenshots/08-notifications.png" width="320" />

---

**turbo-editor**: https://github.com/vmihalachi/turbo-editor

Simple and powerful File Editor for Android

<img src="https://camo.githubusercontent.com/26e85b1e6f305d9259e916f032554ff8e1b6fa43/68747470733a2f2f6c68332e676f6f676c6575736572636f6e74656e742e636f6d2f2d304748756b7747515057342f5643557045684b6e5a43492f41414141414141414148342f63636c4937304b37395f512f773334372d683532302d6e6f2f50686f6e65437573746f6d5f372e706e67" width="300" />

---

**FolioReader-Android**: https://github.com/FolioReader/FolioReader-Android

完成度很高的一款 ePub Android 阅读器

<img src="https://cloud.githubusercontent.com/assets/1277242/19012915/0661c7b2-87e0-11e6-81d6-8c71051e1074.gif" width="300" /> <img src="https://cloud.githubusercontent.com/assets/1277242/19012908/d61f3ce2-87df-11e6-8652-d72b6a1ad9a3.gif" width="300" />

---

**BookReader**: https://github.com/JustWayward/BookReader

“任阅”，开源小说阅读器，高仿追书神器，实现追书推荐、标签检索、翻书效果、文章阅读、缓存章节、日夜间模式、文本朗读等功能

<img src="https://raw.githubusercontent.com/JustWayward/BookReader/master/screenshot/home_zhuishu.png" width="270" /> <img src="https://raw.githubusercontent.com/JustWayward/BookReader/master/screenshot/read_page_4.png" width="270" /> <img src="https://raw.githubusercontent.com/JustWayward/BookReader/master/screenshot/discuss.png" width="270" />

---

**UPMiss**: https://github.com/qiujuer/UPMiss

一个完整的生日管理 App

<img src="https://raw.githubusercontent.com/qiujuer/UPMiss/master/arts/shot.png" width="640" />

---

**GeekNews**: https://github.com/codeestX/GeekNews

A pure reading App based on Material Design + MVP + RxJava + Retrofit + Dagger2 + Realm + Glide

<img src="https://github.com/codeestX/GeekNews/raw/master/screenshots/GIF1.gif" width="320" /> <img src="https://github.com/codeestX/GeekNews/raw/master/screenshots/GIF2.gif" width="320" />

---

**Filmy**: https://github.com/salRoid/Filmy

一款超漂亮的基于 MD 设计的电影 App

<img src="https://camo.githubusercontent.com/c8c6ffb5294c3a1536bf928e3e0ab56fe699a2c6/687474703a2f2f7777772e77656269616e6b732e636f6d2f66696c6d792f66696c6d792e706e67" width="320" /> <img src="https://camo.githubusercontent.com/0adfbf905cf4bf59959c9675bdf02e888aa6e847/687474703a2f2f7777772e77656269616e6b732e636f6d2f66696c6d792f612e706e67" width="320" />

---

**LingDong2.0**: https://github.com/zhoubowen-sky/LingDong2.0

“面对面文件快传”，Android端灵动快传，安卓互传文件，局域网，无网传输文件

<img src="https://raw.githubusercontent.com/zhoubowen-sky/LingDong2.0/master/github-images-folder/cebianlan.jpg" width="270" /> <img src="https://raw.githubusercontent.com/zhoubowen-sky/LingDong2.0/master/github-images-folder/main.jpg" width="270" /> <img src="https://raw.githubusercontent.com/zhoubowen-sky/LingDong2.0/master/github-images-folder/trans.jpg" width="270" />

---

**code-reader**: https://github.com/loopeer/code-reader

手机端代码阅读

<img src="https://raw.githubusercontent.com/loopeer/code-reader/master/screenshot/codereader_setting_day.gif" width="230" /> <img src="https://raw.githubusercontent.com/loopeer/code-reader/master/screenshot/codereader_itemtouch.gif" width="230" />

---

**HAgnostic-News**: https://github.com/grigio/HAgnostic-News

React Native app (Android / iOS) 阅读

<img src="https://cloud.githubusercontent.com/assets/8074/18037131/149c2f34-6d7d-11e6-83d0-82af574301e3.png" width="600" />

---

**LookLook**: https://github.com/xinghongfei/LookLook

一个精美,极简的阅读app

<img src="https://github.com/xinghongfei/LookLook/raw/developer/screenshots/LookLook.gif" width="320" />

---

**boon**: https://github.com/Wing-Li/boon

移动开发者福利App，内含多渠道打包

<img src="https://raw.githubusercontent.com/Wing-Li/boon/master/img/learn.png" width="320" /> <img src="https://raw.githubusercontent.com/Wing-Li/boon/master/img/joke.png" width="320" />

---

**Android_UsingCar_Example**: https://github.com/amapapi/Android_UsingCar_Example

基于高德地图Android API快速搭建用车解决方案的示例

---

**Android_Location_Demo**: https://github.com/amapapi/Android_Location_Demo

高德定位demo

<img src="https://raw.githubusercontent.com/amapapi/Android_UsingCar_Example/master/pic/result.png" width="320" />

---

**simplenote-android**: https://github.com/Automattic/simplenote-android

Simplenote for Android http://simplenote.com

---

**PDFCreator**: https://github.com/scoute-dich/PDFCreator

Android application to create and edit Pdf files

---

**LocalWeather**: https://github.com/piotrek1543/LocalWeather

Weather forecast app using Retrofit, Gson, AndroidAnnotations and ActiveAndroid

<img src="https://raw.githubusercontent.com/piotrek1543/LocalWeather/master/screenshots/device-2016-08-09-172447.png" width="320" /> <img src="https://raw.githubusercontent.com/piotrek1543/LocalWeather/master/screenshots/device-2016-08-09-172551.png" width="320" />

---

**visual-goodies**: https://github.com/alexive/visual-goodies

一些界面好看的库，包括 List， Dialog, Card 等

<img src="https://raw.githubusercontent.com/alexive/visual-goodies/master/images/sample1.gif" width="320" /> <img src="https://raw.githubusercontent.com/alexive/visual-goodies/master/images/sample4.png" width="320" />

---

**SimpleRT**: https://github.com/vvviperrr/SimpleRT

可以将Linux 和 OSX 系统网络通过 USB 分享给 Android 系统

<img src="https://raw.githubusercontent.com/vvviperrr/SimpleRT/master/screens/accessory.png" width="320" /> <img src="https://raw.githubusercontent.com/vvviperrr/SimpleRT/master/screens/connected.png" width="320" />

---

**nock-nock**: https://github.com/afollestad/nock-nock

nock-nock 一个可以帮助你监控网站是否异常的 App

<img src="https://raw.githubusercontent.com/afollestad/nock-nock/master/art/showcase.png" width="640" />

---

**PhotoNoter**: https://github.com/yydcdut/PhotoNoter

Material Design风格的开源照片笔记。(MVP+Dagger2+RxJava+Dex分包脚本+Dex异步加载) http://yydcdut.com/note

<img src="https://raw.githubusercontent.com/yydcdut/PhotoNoter/master/screenshot/animation.gif" width="270" /> <img src="https://raw.githubusercontent.com/yydcdut/PhotoNoter/master/screenshot/screen3.png" width="270" /> <img src="https://raw.githubusercontent.com/yydcdut/PhotoNoter/master/screenshot/screen11.png" width="270" />

---

**SimpleDroidRx**: https://github.com/PhilippeBoisney/SimpleDroidRx

An application that helps you learn and better understand ReactiveX

<img src="https://raw.githubusercontent.com/PhilippeBoisney/SimpleDroidRx/master/Screenshots/hello_worlds_screenshot.png" width="270" /> <img src="https://raw.githubusercontent.com/PhilippeBoisney/SimpleDroidRx/master/Screenshots/famous_operators_screenshot.png" width="270" /> <img src="https://raw.githubusercontent.com/PhilippeBoisney/SimpleDroidRx/master/Screenshots/error_handling_screenshot.png" width="270" />

---

**DebugPurge**: https://github.com/eswarm/DebugPurge

删除安装在手机上的 debug 版本应用

<img src="https://cloud.githubusercontent.com/assets/7868514/17136186/8a8161aa-5366-11e6-9e24-663ae58c3a08.jpg" width="320" />

---

**FanXin3.0**: https://github.com/huangfangyi/FanXin3.0

凡信 3.0 -最强微信仿品

<img src="https://camo.githubusercontent.com/2cf9177718ef081a6498cdc218cc6463acfd13c9/687474703a2f2f7777772e696d6765656b2e6f72672f75706c6f6164732f61727469636c652f32303136303731372f64363039396363633161656461643233326663376433313732376232646566382e706e67" width="270" />

---

**SprintNBA**: https://github.com/smuyyh/SprintNBA

NBA头条新闻、视频集锦、比赛直播（目前仅支持文字直播、球队及球员数据统计）、球队战绩排行、球员数据排名、虎扑论坛专区、球队及球员详细资料

<img src="https://raw.githubusercontent.com/smuyyh/SprintNBA/master/screenshot/home_news.png" width="270" /> <img src="https://raw.githubusercontent.com/smuyyh/SprintNBA/master/screenshot/news_detail.png" width="270" /> <img src="https://raw.githubusercontent.com/smuyyh/SprintNBA/master/screenshot/home_team_sort.png" width="270" />

---

**AndroidBroadcastsMonitor**: https://github.com/ViliusKraujutis/AndroidBroadcastsMonitor

监控安卓广播的应用

---

**AndroidChromium**: https://github.com/JackyAndroid/AndroidChromium

Chromium 浏览器，Android Studio 版本

<img src="https://raw.githubusercontent.com/JackyAndroid/AndroidChromium/master/screenshots/S60709-172236.jpg" width="270" /> <img src="https://raw.githubusercontent.com/JackyAndroid/AndroidChromium/master/screenshots/S60709-172251.jpg" width="270" /> <img src="https://raw.githubusercontent.com/JackyAndroid/AndroidChromium/master/screenshots/S60709-172456.jpg" width="270" />

---

**GithubWidget**: https://github.com/Nightonke/GithubWidget

A simple implementation of swipe card like StreetView!!

<img src="https://raw.githubusercontent.com/Nightonke/GithubWidget/master/Pic/color.png" width="640" />

---

**DeepDiveIntoAndroidDataBinding**: https://github.com/radzio/DeepDiveIntoAndroidDataBinding

DataBinding demo

<img src="https://cloud.githubusercontent.com/assets/469111/16058354/6297c9d0-327e-11e6-9e0c-0aab0f08ba7a.gif" width="400" />

---

**Carbon**: [https://github.com/ZieIony/Carbon](https://github.com/ZieIony/Carbon)

Material Design implementation for Android 2.2+. Shadows, ripples, vectors, fonts, animations, widgets, rounded corners and more.[https://androidreclib.wordpress.com/](https://androidreclib.wordpress.com/)

<img src="https://github.com/ZieIony/Carbon/blob/master/images/anchors.png" width="200" />
<img src="https://github.com/ZieIony/Carbon/blob/master/images/buttonsusage.png" width="200" />
<img src="https://github.com/ZieIony/Carbon/blob/master/images/progress.png" width="200" />
<img src="https://github.com/ZieIony/Carbon/blob/master/images/recyclercards.png" width="200" />

---

**huabanDemo**: https://github.com/LiCola/huabanDemo

MD版的花瓣网App

<img src="https://raw.githubusercontent.com/LiCola/huabanDemo/master/ScreenCapture/Main.jpg" width="240" /> <img src="https://raw.githubusercontent.com/LiCola/huabanDemo/master/ScreenCapture/Drawer.jpg" width="240" />

---

**MarkdownEditors**: https://github.com/qinci/MarkdownEditors

Android Markdown编辑器

<img src="https://raw.githubusercontent.com/qinci/MarkdownEditors/master/image/image_1.png" width="320" /> <img src="https://raw.githubusercontent.com/qinci/MarkdownEditors/master/image/image_13.png" width="320" />

---

**orz**: https://github.com/vsona/orz

A Demo with Retrofit2 Okhttp3 Dagger RxJava RxAndroid ButterKnife...

---

**narrate-android**: https://github.com/timothymiko/narrate-android

日记应用

<img src="https://lh6.ggpht.com/8uGdduyPnGJF-rM0ifjruQR4v_2AJW3Uq4G3kKyVFytt3FYnvpkKdThdQDQMC-TXNDY=h900-rw" width="270" /> <img src="https://lh3.ggpht.com/y9sDAArYyQf5XXpgKX6zRuJvbeeSAFQc79gNT8UaTKoSB9DvBm-aJhQDsZoZqY0Itz0=h900-rw" width="270" />

---

**BookShelf**: https://github.com/iHaPBoy/BookShelf

一款用于管理个人图书及阅读笔记的移动 Android 应用

<img src="https://camo.githubusercontent.com/3e2f92b0dd48dcfbe5a716c8b8d39830908cd3b0/687474703a2f2f7777342e73696e61696d672e636e2f6c617267652f303036744e6252776777316635386e76676d6577396a33303774306477337a66" width="280" /> <img src="https://camo.githubusercontent.com/ecb50943faaffd3be26f3e6199194e62b2ef35b5/687474703a2f2f7777322e73696e61696d672e636e2f6c617267652f303036744e6252776777316635386e7676736f73756a333037743064776a7279" width="280" />

---

**superXingPostCard**: https://github.com/hugeterry/superXingPostCard

一个制作明信片图片的app

<img src="https://raw.githubusercontent.com/hugeterry/superXingPostCard/master/showUI/1.jpg" width="270" /> <img src="https://raw.githubusercontent.com/hugeterry/superXingPostCard/master/showUI/3.jpg" width="270" /> <img src="https://raw.githubusercontent.com/hugeterry/superXingPostCard/master/showUI/4.jpg" width="270" />

---

**KnowWeather**: https://github.com/SilenceDut/KnowWeather

知天气——天气尽在掌握之中

<img src="https://camo.githubusercontent.com/c9b87b7e25da0017371c2595aa0f724be8bb2e0d/687474703a2f2f7777322e73696e61696d672e636e2f6c617267652f30303679386c566167773166616965636d787878326a333132773064777463692e6a7067" width="800" />
---

**WeatherAlarmClock**: https://github.com/kaku2015/WeatherAlarmClock

天气闹钟

<img src="https://raw.githubusercontent.com/kaku2015/WeatherAlarmClock/master/screenshots/2.jpeg" width="270" /> <img src="https://raw.githubusercontent.com/kaku2015/WeatherAlarmClock/master/screenshots/3.jpeg" width="270" /> <img src="https://raw.githubusercontent.com/kaku2015/WeatherAlarmClock/master/screenshots/5.jpeg" width="270" />

---

**GithubContributionsWidget**: https://github.com/donglua/GithubContributionsWidget

Android桌面小部件：展示你的 Github 贡献图

<img src="https://camo.githubusercontent.com/2f626ff1e8ee39034a24f43d6a86e8b1f233fb47/687474703a2f2f6f676b6236376f63382e626b742e636c6f7564646e2e636f6d2f453243344439433343313646312e6a7067" width="320" />

---

**FastHub**: https://github.com/k0shk0sh/FastHub

终极版 GitHub 客户端

<img src="https://raw.githubusercontent.com/k0shk0sh/FastHub/master/.github/assets/mobile_light.png" width="320" /> <img src="https://raw.githubusercontent.com/k0shk0sh/FastHub/master/.github/assets/mobile_night.png" width="320" />

---

**Gitskarios**: https://github.com/gitskarios/Gitskarios

好用的 GitHub 客户端

---

**monkey-android**: https://github.com/yeungeek/monkey-android

Github 第三方客户端

<img src="https://github.com/yeungeek/monkey-android/raw/master/images/monkey.gif" width="270" /> <img src="https://github.com/yeungeek/monkey-android/raw/master/images/preview1.png" width="270" /> <img src="https://github.com/yeungeek/monkey-android/raw/master/images/preview3.png" width="270" />

---

**YouJoin-Android**: https://github.com/FreedomZZQ/YouJoin-Android

YouJoin社交平台的Android客户端

<img src="https://camo.githubusercontent.com/f1696632a3b0c5b501ef04120c021dc50df07542/687474703a2f2f37767a726a302e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f796f756a6f696e2d616e64726f69642d312d77656c636f6d652e706e673f696d616765566965772f322f772f343030" width="270" /> <img src="https://camo.githubusercontent.com/f794aa911cfb803c3da7b7a9256ba6b4ea65b7a7/687474703a2f2f37767a726a302e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f796f756a6f696e2d616e64726f69642d312d7477656574736c6973742e706e673f696d616765566965772f322f772f343030" width="270" /> <img src="https://camo.githubusercontent.com/5daa8595a4df8d88dae54b9b8bc2bb9b01e1a006/687474703a2f2f37767a726a302e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f796f756a6f696e2d616e64726f69642d312d6d656e752e706e673f696d616765566965772f322f772f343030" width="270" />

---

**Android-SlidingEmojiKeyboard**: https://github.com/klinker24/Android-SlidingEmojiKeyboard

Sliding Emoji Keyboard app

<img src="https://raw.githubusercontent.com/klinker24/Android-SlidingEmojiKeyboard/master/ios-emojis/Other/Promo.png" width="800" />

---

**nfcard**: https://github.com/sinpolib/nfcard

一个nfc 客户端，可查询各种公交卡余额等

<img src="https://lh3.googleusercontent.com/bMuBROWaxhp6b0-koSLfyR346vNZ8I2RjWEbHMmOp4vQQ-5qzKo6LVsJuYyKRlAxzqfk=h900-rw" width="320" />

---

**DMGameApp**: https://github.com/xiaohaibin/DMGameApp

DMGameApp是一款基于3DMGAME的一个游戏门户app，非官方版本，界面有一些仿网易新闻客户端

<img src="https://camo.githubusercontent.com/56a8f0bf15f13063c1845756bfe4918058febadc/687474703a2f2f696d672e77646a696d672e636f6d2f6d6d732f73637265656e73686f742f612f31612f32626432633362306665383239363835663365663761666638316431653161615f3332305f3537302e6a706567" width="270" /> <img src="https://camo.githubusercontent.com/a7febef7f20d631e9f35cb70f90a029d58e21460/687474703a2f2f696d672e77646a696d672e636f6d2f6d6d732f73637265656e73686f742f352f33382f37313439353439393531663863623134666438356663653466306561653338355f3332305f3537302e6a706567" width="270" /> <img src="https://camo.githubusercontent.com/33369fb9a7d17d7993b6c049d733fbc43fb77552/687474703a2f2f696d672e77646a696d672e636f6d2f6d6d732f73637265656e73686f742f302f39342f39333765336435356166376336336435393431366661613930633036343934305f3332305f3537302e6a706567" width="270" />

---

**LeafPic**: https://github.com/HoraApps/LeafPic

一个优质的 Android 开源图片查看 App

<img src="https://raw.githubusercontent.com/HoraApps/LeafPic/master/screenshots/1.png" width="270" /> <img src="https://raw.githubusercontent.com/HoraApps/LeafPic/master/screenshots/5.png" width="270" /> <img src="https://raw.githubusercontent.com/HoraApps/LeafPic/master/screenshots/2.png" width="270" />

---

**MicroReader**: https://github.com/YiuChoi/MicroReader

一个小而美的阅读客户端，包含微信精选，IT之家(去广告),果壳热门，知乎日报，和视频推荐栏目，每天更换主题

<img src="https://raw.githubusercontent.com/YiuChoi/MicroReader/master/screenshot/Screenshot_20160503-085830.png" width="200" /> <img src="https://raw.githubusercontent.com/YiuChoi/MicroReader/master/screenshot/Screenshot_20160503-085853.png" width="200" /> <img src="https://raw.githubusercontent.com/YiuChoi/MicroReader/master/screenshot/Screenshot_20160503-085902.png" width="200" /> <img src="https://raw.githubusercontent.com/YiuChoi/MicroReader/master/screenshot/Screenshot_20160503-085945.png" width="200" />

---

**Bourbon**: https://github.com/hitherejoe/Bourbon

MVP 架构的 Dribbble 客户端，支持 Android Mobile, Tablet, Wear and TV

<img src="https://github.com/hitherejoe/Bourbon/blob/master/images/header.png" width="800" />

---

**sailorcast**: https://github.com/fire3/sailorcast

水手放映室 搜狐 优酷 爱奇艺 乐视 无广告 视频客户端 http://www.sailorcast.com

<img src="https://camo.githubusercontent.com/26c60e27a4c9f228b4a1a9f9ccde66b18200e4b7/687474703a2f2f696d672e77646a696d672e636f6d2f6d6d732f73637265656e73686f742f622f30322f65643265636666373233353866356137653237666434633935623862393032625f3332305f3534362e6a706567" width="270" /> <img src="https://camo.githubusercontent.com/8232e1477f87bf3ff1c8dedbdc93e856b1d894b6/687474703a2f2f696d672e77646a696d672e636f6d2f6d6d732f73637265656e73686f742f392f64332f32343861346466616530366332306231373666616666363361623636636433395f3332305f3534342e6a706567" width="270" /> <img src="https://camo.githubusercontent.com/8589a8a782856ef3178d79b0404c91948cb70f81/687474703a2f2f696d672e77646a696d672e636f6d2f6d6d732f73637265656e73686f742f302f39622f32303166386230363437666165623533326465353637396333623431303962305f3332305f3534352e6a706567" width="270" />

---

**RnRelative**: https://github.com/lishengzxc/RnRelative

ReactNative亲戚称谓计算器

<img src="https://raw.githubusercontent.com/lishengzxc/RnRelative/869c4cd27b92a08ea1d3d37e628354f6a7300932/pic.png" width="320" />

---

**HungerMoji**: https://github.com/mikeroelens/HungerMoji

在通知栏操作的游戏

<img src="https://cloud.githubusercontent.com/assets/7868514/15606990/2076bea2-2442-11e6-96b4-7cce38a41126.png" width="320" />

---

**CallerInfo**: https://github.com/xdtianyu/CallerInfo

一个获取号码归属地和其他信息（诈骗、骚扰等）的开源 Android 应用

<img src="https://raw.githubusercontent.com/xdtianyu/CallerInfo/master/screenshots/1.png" width="270" /> <img src="https://raw.githubusercontent.com/xdtianyu/CallerInfo/master/screenshots/5.png" width="270" /> <img src="https://raw.githubusercontent.com/xdtianyu/CallerInfo/master/screenshots/p-2.png" width="270" />

---

**FriendCircle**: https://github.com/razerdp/FriendCircle

高仿微信朋友圈项目

<img src="https://github.com/razerdp/FriendCirclePreview/raw/master/img/2016-04-21_dot_indicator.gif" width="320" />

---

**DiyCodeForAndroid**: https://github.com/Yasic/DiyCodeForAndroid

Diycode社区Android客户端

<img src="https://camo.githubusercontent.com/28850b86582c5124e106bd4b820dc2e870f82c86/687474703a2f2f646979636f64652e62302e7570616979756e2e636f6d2f70686f746f2f323031362f66343134623730366139343131623434663866363365386530303232303334302e6a7067" width="270" />

---

**TranslateToast**: https://github.com/jiang111/TranslateToast

翻译助手 

<img src="https://raw.githubusercontent.com/jiang111/TranslateToast/master/7.gif" width="320" />

---

**AndroidWeekly**: https://github.com/mzule/AndroidWeekly

A third party app for androidweekly.net

<img src="https://raw.githubusercontent.com/mzule/AndroidWeekly/master/art/article.jpg" width="270" /> <img src="https://raw.githubusercontent.com/mzule/AndroidWeekly/master/art/home.jpg" width="270" /> <img src="https://raw.githubusercontent.com/mzule/AndroidWeekly/master/art/translation.gif" width="270" />

---

**PlayTogether**: https://github.com/Chenantao/PlayTogether

一款以兴趣为驱动的陌生人社交app

<img src="https://raw.githubusercontent.com/Chenantao/PlayTogether/master/screenshot/1.png" width="270" /> <img src="https://raw.githubusercontent.com/Chenantao/PlayTogether/master/screenshot/4.png" width="270" /> <img src="https://raw.githubusercontent.com/Chenantao/PlayTogether/master/screenshot/9.png" width="270" />

---

**Cashew**: https://github.com/wheat7/Cashew

腰果Cashew是一个gank.io的客户端

<img src="https://github.com/wheat7/Cashew/raw/master/screenshots/cashew2.png" width="320" /> <img src="https://github.com/wheat7/Cashew/raw/master/screenshots/cashew8.png" width="320" />

---

**ganguo**: https://github.com/yanyiqun001/ganguo

干果——简洁易用的gank客户端

<img src="https://github.com/yanyiqun001/ganguo/raw/master/screenshots/Screenshot_20170605-165508_%E7%BC%96%E8%BE%91.png?raw=true" width="320" /> <img src="https://github.com/yanyiqun001/ganguo/raw/master/screenshots/Screenshot_20170605-165525_%E7%BC%96%E8%BE%91.png?raw=true" width="320" />

---

**MyGank**: https://github.com/mask-hao/MyGank

一个具有用户登录注册，干货收藏功能的干货集中营第三方客户端。个人学习项目，前端使用Android展示，后端使用javaee中转，数据来源干货集中营

<img src="https://github.com/mask-hao/MyGank/raw/master/screenshot/screenshot1.png" width="320" /> <img src="https://github.com/mask-hao/MyGank/raw/master/screenshot/screenshot4.png" width="320" />

---

**GankGirl**: https://github.com/dalingge/GankGirl

使用Jsoup抓取干货集中营闲读数据, 闲读和gank干货app： http://dalingge.com/2017/05/09/%E4%BD%BF%E7%94%A8Jsoup%E6%8A%93%E5%8F%96%E5%B9%B2%E8%B4%A7%E9%9B%86%E4%B8%AD%E8%90%A5%E9%97%B2%E8%AF%BB%E6%95%B0%E6%8D%AE/

<img src="https://github.com/dalingge/GankGirl/raw/master/screenshots/play.gif" width="320" />

---

**FakeWeather**: https://github.com/li-yu/FakeWeather

『假装看天气』─── 天气预报 & 公交查询 & 资讯阅读 & 妹纸福利 的 Android 客户端

<img src="https://raw.githubusercontent.com/li-yu/FakeWeather/master/screenshot.png" width="640" />

---

**RxGank**: https://github.com/sfsheng0322/RxGank

干货集中营Android客户端

<img src="https://raw.githubusercontent.com/sfsheng0322/RxGank/master/res/RxGank.gif" width="320" />

---

**FlipGank**: https://github.com/yiyuanliu/FlipGank

FlipBoard 翻页风格的 Gank.io 客户端

<img src="https://raw.githubusercontent.com/yiyuanliu/FlipGank/master/images/screenshot3.png" width="320" /><img src="https://raw.githubusercontent.com/yiyuanliu/FlipGank/master/images/screenshot4.png" width="320" />

---

**StudyProject**: https://github.com/HotBitmapGG/StudyProject

A Material Design style Gank. Io unofficial client App

<img src="https://raw.githubusercontent.com/HotBitmapGG/StudyProject/master/art/01.png" width="320" /><img src="https://raw.githubusercontent.com/HotBitmapGG/StudyProject/master/art/08.png" width="320" />

---

**react-native-Gank**: https://github.com/wangdicoder/react-native-Gank

主题换色，夜间模式，省流量策略。。。这可能是最友好的Gank.io(干货集中营)客户端了

<img src="https://raw.githubusercontent.com/wangdicoder/react-native-Gank/master/screenshot/discoverytab.png" width="320" /><img src="https://raw.githubusercontent.com/wangdicoder/react-native-Gank/master/screenshot/theme.gif" width="320" />

---

**UGank**: https://github.com/Bakumon/UGank

有干货」—— 体验别具一格的 Gank.io Android 客户端 http://bakumon.me/UGank/

<img src="https://raw.githubusercontent.com/Bakumon/UGank/master/art/ugank2.png" width="600" />

---

**Gank**: https://github.com/JohnnyShieh/Gank

An unofficial client of gank.io, based on Flux pattern and Rx series

<img src="https://raw.githubusercontent.com/JohnnyShieh/Gank/master/screenshots/navigation.jpg" width="270" /> <img src="https://raw.githubusercontent.com/JohnnyShieh/Gank/master/screenshots/android.jpg" width="320" />

---

**GankGirl**: https://github.com/gaolonglong/GankGirl

RxJava+Retrofit+Glide构建的gank.io第三方客户端，包含妹子图和技术干货等

<img src="https://github.com/gaolonglong/GankGirl/raw/master/Screenshot/666.gif" width="320" /> <img src="https://raw.githubusercontent.com/gaolonglong/GankGirl/master/Screenshot/33.png" width="320" />

---

**GanHuoIO**: https://github.com/burgessjp/GanHuoIO

基于Gank.IO提供的API的第三方客户端 http://www.jianshu.com/p/3f137269a942

<img src="https://camo.githubusercontent.com/5ad3bf82cd132c12bb5690f17c72583e23478247/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f3632333530342d343363393063343933393463326233642e6769663f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970" width="320" />

---

**干·妹纸 (Gān Mèizhi) GankMeizhi**: https://github.com/xingrz/GankMeizhi

只是一个业余的 Android 项目而已

<img src="https://github.com/xingrz/GankMeizhi/raw/master/screenshots/1.jpg" width="320" />

---

**Meizhi**: [https://github.com/drakeet/Meizhi](https://github.com/drakeet/Meizhi)

gank.io unofficial client, RxJava & Retrofit

<img src="https://github.com/drakeet/Meizhi/blob/master/screenshots/s0.png" width="160" />
<img src="https://github.com/drakeet/Meizhi/blob/master/screenshots/s7.jpg" width="160" />
<img src="https://github.com/drakeet/Meizhi/blob/master/screenshots/s5.png" width="160" />
<img src="https://github.com/drakeet/Meizhi/blob/master/screenshots/s8.png" width="160" />
<img src="https://github.com/drakeet/Meizhi/blob/master/screenshots/s9.png" width="160" />

---

**RealStuff**: https://github.com/IvorHu/RealStuff

一个看妹纸与开发资讯的Android APP，具有本地缓存、分享与添加收藏的功能，新手向大神学习的练手项目，来自代码家的API http://gank.io

<img src="https://raw.githubusercontent.com/IvorHu/RealStuff/master/screenshoots/clearCache.png" width="320" /> <img src="https://raw.githubusercontent.com/IvorHu/RealStuff/master/screenshoots/navigation.png" width="320" /> <img src="https://raw.githubusercontent.com/IvorHu/RealStuff/master/screenshoots/about.png" width="320" />

---

**GankDaily**: https://github.com/maoruibin/GankDaily

每日提供技术干货的App

<img src="https://github.com/maoruibin/GankDaily/blob/master/art/gank_introduce.png" width="480"/>

---

**GankMM**: https://github.com/maning0303/GankMM

干货集中营提供的API，有美女福利图片，Android，IOS，前端，APP等资源。

<img src="https://raw.githubusercontent.com/maning0303/GankMM/master/screenshots/gank_day_01.jpg" width="300"/> <img src="https://raw.githubusercontent.com/maning0303/GankMM/master/screenshots/gank_night_03.jpg" width="300"/>

---

**ComicReader**: [https://github.com/android-cjj/ComicReader](https://github.com/android-cjj/ComicReader)

漫画阅读器 ComicReader

<img src="https://camo.githubusercontent.com/e43d83c43fdbefe9a41582cf676c6d792df09d58/687474703a2f2f7777772e61706b6275732e636f6d2f646174612f6174746163686d656e742f666f72756d2f3230313530342f31342f30393136303165626f783975747a6d39663931316d632e706e67" width="320" />
<img src="https://camo.githubusercontent.com/e5851858c3e548a46604f950a38f6617d310cc63/687474703a2f2f7777772e61706b6275732e636f6d2f646174612f6174746163686d656e742f666f72756d2f3230313530342f31342f3039333135356f7275736d6477756a6d7661347576772e706e67" width="320" />

---

**AnExplorer**: https://github.com/1hakr/AnExplorer

Another Android Explorer ( File Manager ) is an All-in-One Open source file manager

<img src="https://raw.githubusercontent.com/1hakr/AnExplorer/master/header.jpg" width="640" />

---

**AmazeFileManager**: https://github.com/arpitkh96/AmazeFileManager

一个很精美的文件管理器

<img src="https://lh3.googleusercontent.com/Yu5NTq5Tt74ZEdZ2lUEd2ctxM_8XmY5fbMIKGR4w18D5sz01DOGt9WcUP9jqTS8gEaU=h900-rw" width="320" />
<img src="https://lh3.googleusercontent.com/wWa9VIanEJFgH7mKU693A6PoGASvc_qfytXd7yH8t4OYp7LHDSLZflhsFOiSIOf2OBVq=h900-rw" width="320" />

---

**FileExplorer**: https://github.com/jp1017/FileExplorer

MIUI开源的文件管理器

<img src="https://cloud.githubusercontent.com/assets/7868514/15324122/bf13f7f0-1c77-11e6-850b-8539aff3e065.png" width="320" /> 
<img src="https://cloud.githubusercontent.com/assets/7868514/15324123/bf462284-1c77-11e6-8c0e-f23de968756c.png" width="320" />

---

**AndroidTVLauncher**: https://github.com/JackyAndroid/AndroidTVLauncher

This is a better android-tv-launcher,it can running on the tv box.Build with gradle.

<img src="https://raw.githubusercontent.com/JackyAndroid/AndroidTVLauncher/master/screenshots/design_sketch1.png" width = "400"/> <img src="https://raw.githubusercontent.com/JackyAndroid/AndroidTVLauncher/master/screenshots/design_sketch5.png" width = "400"/>

---

**murmur**: https://github.com/nekocode/murmur

豆瓣电台第三方客户端

![1](https://github.com/nekocode/murmur/blob/master/art/screenshot1.png) ![2](https://github.com/nekocode/murmur/blob/master/art/screenshot2.png) ![3](https://github.com/nekocode/murmur/blob/master/art/screenshot3.png)

---

**TLint**: https://github.com/gzsll/TLint

TLint for 虎扑体育 基于Dagger2+RxJava+Retrofit开发，采用MVP模式

<img src="https://raw.githubusercontent.com/gzsll/TLint/master/resource/Screenshot1.png" width="320" />
<img src="https://raw.githubusercontent.com/gzsll/TLint/master/resource/Screenshot8.png" width="320" />

---

**Joker**: https://github.com/ColorfulCat/Joker

基于糗事百科接口数据的Android客户端，简单版的，有图文笑话，蹲厕所的时候可以看看 0 - 0 ~~(14年6月份写的，相对有点旧~)

<img src="https://github.com/ColorfulCat/Joker/blob/master/img1.png" width="320" />
<img src="https://github.com/ColorfulCat/Joker/blob/master/img2.png" width="320" />

---

**plaid**: https://github.com/nickbutcher/plaid

5.0 MD 设计强大demo

<img src="https://github.com/nickbutcher/plaid/blob/master/screenshots/plaid_demo.gif" width="320" />

---

**mr-mantou-android**: [https://github.com/oxoooo/mr-mantou-android](https://github.com/oxoooo/mr-mantou-android)

On the importance of taste [http://www.oxo.ooo](http://www.oxo.ooo)

<img src="https://github.com/oxoooo/mr-mantou-android/raw/master/promo.jpg" width="640" />

---

**GithubTrends**: [https://github.com/laowch/GithubTrends](https://github.com/laowch/GithubTrends)

It's a GitHub Trending repositories Viewer with Material Design.

<img src="https://github.com/laowch/GithubTrends/blob/master/screenshot/1.png" width="160" />
<img src="https://github.com/laowch/GithubTrends/blob/master/screenshot/4.png" width="160" />
<img src="https://github.com/laowch/GithubTrends/blob/master/screenshot/3.png" width="160" />
<img src="https://github.com/laowch/GithubTrends/blob/master/screenshot/5.png" width="160" />

---

**githot**: [https://github.com/andyiac/githot](https://github.com/andyiac/githot)

GitHot is an Android App that will help you to find the world most popular project and person [http://githot.cn](http://githot.cn)

<img src="https://camo.githubusercontent.com/09fe36eb9e84d6111b99db6fbb9872cea2c0be64/687474703a2f2f666972696d672e6669722e696d2f333935653062383864656664663662336339363535336535376233666461376164303061366231623f696d61676556696577322f302f772f3432362f682f323430" width="160" />
<img src="https://camo.githubusercontent.com/830427f7e9fcb4aa248730d7d0cf7f0f8d5797c9/687474703a2f2f666972696d672e6669722e696d2f656465356435313066626237303232633336396436343834366135353033396232333066613635353f696d61676556696577322f302f772f3432362f682f323430" width="160" />
<img src="https://camo.githubusercontent.com/95410f2c60b39ff3affbc1ef3676639039adb2c3/687474703a2f2f666972696d672e6669722e696d2f323939636262373538343766626564643730316334336433623530323532316132663239303863613f696d61676556696577322f302f772f3432362f682f323430" width="160" />
<img src="https://camo.githubusercontent.com/599fceab8968549051232f925347c3f4c6f30b29/687474703a2f2f666972696d672e6669722e696d2f323631383432646166326364336332646638353537663566623630323463616532613961663038633f696d61676556696577322f302f772f3432362f682f323430" width="160" />

---

**jianshi**: [https://github.com/wingjay/jianshi](https://github.com/wingjay/jianshi)

A Full-Stack mobile app, including Android & Server, Simple-Poem 简诗. You can write poem in graceful & traditional Chinese style

<img src="https://camo.githubusercontent.com/b5cd7b49447c88ceac096b4e969b8c1b94f3b10a/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f3238313636352d623563343465393034323639376539332e706e673f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970253743696d61676556696577322f322f772f31323430" width="320" />
<img src="https://camo.githubusercontent.com/3f9940a080521d28fa2ad1e6bc40c25d104f411f/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f3238313636352d613539613063336165326532616630342e706e673f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970253743696d61676556696577322f322f772f31323430" width="320" />

---

**KuaiChuan**: https://github.com/mayubao/KuaiChuan

仿茄子快传的一款文件传输应用

<img src="https://raw.githubusercontent.com/mayubao/KuaiChuan/master/ScreenShot/home.gif" width="320" /> <img src="https://raw.githubusercontent.com/mayubao/KuaiChuan/master/ScreenShot/fr_1.gif" width="320" />

---

**AnyShareOfAndroid**: [https://github.com/gpfduoduo/AnyShareOfAndroid](https://github.com/gpfduoduo/AnyShareOfAndroid)

西瓜快传 仿照市场上的茄子快传 或者 360文件传输 在局域网内，如果没有局域网，接收方建立热点，发送发接入热点，进行文件（发送方的app、音视频、图片等文件）

<img src="https://github.com/gpfduoduo/AnyShareOfAndroid/blob/master/filetransfer.gif" width="320" />

---

**Conquer**: [https://github.com/hanks-zyh/Conquer](https://github.com/hanks-zyh/Conquer)

A todo list app base Material Design

<img src="https://github.com/hanks-zyh/Conquer/blob/master/Screenshot/demo.gif" width="180" />
<img src="https://github.com/hanks-zyh/Conquer/blob/master/Screenshot/demo2.gif" width="180" />
<img src="https://github.com/hanks-zyh/Conquer/blob/master/Screenshot/s0.png" width="180" />
<img src="https://github.com/hanks-zyh/Conquer/blob/master/Screenshot/s2.png" width="180" />

---

**MLManager**: https://github.com/javiersantos/MLManager

MD风格的用于传送、提取APK文件(包含系统apk)的开源工具软件

<img src="https://raw.githubusercontent.com/javiersantos/MLManager/master/Screenshots/header-basic.png" width="640" />

---

**AppPlus**: [https://github.com/maoruibin/AppPlus](https://github.com/maoruibin/AppPlus)

App+是一个MD风格的用于传送、提取APK文件的开源工具软件。[http://fir.im/appplus](http://fir.im/appplus)

<img src="https://github.com/maoruibin/AppPlus/blob/master/art/index.png" width="270" />
<img src="https://github.com/maoruibin/AppPlus/blob/master/art/setting.png" width="270" />
<img src="https://github.com/maoruibin/AppPlus/blob/master/art/theme.png" width="270" />

---

**SimplifyReader**: [https://github.com/SkillCollege/SimplifyReader](https://github.com/SkillCollege/SimplifyReader)

一款基于Google Material Design设计开发的Android客户端，包括新闻简读，图片浏览，视频爽看 ，音乐轻听以及二维码扫描五个子模块。项目采取的是MVP架构开发，由于还是摸索阶段，可能不是很规范。但基本上应该是这么个套路，至少我个人认为是这样的~恩，就是这样的！

<img src="https://raw.githubusercontent.com/SkillCollege/server/master/SimplifyReader/images/project.gif" width="320" />
<img src="https://raw.githubusercontent.com/SkillCollege/server/master/SimplifyReader/images/qrcode.gif" width="320" />
<img src="https://raw.githubusercontent.com/SkillCollege/server/master/SimplifyReader/images/all_in_one.jpg" width="640" />

---

**ZhiHuDaily-React-Native**: https://github.com/race604/ZhiHuDaily-React-Native

A Zhihu Daily(http://daily.zhihu.com/) App client implemented using React Native (Android and iOS).

<img src="https://github.com/race604/ZhiHuDaily-React-Native/blob/master/art/home1.jpg" width="260" />
<img src="https://github.com/race604/ZhiHuDaily-React-Native/blob/master/art/drawer.jpg" width="260" />
<img src="https://github.com/race604/ZhiHuDaily-React-Native/blob/master/art/content.jpg" width="260" />

---

**ToolWizAppLock**: https://github.com/Toolwiz/ToolWizAppLock

Smart App Lock for Android http://www.toolwiz.com/

<img src="https://github.com/Toolwiz/ToolWizAppLock/blob/master/img/5.pic_hd.jpg" width="260" />
<img src="https://github.com/Toolwiz/ToolWizAppLock/blob/master/img/6.pic_hd.jpg" width="260" />
<img src="https://github.com/Toolwiz/ToolWizAppLock/blob/master/img/7.pic_hd.jpg" width="260" />

---

**archi**: https://github.com/ivacf/archi

Repository that showcases 3 Android app architectures: "Standard Android", MVP and MVVM. The exact same app is built 3 times following the different patterns.

<img src="https://github.com/ivacf/archi/blob/master/images/archi-screenshots.png" width="320" />
<img src="https://github.com/ivacf/archi/blob/master/images/archi-screenshots.png" width="320" />

---

**Clip-Stack**: https://github.com/heruoxin/Clip-Stack

An Android clipboard history manager app with Material Design.

<img src="https://camo.githubusercontent.com/0c552441a9ec2c0c1c9522c1ebb378ae86dd55a4/687474703a2f2f7777342e73696e61696d672e636e2f6c617267652f36366361623336386777316570336b69366f34797a6a3231657130683637616d2e6a7067" width="640" />

---      

**pocket-note-android**: https://github.com/channguyen/pocket-note-android

PocketNote is a simple note application for Android with many useful utilities

<img src="https://raw.githubusercontent.com/channguyen/pocket-note-android/master/appstore/sc1.png" width="320" />
<img src="https://raw.githubusercontent.com/channguyen/pocket-note-android/master/appstore/sc4.png" width="320" />

---

**WeGit**: https://github.com/Leaking/WeGit

An Android App for Github

<img src="https://github.com/Leaking/GithubKnife/blob/master/screenshot/git1.pic.jpg" width="320" />
<img src="https://github.com/Leaking/GithubKnife/blob/master/screenshot/git3.pic.jpg" width="320" />

---

**Protein**: https://github.com/gejiaheng/Protein

目前最漂亮的一个 Dribbble 客户端

<img src="https://github.com/gejiaheng/Protein/raw/master/image/screenshot_main.png" width="320" /> <img src="https://github.com/gejiaheng/Protein/raw/master/image/screenshot_shot.png" width="320" />

---

**Watch**: https://github.com/tuesda/Watch

dribbble 客户端

<img src="https://github.com/tuesda/Watch/raw/master/animation/home.gif" width="320" /> <img src="https://github.com/tuesda/Watch/raw/master/animation/page.gif" width="320" />

---

**StickerCamera**: https://github.com/Skykai521/StickerCamera

This is an Android application with camera,picture cropping,collage sticking and tagging.贴纸标签相机,功能:拍照,相片裁剪,给图片贴贴纸,打标签。

<img src="https://github.com/Skykai521/StickerCamera/blob/master/screenshot/Screenshot_01.gif" width="320" />
<img src="https://github.com/Skykai521/StickerCamera/blob/master/screenshot/Screenshot_2015-07-19-11-23-22.png" width="320" />

---

**JianDan**: https://github.com/ZhaoKaiQiang/JianDan

高仿煎蛋客户端

<img src="https://github.com/ZhaoKaiQiang/JianDan/blob/master/images/demo.gif" width="320" />

---

**JianDanRxJava**: https://github.com/ZhaoKaiQiang/JianDanRxJava

使用Rxjava重构煎蛋高仿

---

**v2ex-android**: https://github.com/CzBiX/v2ex-android

V2EX client for Android

---

**v2ex-android**: https://github.com/greatyao/v2ex-android/

掌上V2EX

---            

**AisenWeiBo**: https://github.com/wangdan/AisenWeiBo

新浪微博第三方Android客户端

<img src="https://github.com/wangdan/AisenWeibo/raw/master/resource/aisen1.gif" width="320" />
<img src="https://github.com/wangdan/AisenWeibo/raw/master/resource/aisen2.gif" width="320" />

---            

**SmsCodeHelper**: https://github.com/drakeet/SmsCodeHelper

A very beautiful and easy to use app: "SmsCodeHelper" (verification code helper), light, open source, it can automatically copy the code to the user's clipboard, when the user receives the message verification code. Material Design and open source: http://fir.im/codehelper (or Google Play "SmsCodeHelper")

<img src="https://github.com/drakeet/SmsCodeHelper/blob/master/screenshots/s1.png" width="320" />
<img src="https://github.com/drakeet/SmsCodeHelper/blob/master/screenshots/s2.png" width="320" />

---            

**wechat**: https://github.com/motianhuo/wechat

A High Copy WeChat ,SNS APP (高仿微信)

<img src="https://camo.githubusercontent.com/c750362668db529cb1bf27a1f5698e4e8ca8df52/687474703a2f2f7777332e73696e61696d672e636e2f626d6964646c652f36373035353637656777316574386663336d3068746a32306d38307a6b7462642e6a7067" width="160" />
<img src="https://camo.githubusercontent.com/95e3879860097dfc83acd66a80576547ceb8a5a5/687474703a2f2f7777342e73696e61696d672e636e2f626d6964646c652f363730353536376567773165746767616139756b666a32306d38307a6b3076722e6a7067" width="160" />
<img src="https://camo.githubusercontent.com/af997b2ef0ff4f63db8516b6ad06e3cfe8da4bd4/687474703a2f2f7777342e73696e61696d672e636e2f626d6964646c652f3637303535363765677731657467676162666475726a32306d38307a6b7462352e6a7067" width="160" />
<img src="https://camo.githubusercontent.com/002c9a612fa76486cf6627ebddc9021779a6acbb/687474703a2f2f7777332e73696e61696d672e636e2f626d6964646c652f363730353536376567773165743866386f38746b706a32306d38307a6b6469372e6a7067" width="160" />

---            

**Notes**: https://github.com/lguipeng/Notes

Material Design Notes App

<img src="https://github.com/lguipeng/Notes/blob/master/screenshot/screenshot_1.png" width="160" />
<img src="https://github.com/lguipeng/Notes/blob/master/screenshot/screenshot_2.png" width="160" />
<img src="https://github.com/lguipeng/Notes/blob/master/screenshot/screenshot_3.png" width="160" />
<img src="https://github.com/lguipeng/Notes/blob/master/screenshot/screenshot_5.png" width="160" />
<img src="https://github.com/lguipeng/Notes/blob/master/screenshot/screenshot_4.png" width="160" />

---              

**hubble_gallery**: https://github.com/derekcsm/hubble_gallery

[Android App] View, Save, and Read about Hubble's best images. https://play.google.com/store/apps/details?id=com.derek_s.hubble_gallery

<img src="http://www.jcodecraeer.com/uploads/150606/1-150606011411U9.png" width="320" />

---

**DoubanMovie-React-Native**:  https://github.com/fengjundev/DoubanMovie-React-Native

 DoubanMovie made with React Native

<img src="https://github.com/fengjundev/DoubanMovie-React-Native/blob/master/screenshot/3.png" width="320" />
<img src="https://github.com/fengjundev/DoubanMovie-React-Native/blob/master/screenshot/7.png" width="320" />

---

**RxWeather**:  https://github.com/SmartDengg/RxWeather

 Architecting Android with RxJava

<img src="http://www.jcodecraeer.com/uploads/151111/1-151111021103G4.gif" width="320" />

---

**Sky31Radio**:  https://github.com/linroid/Sky31Radio

 湘潭大学三翼校园"四季电台" Android客户端 http://linroid.com/2015/02/11/sky31radio/

<img src="https://github.com/linroid/Sky31Radio/blob/master/screenshots/device-2015-01-22-224854.png" width="270" />
<img src="https://github.com/linroid/Sky31Radio/blob/master/screenshots/device-2015-01-22-224820.png" width="270" />
<img src="https://github.com/linroid/Sky31Radio/blob/master/screenshots/device-2015-02-07-141957.png" width="270" />

---

**BlackLight**:  https://github.com/PaperAirplane-Dev-Team/BlackLight

 A light Sina Weibo client for Android 新浪微博客户端

---

**MobileGuard**: https://github.com/ittianyu/MobileGuard

一款比较完整的 Android 安全管理 App

<img src="https://raw.githubusercontent.com/ittianyu/MobileGuard/master/read_me_images/anti-virus.gif" width="270" />
<img src="https://raw.githubusercontent.com/ittianyu/MobileGuard/master/read_me_images/clear_cache.gif" width="270" />
<img src="https://raw.githubusercontent.com/ittianyu/MobileGuard/master/read_me_images/msg_safe.gif" width="270" />

---

**superCleanMaster**: https://github.com/joyoyao/superCleanMaster

一键清理 开源版，包括内存加速，缓存清理，自启管理，软件管理等。

<img src="https://github.com/joyoyao/superCleanMaster/blob/master/screenshot/home.jpg" width="200" />
<img src="https://github.com/joyoyao/superCleanMaster/blob/master/screenshot/1.jpg" width="200" />
<img src="https://github.com/joyoyao/superCleanMaster/blob/master/screenshot/2.jpg" width="200" />
<img src="https://github.com/joyoyao/superCleanMaster/blob/master/screenshot/3.jpg" width="200" />

---

**ZhuanLan**: https://github.com/bxbxbai/ZhuanLan

一个知乎专栏App

<img src="https://raw.githubusercontent.com/bxbxbai/ZhuanLan/master/images/home.png" width="320" />
<img src="https://raw.githubusercontent.com/bxbxbai/ZhuanLan/master/images/list.png" width="320" />

---

**Qiitanium**: https://github.com/ogaclejapan/Qiitanium

Qiitanium is an unofficial Android application of Qiita

<img src="https://raw.githubusercontent.com/ogaclejapan/Qiitanium/master/art/qiitanium.gif" width="320" />

---

**LaunchEnr**: https://github.com/enricocid/LaunchEnr

一个简单好看的 Android Launcher

<img src="https://raw.githubusercontent.com/enricocid/LaunchEnr/master/art2_0.png" width="600"/>

---

**KISS**: https://github.com/Neamar/KISS

轻量的安卓桌面

---

**Lawnchair**: https://github.com/Deletescape-Media/Lawnchair

一个优雅的 Android Launcher

---

**Launcher3**: https://github.com/fookwood/Launcher3

更改官方的Launcher3使得可以在Android Studio编译 http://www.fookwood.com/android

---

**Remindly**: https://github.com/blanyal/Remindly

Remindly is a simple and user friendly application to create reminders. https://play.google.com/store/apps/details?id=com.blanyal.remindly

<img src="https://github.com/blanyal/Remindly/blob/master/screenshots/screenshot1.png" width="270" />
<img src="https://github.com/blanyal/Remindly/blob/master/screenshots/screenshot2.png" width="270" />
<img src="https://github.com/blanyal/Remindly/blob/master/screenshots/screenshot3.png" width="270" />

---

**Leisure**: https://github.com/MummyDing/Leisure

 Leisure is an Android App,it contains Zhihu Daily,Guokr Scientific,XinhuaNet News and Douban

<img src="https://github.com/MummyDing/Leisure/blob/master/ScreenShots/home.png" width="320" /> <img src="https://github.com/MummyDing/Leisure/blob/master/ScreenShots/science.png.png" width="320" />

---

**ganchai**:  https://github.com/openproject/ganchai

干柴（客户端、服务端），专注于Android干货资源

<img src="https://camo.githubusercontent.com/8339e46ede8f34532f3fc1bf3d1ca99ef56b460c/687474703a2f2f37786b73706b2e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f53637265656e73686f745f323031352d30382d32382d30392d35312d32312e706e673f696d6167654d6f6772322f7468756d626e61696c2f21333070" width="210" /> <img src="https://camo.githubusercontent.com/87c56d95476213f6a43637174ab727d1fb60632e/687474703a2f2f37786b73706b2e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f53637265656e73686f745f323031352d30382d32382d30392d35322d33362e706e673f696d6167654d6f6772322f7468756d626e61696c2f21333070" width="210" />

---

**Android-LockScreenSample-DisableHomeButtonKey**:  https://github.com/DUBULEE/Android-LockScreenSample-DisableHomeButtonKey

Android LockScreen Sample Using Service - Disable HomeButton or HomeKey

<img src="https://github.com/DUBULEE/Android-LockScreenSample-DisableHomeButtonKey/blob/master/rawimg/softkey_unlock_lg.gif" width="320" />

---

**RoboBinding-gallery**:  https://github.com/RoboBinding/RoboBinding-gallery

An android app to showcase the usage of `RoboBinding framework`. http://robobinding.org

---

**AnotherMonitor**:  https://github.com/AntonioRedondo/AnotherMonitor

Monitors and records the CPU and memory usage of Android devices https://play.google.com/store/apps/details?id=org.anothermonitor

<img src="https://camo.githubusercontent.com/e8a643e7373bfa716cc54ac949a12c6c760639c9/68747470733a2f2f6c68342e67677068742e636f6d2f6766774d683449683056443041617849385f656831316d364352755f7a5357362d5536463235416a43646c556a436b6c69574842674a4d684462336550646c5f454d6f54" width="320" />

---

**AcDisplay**:  https://github.com/AChep/AcDisplay

AcDisplay is a new way of handling `notifications` in Android. http://acdisplay.org

<img src="https://raw.githubusercontent.com/AChep/AcDisplay/master/screenshots/screenshot1.png" width="320" /> <img src="https://raw.githubusercontent.com/AChep/AcDisplay/master/screenshots/screenshot2.png" width="320" />

---

**JNote**:  https://github.com/Jhuster/JNote

一款支持部分Markdown语法的轻量级便签软件。

<img src="https://camo.githubusercontent.com/64ce94121986c97d46b86126b8bdfe7eeaa0321c/687474703a2f2f7777772e6a6875737465722e636f6d2f6170702f4a4e6f74652f686f6d652e706e67" width="320" />

---

**EWeightScale**:  https://github.com/Jhuster/EWeightScale

一款可以记录和查询体重的应用 http://ticktick.blog.51cto.com/823160/1687127

<img src="https://camo.githubusercontent.com/986d85bf34d63c5a9091ad63e68950f73ab865fe/687474703a2f2f7777772e6a6875737465722e636f6d2f6170702f455765696768745363616c652f686f6d652e706e67" width="320" />

---

**SimpleNews**:  https://github.com/liuling07/SimpleNews

基于Material Design和MVP的新闻客户端

<img src="https://raw.githubusercontent.com/liuling07/SimpleNews/master/screenshot/news.png" width="320" />

---

**NBAPlus**:  https://github.com/SilenceDut/NBAPlus

A concise APP about NBA News and Event with RxJava and EventBus http://fir.im/nbaplus

<img src="https://github.com/SilenceDut/NBAPlus/blob/master/screenshot/1.png" width="400" /> <img src="https://github.com/SilenceDut/NBAPlus/blob/master/screenshot/2.png" width="400" />

---

**MaterialLife**:  https://github.com/juankysoriano/MaterialLife

A Material Design styled Game of Life for Android

<img src="https://camo.githubusercontent.com/3192f67d306cb3fed97c79e4719cf8c3809561e3/687474703a2f2f73382e706f7374696d672e6f72672f787770726d71706d642f6465766963655f636f70792e706e67" width="320" />

---

**CoCoin**:  https://github.com/Nightonke/CoCoin

CoCoin是一款记账APP，有记账、多种方式显示支出占比和支出变化、云同步、智能提醒等功能。

<img src="https://github.com/Nightonke/CoCoin/blob/master/Gif/%E8%AE%B0%E5%BD%95.gif" width="320" />

---

**growth**:  https://github.com/phodal/growth

一个帮你成为顶尖开发者的APP http://www.growth.ren/

<img src="https://raw.githubusercontent.com/phodal/growth/master/marketing/1.pic.jpg" width="320" /> <img src="https://raw.githubusercontent.com/phodal/growth/master/marketing/2.pic.jpg" width="320" />

---

**RxZhiHu**: https://github.com/HotBitmapGG/RxZhiHu

高仿系列の知了日报App

<img src="https://raw.githubusercontent.com/HotBitmapGG/RxZhiHu/master/art/02.png" width="320" /> <img src="https://raw.githubusercontent.com/HotBitmapGG/RxZhiHu/master/art/11.png" width="320" />

---

**ZhihuDailyRRD**:  https://github.com/lsxiao/ZhihuDailyRRD

知乎日报，created by RRD(Retrofit,RxJava,Dagger2)

<img src="https://github.com/lsxiao/ZhihuDailyRRD/raw/master/demo.gif?raw=true" width="320" />

---

**ILOVEYOU**:  https://github.com/androidmalin/ILOVEYOU

HTML5-love-you安卓端app

<img src="https://github.com/androidmalin/ILOVEYOU/blob/master/screenshots/goodimg.gif" width="320" />

---

**ScreenLocker**:  https://github.com/Rogero0o/ScreenLocker

Mr. lock screen is a simple, cool lock screen software, the ability to provide custom cool lock screen for the user

<img src="https://github.com/Rogero0o/ScreenLocker/blob/master/images/1.gif" width="320" />

---

**WallpaperStore**:  https://github.com/zzhoujay/WallpaperStore

完全使用Kotlin开发的一个壁纸应用

<img src="https://github.com/zzhoujay/WallpaperStore/blob/master/image/image_1.jpg" width="320" /> <img src="https://github.com/zzhoujay/WallpaperStore/blob/master/image/image_2.jpg" width="320" />

---

**banya**: https://github.com/forezp/banya

瓣呀，一个非官方的豆瓣app

<img src="https://raw.githubusercontent.com/forezp/banya/master/art/1.jpg" width="270" /> <img src="https://raw.githubusercontent.com/forezp/banya/master/art/6.jpg" width="270" /> <img src="https://raw.githubusercontent.com/forezp/banya/master/art/10.jpg" width="270" />

---

**Douya**: https://github.com/DreaminginCodeZH/Douya

开源的 Material Design 豆瓣客户端（A Material Design app for douban.com）

<img src="https://github.com/DreaminginCodeZH/Douya/blob/master/screenshot/00-main.png" width="320" /> <img src="https://github.com/DreaminginCodeZH/Douya/blob/master/screenshot/01-immersive.jpg" width="320" />

---

**SimpleNews.io**: https://github.com/whiskeyfei/SimpleNews.io

A news App,based on the Material Design and RxJava 、MVP、Component Module. 基于 Material Design 、MVP、RxJava 、Android 组件化的新闻客户端

本代码库借鉴了[SimpleNews](https://github.com/liuling07/SimpleNews)，上面也有原库的介绍，在原来得基础上，修改了较多内容，目前除了一些 tab 切换及 UI 使用原 SimpleNews 逻辑，架构和数据方面基本上已经完全被修改。
Change as follows:

- [x] change the data interface.
- [x] change switch fragment mechanism.
- [x] change mvc mechanism separate ui and logic.
- [x] clear the useless code and liarary and ui resourses.
- [x] add gradle build apk release version.
- [x] add BaseActivity for eventBus.


<img src="http://7xol9p.com1.z0.glb.clouddn.com/github_news.gif" width="320" />

---

