# AndroidLibs == 图片 Image

包含：图片加载框架ImageLoader、自定义图片、裁剪Crop、形状Shape、人脸识别、相机……

[<==返回首页==](https://github.com/XXApple/AndroidLibs)

---

**Matisse**: https://github.com/zhihu/Matisse

一个能带进度条的图片框架，同时有身份标识动能，简单易用

| Zhihu Style                    | Dracula Style                     | Preview                          |
|:------------------------------:|:---------------------------------:|:--------------------------------:|
|![](https://github.com/zhihu/Matisse/blob/master/image/screenshot_zhihu.png) | ![](https://github.com/zhihu/Matisse/blob/master/image/screenshot_dracula.png) | ![](https://github.com/zhihu/Matisse/blob/master/image/screenshot_preview.png)|

---

**Rajawali: https://github.com/Rajawali/Rajawali

Android OpenGL ES 2.0/3.0 Engine

---

**sketch: https://github.com/panpf/sketch

Sketch 是 Android 上一个强大且全面的图片加载器，支持 GIF，手势缩放以及分块显示超大图片

---

**Diooto: https://github.com/moyokoo/Diooto

微博,微信图库效果,微信视频拖放效果,适配状态栏 、屏幕旋转 、全屏 、长图、GIF、视频

<img src="https://github.com/moyokoo/Media/raw/master/diooto3.gif?raw=true" width="320"/> <img src="https://github.com/moyokoo/Media/raw/master/diooto1.gif?raw=true" width="320"/>

---

**android-face-detector: https://github.com/husaynhakeem/android-face-detector

实时人脸检测

<img src="https://github.com/husaynhakeem/android-face-detector/blob/master/app/art/demo.jpg" width="400"/>

---

**AndroidFaceDetection: https://github.com/lchad/AndroidFaceDetection

Android 平台进行人脸检测的几种方案

---

**CVScanner: https://github.com/Credntia/CVScanner

An OpenCV based library for Android to scan ID documents or Passports

---

**pesdk-android-demo: https://github.com/imgly/pesdk-android-demo

图片编辑sdk使用demo

---

**litho-glide: https://github.com/pavlospt/litho-glide

litho-glide

---

**LoTiny: https://github.com/Sunzxyong/Tiny

图片压缩 http://zhengxiaoyong.me/2017/04/23/Android%E5%9B%BE%E7%89%87%E5%8E%8B%E7%BC%A9%E6%A1%86%E6%9E%B6-Tiny/

---

**ImageLoaderFramework: https://github.com/ladingwu/ImageLoaderFramework

打造统一的图片加载框架，融合Glide，Fresco,不入侵业务代码

---

**CameraView: https://github.com/natario1/CameraView

A well documented, high-level Android interface that makes capturing pictures and videos easy, addressing most of the common issues and needs

<img src="https://github.com/natario1/CameraView/raw/master/art/screen1.png" width="300"/> <img src="https://github.com/natario1/CameraView/raw/master/art/screen2.png" width="300"/>

---

**ContinuousScrollableImageView: https://github.com/Cutta/ContinuousScrollableImageView

支持持续性滑动动画的图片组件，用来做背景效果 应该不错

<img src="https://raw.githubusercontent.com/Cutta/ContinuousScrollableImageView/master/gifs/plane.gif?token=AGY3KeydGmvTnBrToMTTuw4wsIpyS9Dzks5ZpH9hwA%3D%3D" width="300"/>

---

**transitional-imageview: https://github.com/MostafaAryan/transitional-imageview

This is an imageView which implements shared element transition pattern on your desired image

<img src="https://github.com/MostafaAryan/transitional-imageview/raw/master/app/src/main/res/drawable/shoe_app_demo.gif?raw=true" width="300"/>

---

**AiyaEffectsAndroid: https://github.com/aiyaapp/AiyaEffectsAndroid

宝宝特效 SDK Android Demo，支持美颜，3D特效，3D动画特效，2D特效等，免费使用

<img src="https://raw.githubusercontent.com/aiyaapp/AiyaEffectsAndroid/master/doc/summarize2.jpg" width="600"/>

---

**diagonal-imageview: https://github.com/santalu/diagonal-imageview

A simple imageview which allows you to create diagonal cut views easily

<img src="https://github.com/santalu/diagonal-imageview/raw/master/screens/rv.png" width="320"/>

---

**GlideImageView: https://github.com/sfsheng0322/GlideImageView

基于Glide V4.0封装的图片加载库，可以监听加载图片时的进度 

<img src="https://github.com/sfsheng0322/GlideImageView/raw/master/screenshot/gif4.gif" width="480"/>

---

**PaletteImageView: https://github.com/DingMouRen/PaletteImageView

懂得智能配色的ImageView,还能给自己设置多彩的阴影

<img src="https://github.com/DingMouRen/PaletteImageView/raw/master/screenshot/demo1.gif" width="270"/> <img src="https://github.com/DingMouRen/PaletteImageView/raw/master/screenshot/demo2.gif" width="270"/>

---

**InsLoadingAnimation: https://github.com/qintong91/InsLoadingAnimation

头像加载进度

<img src="https://github.com/qintong91/InsLoadingAnimation/raw/master/screenshots/demo.gif" width="270"/>

---

**AndroidWM: https://github.com/huangyz0918/AndroidWM

轻量级安卓水印框架，支持隐形数字水印

<img src="https://camo.githubusercontent.com/ee10fde843f5050abbb3424ad9470d17150f1102/68747470733a2f2f692e6c6f6c692e6e65742f323031382f30392f30352f356238663565623161376662302e706e67" width="400"/> <img src="https://camo.githubusercontent.com/42a674fdf9e49c7e774c205063427e1b863a2f90/68747470733a2f2f692e6c6f6c692e6e65742f323031382f30392f30352f356238663565623234643066642e706e67" width="400"/>

---

**RubberStamp: https://github.com/vinaygaba/RubberStamp

给图片添加水印

<img src="https://github.com/vinaygaba/RubberStamp/raw/master/images/rubberstamp_sample.gif" width="320"/>

---

**WatermarkCreator**: https://github.com/ashishbhandari/WatermarkCreator

水印

<img src = "https://raw.githubusercontent.com/ashishbhandari/WatermarkCreator/master/screenshots/watermark_creator.gif" width = "320"/>

---

**progress-image-view-android: https://github.com/safetysystemtechnology/progress-image-view-android

progress-image-view-android

<img src="https://github.com/safetysystemtechnology/progress-image-view-android/raw/master/etc/demo.gif" width="320"/>

---

**DismissibleImageView**: https://github.com/dmallcott/DismissibleImageView

Clickable ImageView that expands to full screen and is dismissible by swiping the image off-screen

<img src = "https://github.com/dmallcott/DismissibleImageView/raw/master/assets/sample.gif" width = "320"/>

---

**PaletteImageView**: https://github.com/DingMouRen/PaletteImageView

为图片添加阴影，阴影颜色来源于图片的主色

<img src = "https://github.com/DingMouRen/PaletteImageView/raw/master/imgs/img.gif" width = "240"/>

---

**LongImageCamera**: https://github.com/wajahatkarim3/LongImageCamera

长图拍摄

<img src = "https://github.com/wajahatkarim3/LongImageCamera/raw/master/Art/demo.gif" width = "240"/>

---

**IdentityImageView**: https://github.com/385841539/IdentityImageView

一个能带进度条的图片框架，同时有身份标识动能，简单易用

<img src = "https://raw.githubusercontent.com/385841539/IdentityImageView/master/app/src/main/res/drawable/biaoshi.gif" width = "240"/>

---

**BifacialView**: https://github.com/pavel163/BifacialView

图像处理后左右对比

<img src = "https://raw.githubusercontent.com/pavel163/BifacialView/master/media/bifacialview1.gif" width = "240"/>

---

**sand**: https://github.com/Jomes/sand

使用JNI实现Sobel算子图像边缘检测

<img src = "https://raw.githubusercontent.com/Jomes/sand/master/gif/sand.gif" width = "200"/>

---

**Camera**: https://github.com/lizhangqu/Camera

二代身份证信息识别

<img src = "https://camo.githubusercontent.com/84165b0a30c3bfa248518a1f3715433b9d0bb942/687474703a2f2f696d672e626c6f672e6373646e2e6e65742f3230313530393037313635313233343033" width = "320"/>

---

**ProCamera**: https://github.com/18Gray/ProCamera

ProCamera是一款基于Camera2 API的相机，实现了相机的常用功能，力求不断挖掘Camera2的巨大潜力，锻造一款在功能和设计上完美的相机产品

<img src = "https://github.com/18Gray/ProCamera/raw/master/screenshot/camera2.jpg" width = "320"/> <img src = "https://github.com/18Gray/ProCamera/raw/master/screenshot/modeselect.jpg" width = "320"/>

---

**Fotoapparat**: https://github.com/Fotoapparat/Fotoapparat

Android 有两套相机 Api，使用起来很麻烦，好在 Foto 开源了他们在 Android 上的 Camera 封装 Api，力荐

<img src = "https://github.com/Fotoapparat/Fotoapparat/raw/master/sample/src/main/res/mipmap-xxxhdpi/ic_launcher.png" width = "320"/>

---

**CameraKit-Android**: https://github.com/flurgle/CameraKit-Android

一个相机的库

<img src = "https://raw.githubusercontent.com/flurgle/CameraKit-Android/master/.repo/permissions.gif" width = "320"/>

---

**ShadowImageView**: https://github.com/yingLanNull/ShadowImageView

可以根据图片变颜色，更加细腻的阴影效果

<img src = "https://github.com/yingLanNull/ShadowImageView/blob/master/show/shadow.gif" width = "320"/>

---

**photo-affix**: https://github.com/afollestad/photo-affix

图片拼接

<img src = "https://raw.githubusercontent.com/afollestad/photo-affix/master/art/pashowcase1.png" width = "640"/>

---

**skia**: https://github.com/google/skia

Skia is a complete 2D graphic library for drawing Text, Geometries, and Images. https://skia.org

---

**android-close-pixelate**: https://github.com/bmaslakov/android-close-pixelate

安卓图片模糊，像素化

<img src = "https://raw.githubusercontent.com/bmaslakov/android-close-pixelate/master/screenshots/giraffe.jpg" width = "320"/> <img src = "https://raw.githubusercontent.com/bmaslakov/android-close-pixelate/master/screenshots/giraffe.png" width = "320"/>

---

**PixelAdjuster**: https://github.com/Commit451/PixelAdjuster

Changes the color of individual pixels in a Bitmap

---

**BypassPicassoImageGetter**: https://github.com/Commit451/BypassPicassoImageGetter

Loads images for Bypass using Picasso

---

**multiselect**: https://github.com/karanvs/multiselect

多个图片/视频选择

---

**MultiPhotoPicker**: https://github.com/nileshpambhar/MultiPhotoPicker

MultiPhotoPicker

<img src = "https://github.com/nileshpambhar/MultiPhotoPicker/raw/master/Screenshots/Screen1.png" width = "320"/> <img src = "https://github.com/nileshpambhar/MultiPhotoPicker/raw/master/Screenshots/Screen2.png" width = "320"/>

---

**ImageNice9Layout**: https://github.com/wobiancao/ImageNice9Layout

仿Nice首页图片列表9图样式，并实现拖拽效果

<img src = "https://github.com/wobiancao/ImageNice9Layout/raw/master/screenshot/drag9.gif" width = "320"/>

---

**ImagePicker-OLX**: https://github.com/RameshBhupathi/ImagePicker-OLX

Combined both TedBottomPicker and Camera View, to get the View Similar to ImagePickers of Olx.

<img src = "https://github.com/RameshBhupathi/ImagePicker-OLX/raw/master/device-2017-07-16-202724.png" width = "320"/>

---

**ImageShowPicker**: https://github.com/yaozs/ImageShowPicker

仿微信朋友圈图片选择

<img src = "https://raw.githubusercontent.com/yaozs/ImageShowPicker/master/pic/weixin_pic.jpg" width = "320"/>

---

**EasyImagePicker**: https://github.com/oswaldo89/EasyImagePicker

EasyImagePicker

<img src = "https://camo.githubusercontent.com/f0c8a42c9f22d401e8dcbc222390450264ffca27/68747470733a2f2f6578747261696d6167652e6e65742f696d616765732f323031372f30342f31342f61613962373934353138313937623130383137306563333163653631653839372e6a7067" width = "240"/> <img src = "https://camo.githubusercontent.com/0c38b10d6c424b0e45563dc2348c7b69e102e283/68747470733a2f2f6578747261696d6167652e6e65742f696d616765732f323031372f30342f31342f36633666336461323763653662646233343539326261653035316262393239322e6a7067" width = "240"/>

---

**EZPhotoPicker**: https://github.com/Siclo-Mobile/EZPhotoPicker

EZPhotoPicker

---

**android-ocr**: https://github.com/rmtheis/android-ocr

Experimental app for optical character recognition on Android

<img src = "https://camo.githubusercontent.com/757e20ff49213fb230eef31c4a982ed886cf0a7f/687474703a2f2f696d672e796f75747562652e636f6d2f76692f464f536769506a477778342f302e6a7067" width = "400"/> <img src = "https://camo.githubusercontent.com/1d6169f57a17128f9fa70e1a75e2b3fba50fe88d/687474703a2f2f696d672e796f75747562652e636f6d2f76692f37764e6570546d425447382f302e6a7067" width = "400"/>

---

**Zoomy**: https://github.com/imablanco/Zoomy

双指控制图片展开，以及放大缩小，做的超棒

<img src = "https://github.com/imablanco/Zoomy/raw/master/art/zoomy.gif" width = "320"/>

---

**AwesomeImagePicker**: https://github.com/myinnos/AwesomeImagePicker

图片选择工具库

<img src = "https://camo.githubusercontent.com/202d0879dc29573ed81d786871408b841b021734/68747470733a2f2f7331392e706f7374696d672e6f72672f3462786d6f7577626e2f496d6167655f5069636b65725f6578616d706c655f312e706e67" width = "180"/> <img src = "https://camo.githubusercontent.com/99945f01c1c482005c7d4dd8a5e6ffce25fd5d48/68747470733a2f2f7331392e706f7374696d672e6f72672f6a6c786877317274762f496d6167655f5069636b65725f6578616d706c655f322e706e67" width = "180"/> <img src = "https://camo.githubusercontent.com/45ab9aa0ae283294e359f96f210e96b07c13be7d/68747470733a2f2f7331392e706f7374696d672e6f72672f34656869626f7a7a372f496d6167655f5069636b65725f6578616d706c655f332e706e67" width = "180"/>

---

**Louvre**: https://github.com/andremion/Louvre

又一个漂亮的 Android 图片选择工具库

<img src = "https://raw.githubusercontent.com/andremion/Louvre/master/art/sample.gif" width = "320"/>

---

**AnchorImageView**: https://github.com/jcodeing/AnchorImageView

支持给图片加锚点的 Android 组件

<img src = "https://raw.githubusercontent.com/jcodeing/AnchorImageView/master/lookme.gif" width = "320"/>

---

**PickPhotoSample**: https://github.com/Werb/PickPhotoSample

Photo Picker Of Android Library

<img src = "https://raw.githubusercontent.com/Werb/PickPhotoSample/master/screenshots/select.png" width = "320"/> <img src = "https://raw.githubusercontent.com/Werb/PickPhotoSample/master/screenshots/show.png" width = "320"/>

---

**PictureSelector**: https://github.com/LuckSiege/PictureSelector

android多图选择器 图片/视频 单选or多选，以及视频录制

<img src = "https://raw.githubusercontent.com/LuckSiege/PictureSelector/master/image/A574F86A9A9F42A77D03B0ACC9E761C9.jpg" width = "320"/> <img src = "https://raw.githubusercontent.com/LuckSiege/PictureSelector/master/image/0F918EB15954836F59A95A3F7E0D2012.jpg" width = "320"/>

---

**PanoramaImageView**: https://github.com/gjiazhe/PanoramaImageView

通过监听手腕旋转进行交互，自动滚动图片

<img src = "https://raw.githubusercontent.com/gjiazhe/PanoramaImageView/master/screenshots/recyclerview_sample.gif" width = "300"/> <img src = "https://raw.githubusercontent.com/gjiazhe/PanoramaImageView/master/screenshots/vertical_sample.gif" width = "300"/>

---

**MultiImageView**: https://github.com/stfalcon-studio/MultiImageView

多种图片样式 UI 组合，很适合做头像相关的功能

<img src = "https://camo.githubusercontent.com/d29a4e2a0dc99b1a114f43fb201e1080e6aaa462/687474703a2f2f692e696d6775722e636f6d2f5334516f4b56422e676966" width = "320"/>

---

**TakePhoto**: https://github.com/crazycodeboy/TakePhoto

一款用于在Android设备上获取照片（拍照或从相册、文件中选择）、裁剪图片、压缩图片的开源工具库

<img src = "https://raw.githubusercontent.com/crazycodeboy/TakePhoto/master/Screenshots/takephoto_preview.png" width = "800"/>

---

**Gradient-Artist**: https://github.com/Hariofspades/Gradient-Artist

Gradient-Artist library will allow you to use gradient overly on top of the image

<img src = "https://raw.githubusercontent.com/Hariofspades/Gradient-Artist/master/assets/wallpaper.png" width = "640"/>

---

**500px-android-blur**: https://github.com/500px/500px-android-blur

500px-android-blur

<img src = "https://github.com/500px/500px-android-blur/raw/master/blurdemo.gif" width = "400"/>

---

**BlurView**: https://github.com/Dimezis/BlurView

IOS 风格的安卓动态模糊库

<img src = "https://raw.githubusercontent.com/Dimezis/BlurView/master/BlurScreenshot.png" width = "320"/>

---

**BlurKit-Android**: https://github.com/flurgle/BlurKit-Android

性能强大的安卓模糊库

<img src = "https://github.com/flurgle/BlurKit-Android/raw/master/.repo/demo.gif" width = "320"/>

---

**AndroidRealTimeBlur**: https://github.com/wenhatai/AndroidRealTimeBlur

Android real-time blur

---

**VectorSupportView**: https://github.com/akashandroid90/VectorSupportView

VectorSupportView is a library to support vector assets in compound drawables

---

**collageview**: https://github.com/lopei/collageview

Android 图片拼图效果

<img src = "https://camo.githubusercontent.com/cedb07108cc866e9f9641e39f144e8135b861637/68747470733a2f2f70702e766b2e6d652f633632363832332f763632363832333337312f32393437632f5a4f354e307644696154342e6a7067" width = "320"/> <img src = "https://camo.githubusercontent.com/b90567e5769502f6e18a8edbfca2fb47eb7d528f/68747470733a2f2f70702e766b2e6d652f633633363831372f763633363831373337312f34353439392f672d344a5473486c6935412e6a7067" width = "320"/>

---

**android-gif-example**: https://github.com/jaredsburrows/android-gif-example

Gif RecyclerView MVP Grid Example using Dagger 2, Retrofit 2, RxJava 2 and Butterknife with Junit and Espresso tests

<img src = "https://camo.githubusercontent.com/8866ca0e83b3cc357db6bdfc0ebd5ca304e16ec1/687474703a2f2f692e696d6775722e636f6d2f7a457243364a562e706e67" width = "320"/>

---

**gifencoder**: https://github.com/square/gifencoder

A pure Java library implementing the GIF89a specification. Suitable for use on Android

<img src = "https://raw.githubusercontent.com/square/gifencoder/master/gallery/simple-animation.gif" width = "240"/>

---

**FocusSurfaceView**: https://github.com/CGmaybe10/FocusSurfaceView

拍照时在相机的预览界面指定一个区域的大小，形状和位置，只拍摄该指定区域里的图像

<img src = "https://raw.githubusercontent.com/CGmaybe10/FocusSurfaceView/master/screenshots/demo.gif" width = "240"/>

---

**ScrollParallaxImageView**: https://github.com/gjiazhe/ScrollParallaxImageView

滚动时图片产生视差效果的ImageView

<img src = "https://raw.githubusercontent.com/gjiazhe/ScrollParallaxImageView/master/screenshot/ss1.gif" width = "240"/> <img src = "https://raw.githubusercontent.com/gjiazhe/ScrollParallaxImageView/master/screenshot/ss3.gif" width = "240"/>

---

**crescento**: https://github.com/developer-shivam/crescento

Add curve at bottom of image views and relative layouts

<img src = "https://raw.githubusercontent.com/developer-shivam/Crescento/master/art/sample2.gif" width = "320"/>

---

**HighPassSkinSmoothing-Android**: https://github.com/AmniX/HighPassSkinSmoothing-Android

An implementation of High Pass Skin Smoothing on Android Bitmap 美颜

<img src = "https://camo.githubusercontent.com/1b009f525c52b22822d43b56f0747d594652bf70/687474703a2f2f7975616f2e6769746875622e696f2f595543494869676850617373536b696e536d6f6f7468696e672f70726576696577732f312e6a7067" width = "640"/>

---

**DexMovingImageView**: https://github.com/dexlex/DexMovingImageView

一个实现了最新的Google Calender中月份图片的效果的ImageView,图片会随着外部ScrollView的滚动而滚动

<img src = "https://raw.githubusercontent.com/dexlex/DexMovingImageView/master/assets/screenshot/home.png" width = "220"/> <img src = "https://raw.githubusercontent.com/dexlex/DexMovingImageView/master/assets/screenshot/menu.png" width = "220"/>

---

**SimpleOneStep**: https://github.com/gavinliu/SimpleOneStep

仿 Smartisan OneStep

<img src = "https://raw.githubusercontent.com/gavinliu/SimpleOneStep/master/screenshots.gif" width = "320"/> <img src = "https://raw.githubusercontent.com/gavinliu/SimpleOneStep/master/screenshots2.gif" width = "320"/>

---

**LargeImage**: https://github.com/LuckyJayce/LargeImage

Android 加载大图 可以高清显示10000*10000像素的图片，轻松实现微博长图功能

<img src = "https://github.com/LuckyJayce/LargeImage/blob/master/raw/demo.gif" width = "320"/>

---

**BigImageViewer**: https://github.com/Piasy/BigImageViewer

大图查看加载库，支持拖动和缩放，利用 fresco 加载，超级方便，但是内存占用超级低，一点也不卡

<img src = "https://github.com/Piasy/BigImageViewer/raw/master/art/fresco_big_image_viewer_demo.gif" width = "320"/>

---

**ImageTransition**: https://github.com/vikramkakkar/ImageTransition

Android 图片放大过渡效果

<img src = "https://github.com/vikramkakkar/ImageTransition/raw/master/img/image_transition.gif?raw=true" width = "320"/>

---

**Squint**: https://github.com/IntruderShanky/Squint

对角线风格

<img src = "https://raw.githubusercontent.com/IntruderShanky/Squint/master/Screenshot/barney_squint.png" width = "320"/> <img src = "https://raw.githubusercontent.com/IntruderShanky/Squint/master/Screenshot/list_squint.png" width = "320"/>

---

**DiagonalLayout**: https://github.com/florent37/DiagonalLayout

斜角 View 效果，用来做 Profile 背景最适合不过

<img src = "https://raw.githubusercontent.com/florent37/DiagonalLayout/master/media/sample.gif" width = "320"/>

---

**Diagonalify**: https://github.com/developer-shivam/Diagonalify

图片对角线分割风格

<img src = "https://raw.githubusercontent.com/developer-shivam/Diagonalify/master/art/screenshot_1.png" width = "320"/> <img src = "https://raw.githubusercontent.com/developer-shivam/Diagonalify/master/art/screenshot_2.png" width = "320"/>

---

**PhotoViewSlider**: https://github.com/jeancsanchez/PhotoViewSlider

图片浏览器

<img src = "https://raw.githubusercontent.com/jeancsanchez/PhotoViewSlider/master/PhotoViewSlider.gif" width = "200"/>

---

**android-hidden-camera**: https://github.com/kevalpatel2106/android-hidden-camera

This library is to take picture using camera without camera preview

<img src = "https://raw.githubusercontent.com/kevalpatel2106/android-hidden-camera/master/apk/sample.png" width = "210"/>

---

**ParaCamera**: https://github.com/janishar/ParaCamera

Simple android camera to take and get image bitmaps

---

**SnappyImageViewer**: https://github.com/nshmura/SnappyImageViewer

Android Image Viewer inspired by StackOverflow's with swipe-to-dimiss and moving animations

<img src = "https://github.com/nshmura/SnappyImageViewer/raw/master/assets/capture.gif" width = "320"/>

---

**gallerymodule**: https://github.com/guiguegon/gallerymodule

Simple gallery to retrieve one or more images. It allow to take new photos or videos

<img src = "https://raw.githubusercontent.com/guiguegon/GalleryModule/master/screenshots/gallery.png" width = "320"/> <img src = "https://raw.githubusercontent.com/guiguegon/GalleryModule/master/screenshots/take_photo.png" width = "320"/>

---

**Blaze**: https://github.com/IntruderShanky/Blaze

图片移动及缩放

<img src = "https://github.com/IntruderShanky/Blaze/raw/master/Screenshots/motion_view.gif" width = "320"/>

---

**cropiwa**: https://github.com/steelkiwi/cropiwa

图片自定义裁剪

<img src = "https://raw.githubusercontent.com/steelkiwi/cropiwa/master/assets/3J8gYWC.gif" width = "320"/>

---

**croperino**: https://github.com/ekimual/croperino

图片裁剪

<img src = "https://cloud.githubusercontent.com/assets/16832215/18544278/855d9aae-7b66-11e6-8236-ba1bc89a8e44.png" width = "320"/>

---

**MultiType-FilePicker**: https://github.com/fishwjy/MultiType-FilePicker

一款轻量级的文件选择器，支持多种文件类型

<img src = "https://github.com/fishwjy/MultiType-FilePicker/raw/master/pic/pick_img.gif" width = "320"/> <img src = "https://github.com/fishwjy/MultiType-FilePicker/raw/master/pic/pick_file.png" width = "320"/>

---

**MediaPickerInstagram**: https://github.com/NodensN/MediaPickerInstagram

Material 风格的类似 Instagram 的图片选择器

<img src = "https://cloud.githubusercontent.com/assets/10350755/20528721/99b9154a-b0cd-11e6-8597-d0ddf11bdca4.png" width = "240"/> <img src = "https://cloud.githubusercontent.com/assets/10350755/20528723/9aa26b64-b0cd-11e6-983d-e796701f52f8.png" width = "240"/>

---

**TelegramGallery**: https://github.com/TangXiaoLv/TelegramGallery

QQ 相册风格，相册选择器

<img src = "https://github.com/TangXiaoLv/TelegramGallery/raw/master/png/1.gif" width = "320"/>

---

**pictorial**: https://github.com/jonasbleyl/pictorial

A universal image viewer for Android

<img src = "https://camo.githubusercontent.com/31ffb9fe8e4dd0878d7b35919fc41a13fe6e2345/687474703a2f2f692e696d6775722e636f6d2f747a6c423169302e706e67" width = "320"/>

---

**TedBottomPicker**: https://github.com/ParkSangGwon/TedBottomPicker

TedBottomPicker is simple image picker using bottom sheet

<img src = "https://raw.githubusercontent.com/ParkSangGwon/TedBottomPicker/master/screenshot1.jpeg" width = "320"/> <img src = "https://raw.githubusercontent.com/ParkSangGwon/TedBottomPicker/master/demo.gif" width = "320"/>

---

**cameraview**: https://github.com/google/cameraview

CameraView aims to help Android developers easily integrate Camera features

---

**FrescoImageViewer**: https://github.com/stfalcon-studio/FrescoImageViewer

对 ImageView 实现了全屏浏览效果，同时支持了图片缩放效果，和滑动消失效果

<img src = "https://raw.githubusercontent.com/stfalcon-studio/FrescoImageViewer/master/images/fresco_image_viewer_demo.gif" width = "270"/>

---

**RecyclerViewCardGallery**: https://github.com/huazhiyuan2008/RecyclerViewCardGallery

RecyclerView实现Card Gallery效果，替代ViewPager方案

<img src = "https://raw.githubusercontent.com/huazhiyuan2008/RecyclerViewCardGallery/master/art/RecyclerViewCardGallery_blur.gif" width = "320"/>

---

**CompareImage**: https://github.com/Onkarn92/CompareImage

编辑后图片对比

<img src = "https://camo.githubusercontent.com/410e870cbb40937a8d1e591d4be6d5a5f2bed9f4/68747470733a2f2f7261772e6769746875622e636f6d2f4f6e6b61726e39322f436f6d70617265496d6167652f6d61737465722f73637265656e732f73637265656e312e676966" width = "320"/>

---

**StyleImageView**: https://github.com/chengdazhi/StyleImageView

Add styles and filters to ImageViews, Views' backgroud, Drawables and Bitmaps, with animation and bitmap output

<img src = "https://raw.githubusercontent.com/chengdazhi/StyleImageView/master/images/style_sample.gif" width = "320"/>

---

**ShapeImageView**: https://github.com/andyxialm/ShapeImageView

ShapeImageView

<img src = "https://raw.githubusercontent.com/andyxialm/ShapeImageView/master/art/device-2016-01-04-173436.png" width = "270"/> <img src = "https://raw.githubusercontent.com/andyxialm/ShapeImageView/master/art/device-2016-01-04-173505.png" width = "270"/> <img src = "https://raw.githubusercontent.com/andyxialm/ShapeImageView/master/art/device-2016-01-04-173522.png" width = "270"/>

---

**Music-Cover-View**: https://github.com/andremion/Music-Cover-View

Useful to be used as album cover in Music apps

<img src = "https://raw.githubusercontent.com/andremion/Music-Cover-View/master/art/sample.gif" width = "320"/>

---

**PuzzleView**: https://github.com/wuapnjie/PuzzleView

Android拼图支持库，轻松实现Instagram Layout效果

<img src = "https://raw.githubusercontent.com/wuapnjie/PuzzleView/master/screenshots/screenshot1.png" width = "320"/> <img src = "https://raw.githubusercontent.com/wuapnjie/PuzzleView/master/screenshots/screenshot2.png" width = "320"/>

---

**PloyFun**: https://github.com/hugeterry/PloyFun

导入图片生成Low Poly风格图片的app

<img src = "https://raw.githubusercontent.com/hugeterry/PloyFun/master/showUI/1.jpg" width = "320"/> <img src = "https://raw.githubusercontent.com/hugeterry/PloyFun/master/showUI/2.jpg" width = "320"/>

---

**onyx**: https://github.com/hanuor/onyx

人工智能、机器学习、深度学习合体的图片资源识别库

<img src = "https://raw.githubusercontent.com/hanuor/onyx/master/anim2.gif" width = "320"/>

---

**WebpifyYourAndroidApp**: https://github.com/AndroidDeveloperLB/WebpifyYourAndroidApp

A small tool to convert your app's png&jpg image files into WebP when possible

---

**JikeGallery**: https://github.com/JeasonWong/JikeGallery

仿即刻首页图片垂直滚动效果

<img src = "https://camo.githubusercontent.com/1706924e07392c8d2c326ff1eb479cd5311bd238/687474703a2f2f69342e7069696d672e636f6d2f313037302f613433343434313832663637376231642e676966" width = "360"/>

---

**pearl**: https://github.com/hanuor/pearl

图片加载、缓存

<img src = "https://camo.githubusercontent.com/347a65e24e8e2e72538af5a675eb149a82f81c0b/68747470733a2f2f7333322e706f7374696d672e6f72672f37696a7732306135682f53637265656e73686f745f323031365f30385f30365f31335f34315f32345f3138325f6e6578757336705f706f7274722e706e67" width = "320"/>

---

**cookie-cutter**: https://github.com/adamstyrc/cookie-cutter

移动或缩放图片来裁剪图片

<img src = "https://raw.githubusercontent.com/adamstyrc/cookie-cutter/master/video.gif" width = "320"/>

---

**ImagePicker**: https://github.com/jeasonlzy0216/ImagePicker

完全仿微信的图片选择，并且提供了多种图片加载接口，选择图片后可以旋转，可以裁剪成矩形或圆形，可以配置各种其他的参数

<img src = "https://raw.githubusercontent.com/jeasonlzy/Screenshots/master/ImagePicker/demo1.png" width = "270"/> <img src = "https://raw.githubusercontent.com/jeasonlzy/Screenshots/master/ImagePicker/demo3.png" width = "270"/>

---

**ImageZipper**: https://github.com/amanjeetsingh150/ImageZipper

压缩图片，An image compresssion library in android

<img src="https://user-images.githubusercontent.com/12881364/28280492-83ac5b2a-6b41-11e7-9394-48ad8e8e44f1.jpg" width = "320"/>

---

**CompressHelper**: https://github.com/nanchen2251/CompressHelper

压缩文件，压缩图片，压缩Bitmap，Compress,CompressImage,CompressFile,CompressBitmap

<img src="https://raw.githubusercontent.com/nanchen2251/CompressHelper/master/111.png" width = "320"/>

---

**AdvancedLuban**: https://github.com/shaohui10086/AdvancedLuban

高效、简洁的图片压缩工具库 / An Advanced Compress Image Library for Android http://shaohui.me

---

**Luban**: https://github.com/Curzibn/Luban

Luban(鲁班)——可能是最接近微信朋友圈的图片压缩算法

---

**zBarLibary**: https://github.com/bertsir/zBarLibary

zbar扫描快，zxing可以生成和识别本地，So,我就把他们结合在了一起

<img src="https://camo.githubusercontent.com/9eec49996c71fef00e117356beb8ee91bc2ed7c8/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f333032393032302d623030343430373562323162326637632e6769663f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970253743696d61676556696577322f322f772f333633" width="320" /> <img src="https://camo.githubusercontent.com/d6372d677c6dae51ae7d8228b797223e0ff2a35f/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f333032393032302d633763373962366166346461363936302e6a70673f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970253743696d61676556696577322f322f772f333630" width="320" />

---

**MVBarcodeReader**: https://github.com/iamMehedi/MVBarcodeReader

条码识别

---

**zxing-android-embedded**: https://github.com/journeyapps/zxing-android-embedded

Port of the ZXing Android application as an Android library project, for embedding in an Android application

---

**AwesomeQRCode**: https://github.com/SumiMakito/AwesomeQRCode

一个优雅的二维码生成器

<img src="https://github.com/SumiMakito/AwesomeQRCode/raw/master/art/awesome-qr-4.png" width="320" />

---

**PressScanCode**: https://github.com/BolexLiu/PressScanCode

一个长按扫描webView上的二维码的工具库

<img src="https://raw.githubusercontent.com/BolexLiu/PressScanCode/master/tips.gif" width="240" />

---

**ZXingDemo**: https://github.com/vivian8725118/ZXingDemo

六种二维码生成的样式

<img src="https://raw.githubusercontent.com/vivian8725118/ZXingDemo/master/art/S61128-17080029.jpg" width="320" />

---

**MobileVisionBarcodeScanner**: https://github.com/KingsMentor/MobileVisionBarcodeScanner

二维码扫描

<img src="https://github.com/KingsMentor/MobileVisionBarcodeScanner/raw/master/lib_example.gif" width="640" />

---

**Android-Zxing**: https://github.com/mylhyl/Android-Zxing

android google zxing 可配置扫描框、线样式 ，生成二维码（文字、联系人） http://blog.csdn.net/hupei/article/details/51859171

<img src="https://raw.githubusercontent.com/mylhyl/Android-Zxing/master/preview/gif.gif" width="270" />

---

**Qart**: https://github.com/scola/Qart

将生成的二维码与选择的图片合成，生成的新二维码

<img src="https://camo.githubusercontent.com/b3484d2714d126883be6a4a1ec69ba8f1ed402a3/687474703a2f2f7777322e73696e61696d672e636e2f6c617267652f613135623461666567773166376a6c766f746468776a32306b66306b6664676d2e6a7067" width="320" />

---

**android-zxingLibrary**: https://github.com/yipianfengye/android-zxingLibrary

Android 二维码，条码扫描，生成库

<img src="https://raw.githubusercontent.com/yipianfengye/android-zxingLibrary/master/images/ezgif.com-video-to-gif%20(2)%2015.33.08.gif" width="320" /> <img src="https://raw.githubusercontent.com/yipianfengye/android-zxingLibrary/master/images/ezgif.com-video-to-gif%20(5).gif" width="320" />

---

**BGAQRCode-Android**: https://github.com/bingoogolapple/BGAQRCode-Android

Android 二维码条码扫描，生成库

<img src="https://camo.githubusercontent.com/9925f6660c608bc6b25bbeb623d0184d5dca6968/687474703a2f2f37786b39646a2e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f7172636f64652f73637265656e73686f74732f7a78696e673130362e676966" width="320" /> <img src="https://camo.githubusercontent.com/592a5ae13ae4c01c298b68d27f179a23843d398a/687474703a2f2f37786b39646a2e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f7172636f64652f73637265656e73686f74732f7a78696e673130332e676966" width="320" />

---

**zxing-barcode**: https://github.com/ThePacific/zxing-barcode

A barcode scanner based on zxing for android

<img src="https://github.com/ThePacific/Zxing-Barcode/blob/master/gif/example.gif" width="320" />

---

**QrCardParsing**: https://github.com/RurioLuca/QrCardParsing

二维码生成、扫描库

<img src = "https://raw.githubusercontent.com/RurioLuca/MeCardParsing/master/img/screen.png" width = "320"/>

---

**QRGenerator**: https://github.com/androidmads/QRGenerator

二维码扫描库

---

**AutoZoomInImageView**: https://github.com/Carbs0126/AutoZoomInImageView

可做splash动画，一张静态图片居中显示并充满屏幕，同时不断放大图片中间部分，形成一种图片不断向中间放大的动画效果

<img src = "https://raw.githubusercontent.com/Carbs0126/Screenshot/master/AutoZoomInImageView.gif" width = "270"/>

---

**AndroidGradientImageView**: https://github.com/skyfe79/AndroidGradientImageView

Android 色彩渐进 ImageView

<img src = "https://raw.githubusercontent.com/skyfe79/AndroidGradientImageView/master/art/gradient-animation.gif" width = "270"/>

---

**QiniuImageLoader**: https://github.com/lingochamp/QiniuImageLoader

在Android上结合七牛提供的API，让加载图片更有效、更节流、更简单、更可控、更酷

<img src = "https://raw.githubusercontent.com/lingochamp/QiniuImageLoader/master/art/demo_1.jpg" width = "320"/> <img src = "https://raw.githubusercontent.com/lingochamp/QiniuImageLoader/master/art/demo_2.jpg" width = "320"/>

---

**CainCamera**: https://github.com/CainKernel/CainCamera

CainCamera是一个集美颜相机、图片编辑、短视频编辑等功能的综合性开源APP，目前主要介绍美颜相机、短视频编辑功能的实现，图片编辑功能暂时还没时间处理。 本人编写该项目主要用于学习如何实现相机的实时美颜、动态滤镜、动态贴纸、彩妆、拍照、短视频分段录制与回删、图片编辑、短时频编辑与合成等功能。

<img src="https://github.com/CainKernel/CainCamera/blob/master/screenshot/sticker_and_filter.jpg" width="480" />

---

**CameraFilters**: https://github.com/JessYanCoding/CameraFilters

摄像头实时滤镜处理库,自带10多种滤镜,支持滤镜扩展,并且兼容七牛云直播滤镜处理

---

**CameraFilter**: https://github.com/nekocode/CameraFilter

Realtime camera filters for Android

---

**CameraFilter**: https://github.com/WeLikeVis/CameraFilter

安卓滤镜集合

---

**AndroidPhotoFilters**: https://github.com/Zomato/AndroidPhotoFilters

图片滤镜

<img src="https://raw.githubusercontent.com/Zomato/AndroidPhotoFilters/master/art/photofilters.gif" width="320" />

---

**photofilter**: https://github.com/mukeshsolanki/photofilter

滤镜

<img src = "https://raw.githubusercontent.com/mukeshsolanki/photofilter/master/screenshots/Car-applyShadingFilter1.png" width = "320"/> <img src = "https://raw.githubusercontent.com/mukeshsolanki/photofilter/master/screenshots/Car-boost2.png" width = "320"/>

---

**gallery**: https://github.com/kenvies/gallery

最实用的图片操作实例

<img src = "https://github.com/wqandroid/wqgallery/raw/dev/app/screenshort/wqgallert.gif" width = "300"/>

---

**ImageGroupView**: https://github.com/loopeer/ImageGroupView

图片增删工具

<img src = "https://raw.githubusercontent.com/loopeer/ImageGroupView/master/screenshot/screenshot.gif" width = "300"/> <img src = "https://raw.githubusercontent.com/loopeer/ImageGroupView/master/screenshot/screenshot_select_photo.gif" width = "300"/>

---

**Compressor**: https://github.com/zetbaitsu/Compressor

图片压缩

<img src = "https://raw.githubusercontent.com/zetbaitsu/Compressor/master/ss.png" width = "320"/>

---

**GifLoadingView**: https://github.com/Rogero0o/GifLoadingView

GifLoadingViewhttps://amitshekhariitbhu.github.io/GlideBitmapPool/

<img src="https://camo.githubusercontent.com/5d60273b50200d40dd0fb3d6e7e2f2283651630d/687474703a2f2f7777342e73696e61696d672e636e2f6d773639302f61363935616364656777316633646579737274346767323034733034783137722e676966" width="160" /> <img src="https://camo.githubusercontent.com/b754e4dd02b606757a3e00242a00f81ca1c79a97/687474703a2f2f7777322e73696e61696d672e636e2f736d616c6c2f613639356163646567773166336465797662707761673230347330347831306a2e676966" width="160" /> <img src="https://camo.githubusercontent.com/de425dc93de5058c2af83756091c40b53fea9132/687474703a2f2f7777332e73696e61696d672e636e2f736d616c6c2f61363935616364656777316633646579777162323967323034733034786a737a2e676966" width="160" /> <img src="https://camo.githubusercontent.com/c67e8c65bcdbdae5a0cb8598d4869b971f6fee0d/687474703a2f2f7777342e73696e61696d672e636e2f736d616c6c2f6136393561636465677731663364657a323037717567323034733034786e61642e676966" width="160" />

---

**GlideSlider**: https://github.com/firdausmaulan/GlideSlider

Glide Image Slider

<img src="https://camo.githubusercontent.com/f64413139bbaa918131384d3597c33e39333aa7f/687474703a2f2f7777332e73696e61696d672e636e2f6d773639302f36313064633033346a773165677a6f7236366f6a64673230393530666b6e70652e676966" width="320"/>

---

**glide-bindingadapter**: https://github.com/s0nerik/glide-bindingadapter

Configurable @BindingAdapter for Glide

---

**GlideBitmapPool**: https://github.com/amitshekhariitbhu/GlideBitmapPool

Glide Bitmap Pool is a memory management library for reusing the bitmap memory https://amitshekhariitbhu.github.io/GlideBitmapPool/

---

**android-drag-square**: https://github.com/SwiftyWang/android-drag-square

一个仿探探上传相片的widget，基于xmuSistone的demo, 提供gradle import，添加上传照片功能以及各种回调，api，方便使用

<img src="https://raw.githubusercontent.com/xmuSistone/android-drag-square/master/capture1.gif" width="270" /> <img src="https://raw.githubusercontent.com/xmuSistone/android-drag-square/master/capture2.gif" width="270" /> <img src="https://raw.githubusercontent.com/xmuSistone/android-drag-square/master/capture3.gif" width="270" />

---

**android-drag-square**: https://github.com/xmuSistone/android-drag-square

流畅，灵活的图片拖拽排序

<img src="https://raw.githubusercontent.com/xmuSistone/android-drag-square/master/capture1.gif" width="270" /> <img src="https://raw.githubusercontent.com/xmuSistone/android-drag-square/master/capture2.gif" width="270" /> <img src="https://raw.githubusercontent.com/xmuSistone/android-drag-square/master/capture3.gif" width="270" />

---

**ShapedImageView**: https://github.com/gavinliu/ShapedImageView

Android Rounded, Circle, Path ImageView

<img src="https://raw.githubusercontent.com/gavinliu/ShapedImageView/master/screenshots1.png" width="320" /> <img src="https://raw.githubusercontent.com/gavinliu/ShapedImageView/master/screenshots2.png" width="320" />

---

**CircleImageView**: https://github.com/zuoweitan/CircleImageView

使用clippath实现的CircleImageView,没有Bitmap,没有锯齿

<img src="https://raw.githubusercontent.com/zuoweitan/CircleImageView/master/screen_shot.png" width="320" />

---

**AvatarImageView**: https://github.com/Carbs0126/AvatarImageView

显示圆形图片或文本

<img src="https://raw.githubusercontent.com/Carbs0126/Screenshot/master/avatar_image_view3.jpg" width="300" /> <img src="https://raw.githubusercontent.com/Carbs0126/Screenshot/master/avatar_image_view1.jpg" width="300" />

---

**android-shape-imageview**: https://github.com/siyamed/android-shape-imageview

自定义形状的头像框架

<img src="https://raw.githubusercontent.com/siyamed/android-shape-imageview/master/images/shader-buble.png" width="320" /> <img src="https://raw.githubusercontent.com/siyamed/android-shape-imageview/master/images/all-samples.png" width="320" />

---

**CustomShapeImageView**: https://github.com/MostafaGazar/CustomShapeImageView

又一个自定义形状的头像框架

<img src="https://raw.githubusercontent.com/MostafaGazar/CustomShapeImageView/master/Screenshot_2016-01-19-09-17-37.png" width="320" />

---

**belvedere**: https://github.com/zendesk/belvedere

An image picker library for Android

---

**hiddenshot**: https://github.com/karanvs/hiddenshot

安卓截图

---

**InstaCapture**: https://github.com/tarek360/InstaCapture

截图

---

**MagicalCamera**: https://github.com/fabian7593/MagicalCamera

A library to take picture easy, trasnfrom your data and save photos in your device

<img src="https://raw.githubusercontent.com/fabian7593/MagicalCamera/master/magicalcamera.gif" width="270" />

---

**android-gif-drawable**: https://github.com/koral--/android-gif-drawable

安卓 Gif 图片加载

---

**recent-images**: https://github.com/amirarcane/recent-images

获取手机里的最新的图片

<img src="https://raw.githubusercontent.com/amirarcane/recent-images/master/demo/Screenshot_2015-10-31-15-40-49.png" width="320" />

---

**LowPoly**: https://github.com/CoXier/LowPoly

一行代码实现 LowPoly

<img src="https://raw.githubusercontent.com/CoXier/LowPoly/master/art/captain.jpg" width="640" />

---

**LowPoly**: https://github.com/zzhoujay/LowPoly

Low Poly风格图片生成器

<img src="https://raw.githubusercontent.com/zzhoujay/LowPoly/master/img/image.png" width="640" />

---

**LowPolyAndroid**: https://github.com/zzhoujay/LowPolyAndroid

Low Poly 风格图片生成器，Android实现版

<img src="https://raw.githubusercontent.com/zzhoujay/LowPoly/master/img/image.png" width="640" />

---

**ScratchView**: https://github.com/cooltechworks/ScratchView

刮开图层查看图片和文字

<img src="https://raw.githubusercontent.com/cooltechworks/ScratchView/2ec97c9a539d5976b68bf62ec07df8c727d72be2/screenshots/scratch_image_view_demo.gif" width="320" /> <img src="https://raw.githubusercontent.com/cooltechworks/ScratchView/master/screenshots/scratch_text_view_demo.gif" width="320" />

---

**android-ndk-gif**: https://github.com/waynejo/android-ndk-gif

Android Gif library

---

**sharp**: https://github.com/Pixplicity/sharp

Scalable vector graphics for Android

<img src="https://raw.githubusercontent.com/Pixplicity/sharp/master/sample-imageview/screenshots/cartman1.png" width="320" /> <img src="https://raw.githubusercontent.com/Pixplicity/sharp/master/sample-imageview/screenshots/cartman2.png" width="320" />

---

**Image-Zoomer**: https://github.com/code-crusher/Image-Zoomer

Image zoom animations library for Android

<img src="https://raw.githubusercontent.com/code-crusher/Image-Zoomer/master/screenshots/zoom.gif" width="320" /> <img src="https://raw.githubusercontent.com/code-crusher/Image-Zoomer/master/screenshots/zoomReverse.gif" width="320" />

---

**image-zoom**: https://github.com/oliveiradev/image-zoom

A simple lib for zoom images on event click

<img src="https://github.com/oliveiradev/image-zoom/blob/master/art/12ynog.gif" width="320" />

---

**TouchImageView**: [https://github.com/MikeOrtiz/TouchImageView](https://github.com/MikeOrtiz/TouchImageView)

Adds touch functionality to Android ImageView.

---

**avatar-view**: https://github.com/TangoAgency/avatar-view

根据首字母显示头像

<img src="https://raw.githubusercontent.com/TangoAgency/avatar-view/master/images/example1.gif" width="320" /> <img src="https://raw.githubusercontent.com/TangoAgency/avatar-view/master/images/example2.gif" width="320" />

---

**CircleImageView**: [https://github.com/hdodenhof/CircleImageView](https://github.com/hdodenhof/CircleImageView)

A circular ImageView for Android

<img src="https://camo.githubusercontent.com/e17a2a83e3e205a822d27172cb3736d4f441344d/68747470733a2f2f7261772e6769746875622e636f6d2f68646f64656e686f662f436972636c65496d616765566965772f6d61737465722f73637265656e73686f742e706e67" width="320" />

---

**KenBurnsView**: https://github.com/flavioarfaria/KenBurnsView

Android ImageViews animated by Ken Burns Effect

<img src="https://github.com/flavioarfaria/KenBurnsView/raw/master/anim.gif" width="320" />

---

**GifImageView**: [https://github.com/felipecsl/GifImageView](https://github.com/felipecsl/GifImageView)

Android ImageView that handles animated GIF images

<img src="https://raw.githubusercontent.com/felipecsl/GifImageView/master/demo.gif" width="320" />

---

**Android-Image-Cropper**: https://github.com/ArthurHub/Android-Image-Cropper

Image Cropping Library for Android, optimized for Camera / Gallery

<img src="https://github.com/ArthurHub/Android-Image-Cropper/blob/master/art/zoom%20sample.gif?raw=true" width="320" />

---

**cropper**: https://github.com/edmodo/cropper

Android widget for cropping and rotating an image.

<img src="https://camo.githubusercontent.com/e4fde77bf41d4a60b234b4e268e5cfa8c17d9b6f/687474703a2f2f692e696d6775722e636f6d2f334668735467666c2e6a7067" width="320" />

---

**android-crop**: https://github.com/jdamcd/android-crop

Android library project for cropping images

<img src="https://github.com/jdamcd/android-crop/blob/master/screenshot.png" width="320" />

---

**Android-PictureTagView**: [https://github.com/saiwu-bigkoo/Android-PictureTagView](https://github.com/saiwu-bigkoo/Android-PictureTagView)

仿nice图片上打标签控件

<img src="https://github.com/saiwu-bigkoo/PictureTagView/blob/master/preview/picturetagviewdemo.gif" width="320" />

---

**SelectableRoundedImageView**: [https://github.com/pungrue26/SelectableRoundedImageView](https://github.com/pungrue26/SelectableRoundedImageView)

Android ImageView that supports different radii on each corner.[http://joooonho.com/?p=289](http://joooonho.com/?p=289)

<img src="https://camo.githubusercontent.com/d359ae58a72bc330df60758703185777a15bd1a0/687474703a2f2f692e696d6775722e636f6d2f6953697a4838322e706e67" width="320" />
<img src="https://camo.githubusercontent.com/d359ae58a72bc330df60758703185777a15bd1a0/687474703a2f2f692e696d6775722e636f6d2f6953697a4838322e706e67" width="320" />

---

**RoundedImageView**: [https://github.com/vinc3m1/RoundedImageView](https://github.com/vinc3m1/RoundedImageView)

A fast ImageView that supports rounded corners, ovals, and circles.

<img src="https://camo.githubusercontent.com/ed1e075be6ed97fa9091d3702e9b96d3e85b7a35/68747470733a2f2f7261772e6769746875622e636f6d2f6d616b6572616d656e2f526f756e646564496d616765566965772f6d61737465722f73637265656e73686f742e706e67" width="320" />
<img src="https://camo.githubusercontent.com/d4970a90842c50a708f94b7bd996657c41ab62fb/68747470733a2f2f7261772e6769746875622e636f6d2f6d616b6572616d656e2f526f756e646564496d616765566965772f6d61737465722f73637265656e73686f742d6f76616c2e706e67" width="320" />

---

**CropImageView**: [https://github.com/cesards/CropImageView](https://github.com/cesards/CropImageView)

Widget allows you crop from whatever side in an ImageView. Currently Android only supports centerCrop type of cropping

<img src="https://github.com/cesards/CropImageView/blob/master/art/cropping.png" width="320" />

<img src="https://github.com/cesards/CropImageView/blob/master/art/slide_menu_left.jpg" width="320" />
<img src="https://github.com/cesards/CropImageView/blob/master/art/slide_menu_right.jpg" width="320" />

---

**BitmapMerger**: [https://github.com/cooltechworks/BitmapMerger](https://github.com/cooltechworks/BitmapMerger)

Play with bitmaps

<img src="https://cloud.githubusercontent.com/assets/13122232/8438305/9f7c2644-1f82-11e5-8f51-25ba7cca0711.gif" width="160" />
<img src="https://cloud.githubusercontent.com/assets/13122232/8438306/9f83ee9c-1f82-11e5-8734-954a13f1b2f2.gif" width="160" />
<img src="https://cloud.githubusercontent.com/assets/13122232/8438307/9f8d7c78-1f82-11e5-8d77-7fb9f31dfd6f.gif" width="160" />

---

**wqgallery**:  https://github.com/wqandroid/wqgallery

android 相册支持单选模式和多选模式

<img src="https://github.com/wqandroid/wqgallery/raw/dev/app/screenshort/wqgallert.gif" width="320" />

---

**Android-Ultra-Photo-Selector**:  https://github.com/AizazAZ/Android-Ultra-Photo-Selector

 Select images from Android devices made easy :-) Start Activity PhotoSelectorActivity, this is the main entry point

<img src="https://github.com/AizazAZ/Android-Ultra-Photo-Selector/blob/master/media/image1.png" width="320" />
<img src="https://github.com/AizazAZ/Android-Ultra-Photo-Selector/blob/master/media/image2.png" width="320" />

---

**DrawableView**:  https://github.com/PaNaVTEC/DrawableView

A view that allows to paint and saves the result as a bitmap http://panavtec.me

<img src="https://github.com/PaNaVTEC/DrawableView/blob/master/art/DrawableView.gif" width="320" />

--- 

**AndroidScrollingImageView**: [https://github.com/Q42/AndroidScrollingImageView](https://github.com/Q42/AndroidScrollingImageView)

An Android view for displaying repeated continuous side scrolling images. This can be used to create a parallax animation effect.

<img src="https://raw.githubusercontent.com/Q42/AndroidScrollingImageView/master/preview.gif" width="320" />
<img src="https://raw.githubusercontent.com/Q42/AndroidScrollingImageView/master/sample_app.png" width="320" />

---

**Pixelate**: [https://github.com/DanielMartinus/Pixelate](https://github.com/DanielMartinus/Pixelate)

Transform images into pixel versions of itself in Android

<img src="https://github.com/DanielMartinus/Pixelate/blob/master/images/pixelate_illustration.png" width="640" />

---

**SimpleCropView**: [https://github.com/IsseiAoki/SimpleCropView](https://github.com/IsseiAoki/SimpleCropView)

A simple image cropping library for Android.

<img src="https://camo.githubusercontent.com/7ef872746a0181356ea0b44d94b7bd939f28c5ae/68747470733a2f2f7261772e6769746875622e636f6d2f77696b692f4973736569416f6b692f53696d706c6543726f70566965772f696d616765732f6769662f64656d6f5f62617369635f75736167652e676966" width="320" />

---

**MultiImageSelector**: [https://github.com/lovetuzitong/MultiImageSelector](https://github.com/lovetuzitong/MultiImageSelector)

Image selector for Android device. Support single choice and multi-choice.

<img src="https://github.com/lovetuzitong/MultiImageSelector/blob/master/art/example_1.png" width="200" />
<img src="https://github.com/lovetuzitong/MultiImageSelector/blob/master/art/select_1.png" width="200" />
<img src="https://github.com/lovetuzitong/MultiImageSelector/blob/master/art/select_2.png" width="200" />
<img src="https://github.com/lovetuzitong/MultiImageSelector/blob/master/art/select_3.png" width="200" />

---

**EasyImage**: https://github.com/jkwiecien/EasyImage

Library for picking pictures from gallery or camera

EasyImage allow you to eaisly take picture from gallery or camera without creating lots of boilerplate.

---

**GiphyImageResultsPreview**: https://github.com/myinnos/GiphyImageResultsPreview

Library for GIF results, preview, play, share everything at one place

<img src="https://github.com/myinnos/GiphyImageResultsPreview/raw/master/gif/GiphyImageResultsPreview.gif" width="320" />

---

**GifLoader**: https://github.com/adhishlal/GifLoader

An Android Library to load your GIF files

<img src="https://raw.githubusercontent.com/adhishlal/GifLoader/master/adhishlal.png" width="640" />

---

**GifView**: https://github.com/Cutta/GifView

Library for playing gifs on Android

<img src="https://camo.githubusercontent.com/19b4e43298746358948ac05ce184fa4d99029159/68747470733a2f2f6d656469612e67697068792e636f6d2f6d656469612f3236745073594c356841344945474166752f67697068792e676966" width="320" />

---

**PhotoEditDemo**: https://github.com/jarlen/PhotoEditDemo

1. 图片编辑(图片添加，文字添加)，实现图片编辑中的图片添加，旋转，缩放，删除；文字的添加，大小缩放，字体更换，颜色更换，删除； 2. 基本滤镜实现与接口封装； 涂鸦(画笔的样式，粗细，颜色，橡皮擦，贴图)； 相框(简单相框，酷炫相框)； 马赛就克(基本马赛克，酷炫马赛克，橡皮擦)及其接口封装 
3. 接下来， 图像剪切，旋转等功能实现测试接口封装； 
4. GIF与MP4，图片互转实现测试与接口封装；

---
