# AndroidLibs == 列表 List

包含：ListView、GridView、RecyclerView、Refresh、LoadMore……

[<==返回首页==](https://github.com/XXApple/AndroidLibs)


---

**Generic-Adapter**: https://github.com/mohanmanu484/Generic-Adapter

One recycler view adapter for all your project

---

**SlimAdapter**: https://github.com/MEiDIK/SlimAdapter

A slim & clean & typeable Adapter without VIEWHOLDER

---

**scrollme-android**: https://github.com/salyangoz/scrollme-android

回到列表顶部

<img src="https://camo.githubusercontent.com/2eac43c7eb37b5ad5aa99ae2a792d040b93b4971/687474703a2f2f7777772e73616c79616e676f7a2e636f6d2e74722f7363726f6c6c6d652f73616d706c652d616e64726f69642e676966" width="320" />

---

**admobadapter**: https://github.com/clockbyte/admobadapter

It wraps your Adapter to display Admob native ads in a ListView/RecyclerView data set. It based on the Yahoo fetchr project

<img src="https://raw.githubusercontent.com/clockbyte/admobadapter/master/screenshots/ezgif.com-gif-maker.gif" width="320" />

---

**greedo-layout-for-android**: https://github.com/500px/greedo-layout-for-android

Full aspect ratio grid LayoutManager for Android's RecyclerView

<img src="https://github.com/500px/greedo-layout-for-android/raw/master/screenshot.png" width="320" />

---

**AutoRecyclerAdapter**: https://github.com/teambition/AutoRecyclerAdapter

Automated configuration RecyclerView.Adapter for Android

<img src="https://github.com/ruzhan123/AutoRecyclerAdapter/raw/master/gif/autos.gif" width="320" />

---

**recyclerview-adapters**: https://github.com/chuross/recyclerview-adapters

Multiple item adapters for RecyclerView

<img src="https://cloud.githubusercontent.com/assets/1422031/24061304/42627b7e-0b9a-11e7-97d1-14a6cabcfd59.gif" width="320" />

---

**EasySwipeMenuLayout**: https://github.com/anzaizai/EasySwipeMenuLayout

Android之自定义View：侧滑删除

<img src="https://camo.githubusercontent.com/83da24707ac86667c1410bfa875cd2abe05e5b33/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f313831313839332d653161613562326633366631636166352e6769663f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970" width="320" />

---

**DraggableTreeView**: https://github.com/jakebonk/DraggableTreeView

TreeView with drag and drop (n-th level)

<img src="https://camo.githubusercontent.com/2ef015a535f2caba2192de64508f251319894d5a/68747470733a2f2f7468756d62732e6766796361742e636f6d2f436f6e66757365645065726b7944776172666d6f6e676f6f73652d73697a655f726573747269637465642e676966" width="320" />

---

**Swiperoo**: https://github.com/BelkaLab/Swiperoo

滑动删除

<img src="https://raw.githubusercontent.com/BelkaLab/Swiperoo/master/swiperoo-library-live-demo.gif" width="600" />

---

**SmartRefreshLayout**: https://github.com/scwang90/SmartRefreshLayout

Android智能下拉刷新框架，支持越界回弹，集成了几十种炫酷的Header和 Footer

<img src="https://github.com/scwang90/SmartRefreshLayout/raw/master/art/gif_practive_weibo.gif" width="320" /> <img src="https://github.com/scwang90/SmartRefreshLayout/raw/master/art/gif_practive_feedlist.gif" width="320" />

---

**Typewriter**: https://github.com/Ilya-Gh/Typewriter

打字机效果的下拉刷新

<img src="https://github.com/Ilya-Gh/Typewriter/raw/master/animation.gif" width="320" />

---

**FireworkyPullToRefresh**: https://github.com/Cleveroad/FireworkyPullToRefresh

烟花效果的下拉刷新

<img src="https://raw.githubusercontent.com/Cleveroad/FireworkyPullToRefresh/master/images/demo_.gif" width="640" />

---

**SwipeableRV**: https://github.com/huan-nguyen/SwipeableRV

SwipeableRV

<img src="https://github.com/huan-nguyen/SwipeableRV/raw/master/screenshot/demo.gif" width="320" />

---

**SwipeMenuRecyclerView**: https://github.com/AItsuki/SwipeMenuRecyclerView

RecyclerView侧滑菜单

<img src="https://camo.githubusercontent.com/e175bae183bd9bd00b2331276279c0a3e9f1c285/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f323230323037392d363866396139373833386130356335332e6769663f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970" width="320" />

---

**ListItemView**: https://github.com/lurbas/ListItemView

基于 MD 实现的一些 List Item 的模板布局，可以帮助大家在开发的时候省时间

<img src="https://raw.githubusercontent.com/lurbas/ListItemView/master/readme/cover.png" width="600" />

---

**RendererRecyclerViewAdapter**: https://github.com/vivchar/RendererRecyclerViewAdapter

A single adapter for the whole project 

<img src="https://raw.githubusercontent.com/vivchar/RendererRecyclerViewAdapter/master/example_new.gif" width="320" />

---

**DiscreteScrollView**: https://github.com/yarolegovich/DiscreteScrollView

基于 RecyclerView 实现的横向滑动组件，超级漂亮和实用

<img src="https://raw.githubusercontent.com/yarolegovich/DiscreteScrollView/master/images/cards_shop.gif" width="320" /> <img src="https://raw.githubusercontent.com/yarolegovich/DiscreteScrollView/master/images/cards_weather.gif" width="320" />

---

**ExpectAnim**: https://github.com/florent37/ExpectAnim

通过描述来实现动画方案

<img src="https://raw.githubusercontent.com/florent37/ExpectAnim/master/media/sample.gif" width="320" /> 
<img src="https://raw.githubusercontent.com/florent37/ExpectAnim/master/media/scroll.gif" width="320" />

---

**SwipeCardview**: https://github.com/iravul/SwipeCardview

SwipeCardview for listing item or products

---

**ShimmerLayout**: https://github.com/team-supercharge/ShimmerLayout

Memory efficient shimmering effect for Android applications by Supercharge

<img src="https://github.com/team-supercharge/ShimmerLayout/raw/master/shimmerlayout.gif" width="320" />

---

**ShimmerRecyclerView**: https://github.com/tabassumLatif/ShimmerRecyclerView

Shimmer effect in RecyclerView

<img src="https://raw.githubusercontent.com/tabassumLatif/ShimmerRecyclerView/master/sample.gif?raw=true" width="320" />

---

**ShimmerRecyclerView**: https://github.com/sharish/ShimmerRecyclerView

ShimmerRecyclerView

<img src="https://raw.githubusercontent.com/sharish/ShimmerRecyclerView/master/screenshots/list_demo.gif" width="320" /> 
<img src="https://raw.githubusercontent.com/sharish/ShimmerRecyclerView/master/screenshots/grid_demo.gif" width="320" />

---

**SimpleRecyclerView**: https://github.com/jaychang0917/SimpleRecyclerView

A RecyclerView extension for building list more easily

<img src="https://github.com/jaychang0917/SimpleRecyclerView/raw/master/art/basic_usage.gif" width="320" />

---

**StickyDecoration**: https://github.com/Gavin-ZYX/StickyDecoration

利用RecyclerView.ItemDecoration实现顶部悬浮效果

<img src="https://camo.githubusercontent.com/c009cb18e1a2bc01f023cfe19b3ac25da7e0a472/687474703a2f2f75706c6f61642d696d616765732e6a69616e7368752e696f2f75706c6f61645f696d616765732f313633383134372d383939383664373134313734316364662e6769663f696d6167654d6f6772322f6175746f2d6f7269656e742f7374726970" width="300" />

---

**RecyclerStickyHeaderView**: https://github.com/TellH/RecyclerStickyHeaderView

在RecyclerView上实现吸顶布局

<img src="https://raw.githubusercontent.com/TellH/RecyclerStickyHeaderView/master/raw/effect.gif" width="320" />

---

**Sticky-Header-Grid**: https://github.com/Codewaves/Sticky-Header-Grid

Sticky-Header-Grid

<img src="https://github.com/Codewaves/Sticky-Header-Grid/blob/master/images/sample.gif" width="240" />

---

**LayoutSwitch**: https://github.com/gjiazhe/LayoutSwitch

实现 RecyclerView 布局切换动画的示例

<img src="https://raw.githubusercontent.com/gjiazhe/LayoutSwitch/master/screenshot/screenshot.gif" width="320" />

---

**excelPanel**: https://github.com/zhouchaoyuan/excelPanel

Android 用 RecyclerView 实现的二维 Excel 效果组件

<img src="https://raw.githubusercontent.com/zhouchaoyuan/excelPanel/master/app/src/main/assets/roomFormDemo.gif" width="320" />

---

**ShimmerRecyclerView**: https://github.com/sharish/ShimmerRecyclerView

类似 Facebook 加载时，条目的闪烁效果

<img src="https://raw.githubusercontent.com/sharish/ShimmerRecyclerView/master/screenshots/list_demo.gif" width="320" /> <img src="https://raw.githubusercontent.com/sharish/ShimmerRecyclerView/master/screenshots/grid_demo.gif" width="320" />

---

**sectionedmergeadapter**: https://github.com/abacritt/sectionedmergeadapter

Work with sub-sections in your Android ListView

<img src="https://raw.githubusercontent.com/abacritt/sectionedmergeadapter/master/app/Screenshot_20160724-231927.png" width="320" />

---

**TwinklingRefreshLayout**: https://github.com/lcodecorex/TwinklingRefreshLayout

TwinklingRefreshLayout 小而强大的刷新控件，自带顺滑的越界回弹

<img src="https://github.com/lcodecorex/TwinklingRefreshLayout/raw/master/art/gif_recyclerview.gif" width="320" /> <img src="https://github.com/lcodecorex/TwinklingRefreshLayout/raw/master/art/gif_recyclerview2.gif" width="320" />

---

**Paginate**: https://github.com/MarkoMilos/Paginate

下拉加载更多框架

<img src="https://raw.githubusercontent.com/MarkoMilos/Paginate/master/art/demo.gif" width="320" />

---

**EasyRecyclerView**: https://github.com/zhuliyuan921112/EasyRecyclerView

一个下拉刷新上拉加载更多框架

<img src="https://camo.githubusercontent.com/7467ac57d7290756110b1949b71cdb455d517548/687474703a2f2f6f66316b74796b737a2e626b742e636c6f7564646e2e636f6d2f6572765f6d6174657269616c5f6865616465722e676966" width="320" />

---

**ScrollablePanel**: https://github.com/Kelin-Hong/ScrollablePanel

支持多个方向滑动的 View，类似 Calendar 里的 UI 效果

<img src="https://raw.githubusercontent.com/Kelin-Hong/ScrollablePanel/master/art/ScrollablePanelDemo.gif" width="320" />

---

**flexbox-layout**: https://github.com/google/flexbox-layout

FlexboxLayout is a library project which brings the similar capabilities of CSS Flexible Box Layout Module to Android

<img src="https://raw.githubusercontent.com/google/flexbox-layout/master/assets/flex-direction.gif" width="270" /> <img src="https://raw.githubusercontent.com/google/flexbox-layout/master/assets/flex-wrap.gif" width="270" /> <img src="https://raw.githubusercontent.com/google/flexbox-layout/master/assets/justify-content.gif" width="270" />

---

**SpannedGridLayoutManager**: https://github.com/Arasthel/SpannedGridLayoutManager

支持不同形态的 Span Grid Layout

<img src="https://github.com/Arasthel/SpannedGridLayoutManager/raw/master/art/spannedgridlayout.gif" width="320" />

---

**turn-layout-manager**: https://github.com/cdflynn/turn-layout-manager

RecyclerView 半圆形布局

<img src="https://github.com/cdflynn/turn-layout-manager/raw/master/app/img/turn_demo.gif?raw=true" width="320" />

---

**LondonEyeLayoutManager**: https://github.com/danylovolokh/LondonEyeLayoutManager

A Layoutmanager that must be used with RecyclerView

<img src="https://cloud.githubusercontent.com/assets/2686355/11742412/651bc71e-a008-11e5-9a5e-4f10be4adbd8.gif" width="320" />

---

**HiveLayoutManager**: https://github.com/Chacojack/HiveLayoutManager

蜂巢布局管理器

<img src="https://camo.githubusercontent.com/77f9a87db596da7aced9fa32d32ba5159a5d2244/68747470733a2f2f636861636f6a61636b2e6769746875622e696f2f323031362f30392f32392f52656379636c6572566965772545372539412538342545342542382538302545342542382541412545392541392541432545382539432538322545372541412539442545352542382538332545352542312538302f686f72697a6f6e74616c2e706e67" width="270" />

---

**vlayout**: https://github.com/alibaba/vlayout

VirtualLayout是一个针对RecyclerView的LayoutManager扩展, 主要提供一整套布局方案和布局间的组件复用的问题

<img src="https://camo.githubusercontent.com/2b947a15f5502af5a4639a5927d68052ccfb54a3/687474703a2f2f696d67332e746263646e2e636e2f4c312f3436312f312f31623962666234323030393034376637356365653038616537343135303564653263373461633061" width="200" />

---

**CarouselLayoutManager**: https://github.com/Azoft/CarouselLayoutManager

让你的RecyclerView秀出传送带效果，支持横向和纵向两种选择

<img src="https://github.com/Azoft/CarouselLayoutManager/raw/master/resources/carousel_double_work_small.gif" width="320" />

---

**ChipsLayoutManager**: https://github.com/BelooS/ChipsLayoutManager

ANDROID. ChipsLayoutManager (SpanLayoutManager). A custom layout manager for RecyclerView which mimicric TextView span behaviour, flow layouts behaviour with support of amazing recyclerView features

<img src="https://github.com/BelooS/ChipsLayoutManager/raw/master/images/demo.gif" width="320" />

---

**DataBinding_For_RecyclerView**: https://github.com/drstranges/DataBinding_For_RecyclerView

Android Data Binding for RecyclerView: flexible way https://habrahabr.ru/post/308872/

<img src="https://raw.githubusercontent.com/drstranges/DataBinding_For_RecyclerView/master/!_img/img1.png" width="320" />

---

**SmileRefresh**: https://github.com/songixan/SmileRefresh

微笑下拉刷新。这是在 SwipeRefreshLayout基础上修改的下拉刷新库

<img src="https://camo.githubusercontent.com/baf0794018fbb0812ade7d741a94d34ac3500b94/687474703a2f2f696d672e626c6f672e6373646e2e6e65742f3230313631303133323032313335373530" width="320" />

---

**FriendGroupManage**: https://github.com/ysq1051838264/FriendGroupManage

仿qq分组管理，可以删除、增加、以及修改等等

<img src="https://raw.githubusercontent.com/ysq1051838264/FriendGroupManage/master/1.gif" width="320" />

---

**EasyHeaderFooterAdapter**: https://github.com/rubengees/EasyHeaderFooterAdapter

An Android library which adds headers and footers to the RecyclerView

<img src="https://raw.githubusercontent.com/rubengees/EasyHeaderFooterAdapter/master/art/sample.gif" width="320" />

---

**StickyViewPagerGridHeaders**: https://github.com/pchauhan/StickyViewPagerGridHeaders

StickyGridView + ViewPager + Header

<img src="https://raw.githubusercontent.com/pchauhan/StickyViewPagerGridHeaders/master/Screenshots/ScreenOne.png" width="270" /> <img src="https://raw.githubusercontent.com/pchauhan/StickyViewPagerGridHeaders/master/Screenshots/Screenhalfscroll.png" width="270" /> <img src="https://raw.githubusercontent.com/pchauhan/StickyViewPagerGridHeaders/master/Screenshots/Screenfullscroll.png" width="270" />

---

**MjolnirRecyclerView**: https://github.com/infinum/MjolnirRecyclerView

Provides a simple way to extend the default RecyclerView behaviour with support for headers, footers, empty view, DiffUtil and ArrayAdapter like methods

---

**SnappyRecyclerAdapter**: https://github.com/longbkiter07/SnappyRecyclerAdapter

manage RecyclerViewAdapter easier

---

**PinnedList-Android**: https://github.com/Joseph82/PinnedList-Android

This library allows you to create a list of items that are pinned by a floating label (text or image) on the left of the list

<img src="https://camo.githubusercontent.com/f5d88bebd99eccc89168d93c8c7ba31583733729/68747470733a2f2f7777772e64726f70626f782e636f6d2f732f79753235353862626d7633747763352f746578745f64656d6f312e6769663f7261773d74727565" width="220" /> <img src="https://camo.githubusercontent.com/2bb257d1e851edcbde37313420cb7de1fccbf7af/68747470733a2f2f7777772e64726f70626f782e636f6d2f732f74376d3779643876683677346a69622f696d6167655f64656d6f312e6769663f7261773d74727565" width="220" />

---

**pinned-section-listview**: https://github.com/beworker/pinned-section-listview

选中的item置顶的List

<img src="https://raw.githubusercontent.com/beworker/pinned-section-listview/master/web/screen3.png" width="220" />

---

**DoubleStickyHeadersList**: https://github.com/Kenber/DoubleStickyHeadersList

双Header的List

<img src="https://raw.githubusercontent.com/Kenber/DoubleStickyHeadersList/master/samplePicture/sample.gif" width="320" />

---

**CircleRecyclerView**: https://github.com/kHRYSTAL/CircleRecyclerView

CircleRecyclerView

<img src="https://raw.githubusercontent.com/kHRYSTAL/CircleRecyclerView/master/screenshot/screenshot1.gif" width="320" /> <img src="https://raw.githubusercontent.com/kHRYSTAL/CircleRecyclerView/master/screenshot/screenshot2.gif" width="320" />

---

**android-ElasticListView**: https://github.com/eschao/android-ElasticListView

ListView 下拉刷新，上拉更多

<img src="https://raw.githubusercontent.com/eschao/android-ElasticListView/master/images/elasticlistview_updating.png" width="300" /> <img src="https://raw.githubusercontent.com/eschao/android-ElasticListView/master/images/elasticlistview_loading.png" width="300" />

---

**RetailMeNotList**: https://github.com/iielse/RetailMeNotList

视差效果的 Item 滑动变大

<img src="https://github.com/iielse/RetailMeNotList/raw/master/previews/123456789.gif" width="320" /> <img src="https://github.com/iielse/RetailMeNotList/raw/master/previews/987654321.gif" width="320" />

---

**realm-android-adapters**: https://github.com/realm/realm-android-adapters

This repository holds adapters for combining Realm Java with Android UI components and framework classes

---

**EasyRecycleAdapterHelper**: https://github.com/HotBitmapGG/EasyRecycleAdapterHelper

一个轻量级简单实用的RecycleViewAdapter辅助类库

<img src="https://raw.githubusercontent.com/HotBitmapGG/EasyRecycleAdapterHelper/master/art/01.gif" width="320" /> <img src="https://raw.githubusercontent.com/HotBitmapGG/EasyRecycleAdapterHelper/master/art/02.gif" width="320" />

---

**SmartisanPull**: https://github.com/hougr/SmartisanPull

“锤子下拉”，东半球最优雅的下拉控件。也叫SmartisanRefreshableLayout

<img src="https://raw.githubusercontent.com/hougr/SmartisanPull/master/screenshot/smartisan_pull_small.gif" width="230" />

---

**AnimateFilterCalendarGridLayout**: https://github.com/DevLight-Mobile-Agency/AnimateFilterCalendarGridLayout

It is a layout like GridLayout. But children in it will fill the column. And you can filter your items with animation. And you can add animated calendar to your project.

<img src="https://camo.githubusercontent.com/5e017416bb7ab1281ced4b4be75b50d1e7ff156f/68747470733a2f2f6c68362e676f6f676c6575736572636f6e74656e742e636f6d2f2d4f4d5674354f77327473452f56736276626d4a4f6f75492f4141414141414141434c732f61516f417a5835684759772f773338362d683535312d6e6f2f6166676c2e676966" width="320" /> <img src="https://camo.githubusercontent.com/8703b683fe9df6fa645bb27c2037746571a03713/68747470733a2f2f6c68342e676f6f676c6575736572636f6e74656e742e636f6d2f2d64586f556e476a474c48452f56736276627465685633492f4141414141414141434c732f45715942364141356659492f773339362d683535322d6e6f2f6163676c2e676966" width="320" />

---

**itemtouchhelper-extension**: https://github.com/loopeer/itemtouchhelper-extension

itemtouchhelper 左滑删除等操作

<img src="https://raw.githubusercontent.com/loopeer/itemtouchhelper-extension/master/screenshot/itemtouch_spring.gif" width="230" /> <img src="https://raw.githubusercontent.com/loopeer/itemtouchhelper-extension/master/screenshot/itemtouch_recycler_width.gif" width="230" />

---

**RecyclerViewSnap**: https://github.com/rubensousa/RecyclerViewSnap

RecyclerView 边缘特效

<img src="https://raw.githubusercontent.com/rubensousa/RecyclerViewSnap/master/screens/snap_googleplay.gif" width="320" /> <img src="https://raw.githubusercontent.com/rubensousa/RecyclerViewSnap/master/screens/snap_final.gif" width="320" />

---

**ListView-Snapshot-Demo**: https://github.com/abhijith0505/ListView-Snapshot-Demo

A demo android application that uses the listview-snapshot android library

<img src="https://raw.githubusercontent.com/abhijith0505/ListView-Snapshot-Demo/master/screenshot.jpg" width="320" />

---

**SelectableListDecoration**: https://github.com/bhargavms/SelectableListDecoration

An Item decoration class for google design lib's RecyclerView

<img src="https://raw.githubusercontent.com/bhargavms/SelectableListDecoration/master/assets/Selection_001.png" width="320" /> <img src="https://raw.githubusercontent.com/bhargavms/SelectableListDecoration/master/assets/Selection_002.png" width="320" />

---

**SimpleRecycler**: https://github.com/e16din/SimpleRecycler

This library extends RecyclerView + Recycler Adapter

---

**RecyclerRefreshLayout**: https://github.com/dinuscxj/RecyclerRefreshLayout

A pull to refresh layout for android, the RecyclerRefreshLayout is based on the SwipeRefreshLayout

<img src="https://raw.githubusercontent.com/dinuscxj/RecyclerRefreshLayout/master/Preview/RecyclerRefreshLayoutNormal.gif?width=300" width="270" /> <img src="https://raw.githubusercontent.com/dinuscxj/RecyclerRefreshLayout/master/Preview/RecyclerRefreshLayoutNoData.gif?width=300" width="270" /> <img src="https://raw.githubusercontent.com/dinuscxj/RecyclerRefreshLayout/master/Preview/RecyclerRefreshLayoutFailure.gif?width=300" width="270" />

---

**AssemblyAdapter**: https://github.com/xiaopansky/AssemblyAdapter

Assembly Adapter Adapter is an extension library on Android, and with it you do not write the Adapter

---

**OkAdapters**: https://github.com/miguelbcr/OkAdapters

Wrappers for Android adapters to simply its api at a minimum

---

**PopupBubble**: https://github.com/webianks/PopupBubble

Easily add and customise "New Post" popup button with the feeds (RecyclerView) of your app

<img src="https://camo.githubusercontent.com/3f8912b907378a5227100a1c6d2868d641a826c6/687474703a2f2f7777772e77656269616e6b732e636f6d2f706f707570627562626c652f322e706e67" width="320" /> <img src="https://camo.githubusercontent.com/9374a2962d3bd61817569fc8483b651d2fbcd1b0/687474703a2f2f7777772e77656269616e6b732e636f6d2f706f707570627562626c652f332e706e67" width="320" />

---

**ExpandableRecyclerview-Databinding**: https://github.com/zaihuishou/ExpandableRecyclerview-Databinding

ExpandableRecyclerview Databinding implemention

<img src="https://raw.githubusercontent.com/zaihuishou/ExpandableRecyclerview-Databinding/master/Screenshots.gif" width="320" />

---

**ItemPool**: https://github.com/nekocode/ItemPool

Decouple the item(/nested viewholder) from recyclerview's adapter

---

**MultiViewAdapter**: https://github.com/DevAhamed/MultiViewAdapter

显示recycleview复杂布局

<img src="https://github.com/DevAhamed/MultiViewAdapter/raw/master/images/MultiViewAdapter-gif.gif?raw=true" width="320" />

---

**epoxy**: https://github.com/airbnb/epoxy

又一个显示recycleview复杂效果的库

<img src="https://raw.githubusercontent.com/airbnb/epoxy/master/epoxy-sample/epoxy_sample_app.gif" width="320" />

---

**AdapterX**: https://github.com/siper/AdapterX

Simple multiview RecyclerView adapter

---

**groupie**: https://github.com/Genius/groupie

Groupie helps you display and manage complex RecyclerView layouts

<img src="https://camo.githubusercontent.com/37f2d500453ef5c5441c7f68bc69ad1145460a9a/687474703a2f2f692e696d6775722e636f6d2f6566744f4530762e676966" width="320" />

---

**MultiTypeView**: https://github.com/LuckyJayce/MultiTypeView

简化RecyclerView的多种type的adapter，Fragment可以动态添加到RecyclerView上，实现复杂的界面分多个模块开发

<img src="https://raw.githubusercontent.com/LuckyJayce/MultiTypeView/master/raw/1.png" width="320" />

---

**MultiType**: https://github.com/drakeet/MultiType

一个列表显示多个不同条目

<img src="https://raw.githubusercontent.com/drakeet/MultiType/master/art/screenshot.png" width="320" />

---

**FunGameRefresh**: https://github.com/Hitomis/FunGameRefresh

好玩的下拉刷新控件，让我们一起来回味童年

<img src="https://raw.githubusercontent.com/Hitomis/FunGameRefresh/master/preview/HitBlock.gif" width="270" /> <img src="https://raw.githubusercontent.com/Hitomis/FunGameRefresh/master/preview/BattleCity.gif" width="270" />

---

**PullToRefresh**: https://github.com/lubeast/PullToRefresh

A PullToRefresh widget. https://lubeast.github.io/PullToRefresh/

<img src="https://camo.githubusercontent.com/f390437ba548be66a9e4c91389e5587000533c24/68747470733a2f2f7261772e6769746875622e636f6d2f6c7562656173742f50756c6c4c61756e6368526f636b65742f6d61737465722f73637265656e73686f74732f726f636b65742e676966" width="240" /> <img src="https://camo.githubusercontent.com/3947994e16b8e19b744f254e69219c626527fe37/68747470733a2f2f7261772e6769746875622e636f6d2f6c7562656173742f50756c6c4c61756e6368526f636b65742f6d61737465722f73637265656e73686f74732f73756e72616973652e676966" width="240" />

---

**SlyceMessaging**: https://github.com/snipsnap/SlyceMessaging

Easily add Sticky Headers to your RecyclerView

<img src="https://raw.githubusercontent.com/snipsnap/SlyceMessaging/master/sample-photos/example.png" width="240" /> <img src="https://raw.githubusercontent.com/snipsnap/SlyceMessaging/master/sample-photos/chat-with-image.png" width="240" />

---

**StickyHeaderListView**: https://github.com/sfsheng0322/StickyHeaderListView

StickyHeaderListView 是基于实际需求做出的灵活可定制的UI功能，具体实现功能如下：  
一、支持无限循环的广告位。  
二、高度可动态配置的Header2和Header3（使用GridView实现）。  
三、主要功能：分类、排序和筛选布局滑动到顶部后吸附、悬停。  
四、自定义FilterView筛选控件，支持动画显示与动画隐藏。  
五、支持标题栏背景颜色渐变、字体颜色渐变。  
六、数据不足一屏动态添加空数据占位。  
七、数据为空时，ListView加载暂无数据视图。  
八、思路清晰、界面优美，添加ripple点击效果。  
九、支持下拉刷新和上拉加载更多功能。  

<table>
    <tr>
        <td><img src="https://github.com/sfsheng0322/StickyHeaderListView/raw/master/screenshots/stickyheader.gif" style="width: 30%;"></td>
        <td><img src="https://github.com/sfsheng0322/StickyHeaderListView/raw/master/screenshots/stickyheader2.gif" style="width: 30%;"></td>
    </tr>
</table>

---

**ClearRecyclerAdapter**: https://github.com/Prokky/ClearRecyclerAdapter

Boilerplate code free Adapter for RecyclerView

---

**Endless-RecyclerView**: https://github.com/ybq/Endless-RecyclerView

加载更多 RecyclerView

---

**SpringView**: https://github.com/liaoinstan/SpringView

A custom view can pull up and down,support ScrollView,ListView,RecyclerView,WebView

![1](https://github.com/liaoinstan/SpringView/blob/master/screenshot/1459212323072_s.gif) ![2](https://github.com/liaoinstan/SpringView/blob/master/screenshot/1459212372609_s.gif)
![3](https://github.com/liaoinstan/SpringView/blob/master/screenshot/1459212462800_s.gif) ![4](https://github.com/liaoinstan/SpringView/blob/master/screenshot/1459212485237_s.gif)

---

**StickyHeaders**: https://github.com/bgogetap/StickyHeaders

Easily add Sticky Headers to your RecyclerView

<img src="https://github.com/bgogetap/StickyHeaders/raw/master/art/demo.gif" width="270" />

---

**ExtendedRecyclerAdapter**: https://github.com/sergiocasero/ExtendedRecyclerAdapter

Simple library for DRY recycler adapter

<img src="https://raw.githubusercontent.com/sergiocasero/ExtendedRecyclerAdapter/master/art/ExtendedRecyclerView.gif" width="270" />

---

**recycler-core**: https://github.com/carrot/recycler-core

Multiple view type handling in RecyclerViews with 90% less tears

<img src="https://camo.githubusercontent.com/37e1cf21eef72546c34f463eba54d40e6ea34740/687474703a2f2f692e696d6775722e636f6d2f4e503757626f712e706e67" width="360" />

---

**RecyclerViewTools**: https://github.com/eyeem/RecyclerViewTools

Collection of tools for RecyclerView. Includes headers, sections, pull to refresh, etc

---

**overscroll-bouncy-android**: https://github.com/chthai64/overscroll-bouncy-android

Overscroll bounce effect for Android

<img src="https://github.com/chthai64/overscroll-bouncy-android/raw/master/arts/OverscrollDemo.gif" width="320" />

---

**CircleRefreshLayout**: https://github.com/tuesda/CircleRefreshLayout

a custom pull-to-refresh layout which contains a interesting animation

<img src="https://github.com/tuesda/CircleRefreshLayout/blob/master/gif/circlerefresh.gif" width="320" />

---

**SnappySmoothScroller**: https://github.com/nshmura/SnappySmoothScroller

可流畅滚动的 Recyclerview

<img src="https://raw.githubusercontent.com/nshmura/SnappySmoothScroller/master/assets/demo.gif" width="320" />

---

**SwiftAdapter**: https://github.com/vkondrav/SwiftAdapter

可展开的 Recyclerview

<img src="https://camo.githubusercontent.com/7d442887b9fcf56f0244f698f63307fab73b453b/687474703a2f2f63646e2e73747265616d61626c652e636f6d2f696d6167652f686772692e6a7067" width="320" />

---

**ExpandableRecyclerview**: https://github.com/zaihuishou/ExpandableRecyclerview

可展开的 Recyclerview

<img src="https://raw.githubusercontent.com/zaihuishou/ExpandableRecyclerview/master/sample-screen.gif" width="320" />

---

**baseAdapter**: https://github.com/hongyangAndroid/baseAdapter

Android 万能的Adapter for ListView,RecyclerView,GridView等，支持多种Item类型的情况

<img src="https://raw.githubusercontent.com/hongyangAndroid/baseAdapter/master/screenshot/single.png" width="320" /> <img src="https://raw.githubusercontent.com/hongyangAndroid/baseAdapter/master/screenshot/rvadapter_01.png" width="320" />

---

**GridBuilder**: https://github.com/Eason90/GridBuilder

A Builder of Android GridLayout

<img src="https://raw.githubusercontent.com/Eason90/GridBuilder/master/screenshots/GridBuilder_1.png" width="600" />

---

**power-adapters**: https://github.com/NextFaze/power-adapters

Composable adapters for Android RecyclerViews and ListViews

---

**rxlist-binder**: https://github.com/s0nerik/rxlist-binder

Binds RxList with the RecyclerView.Adapter

---

**WheelView**: https://github.com/venshine/WheelView

Android滚轮控件，基于ListView实现，可以自定义样式

<img src="https://raw.githubusercontent.com/venshine/WheelView/master/screenshot/screenshot.gif" width="280" /> <img src="https://raw.githubusercontent.com/venshine/WheelView/master/screenshot/screenshot1.png" width="280" />

---

**FocusResize**: https://github.com/borjabravo10/FocusResize

RecyclerView 实现的焦点自动调整

<img src="https://raw.githubusercontent.com/borjabravo10/FocusResize/master/resources/focusResize.gif" width="320" />

---

**TEmptyView**: https://github.com/barryhappy/TEmptyView

TEmptyView是一个小轮子，可简单地设置EmptyView

<img src="https://raw.githubusercontent.com/barryhappy/TEmptyView/master/etc/demo1.png" width="320" /> <img src="https://raw.githubusercontent.com/barryhappy/TEmptyView/master/etc/demo2.png" width="320" />

---

**HeaderAndFooterRecyclerView**: https://github.com/cundong/HeaderAndFooterRecyclerView

A RecyclerView solution, Support addHeaderView, addFooterView, and page loading

<img src="https://raw.githubusercontent.com/cundong/HeaderAndFooterRecyclerView/master/art/art1.png" width="270" /> <img src="https://raw.githubusercontent.com/cundong/HeaderAndFooterRecyclerView/master/art/art3.png" width="270" /> <img src="https://raw.githubusercontent.com/cundong/HeaderAndFooterRecyclerView/master/art/art5.png" width="270" />

---

**LastAdapter**: https://github.com/nitrico/LastAdapter

Don't write a RecyclerView adapter again. Not even a ViewHolder!

---

**Persei.android**: https://github.com/android-cjj/Persei.android

android 版本 Persei

<img src="https://raw.githubusercontent.com/Yalantis/Persei/master/Assets/animation.gif" width="800" />

---

**RecyclerView-MultipleViewTypesAdapter**: https://github.com/yqritc/RecyclerView-MultipleViewTypesAdapter

Android library defining adapter classes of RecyclerView to manage multiple view types

<img src="https://raw.githubusercontent.com/yqritc/RecyclerView-MultipleViewTypesAdapter/master/sample/sample.gif" width="300" />

---

**Toro**: https://github.com/eneim/Toro

Video list auto playback made simple, specially built for RecyclerView

<img src="https://raw.githubusercontent.com/eneim/Toro/master/art/sample_2.gif" width="300" /> <img src="https://raw.githubusercontent.com/eneim/Toro/master/art/sample_4.gif" width="300" />

---

**ListVideoPlay**: https://github.com/brucetoo/ListVideoPlay

Play video in ListView,RecyclerView,and support full-screen,and more feature about video play control

<img src="https://github.com/brucetoo/ListVideoPlay/raw/master/list_video_play.gif" width="300" />

---

**VideoListDemo**: https://github.com/w1123440793/VideoListDemo

一个视频播放列表demo，视频播放使用的ijkplayer,正在播放视频拖动到不可见区域小窗口播放，可全屏切换

<img src="https://raw.githubusercontent.com/w1123440793/VideoListDemo/master/screenshots/vidiolist.gif" width="300" />

---

**Barandroid-sectioned-adapter**: https://github.com/CardinalNow/android-sectioned-adapter

RecyclerView.Adapter 的封装，可自动排序并添加 header

<img src="https://camo.githubusercontent.com/3b85d647e98d540f0ea2be9850691771b430cf79/68747470733a2f2f646c2e64726f70626f7875736572636f6e74656e742e636f6d2f752f33333838303133382f5374616e646172644865616465722e706e67" width="320" /> <img src="https://camo.githubusercontent.com/cb545f8abe903267a9a31df07c126b6b7682dce9/68747470733a2f2f646c2e64726f70626f7875736572636f6e74656e742e636f6d2f752f33333838303133382f437573746f6d486561646572732e706e67" width="320" />

---

**FastScroll**: https://github.com/L4Digital/FastScroll

A ListView-like FastScroller for Android’s RecyclerView

<img src="https://raw.githubusercontent.com/L4Digital/FastScroll/master/fastscroll_example.png" width="320" />

---

**MaterialScrollBar**: https://github.com/turing-tech/MaterialScrollBar

An Android library that brings the Material Design 5.1 sidebar to pre-5.1 devices

<img src="https://raw.githubusercontent.com/turing-tech/MaterialScrollBar/master/sample.png" width="320" />

---

**WaveSideBar**: https://github.com/gjiazhe/WaveSideBar

An index side bar with wave effect

<img src="https://raw.githubusercontent.com/gjiazhe/WaveSideBar/master/screenshot/gif.gif" width="270" /> <img src="https://raw.githubusercontent.com/gjiazhe/WaveSideBar/master/screenshot/position_left.png" width="270" />

---

**Android-QuickSideBar**: https://github.com/saiwu-bigkoo/Android-QuickSideBar

帮助快速查阅对应分组的侧边栏

<img src="https://raw.githubusercontent.com/saiwu-bigkoo/Android-QuickSideBar/master/preview/quicksidebardemo.gif" width="320" />

---

**ShimmerContactsView**: https://github.com/TakeoffAndroid/ShimmerContactsView

Loading contacts made simple with ShimmerContactsView

<img src="https://camo.githubusercontent.com/cd00caacd89b4671a6c79b59f4d838c74d0d15e1/687474703a2f2f692e696d6775722e636f6d2f6859306e3751472e676966" width="320" /> <img src="https://camo.githubusercontent.com/4d33a3e0cda2a395361340c8357ca6fc14bc0fc0/687474703a2f2f692e696d6775722e636f6d2f6e764d64554a492e676966" width="320" />

---

**bubble-scroll**: https://github.com/cdflynn/bubble-scroll

泡泡效果的索引滚动控件

<img src="https://github.com/cdflynn/bubble-scroll/raw/master/sample/img/scroll_sample_gif.gif?raw=true" width="320" />

---

**SideBar**: https://github.com/kongnanlive/SideBar

全新的快速索引导航栏，联系人字母排序侧边栏

<img src="https://raw.githubusercontent.com/kongnanlive/SideBar/master/gif5.gif" width="200" />

---

**AnimSideBar**: https://github.com/AlexLiuSheng/AnimSideBar

A SiderBar base on Android that has a beautiful anim

<img src="https://cloud.githubusercontent.com/assets/12408339/15278798/0df854a2-1b50-11e6-962e-15cb94ecc113.gif" width="320" />

---

**SpringHeader**: https://github.com/loopeer/SpringHeader

CoordinatorLayout 实现的下拉刷新

<img src="https://raw.githubusercontent.com/loopeer/SpringHeader/master/art/demo.gif" width="320" />

---

**AdapterDelegates-ListView**: https://github.com/esafirm/AdapterDelegates-ListView

ListView Adapter 代理工具

---

**SwipeActionAdapter**: https://github.com/wdullaer/SwipeActionAdapter

ListView 左滑右滑

<img src="https://camo.githubusercontent.com/d02997a8f88b797a1df02e768a822a2bf7e9daa5/68747470733a2f2f7261772e6769746875622e636f6d2f7764756c6c6165722f5377697065416374696f6e416461707465722f67682d70616765732f696d616765732f73776970655f322e706e67" width="400" /> <img src="https://camo.githubusercontent.com/7215066edafdb957f51fa7c30bd1e62f74a1210e/68747470733a2f2f7261772e6769746875622e636f6d2f7764756c6c6165722f5377697065416374696f6e416461707465722f67682d70616765732f696d616765732f73776970655f312e706e67" width="400" />

---

**ParallaxRecyclerView**: https://github.com/mzelzoghbi/ParallaxRecyclerView

视差效果 RecyclerView 

<img src="https://raw.githubusercontent.com/mzelzoghbi/ParallaxRecyclerView/master/gif_1.gif" width="240" /> <img src="https://raw.githubusercontent.com/mzelzoghbi/ParallaxRecyclerView/master/gif_2.gif" width="240" />

---

**MultiChoiceRecyclerView**: https://github.com/dvdciri/MultiChoiceRecyclerView

RecyclerView 实现的多选框架

<img src="https://raw.githubusercontent.com/dvdciri/MultiChoiceRecyclerView/master/example1.png" width="270" /> <img src="https://raw.githubusercontent.com/dvdciri/MultiChoiceRecyclerView/master/example2.png" width="270" /> <img src="https://raw.githubusercontent.com/dvdciri/MultiChoiceRecyclerView/master/example.png" width="270" />

---

**RecyclerViewEnhanced**: https://github.com/nikhilpanju/RecyclerViewEnhanced

RecyclerView 用法增强

<img src="https://raw.githubusercontent.com/nikhilpanju/RecyclerViewEnhanced/master/sample/src/common/images/Demo.gif" width="320" />

---

**CardStackView**: https://github.com/loopeer/CardStackView

Show something like cards with 3 kinds of animations

<img src="https://raw.githubusercontent.com/loopeer/CardStackView/master/screenshot/screenshot1.gif" width="320" /> <img src="https://raw.githubusercontent.com/loopeer/CardStackView/master/screenshot/screenshot3.gif" width="320" />

---

**RecyclerViewUndoSwipe**: https://github.com/HoneyNeutrons/RecyclerViewUndoSwipe

超实用！！ Android RecyclerView Undo Swipe支持

<img src="https://camo.githubusercontent.com/633c9f0144b49b6a90edb18e44361f843010cd0f/687474703a2f2f696d6775722e636f6d2f523931554a716c2e676966" width="640" />

---

**flowlayoutmanager**: https://github.com/xiaofeng-han/AndroidLibs/tree/master/flowlayoutmanager

FlowLayoutManager is a layoutManager that works with Android RecyclerView Widget

<img src="https://cloud.githubusercontent.com/assets/15362031/15170689/fe3117d6-16fc-11e6-8ffc-3e90b9bf5430.gif" width="320" />

---

**ExpandableDelegates**: https://github.com/Marchuck/ExpandableDelegates

more easy way to add multiple delegates to your expandable recyclerView!

---

**CommonAdapter**: https://github.com/qyxxjd/CommonAdapter

一个适用于ListView/GridView/RecyclerView的Adapter库,简化大量重复代码,支持多种布局,可自定义图片加载的实现

<img src="https://raw.githubusercontent.com/qyxxjd/CommonAdapter/master/screenshots/main.png" width="270" /> <img src="https://raw.githubusercontent.com/qyxxjd/CommonAdapter/master/screenshots/simple.png" width="270" /> <img src="https://raw.githubusercontent.com/qyxxjd/CommonAdapter/master/screenshots/multiple.png" width="270" />

---

**FlexibleAdapter**: https://github.com/davideas/FlexibleAdapter

Adapter for SelectionMode, ViewHolders, Filter, FastScroller, Animations, Undo, Headers, Expandable, Draggable, Swipeable

<img src="https://raw.githubusercontent.com/davideas/FlexibleAdapter/master/screenshots/drag_grid_overall.png" width="270" /> <img src="https://raw.githubusercontent.com/davideas/FlexibleAdapter/master/screenshots/undo_single_selection.png" width="270" /> <img src="https://raw.githubusercontent.com/davideas/FlexibleAdapter/master/screenshots/swipe-to-dismiss2.png" width="270" />

---

**SnappingSwipingRecyclerView**: https://github.com/CarlLee/SnappingSwipingRecyclerView

似微信读书首页的长按之后滑动删除的特效和动画

<img src="https://raw.githubusercontent.com/CarlLee/SnappingSwipingRecyclerView/master/preview.gif" width="320" />

---

**EasyRecyclerView**: https://github.com/diegodobelo/AndroidExpandingViewLibrary

展开收缩的View

<img src="https://d13yacurqjgara.cloudfront.net/users/226618/screenshots/2340386/shoping_list.gif" width="600" />

---

**StaggeredTextGridView**: https://github.com/riontech-xten/StaggeredTextGridView

自定义瀑布流文本 GridView

<img src="https://raw.githubusercontent.com/riontech-xten/StaggeredTextGridView/master/Screenshot_2016-04-28-19-52-08.png" width="320" /> <img src="https://raw.githubusercontent.com/riontech-xten/StaggeredTextGridView/master/Screenshot_2016-05-23-14-54-26.png" width="320" />

---

**EasyRecyclerView**: https://github.com/Jude95/EasyRecyclerView

常用的RecyclerView的各种需求封装进库

<img src="https://github.com/Jude95/EasyRecyclerView/blob/master/recycler3.gif" width="320" />

---

**InfiniteListView**: https://github.com/ugurcany/InfiniteListView

上拉加载更多，下拉刷新

<img src="https://raw.githubusercontent.com/ugurcany/InfiniteListView/master/infinitelistview.gif" width="320" />

---

**StickyHeaders**: https://github.com/ShamylZakariya/StickyHeaders

Adapter and LayoutManager for Android RecyclerView which enables sticky header positioning

<img src="https://raw.githubusercontent.com/ShamylZakariya/StickyHeaders/master/readme-assets/video-addressbook.gif" width="320" /> <img src="https://raw.githubusercontent.com/ShamylZakariya/StickyHeaders/master/readme-assets/video-callbacks.gif" width="320" />

---

**CalendarListview**: https://github.com/traex/CalendarListview

CalendarListview provides a easy way to select dates with a calendar for API 10+

<img src="https://raw.githubusercontent.com/traex/CalendarListview/master/demo.gif" width="320" />

---

**BaseRecyclerViewAdapterHelper**: https://github.com/CymChad/BaseRecyclerViewAdapterHelper

Powerful and flexible RecyclerAdapter,www.recyclerview.org

<img src="https://github.com/CymChad/BaseRecyclerViewAdapterHelper/blob/master/demo_res/demo.gif" width="320" />

---

**RecyclerViewPresenter**: https://github.com/kibotu/RecyclerViewPresenter

Convenience library to handle different view types with different presenters in a single RecyclerView

<img src="https://raw.githubusercontent.com/kibotu/RecyclerViewPresenter/master/screenshot.png" width="300" />

---

**recyclerview-animators**: [https://github.com/wasabeef/recyclerview-animators](https://github.com/wasabeef/recyclerview-animators)

An Android Animation library which easily add itemanimator to RecyclerView items.

<img src="https://github.com/wasabeef/recyclerview-animators/blob/master/art/demo.gif" width="160" />
<img src="https://github.com/wasabeef/recyclerview-animators/blob/master/art/demo2.gif" width="160" />
<img src="https://github.com/wasabeef/recyclerview-animators/blob/master/art/demo4.gif" width="160" />
<img src="https://github.com/wasabeef/recyclerview-animators/blob/master/art/demo3.gif" width="160" />
<img src="https://github.com/wasabeef/recyclerview-animators/blob/master/art/demo5.gif" width="160" />

---

**EasyAdapter**: https://github.com/mzule/EasyAdapter

一种简单的 Adapter 解决方案，支持多种 ViewType，轻松创建 ViewHolder 模式 Adapter. 支持 ListView 和 RecyclerView

---

**recyclerviewhelper**: https://github.com/nisrulz/recyclerviewhelper

RecyclerView 超强助手

---

**android-PullRefreshLayout**: [https://github.com/baoyongzhang/android-PullRefreshLayout](https://github.com/baoyongzhang/android-PullRefreshLayout)

This component like SwipeRefreshLayout, it is more beautiful than SwipeRefreshLayout.

<img src="https://raw.githubusercontent.com/baoyongzhang/android-PullRefreshLayout/master/demo.gif" width="320" />

---

**android-Ultra-Pull-To-Refresh**: https://github.com/liaohuqiu/android-Ultra-Pull-To-Refresh

Ultra Pull to Refresh for Android. Support all the views. [http://android-ultra-ptr.liaohuqiu.net/](http://android-ultra-ptr.liaohuqiu.net/)

<img src="https://camo.githubusercontent.com/588a2ef2cdcfb6c71e88437df486226dd15605b3/687474703a2f2f737261696e2d6769746875622e71696e6975646e2e636f6d2f756c7472612d7074722f73746f72652d686f7573652d737472696e672d61727261792e676966" width="160" />
<img src="https://camo.githubusercontent.com/d3fbe757c87fddc94e998ebdd08ac55956aed1cf/687474703a2f2f737261696e2d6769746875622e71696e6975646e2e636f6d2f756c7472612d7074722f73746f72652d686f7573652d737472696e672e676966" width="160" />
<img src="https://camo.githubusercontent.com/4dfccd5a50f7d59b512300fce341a1217950603a/687474703a2f2f737261696e2d6769746875622e71696e6975646e2e636f6d2f756c7472612d7074722f6d6174657269616c2d7374796c652e676966" width="160" />
<img src="https://camo.githubusercontent.com/9033435ad82be43ccddc8203450f361ee270c724/687474703a2f2f737261696e2d6769746875622e71696e6975646e2e636f6d2f756c7472612d7074722f70756c6c2d746f2d726566726573682e676966" width="160" />
<img src="https://camo.githubusercontent.com/88cdf877aa0a1fb19506ecf3404447eba59e68cc/687474703a2f2f737261696e2d6769746875622e71696e6975646e2e636f6d2f756c7472612d7074722f6175746f2d726566726573682e676966" width="160" />

---

**Chris-Android-PullToRefresh**: https://github.com/bboyfeiyu/Chris-Android-PullToRefresh

下拉刷新，上拉加载库

<img src="https://raw.githubusercontent.com/chrisbanes/Android-PullToRefresh/master/header_graphic.png" width="480" />

---

**RecyclerView-FastScroll**: https://github.com/timusus/RecyclerView-FastScroll

A simple FastScroller for Android's RecyclerView

<img src="https://raw.githubusercontent.com/timusus/RecyclerView-FastScroll/master/screenshot.png" width="320" />

---

**Timeline-View**: https://github.com/vipulasri/Timeline-View

Android Timeline View is used to display views like Tracking of shipment/order, steppers etc

<img src="https://github.com/vipulasri/Timeline-View/blob/master/Screenshot1.png" width="320" />

---

**MultiStateView**: [https://github.com/Kennyc1012/MultiStateView](https://github.com/Kennyc1012/MultiStateView)

Android View that displays different content based on its state

<img src="https://github.com/Kennyc1012/MultiStateView/blob/master/art/content.png" width="160" />
<img src="https://github.com/Kennyc1012/MultiStateView/blob/master/art/loading.png" width="160" />
<img src="https://github.com/Kennyc1012/MultiStateView/raw/master/art/empty.png" width="160" />
<img src="https://github.com/Kennyc1012/MultiStateView/raw/master/art/error.png" width="160" />

---

**FlyRefresh**: [https://github.com/race604/FlyRefresh](https://github.com/race604/FlyRefresh)

The implementation of [https://dribbble.com/shots/2067564-Replace](https://dribbble.com/shots/2067564-Replace)

<img src="https://github.com/race604/FlyRefresh/blob/master/images/flyrefresh.gif" width="320" />

---

**ToDoList**: https://github.com/Yalantis/ToDoList

Yalantis 放出的一个新作品：ToDoList，拥有非常平滑漂亮的动画

<img src="https://raw.githubusercontent.com/Yalantis/ToDoList/master/content_shot_to-do_dribbble.gif" width="600" />

---

**Multi-Selection**: https://github.com/Yalantis/Multi-Selection

Yalantis 放出的又一大作：Multi-Selection （优雅多选框），把选中的先存起来

<img src="https://raw.githubusercontent.com/Yalantis/Multi-Selection/develop/imgs/dribble.gif" width="600" />

---

**pull-to-make-soup**: https://github.com/Yalantis/pull-to-make-soup

RecyclerView 下拉刷新

<img src="https://raw.githubusercontent.com/Yalantis/PullToMakeSoup/master/PullToMakeSoupDemo/Resouces/recipe-finder.gif" width="600" />

---

**Phoenix**: [https://github.com/Yalantis/Phoenix](https://github.com/Yalantis/Phoenix)

Phoenix Pull-to-Refresh. [https://yalantis.com/](https://yalantis.com/)

<img src="https://camo.githubusercontent.com/d406ac5a03a2b1fa5cf41fadc8d2408cb8709bdc/68747470733a2f2f6431337961637572716a676172612e636c6f756466726f6e742e6e65742f75736572732f3132353035362f73637265656e73686f74732f313635303331372f7265616c6573746174652d70756c6c5f312d322d332e676966" width="320" />

---

**Taurus**: [https://github.com/Yalantis/Taurus](https://github.com/Yalantis/Taurus)

A little more fun for the pull-to-refresh interaction.[https://yalantis.com/](https://yalantis.com/)

<img src="https://camo.githubusercontent.com/3a24e22eb3f8338573dba0701c089c12f6b70f11/68747470733a2f2f6431337961637572716a676172612e636c6f756466726f6e742e6e65742f75736572732f3132353035362f73637265656e73686f74732f313632333133312f746f7572732d70756c6c2d616972706c616e655f322d322d332e676966" width="320" />

---

**CircleRefreshLayout**: [https://github.com/tuesda/CircleRefreshLayout](https://github.com/tuesda/CircleRefreshLayout)

a custom pull-to-refresh layout which contains a interesting animation.

<img src="https://github.com/tuesda/CircleRefreshLayout/blob/master/gif/circlerefresh.gif" width="320" />

---

**SmoothRefreshLayout**: https://github.com/dkzwm/SmoothRefreshLayout

.一个高效的Android刷新库，理论上支持所有的视图，比官方的SwipeRefreshLayout更强大且使用方便

<img src="https://github.com/dkzwm/SmoothRefreshLayout/blob/master/snapshot/test_two_level_refresh.png" width="320" />

---

**WaveSwipeRefreshLayout**: [https://github.com/recruit-lifestyle/WaveSwipeRefreshLayout](https://github.com/recruit-lifestyle/WaveSwipeRefreshLayout)

[http://engineer.recruit-lifestyle.co.jp/techblog/2015-08-03-swipe-refresh-layout/](http://engineer.recruit-lifestyle.co.jp/techblog/2015-08-03-swipe-refresh-layout/)

<img src="https://github.com/recruit-lifestyle/WaveSwipeRefreshLayout/blob/master/sc/animation.gif" width="320" />

---

**FoldableLayout**: [https://github.com/worldline/FoldableLayout](https://github.com/worldline/FoldableLayout)

An Android demo of a foldable layout implementation.

<img src="https://raw.githubusercontent.com/worldline/FoldableLayout/dev/screenshots/demo.gif" width="320" />

---

**SuperRecyclerView**: [https://github.com/Malinskiy/SuperRecyclerView](https://github.com/Malinskiy/SuperRecyclerView)

Pumped up RecyclerView

---

**RecyclerViewSwipeDismiss**: [https://github.com/CodeFalling/RecyclerViewSwipeDismiss](https://github.com/CodeFalling/RecyclerViewSwipeDismiss)

A very easy-to-use and non-intrusive implement of Swipe to dismiss for RecyclerView.

<img src="https://github.com/CodeFalling/RecyclerViewSwipeDismiss/blob/master/RecyclerViewSwipeDismiss.gif" width="320" />

---

**FlabbyListView**: [https://github.com/jpardogo/FlabbyListView](https://github.com/jpardogo/FlabbyListView)

Android library to display a ListView whose cells are not rigid but flabby and react to ListView scroll.

<img src="https://camo.githubusercontent.com/2194c820b758d70a0bf525e14e1b7f3f135b6ece/687474703a2f2f692e696d6775722e636f6d2f756743424869482e6769665d28687474703a2f2f692e696d6775722e636f6d2f756743424869482e676966" width="320" />
<img src="https://camo.githubusercontent.com/e8e4947b18c6998175e02c3ea8b5c898eea35cfd/687474703a2f2f692e696d6775722e636f6d2f776657477242532e6769665d28687474703a2f2f692e696d6775722e636f6d2f776657477242532e676966" width="320" />

---

**TimelineView**: https://github.com/alorma/TimelineView

Cute timeline view for android

<img src="https://github.com/alorma/TimelineView/blob/master/screenshot.png" width="320" />

---

**ParallaxListView**: [https://github.com/Gnod/ParallaxListView](https://github.com/Gnod/ParallaxListView)

A Android ListView Demo with a parallax effect header like Path.

<img src="https://github.com/Gnod/ParallaxListView/blob/master/img_sample.gif" width="320" />

---

**PullZoomView**: [https://github.com/Frank-Zhu/PullZoomView](https://github.com/Frank-Zhu/PullZoomView)

An Android custom ListView and ScrollView with pull to zoom-in.

<img src="https://raw.githubusercontent.com/Frank-Zhu/PullZoomView/master/art/pull-to-zoom.gif" width="320" />

---

**SwipeMenuListView**: [https://github.com/baoyongzhang/SwipeMenuListView](https://github.com/baoyongzhang/SwipeMenuListView)

A swipe menu for ListView.

<img src="https://raw.githubusercontent.com/baoyongzhang/SwipeMenuListView/master/demo.gif" width="320" />

---

**discrollview**: [https://github.com/flavienlaurent/discrollview](https://github.com/flavienlaurent/discrollview)

Scroll + discover = DiscrollView

<img src="https://github.com/wasabeef/awesome-android-ui/blob/master/art/discrollview.gif" width="320" />

---

**StickyListHeaders**: [https://github.com/emilsjolander/StickyListHeaders](https://github.com/emilsjolander/StickyListHeaders)

An android library for section headers that stick to the top

<img src="https://github.com/emilsjolander/StickyListHeaders/raw/master/demo.gif" width="320" />

---

**ListBuddies**: [https://github.com/jpardogo/ListBuddies](https://github.com/jpardogo/ListBuddies)

Android library to achieve in an easy way, the behaviour of the home page in the Expedia app, with a pair of auto-scroll circular parallax ListViews.

<img src="https://camo.githubusercontent.com/263db3cffd142dbbacf06fb43aaa5997ff1c243e/68747470733a2f2f7261772e6769746875622e636f6d2f6a706172646f676f2f4c697374427564646965732f6d61737465722f6172742f73637265656e73686f745f6c697374627564646965735f322e706e67" width="320" />
<img src="https://github.com/wasabeef/awesome-android-ui/blob/master/art/ListBuddies.gif" width="320" />

---

**Android-ObservableScrollView**: [https://github.com/ksoichiro/Android-ObservableScrollView](https://github.com/ksoichiro/Android-ObservableScrollView)

Android library to observe scroll events on scrollable views.[http://ksoichiro.github.io/Android-ObservableScrollView/](http://ksoichiro.github.io/Android-ObservableScrollView/)

<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo12.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo10.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo11.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo13.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo1.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo2.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo3.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo4.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo5.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo6.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo7.gif" width="160" />
<img src="https://raw.githubusercontent.com/ksoichiro/Android-ObservableScrollView/master/samples/images/demo8.gif" width="160" />

---

**AsymmetricGridView**: [https://github.com/felipecsl/AsymmetricGridView](https://github.com/felipecsl/AsymmetricGridView)

Android ListView that mimics a GridView with asymmetric items. Supports items with row span and column span.[http://felipecsl.com/AsymmetricGridView](http://felipecsl.com/AsymmetricGridView)

<img src="https://raw.githubusercontent.com/felipecsl/AsymmetricGridView/master/screenshots/ss_2_cols.png" width="320" />
<img src="https://raw.githubusercontent.com/felipecsl/AsymmetricGridView/master/screenshots/ss_5_cols.png" width="320" />

---

**DynamicGrid**: [https://github.com/askerov/DynamicGrid](https://github.com/askerov/DynamicGrid)

Drag and drop GridView for Android

<img src="https://github.com/wasabeef/awesome-android-ui/blob/master/art/DynamicGrid.gif" width="320" />

---

**PinterestLikeAdapterView**:  https://github.com/GDG-Korea/PinterestLikeAdapterView

 An Android multi column list view like Pinterest.

<img src="https://camo.githubusercontent.com/97e5e0acd9bce5cc3d98b8dbb2b528cc3e98c3e9/68747470733a2f2f7261772e6769746875622e636f6d2f4744472d4b6f7265612f50696e7465726573744c696b6541646170746572566965772f6d61737465722f73637265656e73686f742e706e67" width="320" />

---

**DragSortAdapter**:  https://github.com/vinc3m1/DragSortAdapter

 Drag and drop re-ordering adapter for RecyclerView

<img src="http://www.23code.com/wp-content/uploads/2015/01/device-2015-01-27-134318.jpg" width="320" />

--- 

**AndroidStaggeredGrid**: [https://github.com/etsy/AndroidStaggeredGrid](https://github.com/etsy/AndroidStaggeredGrid)

An Android staggered grid view which supports multiple columns with rows of varying sizes.[https://github.com/etsy/AndroidStaggeredGrid](https://github.com/etsy/AndroidStaggeredGrid)

<img src="https://camo.githubusercontent.com/a243ad5c2788730c40fc1d348e5ed85adb59c484/687474703a2f2f662e636c2e6c792f6974656d732f327a31423059304d3047304f326b316c334a30332f5472656e64696e672e706e67" width="320" />

---

**android-parallax-recyclerview**: [https://github.com/kanytu/android-parallax-recyclerview](https://github.com/kanytu/android-parallax-recyclerview)

An adapter which could be used to achieve a parallax effect on RecyclerView.

<img src="https://raw.githubusercontent.com/kanytu/android-parallax-recycleview/master/screenshots/screenshot.gif" width="320" />
<img src="https://raw.githubusercontent.com/kanytu/android-parallax-recycleview/master/screenshots/parallaxtoolbar.gif" width="320" />

---

**BlurStickyHeaderListView**: [https://github.com/emmano/BlurStickyHeaderListView](https://github.com/emmano/BlurStickyHeaderListView)

ListView with blur/parallax/sticky capabilities.

<img src="https://github.com/wasabeef/awesome-android-ui/blob/master/art/BlurStickyHeaderListView.gif" width="320" />

---

**MultiLineDivider**: https://github.com/sakebook/MultiLineDivider

Multi divider in RecyclerView on Android

<img src="https://raw.githubusercontent.com/sakebook/MultiLineDivider/master/art/vertical.png" width="320" />
<img src="https://raw.githubusercontent.com/sakebook/MultiLineDivider/master/art/horizontal.png" width="320"/>

---

**RecyclerViewDivider**: https://github.com/Fondesa/RecyclerViewDivider

RecyclerView 分割线

<img src="https://raw.githubusercontent.com/Fondesa/RecyclerViewDivider/master/art/screenshot_div_draw.png" width="320" />
<img src="https://raw.githubusercontent.com/Fondesa/RecyclerViewDivider/master/art/screenshot_grid.png" width="320"/>

---

**ItemDecorations**: [https://github.com/dkzwm/ItemDecorations](https://github.com/dkzwm/ItemDecorations)

A dividers library for RecyclerView which use GridLayoutManager or LinearLayoutManager ，   
when the RecyclerView used GridLayoutManager that supports cross-column feature
<p>
<img src="https://raw.githubusercontent.com/dkzwm/ItemDecorations/master/snapshot1.png" width="320" />
<img src="https://raw.githubusercontent.com/dkzwm/ItemDecorations/master/snapshot2.png" width="320"/>
<p/>

---

**RecyclerView-FlexibleDivider**: https://github.com/yqritc/RecyclerView-FlexibleDivider

Android library providing simple way to control divider items of RecyclerView.

<img src="https://github.com/yqritc/RecyclerView-FlexibleDivider/blob/master/sample/sample1.gif" width="320" />
<img src="https://github.com/yqritc/RecyclerView-FlexibleDivider/blob/master/sample/sample2.gif" width="320" />

---

**Dividers**: [https://github.com/Karumi/Dividers](https://github.com/Karumi/Dividers)

Dividers is a simple Android library to create easy separators for your RecyclerViews

<img src="https://github.com/Karumi/Dividers/blob/master/art/example.gif" width="320" />

---

**AndroidTreeView**: [https://github.com/bmelnychuk/AndroidTreeView](https://github.com/bmelnychuk/AndroidTreeView)

AndroidTreeView. TreeView implementation for android.

<img src="https://camo.githubusercontent.com/e30f6694c99cc4404b7654f74e3d1598665792ea/68747470733a2f2f6c68342e67677068742e636f6d2f787a6b62334e35384c48325473625f6747733075335f783831564f4c776c6863702d6634707a5f73525f69523376414b58664a6f416377426a4e37344c767a70564c453d683930302d7277" width="320" />
<img src="https://camo.githubusercontent.com/e600e1392139be2db0f466f30c63ecd84af39080/68747470733a2f2f6c68352e67677068742e636f6d2f55743642795f69556e6b4e667a49626150427363386842655165466a5f3255584a685f3174667744646c544171476b6869523732415f417751304c304748334f4661673d683930302d7277" width="320" />

---

**RecyclerViewFastScroller**: [https://github.com/danoz73/RecyclerViewFastScroller](https://github.com/danoz73/RecyclerViewFastScroller)

A Fast Scroller for the RecyclerView world!

<img src="https://camo.githubusercontent.com/89c3458b7404559a3a2bcc07b11abda23cb9f04f/687474703a2f2f692e696d6775722e636f6d2f496f7a557475636c2e706e67" width="320" />
<img src="https://camo.githubusercontent.com/8b8e323a4f7f904b6d6f5057ceaa28a81570af26/687474703a2f2f692e696d6775722e636f6d2f327a4277496c776c2e706e67" width="320" />

---

**RecyclerView-MultipleViewTypesAdapter**: [https://github.com/yqritc/RecyclerView-MultipleViewTypesAdapter](https://github.com/yqritc/RecyclerView-MultipleViewTypesAdapter)

Android library defining adapter classes of RecyclerView to manage multiple view types

<img src="https://github.com/yqritc/RecyclerView-MultipleViewTypesAdapter/blob/master/sample/sample.gif" width="320" />

---

**SwipeToAction**: [https://github.com/diftco/SwipeToAction](https://github.com/diftco/SwipeToAction)

An easy way to add a simple 'swipe-and-do-something' behavior to your `RecyclerView` items. Just like in Gmail or Inbox apps.

<img src="https://raw.githubusercontent.com/diftco/SwipeToAction/master/screenshots/swipetoaction.gif" width="320" />

---

**android-advancedrecyclerview**: [https://github.com/h6ah4i/android-advancedrecyclerview](https://github.com/h6ah4i/android-advancedrecyclerview)

RecyclerView extension library which provides advanced features. (ex. Google's Inbox app like swiping, Play Music app like drag and drop sorting)

<img src="https://github.com/wasabeef/awesome-android-ui/blob/master/art/AdvancedRecyclerView.gif" width="320" />

---

**RecyclerItemDecoration**: [https://github.com/magiepooh/RecyclerItemDecoration](https://github.com/magiepooh/RecyclerItemDecoration)

ItemDecoration for RecyclerView using LinearLayoutManager for Android

<img src="https://raw.githubusercontent.com/magiepooh/RecyclerItemDecoration/master/art/demo_vertical.gif" width="320" />
<img src="https://raw.githubusercontent.com/magiepooh/RecyclerItemDecoration/master/art/demo_horizontal.gif" width="320" />

---

**MaterialRecents**: [https://github.com/ZieIony/MaterialRecents](https://github.com/ZieIony/MaterialRecents)

Lollipop's Recents container

<img src="https://github.com/ZieIony/MaterialRecents/blob/master/images/recents.gif" width="320" />

---

**drag-select-recyclerview**: [https://github.com/afollestad/drag-select-recyclerview](https://github.com/afollestad/drag-select-recyclerview)

Easy to implement Google Photos style multi-selection for RecyclerViews.[http://aidanfollestad.com](http://aidanfollestad.com)

<img src="https://github.com/wasabeef/awesome-android-ui/blob/master/art/drag-select-recyclerview.gif" width="320" />

---

**sticky-headers-recyclerview**: [https://github.com/timehop/sticky-headers-recyclerview](https://github.com/timehop/sticky-headers-recyclerview)

Sticky Headers decorator for Android's RecyclerView

<img src="https://camo.githubusercontent.com/2712b977a781964db02085035e43281773ab4ffa/687474703a2f2f692e696d6775722e636f6d2f49307a746f50772e676966" width="320" />
<img src="https://camo.githubusercontent.com/9fe2a23efb0ab8222910a09e21234c0c313afc10/687474703a2f2f692e696d6775722e636f6d2f6235704a6a744c2e676966" width="480" />

---

**NotBoringActionBar**: [https://github.com/flavienlaurent/NotBoringActionBar](https://github.com/flavienlaurent/NotBoringActionBar)

News Stand app makes the ActionBar not boring!

<img src="https://camo.githubusercontent.com/65f2d44e0e5064369aec8ee41838bd073e695975/68747470733a2f2f7261772e6769746875622e636f6d2f666c617669656e6c617572656e742f4e6f74426f72696e67416374696f6e4261722f6d61737465722f67726170686963732f6e6f74626f72696e6761622e676966" width="320" />

---
 
**ListViewAnimations**: [https://github.com/nhaarman/ListViewAnimations](https://github.com/nhaarman/ListViewAnimations)

An Android library which allows developers to easily add animations to ListView items

<img src="https://raw.githubusercontent.com/nhaarman/ListViewAnimations/gh-pages/images/dynamiclistview.gif" width="320" />

---
 
**WaterDropListView**: [https://github.com/THEONE10211024/WaterDropListView](https://github.com/THEONE10211024/WaterDropListView)

WaterDropListView，just like the iOS

<img src="https://github.com/THEONE10211024/WaterDropListView/blob/master/demo/demo.gif" width="320" />

---

**BGARefreshLayout-Android**: https://github.com/bingoogolapple/BGARefreshLayout-Android

多种下拉刷新效果、上拉加载更多、可配置自定义头部广告位

<img src="https://camo.githubusercontent.com/912ee9a45b5ed7063bd6fe7634f8130953a7051d/687474703a2f2f37786b39646a2e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f726566726573686c61796f75742f73637265656e73686f74732f6267615f726566726573686c61796f7574312e676966" width="270" />
<img src="https://camo.githubusercontent.com/7539fed2c320aecc0d47320586e8c2ee22a2d762/687474703a2f2f37786b39646a2e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f726566726573686c61796f75742f73637265656e73686f74732f6267615f726566726573686c61796f7574322e676966" width="270" />
<img src="https://camo.githubusercontent.com/1f869f094c59adfef8a63f8f870c53092fae8d19/687474703a2f2f37786b39646a2e636f6d312e7a302e676c622e636c6f7564646e2e636f6d2f726566726573686c61796f75742f73637265656e73686f74732f6267615f726566726573686c61796f7574362e676966" width="270" />

---

**FastAdapter**: https://github.com/mikepenz/FastAdapter

The bullet proof, fast and easy to use adapter library, which minimizes developing time when use RecyclerView... http://mikepenz.github.io/FastAdapter

<img src="https://raw.githubusercontent.com/mikepenz/FastAdapter/develop/DEV/github/screenshots1.jpg" width="640"/>

---

**NestedTimeLineRecyclerView**: https://github.com/ishratkhan/NestedTimeLineRecyclerView

It is a custom implementation of nested timeline view using RecyclerView

<img src="https://camo.githubusercontent.com/8c9d67b4ad583b72f61f87ebc0ea9e34bce7544e/687474703a2f2f692e696d6775722e636f6d2f497375444636672e676966" width="320" />

---

**YLListView**: https://github.com/yll2wcf/YLListView

YLListView仿IOS弹簧效果的ListView

<img src="https://raw.githubusercontent.com/yll2wcf/YLListView/master/gif/1.gif" width="320" />

---