﻿using Coldairarrow.DotNettyRPC;
using Common;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Threading.Tasks;

namespace Client
{
    class Program
    {
        static void DotNettyRPCTest()
        {
            int threadCount = 1;
            int port = 39999;
            int count = 10000;
            int errorCount = 0;
            RPCServer rPCServer = new RPCServer(port);
            rPCServer.RegisterService<IHello, Hello>();
            rPCServer.Start();
            IHello client = null;
            client = RPCClientFactory.GetClient<IHello>("127.0.0.1", port);
            client.SayHello("aaa");
            Stopwatch watch = new Stopwatch();
            List<Task> tasks = new List<Task>();
            watch.Start();
            for(int i=0;i< threadCount; i++)
            {
                tasks.Add(Task.Run(() =>
                {
                    for(int j = 0; j < count; j++)
                    {
                        string msg = string.Empty;
                        try
                        {
                            //msg = client.SayHello("Hello");
                            //Console.WriteLine($"{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss:fff")}:{msg}");
                        }
                        catch (Exception ex)
                        {
                            errorCount++;
                            //Console.WriteLine(ExceptionHelper.GetExceptionAllMsg(ex));
                        }
                    }
                }));
            }
            Task.WaitAll(tasks.ToArray());
            watch.Stop();
            Console.WriteLine($"并发数:{threadCount},运行:{count}次,每次耗时:{(double)watch.ElapsedMilliseconds / count}ms");
            Console.WriteLine($"错误次数：{errorCount}");
        }

        static void Main(string[] args)
        {
            IHello client = RPCClientFactory.GetClient<IHello>("127.0.0.1", 39999);
            client.SayHello("Hello");
            Console.WriteLine("完成");
            Console.ReadLine();
        }
    }
}
