---
title: "Bézier Curves"
video_number: 163
date: 2021-08-22
video_id: enNfb6p3j_g
repository: CC_163_Bezier

variations:
  - name: "Basic"
    lang: "p5js"
    folder: "basic-bezier"
    web_editor: Z53a719cQ
  - name: "Editor by Simon Tiger"
    lang: "p5js"
    folder: "bezier-editor"
    web_editor: _R7RgtGfA
  - name: "bezierVertex"
    lang: "p5js"
    folder: "bezier-vertex"
    web_editor: O3_cLiOaw
  - name: "Time Table Cardioid with Bezier"
    lang: "p5js"
    folder: "cardioid-bezier"
    web_editor: kZ8dpklQg
  - name: "Quadratic"
    lang: "p5js"
    folder: "quadratic"
    web_editor: fJIMDmHcE
  - name: "Cubic"
    lang: "p5js"
    folder: "cubic"
    web_editor: S1Pt8lol1
  - name: "Bezier with Formula"
    lang: "p5js"
    folder: "bezier-formula"
    web_editor: 0XOLNHbvC

links:
  - title: "#SupportP5 2020"
    url: https://donorbox.org/supportp52020
  - title: "Jason Oswald (GitHub)"
    url: https://github.com/gajoswald
  - title: "Processing Foundation"
    url: https://processingfoundation.org/
  - title: "bezier() - p5.js Reference"
    url: https://p5js.org/reference/#/p5/bezier
  - title: "Bézier curve (Wikipedia)"
    url: https://en.wikipedia.org/wiki/B%C3%A9zier_curve
  - title: "Custom shapes - Programming Design Systems by Rune Madsen"
    url: https://www.programmingdesignsystems.com/shape/custom-shapes/index.html#custom-shapes-pANLh0l
  - title: "lerp() - p5.js Reference"
    url: https://p5js.org/reference/#/p5/lerp

videos:
  - title: "Self Avoiding Walk - Coding Challenge 162"
    author: "The Coding Train"
    url: /CodingChallenges/162-self-avoiding-walk
  - title: "Time Table Cardioid - Coding Challenge 133"
    author: "The Coding Train"
    url: /CodingChallenges/133-times-tables-cardioid

topics:
  - title: "Welcome! Thanks Jason!"
    time: "0:00"
  - title: "Explain! What is the bezier() function?"
    time: "1:03"
  - title: "Explain! The difference between linear, quadratic, and cubic bezier curves?"
    time: "2:02"
  - title: "Explain! What is a control point?"
    time: "2:34"
  - title: "Code! Let's try the bezier() function!"
    time: "3:42"
  - title: "Code! Now we can explore bezierVertex()!"
    time: "5:02"
  - title: "But wait! How can we go farther?"
    time: "7:13"
  - title: "Explain! How is lerp() related to bezier()?"
    time: "7:39"
  - title: "Code! How can we draw a straight line with vertex()?"
    time: "9:09"
  - title: "Explain! Lerpception!!"
    time: "10:59"
  - title: "Code! Quadratic bezier!"
    time: "13:21"
  - title: "Code! What if we connect the points from the two lerps?"
    time: "14:47"
  - title: "Code! Cubic bezier."
    time: "16:02"
  - title: "Code! Let's bring back the rainbow!"
    time: "19:21"
  - title: "Code! Moving points based on bouncing ball."
    time: "20:17"
  - title: "Wrap up. What will you create?"
    time: "21:40"

contributions:
  - title: "Complete N point/degree Bezier Curve Editor"
    author: "Ayush Koul"
    url: https://preview.p5js.org/ayushkoul00/present/sDkHTR6r2d
    source: https://editor.p5js.org/ayushkoul00/sketches/sDkHTR6r2d
  - title: "Bezier Arch Synthwave Animation"
    author: "Chris Sears"
    url: https://editor.p5js.org/Prof-Sears/full/3zStiATFL
    source: https://editor.p5js.org/Prof-Sears/sketches/3zStiATFL
  - title: "Bezier Curve Road Editor"
    author: "David Snyder"
    url: https://preview.p5js.org/D_Snyder/present/F5rWBZZ4r
    source: https://editor.p5js.org/D_Snyder/sketches/F5rWBZZ4r
  - title: "Bezier Curve LERP Animations (2-10 points)"
    author: "I L M Narayana"
    url: https://editor.p5js.org/ilmnarayana/full/_vyuj8rli
    source: https://editor.p5js.org/ilmnarayana/sketches/_vyuj8rli
  - title: "Bezier Curve Art"
    author:
      name: "Larry Campfire"
    url: "https://editor.p5js.org/Larry/full/F6j0Ztv33"
    source: "https://editor.p5js.org/Larry/sketches/F6j0Ztv33"
  - title: "Quartic Bezier Curve"
    author:
      name: "Codefish"
    url: "https://editor.p5js.org/Codefish/full/zFswDsx33"
    source: "https://editor.p5js.org/Codefish/sketches/zFswDsx33"
  - title: "animated n control point Bézier curve"
    author: "Alex Hunter"
    url: https://editor.p5js.org/alonjazz/full/pHoT3Nfh0
    source: https://editor.p5js.org/alonjazz/sketches/pHoT3Nfh0
  - title: "Moving on an Infinite Loop made with Bézier curves"
    author: "jaipack17"
    url: https://editor.p5js.org/jaipack17/full/M99fmswxg
    source: https://editor.p5js.org/jaipack17/sketches/M99fmswxg
  - title: "animated n control point Bézier curve"
    author: "Monique GOBRIAL"
    video_id: 4GVd-JtaizE
    source: https://editor.p5js.org/MGOBRIAL/sketches/imSjRRYpM
  - title: "Bezier Flowers"
    author:
      name: "Denisovich"
      url: "https://DenisovichDev.github.io/link-tree/"
    url: "https://openprocessing.org/sketch/1319370"
    source: "https://openprocessing.org/sketch/1319370#code"
  - title: "Bezier Curve by Mavyfaby"
    author:
      name: "Maverick G. Fabroa"
      url: "https://mavyfaby.ml"
    url: "https://mavyfaby.ml/projects/bezier-curve"
    source: "https://github.com/mavyfaby/bezier-curve"
  - title: "3D Beziercurves"
    author:
      name: "Chenne Bicken"
    url: "https://editor.p5js.org/bewies/full/ZDIWpyv1Z"
    source: "https://editor.p5js.org/bewies/sketches/ZDIWpyv1Z"
  - title: "N Control Points Bézier With Draggable points"
    author:
      name: "Tushar Upadhyay"
    url: "https://editor.p5js.org/tusharpg/full/rOxi9XjZi"
    source: "https://editor.p5js.org/tusharpg/sketches/rOxi9XjZi"
  - title: "P5.js N Point Bézier Curve showing auxiliar Lines"
    author:
      name: "Cássio Souza"
    url: "https://codepen.io/cassiofb-dev/full/yLzbOKK"
    source: "https://codepen.io/cassiofb-dev/pen/yLzbOKK"
---
Have you ever wanted to know more about bézier curves in p5.js? Thanks to a generous donation from Jason Oswald, I do a deep dive exploring the bézier curve function and the math behind the algorithm?
