## Contributing to The Coding Train

Contributions to this repository encouraged! We're all learning so mistakes and confusion are welcome, we're here to help and try to make contributing as friendly and accessible as possible.

Here are the type of contributions we are looking for:
 - bug-fixes
 - making the code easier to read (including code comments!)
 - adding a link to your creative version of a challenge or tutorial - [guide](https://thecodingtrain.com/Guides/community-contribution-guide.html)
 - website design improvements
 - adding any missing content - [guide](https://thecodingtrain.com/Guides/content-contribution-guide.html)
 - porting coding challenges to other languages (eg. Processing -> JavaScript/p5.js) - [overview](https://github.com/CodingTrain/website/issues/1347)

The code in the repository should match the code written in the YouTube tutorials, so that fellow passengers can use this code as a base for their own implementations.

To make a contribution, fork this repository and create a pull request.

If it is a "community contribution" please try to **include a link to a running demo** (or video / gif / 
screen capture) in the pull request's description. This makes it easy to quickly view the contribution and provide feedback! [Here is a guide with more instructions](https://thecodingtrain.com/Guides/community-contribution-guide.html).

If you are just editing a single file, you may click the pencil when viewing the file to edit in the browser.

If you are unsure about git and GitHub, and how to make your contribution,
these [Git and GitHub for Poets tutorials](https://www.youtube.com/playlist?list=PLRqwX-V7Uu6ZF9C0YMKuns9sLDzK6zoiV) might help.

Happy Coding!

