# Contributing

1. Find an issue that needs assistance by searching in our [Issue Tracker](https://github.com/CodersForLife/Data-Structures-Algorithms/issues).
2. Let us know you are working on it by posting a comment on the issue.
3. Follow these Contribution Guidelines to start working on the issue.

## Forking the Project

1. Fork it by clicking the "Fork" button in [the top level of the repository](https://github.com/CodersForLife/Data-Structures-Algorithms).
2. Clone your fork of _Data-Structures-Algorithms_.
```
$ git clone https://github.com/yourUsername/Data-Structures-Algorithms
```
3. Create your feature branch: `git checkout -b my-new-feature`
4. Add your changes to the project.
5. Commit your changes: `git commit -m 'Add some feature'`
6. Push to the branch: `git push origin my-new-feature`
7. Submit your pull request!

## Submitting a Pull Request

**When you make a Pull Request, all of your changes need to be in one commit.**

If you have more than one commit in your feature branch you should [_squash_](https://forum.freecodecamp.org/t/how-to-squash-multiple-commits-into-one-with-git/13231) your commits.

* Your PR title should follow the `category: algorithm (language)` model.
  * Ex1: `Sorting: Bubble Sort (C)`
  * Ex2: `Searching: Binary Search (Java)`
* After creating your PR, you must fill the checkboxes that define our contribution guidelines.
* Your changes will be reviewed and added to the main repository!

**After your pull request is merged**, you can safely delete your branch.

## Coding Guidelines

* All the codes should be modular.
* All the codes should be indented.
* Name of the file should be algorithm's name and first letter of file should be capital.
* Code written should be readable.
* Variable names should be logical and understandable. Like `int x; // This is not allowed`
* Same algorithm can be submitted in different languages.
