
#import "FBBundleInfo.h"

@interface FBApplicationInfo : FBBundleInfo {
    NSString * _appIDEntitlement;
    NSSet * _backgroundModes;
    BOOL  _beta;
    BOOL  _blocked;
    NSURL * _bundleContainerURL;
    NSArray * _customMachServices;
    NSURL * _dataContainerURL;
    NSArray * _deviceFamilies;
    NSString * _displayName;
    NSNumber * _downloaderDSID;
    BOOL  _enabled;
    NSDictionary * _environmentVariables;
    NSURL * _executableURL;
    BOOL  _exitsOnSuspend;
    NSArray * _externalAccessoryProtocols;
    BOOL  _hasViewServicesEntitlement;
    BOOL  _initialized;
    BOOL  _installing;
    BOOL  _isManaged;
    NSNumber * _itemID;
    double  _lastModifiedDate;
    NSDictionary * _lazy_entitlements;
    NSString * _lazy_fallbackFolderName;
    NSArray * _lazy_folderNames;
    float  _minimumBrightnessLevel;
    BOOL  _newsstand;
    long  _once_entitlements;
    long  _once_folderNames;
    NSString * _preferenceDomain;
    BOOL  _provisioningProfileValidated;
    NSNumber * _purchaserDSID;
    int  _ratingRank;
    NSArray * _requiredCapabilities;
    BOOL  _requiresPersistentWiFi;
    BOOL  _restricted;
    NSURL * _sandboxURL;
    NSString * _sdkVersion;
    NSString * _signerIdentity;
    unsigned int  _supportedInterfaceOrientations;
    NSArray * _tags;
    unsigned int  _type;
    BOOL  _uninstalling;
}

@property (getter=_appIDEntitlement, nonatomic, readonly, copy) NSString *appIDEntitlement;
@property (getter=isBeta, nonatomic, readonly) BOOL beta;
@property (getter=isBlocked, nonatomic, readonly) BOOL blocked;
@property (nonatomic, readonly, retain) NSURL *bundleContainerURL;
@property (nonatomic, readonly, retain) NSArray *customMachServices;
@property (copy, nonatomic) NSString *applicationType;
@property (nonatomic, readonly, retain) NSURL *dataContainerURL;
@property (readonly, copy) NSString *debugDescription;
@property (readonly, copy) NSString *description;
@property (nonatomic, readonly, retain) NSArray *deviceFamilies;
@property (nonatomic, readonly, copy) NSString *displayName;
@property (nonatomic, readonly, retain) NSNumber *downloaderDSID;
@property (getter=isEnabled, nonatomic, readonly) BOOL enabled;
@property (nonatomic, readonly, retain) NSDictionary *entitlements;
@property (nonatomic, readonly, retain) NSDictionary *environmentVariables;
@property (nonatomic, readonly, retain) NSURL *executableURL;
@property (getter=isExitsOnSuspend, nonatomic, readonly) BOOL exitsOnSuspend;
@property (nonatomic, readonly, retain) NSArray *externalAccessoryProtocols;
@property (nonatomic, readonly, retain) NSString *fallbackFolderName;
@property (nonatomic, readonly, retain) NSArray *folderNames;
@property (getter=hasFreeDeveloperProvisioningProfile, nonatomic, readonly) BOOL freeDeveloperProvisioningProfile;
@property (nonatomic, readonly) BOOL hasViewServicesEntitlement;
@property (readonly) unsigned int hash;
@property (getter=_isInstalling, setter=_setInstalling:, nonatomic) BOOL installing;
@property (nonatomic, readonly, retain) NSNumber *itemID;
@property (nonatomic, readonly) double lastModifiedDate;
@property (nonatomic, readonly) float minimumBrightnessLevel;
@property (getter=isNewsstand, nonatomic, readonly) BOOL newsstand;
@property (nonatomic, readonly, copy) NSString *preferenceDomain;
@property (getter=isProvisioningProfileValidated, nonatomic, readonly) BOOL provisioningProfileValidated;
@property (nonatomic, readonly, retain) NSNumber *purchaserDSID;
@property (nonatomic, readonly) int ratingRank;
@property (nonatomic, readonly, retain) NSArray *requiredCapabilities;
@property (nonatomic, readonly) BOOL requiresPersistentWiFi;
@property (getter=isRestricted, nonatomic, readonly) BOOL restricted;
@property (nonatomic, readonly, retain) NSURL *sandboxURL;
@property (nonatomic, readonly, copy) NSString *sdkVersion;
@property (nonatomic, readonly) int signatureState;
@property (nonatomic, readonly, copy) NSString *signerIdentity;
@property (readonly) Class superclass;
@property (nonatomic, readonly) unsigned int supportedInterfaceOrientations;
@property (nonatomic, readonly, retain) NSArray *tags;
@property (nonatomic, readonly) unsigned int type;
@property (getter=_isUninstalling, setter=_setUninstalling:, nonatomic) BOOL uninstalling;
@property (getter=hasUniversalProvisioningProfile, nonatomic, readonly) BOOL universalProvisioningProfile;

+ (unsigned int)_applicationTypeForProxy:(id)arg1;
+ (void)_buildDefaults:(id)arg1 fromInfo:(id)arg2 entitlements:(id)arg3 appType:(unsigned int)arg4 isOnOrAfterOkemo:(BOOL)arg5;
+ (unsigned int)_computeSupportedInterfaceOrientationsWithInfo:(id)arg1 forDefaults:(id)arg2;
+ (id)_configureEnvironment:(id)arg1 withInfo:(id)arg2 isPreApex:(BOOL)arg3;
+ (id)_genreNameForID:(int)arg1;

- (id)_appIDEntitlement;
- (id)_applicationTrustData;
- (id)_initForProfileManagerTesting;
- (id)_initWithApplicationProxy:(id)arg1;
- (id)_initWithBundleIdentifier:(id)arg1 url:(id)arg2;
- (id)_initWithBundleProxy:(id)arg1 overrideURL:(id)arg2;
- (BOOL)_isInstalling;
- (BOOL)_isUninstalling;
- (void)_loadFromProxy:(id)arg1;
- (int)_mapSignatureStateFromTrustState:(unsigned int)arg1;
- (void)_once_loadFolderNamesIfNecessary;
- (void)_overrideTags:(id)arg1;
- (id)_profileManager;
- (void)_setInstalling:(BOOL)arg1;
- (void)_setProfileManager:(id)arg1;
- (void)_setUninstalling:(BOOL)arg1;
- (void)acceptApplicationSignatureIdentity;
- (BOOL)builtOnOrAfterSDKVersion:(id)arg1;
- (id)bundleContainerURL;
- (id)customMachServices;
- (id)dataContainerURL;
- (void)dealloc;
- (id)debugDescription;
- (id)defaults;
- (id)description;
- (id)descriptionBuilderWithMultilinePrefix:(id)arg1;
- (id)descriptionWithMultilinePrefix:(id)arg1;
- (id)deviceFamilies;
- (id)displayName;
- (id)downloaderDSID;
- (id)entitlements;
- (id)environmentVariables;
- (id)executableURL;
- (id)externalAccessoryProtocols;
- (id)fallbackFolderName;
- (id)folderNames;
- (BOOL)hasFreeDeveloperProvisioningProfile;
- (BOOL)hasUniversalProvisioningProfile;
- (BOOL)hasViewServicesEntitlement;
- (id)initWithApplicationProxy:(id)arg1;
- (BOOL)isBeta;
- (BOOL)isBlocked;
- (BOOL)isEnabled;
- (BOOL)isExitsOnSuspend;
- (BOOL)isNewsstand;
- (BOOL)isProvisioningProfileValidated;
- (BOOL)isRestricted;
- (id)itemID;
- (double)lastModifiedDate;
- (float)minimumBrightnessLevel;
- (id)preferenceDomain;
- (id)purchaserDSID;
- (int)ratingRank;
- (id)requiredCapabilities;
- (BOOL)requiresPersistentWiFi;
- (id)sandboxURL;
- (id)sdkVersion;
- (int)signatureState;
- (id)signerIdentity;
- (BOOL)statusBarHiddenForInterfaceOrientation:(int)arg1 onDisplay:(id)arg2;
- (id)succinctDescription;
- (id)succinctDescriptionBuilder;
- (unsigned int)supportedInterfaceOrientations;
- (BOOL)supportsAllInterfaceOrientations;
- (BOOL)supportsBackgroundMode:(id)arg1;
- (BOOL)supportsDeviceFamily:(unsigned int)arg1;
- (BOOL)supportsInterfaceOrientation:(int)arg1;
- (id)tags;
- (unsigned int)type;

@end
