# Convert Code to VSCode Snippet

[View, Screenshot, Remix, or Edit on COTR](https://cotr.dev/snippet/363)

## Code Snippet
```
function convertCodeToSnippet(): string {
  // Get form values
  const description = title;
  const tabTrigger = "test";

  // Generate VSCode snippet
  const snippet = `"${description}": {
  "prefix": "${tabTrigger}",
  "body": [
    ${code
      .split("\n")
      .map((line: string) => `"${line.replace(/"/g, '\\"')}"`)
      .join(",\n    ")}
  ],
  "description": "${description}"
}`;

  console.log(snippet);
  return snippet;
}
```

## Description
**Explanation:**

The `convertCodeToSnippet()` function is designed to convert the provided code into a Visual Studio Code (VSCode) code snippet. VSCode snippets are reusable code templates that can be quickly inserted into your code editor using a short keyword or tab trigger.

Here's a breakdown of how the function works:

1. **Get Form Values**:
   - It extracts the `title` from the form, which presumably contains the description of the snippet.
   - It assigns a hard-coded value of "test" to the `tabTrigger`, which is the keyword that will trigger the snippet in VSCode.

2. **Generate VSCode Snippet**:
   - The main logic of the function involves generating a VSCode snippet in JSON format.
   - It starts by defining a key-value pair with the `description` as the key and an object value.
   - The object contains properties like `prefix` (the tab trigger), `body` (the actual code snippet), and `description`.
   - The `body` property is generated by splitting the provided `code` into individual lines and enclosing each line with double quotes (`"`) and escaping any existing double quotes (`\"`) for proper formatting.
   - The snippet object is then converted into a JSON string.

3. **Console Logging and Return**:
   - The generated snippet is logged to the console for visibility.
   - Finally, the snippet is returned as a string, which can be used to save or share the reusable code template.

The `convertCodeToSnippet()` function provides a convenient way to create and use VSCode snippets for efficient and consistent code development.

## Tags
javascript, vscode, snippet
