# Toggle Leading Spaces

[View, Screenshot, Remix, or Edit on COTR](https://cotr.dev/snippet/353)

## Code Snippet
```
<div
  title="Remove Leading Spaces"
  className="rounded-full bg-neutral-content/30 hover:bg-green-500 hover:text-black/50 text-transparent border-none 
  h-4 w-4 shadow-inner cursor-pointer place-content-center align-middle"
  onClick={() => {
    setShowBackground(!showBackground);
  }}
>
  <center className="-rotate-45">
    <PiCaretUpDownFill size={12} />
  </center>
</div>
```

## Description
This code snippet creates a button element that, when clicked, toggles the value of a boolean variable named `showBackground`. The button has the following properties:

- `title`: "Remove Leading Spaces", which is a tooltip that appears when the mouse hovers over the button.
- `className`: "rounded-full bg-neutral-content/30 hover:bg-green-500 hover:text-black/50 text-transparent border-none h-4 w-4 shadow-inner cursor-pointer place-content-center align-middle", which specifies the button's appearance and behavior. It is a circular button with a neutral background color, and when hovered over, it turns green and the text becomes visible. It has no border, is 4px high and 4px wide, and has a drop shadow. It is also a cursor pointer, meaning the cursor changes to a hand when hovering over it.
- `onClick`: () => { setShowBackground(!showBackground); }, which is an event listener that is triggered when the button is clicked. This function toggles the value of the `showBackground` variable, which is assumed to be a state variable in the component where this button is used. When the button is clicked, the value of `showBackground` becomes the opposite of its current value.
- `center className="-rotate-45"`: This centers the content of the button vertically and rotates it 45 degrees counterclockwise.
- `PiCaretUpDownFill size={12}`: This is the icon that is displayed on the button, in this case, an up and down caret. The size attribute sets the size of the icon to 12px.

## Tags
html, javascript, css, react, dom, onclick, shadow, cursor, center, rotate, picaretupdownfill
