# Display Responsive Text with Conditional Rendering

[View, Screenshot, Remix, or Edit on COTR](https://cotr.dev/snippet/351)

## Code Snippet
```
export default function ResponsiveText({
  longText,
  shortText,
}: {
  longText: string;
  shortText: string;
}) {
  return (
    <div>
      <div className="max-sm:hidden">{longText}</div>
      <div className="sm:hidden">{shortText}</div>
    </div>
  );
}
```

## Description
The provided code snippet is a React functional component called `ResponsiveText` that is used to conditionally render different text content based on the screen size. It takes two mandatory props: `longText` and `shortText`, both of which are strings.

Here's how this component works:

1. It renders a `<div>` that serves as the container for the text content.

2. Inside the container, it renders two nested `<div>` elements with conditional classes based on the screen size:

   - The first `<div>` has a `className` of `"max-sm:hidden"`. This means that it will be visible only when the screen size is less than or equal to the `sm` breakpoint (which is typically around 640px wide). When the screen is larger than this breakpoint, this `<div>` will be hidden. Inside this `<div>`, the `longText` prop is rendered.

   - The second `<div>` has a `className` of `"sm:hidden"`. This means that it will be visible only when the screen size is strictly less than the `sm` breakpoint. When the screen is larger than or equal to this breakpoint, this `<div>` will be hidden. Inside this `<div>`, the `shortText` prop is rendered.

By using these conditional classes, the `ResponsiveText` component ensures that only one of the `<div>` elements is visible at a time, depending on the screen size. When the screen is small (less than or equal to `sm` breakpoint), the `longText` will be displayed. When the screen is larger (greater than the `sm` breakpoint), the `shortText` will be displayed.

This component is useful in scenarios where you want to display different content on different screen sizes. For instance, you might want to show a full description of a product on larger screens but display only a concise summary on smaller screens.

## Tags
typescript, react, functional component, responsive design, dynamic text
