# Yes

[View, Screenshot, Remix, or Edit on COTR](https://cotr.dev/snippet/357)

## Code Snippet
```
Iterable.generate(100, (_) => "Yes!\n").for each(print);
```

## Description
The provided code snippet uses Kotlin's extension functions and lambdas to generate and print a sequence of 100 lines, each containing the text "Yes!". Here's a breakdown of how it works:

Iterable.generate(100, (_)) => "Yes!\n"): This line creates an iterable sequence of 100 elements using the generate function. The _ parameter in the lambda represents a placeholder or an unused variable. It is a common convention in Kotlin to use _ when the parameter is not used. The lambda function within generate simply returns the string "Yes!\n" for each element in the sequence.

.forEach(print): This line applies the forEach extension function to the generated iterable sequence. The forEach function takes a lambda as an argument, which in this case is the print function. The print function is a built-in function that prints its argument to the standard output, typically your console or terminal.

The combination of these functions effectively creates a sequence of 100 lines, each containing "Yes!\n", and then prints each line to the output. As a result, you will see 100 lines of "Yes!" printed consecutively in your console or terminal when you run this code snippet.

## Tags
functional-programming, iterable, dart, collections
