# Frameworks, Bibliotecas, Wizards, Experts e Componentes Delphi
<p align="center">
  <a href="https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/C4D-Logo.png">
    <img alt="Code4Delphi" height="100" src="https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/c4d-logo-100x100.png">
  </a> 
</p>
Lista com diversos Frameworks, Bibliotecas, Wizards, Experts e Componentes para serem utilizados no Delphi <br/>
Nos envie suas sugestões, para que possamos adiciona-las a lista. O envio pode ser feito através de <a href="https://github.com/Code4Delphi/utilitarios-delphi/issues" target="_blank"> Issues</a>, <a href="https://github.com/Code4Delphi/utilitarios-delphi/pulls" target="_blank">Pull requests</a> ou atráves de um de nossos contatos . 

<br/>

## 📞 Contatos

<p align="left">
  <a href="https://t.me/Code4Delphi" target="_blank">
    <img src="https://img.shields.io/badge/Telegram:-Join%20Channel-blue?logo=telegram">
  </a>   
   &nbsp;
  <a href="https://www.youtube.com/@code4delphi" target="_blank">
    <img src="https://img.shields.io/badge/YouTube:-Join%20Channel-red?logo=youtube&logoColor=red">
  </a> 
   &nbsp;
  <a href="https://www.linkedin.com/in/cesar-cardoso-dev" target="_blank">
    <img src="https://img.shields.io/badge/LinkedIn:-Follow-blue?logo=LinkedIn&logoColor=blue">
  </a> 
  &nbsp;
  <a href="mailto:contato@code4delphi.com.br" target="_blank">
    <img src="https://img.shields.io/badge/E--mail-contato%40code4delphi.com.br-yellowgreen?logo=maildotru&logoColor=yellowgreen">
  </a>
</p>

<br/>

> [!IMPORTANT]
> ### ⭐ Não se esqueça de deixar sua estrela para ajudar a propagar o repositório.

<br/>
   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="20 - Code4Delphi"> Code4Delphi </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="95 - C4D-Validate-Components"> <b> C4D-Validate-Components </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi" title="Acessar link"> César Cardoso (Code4Delphi) </a> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi/C4D-Validate-Components" title="Acessar link"> https://github.com/Code4Delphi/C4D-Validate-Components </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Framework para validação automática de formulários Delphi.<br/><p> * Como o framework foi criado: <a target="_blank" href="https://www.youtube.com/watch?v=JSfqS-LhPhM&list=PLLHSz4dOnnN0ol4cYiclyRKLmYzJV8xNd" title="Acessar link"> https://www.youtube.com/watch?v=JSfqS-LhPhM&list=PLLHSz4dOnnN0ol4cYiclyRKLmYzJV8xNd </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="96 - C4D-Version"> <b> C4D-Version </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi" title="Acessar link"> César Cardoso (Code4Delphi) </a> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi/C4D-Version" title="Acessar link"> https://github.com/Code4Delphi/C4D-Version </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Com o C4D-Version, você pode fazer o controle da versão do seu sistema através do Version Info da própria IDE do Delphi.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="97 - C4D-LogFile"> <b> C4D-LogFile </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi" title="Acessar link"> César Cardoso (Code4Delphi) </a> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi/C4D-LogFile" title="Acessar link"> https://github.com/Code4Delphi/C4D-LogFile </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Com o C4D-LogFile, você pode gravar logs em arquivos, de forma rápida e simples de qualquer lugar de seu sistema.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="99 - C4D-Console"> <b> C4D-Console </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi" title="Acessar link"> César Cardoso (Code4Delphi) </a> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi/C4D-Console" title="Acessar link"> https://github.com/Code4Delphi/C4D-Console </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Framework para escrita de logs em Console Application. Com o C4D-Console, você pode controlar de uma forma rápida e fácil, a escrita de Logs para quando estiver utilizando um projeto Console Application no Delphi            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="5 - Gerenciador de dependências"> Gerenciador de dependências </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="65 - Boss"> <b> Boss </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad" title="Acessar link"> HashLoad </a> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad/boss" title="Acessar link"> https://github.com/HashLoad/boss </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Boss é um gerenciador de dependências open source inspirado no npm para projetos desenvolvidos em Delphi. Você pode gerenciar facilmente as dependências em seu projeto. Um utilitário de linha de comando está disponível, assim como a integração IDE.<br/><p> * Boss - Vinicius Sanches: <a target="_blank" href="https://www.youtube.com/watch?v=bchUVPFRUj8" title="Acessar link"> https://www.youtube.com/watch?v=bchUVPFRUj8 </a> </p><p> * Instalando e configurando - Alessandro: <a target="_blank" href="https://www.youtube.com/watch?v=Oxsl5fi3IsI&t" title="Acessar link"> https://www.youtube.com/watch?v=Oxsl5fi3IsI&t </a> </p><p> * Instalando e configurando - Adriano Santos: <a target="_blank" href="https://www.youtube.com/watch?v=oPJlt9tIh1k" title="Acessar link"> https://www.youtube.com/watch?v=oPJlt9tIh1k </a> </p><p> * Autenticação GitHub SSH: <a target="_blank" href="https://www.youtube.com/watch?v=geAGT-M0RGY" title="Acessar link"> https://www.youtube.com/watch?v=geAGT-M0RGY </a> </p><p> * Boss - André Dias: <a target="_blank" href="https://www.youtube.com/watch?v=NzJ6hae4jRc" title="Acessar link"> https://www.youtube.com/watch?v=NzJ6hae4jRc </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="66 - Boss Experts"> <b> Boss Experts </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar" title="Acessar link"> Gabriel Baltazar </a> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar/boss-experts" title="Acessar link"> https://github.com/gabrielbaltazar/boss-experts </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Boss Experts é um utilitário para IDE do Delphi que visa facilitar o uso do Boss sem ter que sair do IDE Delphi<br/><p> * Instalação e utilização - Adriano Santos: <a target="_blank" href="https://www.youtube.com/watch?v=88tk4ERMvVg" title="Acessar link"> https://www.youtube.com/watch?v=88tk4ERMvVg </a> </p><p> * Instalação e utilização - Gabriel: <a target="_blank" href="https://www.youtube.com/watch?v=XqdjcQz13_A&" title="Acessar link"> https://www.youtube.com/watch?v=XqdjcQz13_A& </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="2 - Servidores de aplicação REST"> Servidores de aplicação REST </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="52 - Horse"> <b> Horse </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad" title="Acessar link"> HashLoad </a> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad/horse" title="Acessar link"> https://github.com/HashLoad/horse </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Horse é um framework web inspirado no Express para Delphi e Lazarus. Projetado para facilitar o desenvolvimento rápido de forma minimalista e com alto desempenho.<br/><p> * Horse! Simplicidade em forma de API: <a target="_blank" href="https://www.youtube.com/watch?v=H7IC0fRgQ8s" title="Acessar link"> https://www.youtube.com/watch?v=H7IC0fRgQ8s </a> </p><p> * Vídeos: <a target="_blank" href="https://www.youtube.com/@HashLoad/videos" title="Acessar link"> https://www.youtube.com/@HashLoad/videos </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="53 - DMVC (Delphi MVC Framework)"> <b> DMVC (Delphi MVC Framework) </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/danieleteti" title="Acessar link"> Daniele Teti </a> </td>
          <td> <a target="_blank" href="https://github.com/danieleteti/delphimvcframework" title="Acessar link"> https://github.com/danieleteti/delphimvcframework </a> </td>
          <td> 
            <img alt="Itália" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/italia.png" title="Itália"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> DMVCFramework é uma estrutura Delphi muito popular que fornece uma estrutura RESTful, JSON-RPC e ActiveRecord fácil de usar, escalonável e flexível para desenvolvedores Delphi.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="54 - RDW (RestDataWare)"> <b> RDW (RestDataWare) </b> </span> </td>
          <td> <a target="_blank" href="https://sourceforge.net/projects/rest-dataware-componentes/" title="Acessar link"> Gilberto Rocha </a> </td>
          <td> <a target="_blank" href="https://github.com/OpenSourceCommunityBrasil/REST-DataWare" title="Acessar link"> https://github.com/OpenSourceCommunityBrasil/REST-DataWare </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> REST DataWare é uma suite de componentes criado para acelerar o desenvolvimento de aplicações 3 camadas com tudo que o RAD tem pra oferecer. Funcionando desde o Delphi 7 e também no Lazarus, o RDW como normalmente chamamos, é uma ferramenta completa para aplicações desktop, web e multiplataforma!            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="84 - TMS XData"> <b> TMS XData </b> </span> </td>
          <td> <a target="_blank" href="https://www.tmssoftware.com/site/" title="Acessar link"> TMS software </a> </td>
          <td> <a target="_blank" href="https://www.tmssoftware.com/site/xdata.asp" title="Acessar link"> https://www.tmssoftware.com/site/xdata.asp </a> </td>
          <td> 
            <img alt="Bélgica" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/belgica.png" title="Bélgica"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> TMS XData é um framework Delphi que permite criar servidores HTTP/HTTPS que expõem dados através de REST/JSON.<br/><p> * Demonstra&ccedil;&atilde;o: <a target="_blank" href="https://www.youtube.com/watch?v=tCOFSyubHus" title="Acessar link"> https://www.youtube.com/watch?v=tCOFSyubHus </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="4 - Consumir serviços REST"> Consumir serviços REST </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="50 - RESTRequest4Delphi"> <b> RESTRequest4Delphi </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/viniciussanchez" title="Acessar link"> Vinicius Sanchez </a> </td>
          <td> <a target="_blank" href="https://github.com/viniciussanchez/RESTRequest4Delphi" title="Acessar link"> https://github.com/viniciussanchez/RESTRequest4Delphi </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> RESTRequest4Delphi é uma API para consumir serviços REST escritos em qualquer linguagem de programação. Projetado para facilitar o desenvolvimento, de forma simples e minimalista            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="62 - GBClient"> <b> GBClient </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar" title="Acessar link"> Gabriel Baltazar </a> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar/GBClient" title="Acessar link"> https://github.com/gabrielbaltazar/GBClient </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Biblioteca Delphi REST Client para consumir serviços REST            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="63 - Delphi REST Client API"> <b> Delphi REST Client API </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/fabriciocolombo" title="Acessar link"> Fabricio Colombo </a> </td>
          <td> <a target="_blank" href="https://github.com/fabriciocolombo/delphi-rest-client-api" title="Acessar link"> https://github.com/fabriciocolombo/delphi-rest-client-api </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Biblioteca Delphi REST Client para consumir serviços REST. A API foi projetada para funcionar com <b>Delphi 7 ou posterior</b>. Versões mais recentes aproveitam os métodos genéricos.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="6 - JSON"> JSON </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="51 - DataSet Serialize"> <b> DataSet Serialize </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/viniciussanchez" title="Acessar link"> Vinicius Sanchez </a> </td>
          <td> <a target="_blank" href="https://github.com/viniciussanchez/dataset-serialize" title="Acessar link"> https://github.com/viniciussanchez/dataset-serialize </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> DataSet Serialize é um conjunto de recursos para simplificar o trabalho com JSON e DataSet. Exportar ou importar a estrutura de campos DataSet no formato JSON            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="88 - DataValidator"> <b> DataValidator </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/dliocode" title="Acessar link"> Danilo Lucas </a> </td>
          <td> <a target="_blank" href="https://github.com/dliocode/datavalidator" title="Acessar link"> https://github.com/dliocode/datavalidator </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> DataValidator foi projetado para ser uma biblioteca simples de validação de dados JSON            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="70 - GBJSON"> <b> GBJSON </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar" title="Acessar link"> Gabriel Baltazar </a> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar/GBJSON" title="Acessar link"> https://github.com/gabrielbaltazar/GBJSON </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Permite transformar um Objeto do Delphi em um JSON ou Vice-versa.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="78 - JSONBr"> <b> JSONBr </b> </span> </td>
          <td> <a target="_blank" href="https://www.isaquepinheiro.com.br/" title="Acessar link"> Isaque Pinheiro </a> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad/JSONBr" title="Acessar link"> https://github.com/HashLoad/JSONBr </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> JSON BRASIL é uma library opensource que provê escritas arquivos JSON, de forma funcional e orientada a objeto, além dos recursos de gerar um JSON de um objeto e popular o objeto com base em um arquivo JSON, seu diferencial são os eventos onGetValue() e onSetValue() que dão a dinâmica de tratar seu próprio tipo de campo, alimentado assim o JSON e lendo esse campo dele.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="3 - ORM (Mapeamento Objeto-Relacional)"> ORM (Mapeamento Objeto-Relacional) </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="55 - ORMBr"> <b> ORMBr </b> </span> </td>
          <td> <a target="_blank" href="https://www.isaquepinheiro.com.br/" title="Acessar link"> Isaque Pinheiro </a> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad/ORMBr" title="Acessar link"> https://github.com/HashLoad/ORMBr </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Da visão de aproveitar ao máximo o conceito de Orientação a Objetos, o Mapeamento Objeto-Relacional (ORM) consiste em um framework que tem por objetivo encurtar as distância entre a orientado a objetos e o modelo entidade-relacional, criando uma ponte (mapeamento) entre eles. Com a abordagem, é possível a construção de sistemas aplicando a orientado a objetos, cujo os objetos são persistidos em um banco de dados relacional.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="56 - SimpleORM"> <b> SimpleORM </b> </span> </td>
          <td> <a target="_blank" href="https://www.academiadocodigo.com.br/" title="Acessar link"> Academia do Código </a> </td>
          <td> <a target="_blank" href="https://github.com/academiadocodigo/SimpleORM" title="Acessar link"> https://github.com/academiadocodigo/SimpleORM </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> O SimpleORM tem o Objetivo de facilitar suas implementações de CRUD, agilizando mais de 80% do seu processo de desenvolvimento de software.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="57 - TMS Aurelius"> <b> TMS Aurelius </b> </span> </td>
          <td> <a target="_blank" href="https://www.tmssoftware.com/site/" title="Acessar link"> TMS software </a> </td>
          <td> <a target="_blank" href="https://www.tmssoftware.com/site/aurelius.asp" title="Acessar link"> https://www.tmssoftware.com/site/aurelius.asp </a> </td>
          <td> 
            <img alt="Bélgica" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/belgica.png" title="Bélgica"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Framework ORM para Delphi com suporte completo para manipulação de dados, consultas complexas e avançadas, herança, polimorfismo e muito mais            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="58 - DORM (Delphi ORM)"> <b> DORM (Delphi ORM) </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/danieleteti" title="Acessar link"> Daniele Teti </a> </td>
          <td> <a target="_blank" href="https://github.com/danieleteti/delphi-orm" title="Acessar link"> https://github.com/danieleteti/delphi-orm </a> </td>
          <td> 
            <img alt="Itália" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/italia.png" title="Itália"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Delphi ORM (DORM para abreviar) é um poderoso ORM para Delphi. É bastante robusto e testado porque usado desde 2010 na produção para muitos sistemas críticos de negócios            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="59 - DevART EntityDAC"> <b> DevART EntityDAC </b> </span> </td>
          <td> <a target="_blank" href="https://www.devart.com/" title="Acessar link"> Devart </a> </td>
          <td> <a target="_blank" href="https://www.devart.com/entitydac/" title="Acessar link"> https://www.devart.com/entitydac/ </a> </td>
          <td> 
            <img alt="República Tcheca" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/republica-tcheca.png" title="República Tcheca"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> EntityDAC é um ORM para Delphi com suporte a LINQ. Ele fornece uma estrutura poderosa que permite executar o mapeamento objeto-relacional de objetos de banco de dados para classes Delphi com suporte completo para encapsulamento, herança, polimorfismo e outros recursos de OOP            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="69 - Marshmallow"> <b> Marshmallow </b> </span> </td>
          <td> <a target="_blank" href="https://www.spring4d.org" title="Acessar link"> Spring4D </a> </td>
          <td> <a target="_blank" href="https://bitbucket.org/soundvibe/marshmallow/wiki/Home" title="Acessar link"> https://bitbucket.org/soundvibe/marshmallow/wiki/Home </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> O projeto "Marshmallow" foi inspirado em .NET micro ORM's (principalmente por PetaPoco) e Java Hibernate. O objetivo principal era escrever um framework Delphi ORM simples de usar, mas poderoso. O Framework usa os recursos mais recentes da linguagem Delphi, incluindo genéricos, atributos, RTTI aprimorado, registros, sobrecarga de operadores, etc. Isso permite que os desenvolvedores sejam mais produtivos, escrevam códigos mais limpos. "Marshmallow" é desenvolvido por Linas Naginionis.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="61 - Synopse mORMot"> <b> Synopse mORMot </b> </span> </td>
          <td> <a target="_blank" href="#" title="Acessar link"> Não informado </a> </td>
          <td> <a target="_blank" href="https://github.com/synopse/mORMot2" title="Acessar link"> https://github.com/synopse/mORMot2 </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Um framework Open Source Client-Server ORM/SOA/MVC            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="7 - Websocket"> Websocket </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="73 - Bird Socket Client"> <b> Bird Socket Client </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/mateusvicente100" title="Acessar link"> Mateus Vicente </a> </td>
          <td> <a target="_blank" href="https://github.com/mateusvicente100/bird-socket-client" title="Acessar link"> https://github.com/mateusvicente100/bird-socket-client </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Cliente para conexão WebSocket para Delphi. <br/>
WebSocket é um protocolo de comunicação bidirecional que permite a comunicação em tempo real entre um cliente e um servidor (navegador e um servidor).<br/><p> * Demonstra&ccedil;&atilde;o: <a target="_blank" href="https://www.youtube.com/watch?v=vYkOrgMtObg" title="Acessar link"> https://www.youtube.com/watch?v=vYkOrgMtObg </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="72 - Bird Socket Server"> <b> Bird Socket Server </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/mateusvicente100" title="Acessar link"> Mateus Vicente </a> </td>
          <td> <a target="_blank" href="https://github.com/mateusvicente100/bird-socket-server" title="Acessar link"> https://github.com/mateusvicente100/bird-socket-server </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Servidor WebSocket para Delphi. <br/>
WebSocket é um protocolo de comunicação bidirecional que permite a comunicação em tempo real entre um cliente e um servidor (navegador e um servidor).<br/><p> * Demonstra&ccedil;&atilde;o: <a target="_blank" href="https://www.youtube.com/watch?v=vYkOrgMtObg" title="Acessar link"> https://www.youtube.com/watch?v=vYkOrgMtObg </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="10 - Database Migration Framework"> Database Migration Framework </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="80 - Duck"> <b> Duck </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/CarlosHe" title="Acessar link"> Carlos Modesto </a> </td>
          <td> <a target="_blank" href="https://github.com/CarlosHe/duck" title="Acessar link"> https://github.com/CarlosHe/duck </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Duck é um database migration framework (estrutura de migração de banco de dados). Gerencie seu banco de dados criando alterações SQL incrementais ou funções Delphi.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="11 - Web Application Framework (Delphi para Web)"> Web Application Framework (Delphi para Web) </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="86 - D2Bridge"> <b> D2Bridge </b> </span> </td>
          <td> <a target="_blank" href="https://www.youtube.com/@talisjonatas" title="Acessar link"> Talis Jonatas Gomes </a> </td>
          <td> <a target="_blank" href="https://d2bridge.com.br/svn/D2Bridge/trunk" title="Acessar link"> https://d2bridge.com.br/svn/D2Bridge/trunk </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Agora é possivel levar seus aplicativos feitos em Delphi diretamente para WEB sem reescrever código, mesma base de código, mesmo aplicativo, Windows e WEB, tudo isso usando a nova Framework D2Bridge agora com o Prism. </br>
<b> <span class="text-danger">*</span> Ao acessar o projeto caso seja exigido informe o usuário anonymous e deixe o campo senha em branco </b><br/><p> * Discord (disponível em Português e Inglês): <a target="_blank" href="https://discord.gg/CfYN3FpYMc" title="Acessar link"> https://discord.gg/CfYN3FpYMc </a> </p><p> * Grupo do WhatsAPP: <a target="_blank" href="https://chat.whatsapp.com/Jz8ditsGyzl79eSI5tL5Cq" title="Acessar link"> https://chat.whatsapp.com/Jz8ditsGyzl79eSI5tL5Cq </a> </p><p> * Vídeos: <a target="_blank" href="www.youtube.com/@talisjonatas" title="Acessar link"> www.youtube.com/@talisjonatas </a> </p><p> * Prism Server without Datasnap: <a target="_blank" href="https://www.youtube.com/watch?v=aacB9_X_Nfg" title="Acessar link"> https://www.youtube.com/watch?v=aacB9_X_Nfg </a> </p><p> * Como funciona: <a target="_blank" href="http://code4delphi.com.br/img/D2Bridge-Como-Funciona.png" title="Acessar link"> http://code4delphi.com.br/img/D2Bridge-Como-Funciona.png </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="82 - IntraWeb"> <b> IntraWeb </b> </span> </td>
          <td> <a target="_blank" href="https://www.atozed.com/" title="Acessar link"> Atozed Software </a> </td>
          <td> <a target="_blank" href="https://www.atozed.com.br/intraweb/" title="Acessar link"> https://www.atozed.com.br/intraweb/ </a> </td>
          <td> 
            <img alt="Nova Zelândia" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/nova-zelandia.png" title="Nova Zelândia"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Com mais de 20 anos de estrada e utilizada por centenas de milhares de desenvolvedores Delphi mundo afora, o IntraWeb é a ferramenta líder no desenvolvimento de aplicativos e páginas web dinâmicas com Delphi.
Devido a sua facilidade de uso, baixa curva de aprendizado e facilidade de integração com frameworks como JQuery, JQueryMobile, Bootstrap, dentre outros, o IntraWeb tem conquistado cada vez mais fãs na comunidade Delphi, em especial na comunidade Brasileira.<br/><p> * Demonstra&ccedil;&atilde;o: <a target="_blank" href="https://www.youtube.com/watch?v=6GfrJDRYEFg" title="Acessar link"> https://www.youtube.com/watch?v=6GfrJDRYEFg </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="81 - uniGUI"> <b> uniGUI </b> </span> </td>
          <td> <a target="_blank" href="http://www.fmsoft.net/" title="Acessar link"> FMSoft </a> </td>
          <td> <a target="_blank" href="https://www.unigui.com/" title="Acessar link"> https://www.unigui.com/ </a> </td>
          <td> 
            <img alt="Turquia" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/turquia.png" title="Turquia"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Framework para criar desktop, mobile e aplicações Web. Ele usa os principais frameworks JavaScript do setor, Sencha Ext JS e Sencha Touch, para criar uma experiência moderna, elegante e rica em recursos do lado do cliente.<br/><p> * Demonstra&ccedil;&atilde;o: <a target="_blank" href="https://www.youtube.com/watch?v=XrO9JTpvdMA" title="Acessar link"> https://www.youtube.com/watch?v=XrO9JTpvdMA </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="83 - TMS WEB Core"> <b> TMS WEB Core </b> </span> </td>
          <td> <a target="_blank" href="https://www.tmssoftware.com/site/" title="Acessar link"> TMS software </a> </td>
          <td> <a target="_blank" href="https://www.tmssoftware.com/site/tmswebcore.asp" title="Acessar link"> https://www.tmssoftware.com/site/tmswebcore.asp </a> </td>
          <td> 
            <img alt="Bélgica" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/belgica.png" title="Bélgica"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilatilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> TMS Web core é uma ferramenta de desenvolvimento web que permite criar aplicações web cliente a partir de Delphi usando a metodologia de desenvolvimento RAD e um framework baseado em componentes<br/><p> * Demonstra&ccedil;&atilde;o: <a target="_blank" href="https://youtu.be/ohlOXGM95Ng?si=-6tES-YlwFPc-6Sc" title="Acessar link"> https://youtu.be/ohlOXGM95Ng?si=-6tES-YlwFPc-6Sc </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="12 - Academia do Código"> Academia do Código </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="90 - Bind4D"> <b> Bind4D </b> </span> </td>
          <td> <a target="_blank" href="https://www.academiadocodigo.com.br/" title="Acessar link"> Academia do Código </a> </td>
          <td> <a target="_blank" href="https://github.com/academiadocodigo/Bind4D" title="Acessar link"> https://github.com/academiadocodigo/Bind4D </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Framework para realização de Bind via notação de Atributos nos componentes do formulário. O Bind4D tem o objetivo de facilitar a transição de dados entre a camada de visão e as demais camadas do seu sistema, realizando de forma automática mediante notação a conversão dos dados de um formulário para JSON, atribuindo estilos a componentes, realizando validação de campos, configuração de exibição de dados do dataset em um DbGrid e muito mais.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="91 - LocalCache4D"> <b> LocalCache4D </b> </span> </td>
          <td> <a target="_blank" href="https://www.academiadocodigo.com.br/" title="Acessar link"> Academia do Código </a> </td>
          <td> <a target="_blank" href="https://github.com/academiadocodigo/localcache4d" title="Acessar link"> https://github.com/academiadocodigo/localcache4d </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Estrutura de chave e valor para realização de cache temporário ou fixo na sua aplicação.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="89 - Router4Delphi"> <b> Router4Delphi </b> </span> </td>
          <td> <a target="_blank" href="https://www.academiadocodigo.com.br/" title="Acessar link"> Academia do Código </a> </td>
          <td> <a target="_blank" href="https://github.com/academiadocodigo/Router4Delphi" title="Acessar link"> https://github.com/academiadocodigo/Router4Delphi </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Framework para Criação de Rotas de Telas para FMX e VCL, com o objetivo de facilitar a chamada de telas e embed de Layouts em aplicações FMX, e Panels em aplicações VCL, reduzindo o acoplamento das telas de dando mais dinâmismo e práticidade na construção de interfaces ricas em Delphi            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="92 - Safety4D"> <b> Safety4D </b> </span> </td>
          <td> <a target="_blank" href="https://www.academiadocodigo.com.br/" title="Acessar link"> Academia do Código </a> </td>
          <td> <a target="_blank" href="https://github.com/academiadocodigo/safety4d" title="Acessar link"> https://github.com/academiadocodigo/safety4d </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Framework para Controle de Regras de Acesso de Usuários inspirado no conceito RBAC (role-based access control). Ele se baseia em uma estrutura JSON de configuração para definição das permissões, inspirada na estrutura utilizada pelo Windows Azure.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="14 - Adriano Santos"> Adriano Santos </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="94 - ADRConnection"> <b> ADRConnection </b> </span> </td>
          <td> <a target="_blank" href="https://www.adrianosantostreina.com.br/" title="Acessar link"> Adriano Santos </a> </td>
          <td> <a target="_blank" href="https://github.com/adrianosantostreina/ADRConnection" title="Acessar link"> https://github.com/adrianosantostreina/ADRConnection </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Classes de conexão com banco de dados            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="93 - MobilePermissions"> <b> MobilePermissions </b> </span> </td>
          <td> <a target="_blank" href="https://www.adrianosantostreina.com.br/" title="Acessar link"> Adriano Santos </a> </td>
          <td> <a target="_blank" href="https://github.com/adrianosantostreina/MobilePermissions" title="Acessar link"> https://github.com/adrianosantostreina/MobilePermissions </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Criado para tornar mais fácil a permissão de solicitação no Android 8.x ou posterior. Ele traz todas as permissões previstas em Project > Options > Application > User Permissions            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="8 - Injeção de dependência"> Injeção de dependência </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="74 - InjectorBr"> <b> InjectorBr </b> </span> </td>
          <td> <a target="_blank" href="https://www.isaquepinheiro.com.br/" title="Acessar link"> Isaque Pinheiro </a> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad/InjectorBr" title="Acessar link"> https://github.com/HashLoad/InjectorBr </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> InjectorBr é um framework de injeção de dependência para aplicações Delphi. A injeção de dependência é um padrão de projeto de software que permite desacoplar componentes de uma aplicação, tornando-as mais modulares e fáceis de manter, com ele os desenvolvedores podem facilmente criar aplicações modulares e flexíveis, evitando dependências acopladas e reduzindo a complexidade do código. O framework também inclui recursos para gerenciamento de ciclo de vida dos componentes.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="68 - Spring4D"> <b> Spring4D </b> </span> </td>
          <td> <a target="_blank" href="https://www.spring4d.org" title="Acessar link"> Spring4D </a> </td>
          <td> <a target="_blank" href="https://bitbucket.org/sglienke/spring4d" title="Acessar link"> https://bitbucket.org/sglienke/spring4d </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Spring4D é uma biblioteca de código aberto para Delphi XE e superior. Ele consiste em vários módulos diferentes que contêm uma biblioteca de classes base (tipos comuns, tipos de coleção baseados em interface, extensões de reflexão) e uma estrutura de injeção de dependência. Ele usa a Licença Apache 2.0. Biblioteca que trabalha com collections, frameworks de injeção de dependências. Spring4D foi originalmente escrito por Baoquan Zuo e agora é mantido por <a href="https://github.com/sglienke" target="_blank"> Stefan Glienke </a><br/><p> * Ecossistema Completo: Boss + Horse + Spring4D: <a target="_blank" href="https://www.youtube.com/watch?v=EW3z06Wt1yo" title="Acessar link"> https://www.youtube.com/watch?v=EW3z06Wt1yo </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="18 - Outros de Vinicius Sanchez"> Outros de Vinicius Sanchez </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="111 - XML Builder"> <b> XML Builder </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/viniciussanchez" title="Acessar link"> Vinicius Sanchez </a> </td>
          <td> <a target="_blank" href="https://github.com/viniciussanchez/xml-builder" title="Acessar link"> https://github.com/viniciussanchez/xml-builder </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Construtor de XML para Delphi. Fornece escrita por meio de uma interface, permitindo a criação de um XML de uma forma muito mais rápida e intuitiva.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="110 - BCrypt"> <b> BCrypt </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/viniciussanchez" title="Acessar link"> Vinicius Sanchez </a> </td>
          <td> <a target="_blank" href="https://github.com/viniciussanchez/bcrypt" title="Acessar link"> https://github.com/viniciussanchez/bcrypt </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> É uma biblioteca de ajuda para fazer hash de senhas.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="15 - Outros de Gabriel Baltazar"> Outros de Gabriel Baltazar </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="67 - GBWinService"> <b> GBWinService </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar" title="Acessar link"> Gabriel Baltazar </a> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar/GBWinService" title="Acessar link"> https://github.com/gabrielbaltazar/GBWinService </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Execute seus aplicativos VCL como StandAlone e WinService<br/><p> * API Horse Stand Alone e WinSvc na mesma aplicação: <a target="_blank" href="https://www.youtube.com/watch?v=0bH5vcvavJs" title="Acessar link"> https://www.youtube.com/watch?v=0bH5vcvavJs </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="71 - AWS4Delphi"> <b> AWS4Delphi </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar" title="Acessar link"> Gabriel Baltazar </a> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar/AWS4Delphi" title="Acessar link"> https://github.com/gabrielbaltazar/AWS4Delphi </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> O AWS4Delphi é um SDK Delphi para integração com serviços da AWS com delphi de forma rápida e simples. Os serviços disponíveis são: Amazon SNS (Serviço de notificação simples) - Amazon SQS (serviço de fila simples) - Amazon S3 (Serviço de armazenamento simples)            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="9 - Outros de Isaque Pinheiro"> Outros de Isaque Pinheiro </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="76 - CQLBr"> <b> CQLBr </b> </span> </td>
          <td> <a target="_blank" href="https://www.isaquepinheiro.com.br/" title="Acessar link"> Isaque Pinheiro </a> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad/CQLBr" title="Acessar link"> https://github.com/HashLoad/CQLBr </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Criteria Query Language é uma biblioteca que fornece escrita por meio de uma interface, permitindo o mapeamento da sintaxe orientada a objeto para executar operações de consulta, inserção, atualização e exclusão de banco de dados.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="77 - DBCBr"> <b> DBCBr </b> </span> </td>
          <td> <a target="_blank" href="https://www.isaquepinheiro.com.br/" title="Acessar link"> Isaque Pinheiro </a> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad/DBCBr" title="Acessar link"> https://github.com/HashLoad/DBCBr </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> DATABASE COMPARER BRASIL, um comparador de estrutura de banco de dados, que nasceu do código do ORMBr que disponibiliza esse recurso, mas a um nível limitado como de criar tabelas, adicionar novos campos a tabela já existente, e outros recursos de criar PrimaryKeys, ForeignKeys e Indexes para as tabelas.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="75 - DBEBr"> <b> DBEBr </b> </span> </td>
          <td> <a target="_blank" href="https://www.isaquepinheiro.com.br/" title="Acessar link"> Isaque Pinheiro </a> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad/DBEBr" title="Acessar link"> https://github.com/HashLoad/DBEBr </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> DATABASE ENGINE é um framework opensource que provê desacoplamento de conexão através de uma interface orientada a objeto, deixando seu sistema totalmente desacoplado de um único Engine de conexão, proporcionando de forma fácil e simples a troca para usar qualquer Engine disponível no mercado, seja ele FireDAC, DBExpress, Zeos entre outros            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="21 - Wizards e Experts"> Wizards e Experts </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="100 - Code4D-Wizard"> <b> Code4D-Wizard </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi" title="Acessar link"> César Cardoso (Code4Delphi) </a> </td>
          <td> <a target="_blank" href="https://github.com/Code4Delphi/Code4D-Wizard" title="Acessar link"> https://github.com/Code4Delphi/Code4D-Wizard </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Code4D-Wizard é um conjunto de ferramentas de plugin projetadas para serem usadas no Delphi IDE. Ele adiciona ao Delphi IDE diversos recursos para melhorar nossa eficiência, velocidade e produtividade de desenvolvimento. Este Wizard foi desenvolvido usando OTA (Open Tools API)<br/><p> * Principais recursos: <a target="_blank" href="https://www.youtube.com/watch?v=gPiGDuRL8uk" title="Acessar link"> https://www.youtube.com/watch?v=gPiGDuRL8uk </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="103 - Horse wizard"> <b> Horse wizard </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad" title="Acessar link"> HashLoad </a> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad/horse-wizard" title="Acessar link"> https://github.com/HashLoad/horse-wizard </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Horse-wizard é um assistente para criar novos aplicativos Horse. Fácil, rápido e simples. Uma ferramenta para facilitar o seu trabalho!<br/><p> * Instalação COM Boss: <a target="_blank" href="https://www.youtube.com/watch?v=lEgXs9aSXz8" title="Acessar link"> https://www.youtube.com/watch?v=lEgXs9aSXz8 </a> </p><p> * Instalação SEM o Boss: <a target="_blank" href="https://www.youtube.com/watch?v=nsSF0sRDmAg" title="Acessar link"> https://www.youtube.com/watch?v=nsSF0sRDmAg </a> </p><p> * Instalação - Adriano Santos: <a target="_blank" href="https://www.youtube.com/watch?v=Ja69cJav9-g" title="Acessar link"> https://www.youtube.com/watch?v=Ja69cJav9-g </a> </p><p> * Demo: <a target="_blank" href="https://www.youtube.com/watch?v=44gM_teUmzQ" title="Acessar link"> https://www.youtube.com/watch?v=44gM_teUmzQ </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="104 - Boss Experts"> <b> Boss Experts </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/HashLoad" title="Acessar link"> HashLoad </a> </td>
          <td> <a target="_blank" href="https://github.com/gabrielbaltazar/boss-experts" title="Acessar link"> https://github.com/gabrielbaltazar/boss-experts </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Boss Experts é um utilitário para IDE do Delphi que visa facilitar o uso do Boss sem ter que sair do IDE Delphi<br/><p> * Instalação e utilização - Adriano Santos: <a target="_blank" href="https://www.youtube.com/watch?v=88tk4ERMvVg" title="Acessar link"> https://www.youtube.com/watch?v=88tk4ERMvVg </a> </p><p> * Instalação e utilização - Gabriel: <a target="_blank" href="https://www.youtube.com/watch?v=XqdjcQz13_A&" title="Acessar link"> https://www.youtube.com/watch?v=XqdjcQz13_A& </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="101 - CnPack"> <b> CnPack </b> </span> </td>
          <td> <a target="_blank" href="https://www.cnpack.org/index.php?lang=en" title="Acessar link"> CnPack </a> </td>
          <td> <a target="_blank" href="https://cnpack.org/index.php?lang=en" title="Acessar link"> https://cnpack.org/index.php?lang=en </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> CnWizards é o principal produto da CnPack, com o nome completo em inglês 'CnPack IDE Wizards'. É um conjunto de ferramentas de plug-in gratuito usado no Delphi/C++Builder /BDS/RAD Studio para melhorar nossa eficiência de desenvolvimento.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="102 - GExperts"> <b> GExperts </b> </span> </td>
          <td> <a target="_blank" href="#" title="Acessar link"> Não informado </a> </td>
          <td> <a target="_blank" href="https://www.gexperts.org/" title="Acessar link"> https://www.gexperts.org/ </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> GExperts é um plugin para o IDE Delphi que adiciona muitas funcionalidades.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="105 - ChatGPTWizard"> <b> ChatGPTWizard </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/AliDehbansiahkarbon" title="Acessar link"> Ali Dehbansiahkarbon </a> </td>
          <td> <a target="_blank" href="https://github.com/AliDehbansiahkarbon/ChatGPTWizard" title="Acessar link"> https://github.com/AliDehbansiahkarbon/ChatGPTWizard </a> </td>
          <td> 
            <img alt="Turquia" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/turquia.png" title="Turquia"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Um plug-in de IA para o IDE do Delphi. Primeiro plugin para suportar ChatGPT, Writesonic e YouChat!            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="124 - MobileExperts"> <b> MobileExperts </b> </span> </td>
          <td> <a target="_blank" href="https://www.adrianosantostreina.com.br/" title="Acessar link"> Adriano Santos </a> </td>
          <td> <a target="_blank" href="https://github.com/adrianosantostreina/MobileExperts" title="Acessar link"> https://github.com/adrianosantostreina/MobileExperts </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Mobile Experts é um plugin OpenSource para instalação em Delphi que implementa recursos que facilitam o desenvolvimento Mobile iOS e Android.<br/><p> * Demonstra&ccedil;&atilde;o: <a target="_blank" href="https://www.youtube.com/watch?v=hcCN8FkYE30" title="Acessar link"> https://www.youtube.com/watch?v=hcCN8FkYE30 </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="23 - Gerencimento de memória / Detecção de vazamentos de memória"> Gerencimento de memória / Detecção de vazamentos de memória </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="118 - FastMM"> <b> FastMM </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/pleriche" title="Acessar link"> Pierre le Riche </a> </td>
          <td> <a target="_blank" href="https://github.com/pleriche/FastMM4" title="Acessar link"> https://github.com/pleriche/FastMM4 </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> <b> Algumas funcionalidades do FastMM foram incorporadas ao Delphi para Win32 e Win64 a partir da versão 2006 <a href="https://docwiki.embarcadero.com/RADStudio/Alexandria/en/Memory_Management" target="_blank"> (Ver lista completa de ferramentas de gerenciamento de memória do Delphi) </a>  <br/> </b>
FastMM é uma ferramenta amplamente utilizada para detectar vazamentos de memória. Os vazamentos de memória nos projetos são relatados depois que você fecha o aplicativo em execução. <br/>
Um gerenciador de memória de substituição rápida para aplicativos Embarcadero Delphi que se adapta bem ao uso multithread, não é propenso à fragmentação de memória e suporta memória compartilhada sem o uso de arquivos .DLL externos. <br/>
Existe também uma nova versão chamada FastMM5, que pode ser acessada através do seguinte link: <a href="https://github.com/pleriche/FastMM5" target="_blank"> https://github.com/pleriche/FastMM5 </a><br/><p> * Artigo da Embarcadero sobre FastMM4 e FastMM5: <a target="_blank" href="https://blogs.embarcadero.com/dev-c-modernized-with-powerful-new-fastmm5-memory-manager/" title="Acessar link"> https://blogs.embarcadero.com/dev-c-modernized-with-powerful-new-fastmm5-memory-manager/ </a> </p><p> * Artigo com dicas de como instalar e usar: <a target="_blank" href="https://www.softacom.com/blog/catching_memory_leaks_in_delphi_apps/#fastmm" title="Acessar link"> https://www.softacom.com/blog/catching_memory_leaks_in_delphi_apps/#fastmm </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="127 - Nexus Quality Suite"> <b> Nexus Quality Suite </b> </span> </td>
          <td> <a target="_blank" href="https://www.nexusdb.com/support/index.php" title="Acessar link"> NexusQA Pty Ltd </a> </td>
          <td> <a target="_blank" href="https://www.nexusdb.com/support/index.php?q=node/27156" title="Acessar link"> https://www.nexusdb.com/support/index.php?q=node/27156 </a> </td>
          <td> 
            <img alt="Austrália" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/australia.png" title="Austrália"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> O Nexus Quality Suite (NQS) é um conjunto de ferramentas que permite ajustar seus aplicativos aos mais altos padrões de desempenho e qualidade possíveis. A coleção atual de ferramentas inclui perfiladores de nível de Linha, Método e Bloco; uma ferramenta de análise de memória e recursos do alho-poró; um analisador de cobertura de teste unitário; uma ferramenta de análise executável estática; e uma ferramenta de gravador/reprodução de scripts GUI.<br/><p> * Artigo Embarcadero: <a target="_blank" href="https://blogs.embarcadero.com/powerful-quality-assurance-nexus-quality-suite-for-delphi-on-windows/" title="Acessar link"> https://blogs.embarcadero.com/powerful-quality-assurance-nexus-quality-suite-for-delphi-on-windows/ </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="120 - EurekaLog"> <b> EurekaLog </b> </span> </td>
          <td> <a target="_blank" href="https://www.eurekalog.com/index.php" title="Acessar link"> Fabio Dell'Aria and EurekaLog </a> </td>
          <td> <a target="_blank" href="https://www.eurekalog.com/downloads_delphi.php" title="Acessar link"> https://www.eurekalog.com/downloads_delphi.php </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> EurekaLog é a ferramenta de rastreamento de exceção que pode dar ao seu aplicativo a capacidade de capturar bugs e gera um log detalhado com as informações da pilha de chamadas, como nome da unidade, nome da classe, método e número da linha. Essas informações também são registradas em um arquivo. Além disso, essa ferramenta fornece a capacidade para os usuários finais do aplicativo enviar as informações sobre esses logs de erro para o desenvolvedor do aplicativo via e-mail. Além de todos esses recursos, o EurekaLog também oferece suporte à detecção de vazamento de memória.<br/><p> * Artigo com dicas de como instalar e usar: <a target="_blank" href="https://www.softacom.com/blog/catching_memory_leaks_in_delphi_apps/#eurekalog" title="Acessar link"> https://www.softacom.com/blog/catching_memory_leaks_in_delphi_apps/#eurekalog </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="121 - madExcept"> <b> madExcept </b> </span> </td>
          <td> <a target="_blank" href="https://www.madshi.net/" title="Acessar link"> SystemSoftware </a> </td>
          <td> <a target="_blank" href="https://www.madshi.net/madExceptDescription.htm" title="Acessar link"> https://www.madshi.net/madExceptDescription.htm </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> MadExcept é uma biblioteca comercial paga, porém possui uma versão free para uso pessoal. Foi desenvolvida para ajudar os desenvolvedores a localizar bugs em seu software. Sempre que houver qualquer falha ou exceção, madExcept irá automaticamente pegá-lo, registrar muitas informações úteis e fornecer aos usuários finais a possibilidade de enviar aos desenvolvedores um relatório completo de bugs. madExcept também é capaz de encontrar vazamentos de memória, vazamentos de recursos e saturações de buffer.<br/><p> * Artigo com dicas de como instalar e usar: <a target="_blank" href="https://www.softacom.com/blog/catching_memory_leaks_in_delphi_apps/#eurekalog" title="Acessar link"> https://www.softacom.com/blog/catching_memory_leaks_in_delphi_apps/#eurekalog </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="122 - Delphi LeakCheck"> <b> Delphi LeakCheck </b> </span> </td>
          <td> <a target="_blank" href="https://bitbucket.org/shadow_cs/workspace/repositories/" title="Acessar link"> Honza Rame </a> </td>
          <td> <a target="_blank" href="https://bitbucket.org/shadow_cs/delphi-leakcheck/src/master/" title="Acessar link"> https://bitbucket.org/shadow_cs/delphi-leakcheck/src/master/ </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Biblioteca de verificação de vazamento multiplataforma para Delphi. <br/>
LeakCheck é uma extensão do gerenciador de memória que adiciona funcionalidade de verificação de vazamento. A principal diferença do gerenciador de memória padrão é a implementação multiplataforma de verificação de vazamentos com integração DUnit e DUnitX.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="123 - TMS MemInsight"> <b> TMS MemInsight </b> </span> </td>
          <td> <a target="_blank" href="https://www.tmssoftware.com/site/" title="Acessar link"> TMS software </a> </td>
          <td> <a target="_blank" href="https://www.tmssoftware.com/site/tmsmeminsight.asp" title="Acessar link"> https://www.tmssoftware.com/site/tmsmeminsight.asp </a> </td>
          <td> 
            <img alt="Bélgica" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/belgica.png" title="Bélgica"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> O TMS MemInsight é uma coleção de ferramentas de depuração que contém vários módulos: um perfilador de memória, um visualizador de threads, um visualizador de módulos e um manipulador de exceções aprimorado. O TMS MemInsight pode ser facilmente integrado aos seus projetos Delphi, seja usando sua interface gráfica de usuário integrada ou sua API.<br/><p> * Introdução ao MemInsight: <a target="_blank" href="https://www.youtube.com/watch?v=0QD8twqURZw" title="Acessar link"> https://www.youtube.com/watch?v=0QD8twqURZw </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="128 - https://www.deleaker.com/"> <b> https://www.deleaker.com/ </b> </span> </td>
          <td> <a target="_blank" href="https://www.deleaker.com/" title="Acessar link"> Deleaker </a> </td>
          <td> <a target="_blank" href="https://www.deleaker.com/" title="Acessar link"> https://www.deleaker.com/ </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Deleaker é uma extensão para o IDE do Delphi. É um aplicativo autônomo para detecção de vazamento de memória, GDI e manipuladores.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="126 - BrainMM"> <b> BrainMM </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/d-mozulyov" title="Acessar link"> Dmitry </a> </td>
          <td> <a target="_blank" href="https://github.com/d-mozulyov/BrainMM" title="Acessar link"> https://github.com/d-mozulyov/BrainMM </a> </td>
          <td> 
            <img alt="Rússia" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/russia.png" title="Rússia"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Gerenciador de memória para Delphi            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="1 - Outros"> Outros </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="87 - ComponentDinosOffice-OpenOffice"> <b> ComponentDinosOffice-OpenOffice </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/Daniel09Fernandes" title="Acessar link"> Daniel Fernandes </a> </td>
          <td> <a target="_blank" href="https://github.com/Daniel09Fernandes/ComponentDinosOffice-OpenOffice" title="Acessar link"> https://github.com/Daniel09Fernandes/ComponentDinosOffice-OpenOffice </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Componentes Delphi para LibreOffice<br/><p> * Podcast - Papo Pro ACBr: <a target="_blank" href="https://open.spotify.com/episode/7mthWdVwLCLb0R0upxDmwL" title="Acessar link"> https://open.spotify.com/episode/7mthWdVwLCLb0R0upxDmwL </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         
        <tr> 
          <td> <span title="129 - Awesome Pascal"> <b> Awesome Pascal </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/Fr0sT-Brutal" title="Acessar link"> Fr0sT-Brutal </a> </td>
          <td> <a target="_blank" href="https://github.com/Fr0sT-Brutal/awesome-pascal" title="Acessar link"> https://github.com/Fr0sT-Brutal/awesome-pascal </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Uma lista de frameworks, bibliotecas, recursos e coisas brilhantes de Delphi, FreePascal e outros *Pascal. Apenas projetos de código aberto são considerados nesta lista.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         
        <tr> 
          <td> <span title="130 - Excel4Delphi"> <b> Excel4Delphi </b> </span> </td>
          <td> <a target="_blank" href="https://github.com/HemulGM" title="Acessar link"> HemulGM </a> </td>
          <td> <a target="_blank" href="https://github.com/HemulGM/Excel4Delphi" title="Acessar link"> https://github.com/HemulGM/Excel4Delphi </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5">
            Ler, Escrever excel 2002/2003 XML (SpreadsheetML / XML Spreadsheet) biblioteca.
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="19 - Componentes"> Componentes </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="112 - ACBr"> <b> ACBr </b> </span> </td>
          <td> <a target="_blank" href="https://projetoacbr.com.br/" title="Acessar link"> ACBr </a> </td>
          <td> <a target="_blank" href="svn://svn.code.sf.net/p/acbr/code/trunk2" title="Acessar link"> svn://svn.code.sf.net/p/acbr/code/trunk2 </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> O acrônimo ACBr significa: Automação Comercial Brasil. <br/>
Em síntese, é um Projeto de Código Aberto(gratuito), de Componentes e Programas destinados ao desenvolvimento de Aplicações do segmento de Automação Comercial. Possui vários componentes para área fiscal (NF-e, NFC-e, CT-e, MDF-e, etc), componentes para geração de boletos e PIX, entre muitos outros.<br/><p> * Forum: <a target="_blank" href="https://www.projetoacbr.com.br/forum/" title="Acessar link"> https://www.projetoacbr.com.br/forum/ </a> </p><p> * Discord: <a target="_blank" href="https://discord.gg/acbr" title="Acessar link"> https://discord.gg/acbr </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="113 - HcComponentes"> <b> HcComponentes </b> </span> </td>
          <td> <a target="_blank" href="https://magno.tec.br/" title="Acessar link"> Alexandre Magno </a> </td>
          <td> <a target="_blank" href="https://github.com/magnoamds/hccomponentes" title="Acessar link"> https://github.com/magnoamds/hccomponentes </a> </td>
          <td> 
            <img alt="Brasil" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/brasil.png" title="Brasil"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> É um mecanismo para ter o conceito de componentes DBWare em ambiente 3 camadas. <br/>
Ele simula um DataSet (FDQuey, ZQuery) porém não mantem um ponteiro com a base de dados. <br/>
Nele se informa as informações de um select, ou se carrega os dados para a persistência no banco, o componente envia esses dados para uma aplicação 3 camadas (Horse, RDW, Indy, Datasnap), ele processa os dados do lado do servidor pega o ResultSet do DataSet envia os dados novamente para o client e exibe na tela. <br/> 
Da a sensação de que estamos usando componentes de query normais (FDQuery, ZQuery), mas ele não é uma query normal pois por trás ele faz toda a estrutura de comunicação via protocolo HTTP.
Existe o componente HCServer do lado do servidor e o HCConect do lado do cliente. <br/>
Pode ser usado com o Horse (recomendado), RDW, Indy, Datasnap <br/>
Para utilizar o Firedac por exemplo, existe o componente HCMemTable, ele agrega funcionalidade no FDMemTable (nativo do Delphi), como por exemplo a propriedade HCBase que pode ser ligada a um componente HcBaseDataSet, onde pode ser informar o SQL do lado do Cliente, quando der um open no HCMemTable os dados são enviados para o servidor, processa no servidor e devolve o ResultSet do DataSet e popula dentro do MemTable dando a sensação de estar usando um FDQuery normal.<br/><p> * Grupo no Telegram: <a target="_blank" href="https://t.me/n_tier" title="Acessar link"> https://t.me/n_tier </a> </p><p> * Vídeo da versão de avaliação: <a target="_blank" href="https://www.youtube.com/watch?v=9K5hylKndv8" title="Acessar link"> https://www.youtube.com/watch?v=9K5hylKndv8 </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
  <table>
    <thead>
      <tr>
        <th colspan="5"> <span title="22 - Componentes de conexão"> Componentes de conexão </span> </th>  
      </tr>
      <tr>
        <th> Nome </th>
        <th> Autor </th>
        <th> Link </th>
        <th> Pa&iacute;s </th>
        <th> Free </th>
      </tr>
    </thead>
    <tbody> 
        <tr> 
          <td> <span title="115 - FireDAC"> <b> FireDAC </b> </span> </td>
          <td> <a target="_blank" href="https://www.embarcadero.com/br/" title="Acessar link"> Embarcadero </a> </td>
          <td> <a target="_blank" href="https://www.embarcadero.com/br/products/rad-studio/firedac" title="Acessar link"> https://www.embarcadero.com/br/products/rad-studio/firedac </a> </td>
          <td> 
            <img alt="Estados Unidos" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/estados-unidos.png" title="Estados Unidos"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> FireDAC é uma biblioteca Universal Data Access para desenvolver aplicativos para vários dispositivos, conectados a bancos de dados corporativos. Com sua poderosa arquitetura universal, o FireDAC permite acesso direto nativo de alta velocidade de Delphi e C++Builder para InterBase, SQLite, MySQL, SQL Server, Oracle, PostgreSQL, DB2, SQL Anywhere, Advantage DB, Firebird, Access, Informix, DataSnap e muito mais, incluindo o Banco de Dados NoSQL MongoDB.<br/><p> * Introdução ao Firedac (Régys Borges): <a target="_blank" href="https://www.youtube.com/watch?v=hCOQhfeDwdE" title="Acessar link"> https://www.youtube.com/watch?v=hCOQhfeDwdE </a> </p><p> * Dicas e Macetes (Alan Glei): <a target="_blank" href="https://www.youtube.com/watch?v=cNI3mUN6TUA" title="Acessar link"> https://www.youtube.com/watch?v=cNI3mUN6TUA </a> </p><p> * Melhores Praticas, Dicas e Truques (Alan Glei): <a target="_blank" href="https://www.youtube.com/watch?v=hmVfSa8g8E8" title="Acessar link"> https://www.youtube.com/watch?v=hmVfSa8g8E8 </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="114 - ZeosLib"> <b> ZeosLib </b> </span> </td>
          <td> <a target="_blank" href="#" title="Acessar link"> Não informado </a> </td>
          <td> <a target="_blank" href="https://sourceforge.net/projects/zeoslib/" title="Acessar link"> https://sourceforge.net/projects/zeoslib/ </a> </td>
          <td> 
            <img alt="" height="20" src="" title=""/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/ok.png" title="Sim" alt="Sim" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> O ZeosLib é um conjunto de componentes de banco de dados para MySQL, MariaDB, PostgreSQL, Interbase, Firebird, MS SQL Server, SAP Adaptive Server Enterprise e Adaptive Server Anywhere (anteriormente Sybase), Oracle e SQLite para Delphi, FreePascal/Lazarus e C++ Builder.<br/><p> * GitHub (cópia do repositório oficial atualizado uma vez por dia): <a target="_blank" href="https://github.com/marsupilami79/zeoslib" title="Acessar link"> https://github.com/marsupilami79/zeoslib </a> </p><p> * Como instalar: <a target="_blank" href="https://showdelphi.com.br/como-instalar-o-zeoslib-no-delphi-e-onde-baixar/" title="Acessar link"> https://showdelphi.com.br/como-instalar-o-zeoslib-no-delphi-e-onde-baixar/ </a> </p>            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>         <tr> 
          <td> <span title="117 - UniDac"> <b> UniDac </b> </span> </td>
          <td> <a target="_blank" href="https://www.devart.com/" title="Acessar link"> Devart </a> </td>
          <td> <a target="_blank" href="https://www.devart.com/unidac/" title="Acessar link"> https://www.devart.com/unidac/ </a> </td>
          <td> 
            <img alt="República Tcheca" height="20" src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/Bandeiras/republica-tcheca.png" title="República Tcheca"/> 
          </td>
          <td> 
            <img src="https://github.com/Code4Delphi/utilitarios/blob/master/Img/no.png" title="N&atilde;o" alt="N&atilde;o" /> 
          </td>
        </tr>
        <tr>
          <td colspan="5"> Universal Data Access Components (UniDAC) é uma biblioteca de componentes que fornece acesso direto a vários bancos de dados do Delphi e C++Builder, incluindo Community Edition, bem como Lazarus (e Free Pascal) no Windows, Linux, macOS, iOS e Android para plataformas de 32 bits e 64 bits.            
          </td>
        </tr>
        <tr>
          <td colspan="5">  &nbsp; </td>
        </tr>  
    </tbody>
  </table>   
