#  Code4D-Wizard - Wizard for Delphi IDE
<p align="center">
  <a href="https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/C4D-Logo.png">
    <img alt="Code4Delphi" height="100" src="https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/c4d-logo-100x100.png">
  </a>  
</p>
Code4D-Wizard is a wizard/plugin designed to be used in the Delphi IDE. It adds to the Delphi IDE several features and functionality to improve development efficiency, speed and productivity. This Wizard was developed using OTA (Open Tools API)

# 📞 Contacts

<p align="left">
  <a href="https://t.me/Code4Delphi" target="_blank">
    <img src="https://img.shields.io/badge/Telegram-Join%20Channel-blue?logo=telegram">
  </a> 
  &nbsp;
  <a href="https://www.youtube.com/@code4delphi" target="_blank">
    <img src="https://img.shields.io/badge/YouTube-Join%20Channel-red?logo=youtube&logoColor=red">
  </a>
  &nbsp;
  <a href="https://www.linkedin.com/in/cesar-cardoso-dev" target="_blank">
    <img src="https://img.shields.io/badge/LinkedIn-Follow-blue?logo=LinkedIn&logoColor=blue">
  </a>  
  &nbsp;
  <a href="https://go.hotmart.com/U81331747Y?dp=1" target="_blank">
    <img src="https://img.shields.io/badge/Course-Open%20Tools%20API-F00?logo=delphi">
  </a>   
  &nbsp;
  <a href="mailto:contato@code4delphi.com.br" target="_blank">
    <img src="https://img.shields.io/badge/E--mail-Send-yellowgreen?logo=maildotru&logoColor=yellowgreen">
  </a>
</p>

## ⚙️ Installation

1 - Download Code4D-Wizard. You can download the .zip file or clone the project on your PC.

![image](https://github.com/user-attachments/assets/bb8df3a1-49a1-463c-8445-4c5325398c0e)

2 - In your Delphi, access the menu File > Open and select the file: Package/C4DWizard.dpk

![image](https://github.com/user-attachments/assets/2e2f606a-441d-4d5b-8aae-75a3b7255f77)

3 - Right-click on the project name and select "Install"

![image](https://github.com/user-attachments/assets/792ce355-d39f-4835-a117-fe441253f167)

4 - The Code4D item will be added to the IDE's MainMenu

![Code4D-item-added-to-MainMenu.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Code4D-item-added-to-MainMenu.png)

<br/>

# 👨‍🎓 Treinamento completo sobre OTA / Complete OTA training
[**Acessar treinamento / Access training**](https://hotmart.com/pt-br/marketplace/produtos/delphi-ota-open-tools-api/U81331747Y)

<br/>‌

# 🔎 Preview resources Code4D-Wizard

### * Menus add in MainMenu IDE

![Menus-Add-in-MainMenu-IDE-Delphi.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Menus-Add-in-MainMenu-IDE-Delphi.png)

- **Open External Path**: Lets you add items for quick access to resources external to the IDE. How to access files, folders, web links and even CMD commands to perform one or more functions in Windows CMD. Can be configured shortcut keys, and even a logo for each item
  ![Open-External.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Open-External.png)
- **Uses Organization**: Allows you to organize the Uses of the Units, with various configurations, such as the possibility of leaving one Uses per line, sorting uses in alphabetical order, grouping uses by namespaces, breaking lines between namespaces. In addition to making it possible to organize by scope, that is, by the current unit, by open units, project group or project units, and showing a Log with the Units that were orphaned.

  ![Uses-Organization.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Uses-Organization.png)
- **Reopen File History**: Opens a screen, where a history is listed, with all project groups and projects previously opened in the IDE. Enabling the marking of project group or projects as favorites, so that they are shown in prominence. Various information is also presented, such as the date of the last opening and closing, and the possibility of creating a nickname for the item. It is also possible to separate by groups, and search by different filters, including opening dates. On this screen, it is also possible to access various resources of the projects or project group, such as automatically opening the Github Desktop with the project already selected, opening the project in the remote repository, opening the project file in the Windows explorer, among many other resources.
  ![Reopen.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Reopen.png)
- **Translate Text**: Allows texts to be translated between several languages, WITHOUT using any credentials or passwords. If you have any text selected in the IDE's editor at the time the screen is called, the selected text will be loaded onto the screen for translation.
  ![Translate.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Translate.png)
- **Indent Text Selected**: This feature serves to indent the selected code, taking into account some characters, such as := (two equal points), this feature will indent the fonts, aligning the := (two equal points)
- **Find in Files**: Searches the units, with several configuration options, and can search not only in .pas files but also in .dfm, . fmx and in .dpr and .dproj. Another interesting point is that when displaying the search result, it marks the words found in green to make identification easier, in addition to showing a totalizer with the number of occurrences of the searched text and the number of files that have them.
  ![Find-in-files.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Find-in-files.png)

  ![Find-in-files-Messages.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Find-in-files-Messages.png)

- **Replace in Files**: Makes the alteration of texts in the units, with several option of configurations, and it can make the replace not only in .pas files but also in .dfm, . fmx and in .dpr and .dproj. Another interesting point is that when displaying the result of the changes, it shows a totalizer with the number of occurrences of the text changed and the number of files that have them.
  ![Replace-in-files.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Replace-in-files.png)
- **Default Files In Opening Project**: This feature allows you to inform which units or forms are automatically opened as soon as the project is opened in the IDE.
  ![Default-Files-In-Opening-Project.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Default-Files-In-Opening-Project.png)
- **Settings**: It has some settings related to the Wizard, such as the possibility of informing shortcuts for MainMenu items.

  With the option "**Before compiling, check if binary is not running**" checked, always before compiling or building the project, it will be checked if it is not already running, if so, a question will be displayed alerting that the program be closed beforehand, so as not to waste time waiting for the compilation without being able to finish it.
  
  With the option "**Block the INSERT Key**" checked, it will not be possible to press the "Insert" key on the keyboard, thus not allowing the IDE to switch between "Insert" and "Overwrite", preventing the "Overwrite" feature from being unintentionally enabled.
  
  The "**Open Data Folder**" button, opens in the Windows explorer, the folder where the files used by the Code4D-Wizard are created and stored.  
  ![Settings.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Settings.png)
- **Backup/Restore Configs**: Allows you to export and import backup files with the Code4D-Wizard settings and data, so when you format your PC you don't ask for your data. In addition to enabling data sharing among other programmers on your team.
  ![Backup.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/Backup.png)
- **Open in GitHub Desktop**: Allows opening the current project directly on Github Desktop, with the project already open. It is possible to open it in other version management programs, just use the resources available in the Open External Path menu item
- **View in Remote Repository**: Opens the remote repository of the Git project in the browser, it can be GitHub, Bitbucket, GitLab, etc.
- **View Information Remote Repository**: Displays remote repository information of the project
- **View Project File in Explorer**: Opens the current project file in Windows Explorer
- **View Current File in Explorer**: Opens the current file, which is open in the IDE in Windows Explorer
- **View Current Binary in Explorer**: Opens the binary file (.exe) in Windows Explorer, also works for Linux compilation and DLL

‌

### * PopupMenu do Project Manager

![PopupMenu-Project-Manager.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/PopupMenu-Project-Manager.png)

‌

### * ToolBars

![ToolBars.png](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/Images/ToolBars.png)

#### **ToolBar Build:**

- Button **Build Project In Release**: Executes the Build of the selected project, with several checks and improvements. Before giving the Build, it checks if the project's .exe is not already open, if it is, it gives a message for it to be closed first. It also automatically changes the project from Debug to Release, and after the Build is finished, it returns to Debug if necessary.
- It is also possible to change the Build Configurations directly through the ComboBox of the ToolBar too, you can change it to Debug or Release

#### **ToolBar Branch:**

- In this ToolBar it is possible to visualize the current Git branch that the project is in. If you are in Branch Master or Main, the text will turn red, alerting the programmer to change the Branch.


‌
# 💬 Contributions / Ideas / Bug Fixes
To submit a pull request, follow these steps:

1. Fork the project
2. Create a new branch (`git checkout -b minha-nova-funcionalidade`)
3. Make your changes
4. Make the commit (`git commit -am 'Functionality or adjustment message'`)
5. Push the branch (`git push origin Message about functionality or adjustment`)
6. Open a pull request


## ⚠️ License
`Code4D-Wizard` is free and open-source wizard licensed under the [MIT License](https://github.com/Code4Delphi/Code4D-Wizard/blob/master/LICENSE).
