export const chunkArray = <T>(arr: T[], chunkSize: number) =>
    arr.reduce((chunks, elem, index) => {
        const chunkIndex = Math.floor(index / chunkSize)
        const chunk = chunks[chunkIndex] || []
        // eslint-disable-next-line no-param-reassign
        chunks[chunkIndex] = chunk.concat([elem])
        return chunks
    }, [] as T[][])
