
<img src="static/openai.png" width="130px" align="right" />

# openai-toolbox [![Awesome](https://cdn.jsdelivr.net/gh/sindresorhus/awesome@d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome#readme)

一个收集各种 OpenAI 工具和资源的仓库，帮助开发者更方便地使用 OpenAI 的技术和服务。
<br><br>

### OpenAI 官方链接

| 名称 | 描述 |
| --- | --- |
| [Overview](https://platform.openai.com/overview) | OpenAI 开发者预览页 |
| [Usage](https://platform.openai.com/account/usage) | 个人账户 API 用量统计 |
| [Cookbook](https://github.com/openai/openai-cookbook) | 使用 OpenAI API 的示例 |
| [Pricing](https://openai.com/pricing) | OpenAI 所有模型收费价格预览 |
| [Tokenizer](https://platform.openai.com/tokenizer) | GPT 系列模型使用的标记文本分词器 |


### GPT系列 - 面向开发者

| 名称 | 描述 |
| --- | --- |
| [Cursor](https://www.cursor.so/) | 专为使用 AI 编程而构建的编辑器，帮助编写、编辑和讨论您的代码 |
| [GPT-Commit](https://github.com/zurawiki/gptcommit) | 一个可以帮助你生成Commit Message的工具 |
| [ChatGPT-CodeReview](https://github.com/anc95/ChatGPT-CodeReview) | 由 ChatGPT 提供支持的代码审查机器人 |
| [Shell_GPT](https://github.com/TheR1D/shell_gpt) | 由 ChatGPT 提供支持的命令行生产力工具，将帮助您更快、更高效地完成任务 |
| [GPT-Cli](https://www.gptcli.com/) | 多功能 ChatGPT 命令行工具，内置 Commit、Command、Translate |
| [AI-Code-Translator](https://github.com/feseeker/ai-code-translator) | 使用 AI 将代码从一种语言翻译成另一种语言 |
| [AI-Code-Doctor](https://github.com/CharleeWa/ai-code-doctor) | 让AI成为你的代码医生，快速解决错误信息 |
| [ChatGPT-Next-Web](https://github.com/Yidadaa/ChatGPT-Next-Web) | 一键拥有你自己的 ChatGPT 网页服务，拥有精美的界面 |
| [Openai-PR-Reviewer](https://github.com/fluxninja/openai-pr-reviewer) | 一个基于 ChatGPT 的 GitHub PR Reviewer |
| [Wolverine](https://github.com/biobootloader/wolverine) | GPT4 驱动的项目，展示了如何让 AI 来持续的运行脚本 |
| [Chatbot-UI](https://github.com/mckaywrigley/chatbot-ui) | 一个开源的ChatGPT用户界面 |
| [Feishu-OpenAI](https://github.com/ConnectAI-E/Feishu-OpenAI) | 飞书 ×（GPT-3.5 + DALL·E + Whisper）= 飞一般的工作体验 |
| [Chatgpt-Web](https://github.com/Chanzhaoyu/chatgpt-web) | 用 Express 和 Vue3 搭建的 ChatGPT 演示网页 |
| [AI-Shell](https://github.com/BuilderIO/ai-shell) | 将自然语言转换为 shell 命令的 CLI |
| [RustChat](https://github.com/ZhangHanDong/rustchat) | 用 ChatGPT 打造最强 Rust 辅助学习“魔法”系统 |
| [AutoPR](https://github.com/irgolic/AutoPR) | 一个 Github Action，可以自动编写拉取请求以响应问题 |
| [ChatChat](https://github.com/okisdev/ChatChat) | 解锁你的下一级 AI 对话体验。支持 OpenAI、微软 Azure、Claude、Cohere等多个 API |
| [PrivateGPT](https://github.com/imartinez/privateGPT) | 使用 GPT 的强大功能与您的文档进行私密交互，100% 私密，无数据泄露 |
| [LangChain](https://github.com/hwchase17/langchain) | 通过可组合性使用 LLM 构建应用程序 |
| [ChatGPT-WeChat](https://github.com/zhayujie/chatgpt-on-wechat) | 使用 ChatGPT 搭建微信聊天机器人 |
| [LangChain-ChatGLM](https://github.com/imClumsyPanda/langchain-ChatGLM) | 基于本地知识库的 ChatGLM 问答 |
| [GitHub-Copilot](https://github.com/features/copilot) | GitHub 官方推出的基于 GPT 模型的代码助手 |
| [Pandora](https://github.com/pengzhile/pandora) | 潘多拉 (Pandora)，实现了网页版 ChatGPT 的主要操作，绕过 Cloudflare，速度喜人 |
| [ChatBox](https://github.com/Bin-Huang/chatbox) | 开源的 ChatGPT API (OpenAI API) 桌面客户端，Prompt 的调试与管理工具 |
| [GPTEngineer](https://github.com/AntonOsika/gpt-engineer) | 一个提示词生成代码库，几分钟内完成一个编码项目 |
| [SweepAI](https://github.com/sweepai/sweep) | 一款 Github App，可以将 bug 报告和功能请求转换为代码更改 |


### GPT系列 - 产品应用

| 名称 | 描述 |
| --- | --- |
| [OpenAI-Translator](https://github.com/yetone/openai-translator) | 基于 ChatGPT API 的划词翻译浏览器插件和跨平台桌面端应用 |
| [CopilotHub](https://app.copilothub.co/) | 基于 ChatGPT 创建个人的知识库平台 |
| [ChatPDF](https://www.chatpdf.com/) | 一个学习神器，上传PDF文件后，可以对它提问任何关于这份PDF的问题 |
| [ChatPaper](https://github.com/kaixindelele/ChatPaper) | 利用chatgpt进行论文总结+润色+审稿+审稿回复 |
| [ChatDoc](https://chatdoc.com/) | 基于 ChatGPT 的文件阅读助手，可以 从 PDF 中快速提取、定位和汇总信息 |
| [PandaGPT](https://www.pandagpt.io/) | 另一个工具，上传PDF文件后，可以对它提问任何关于这份PDF的问题 |
| [MacGPT](https://www.macgpt.com/) | ChatGPT 桌面客户端，支持API key 和 Web UI 两种模式随意切换 |
| [TypingMind](https://www.typingmind.com/) | 更好的 ChatGPT 用户界面, 支持网络搜索和实时数据 |
| [ChatWebpage](https://chatwebpage.com/) | 与任何网页聊天，提问关于网页的任何问题 |
| [ChatBase](https://www.chatbase.co/) | 为您的网站定制 ChatGPT，让您的网站更加智能 |
| [WebscrapeAi](https://webscrapeai.com/) | 无代码抓取网站 |
| [60sec.site](https://60sec.site/) | 用ai在60秒内生成漂亮的着陆页 |
| [Polyglot](https://github.com/liou666/polyglot) | 桌面端AI语言练习应用 |
| [GodMode](https://godmode.space/) | 一款类AutoGPT的Web UI实现，需要自带Key |
| [BookAI](https://www.bookai.chat/) | 可以自己添加书籍，问任何书里的内容 |
| [Gamma](https://gamma.app/) | 一个演示文稿生成平台，再也无需手工从零开始做PPT |


### GPT系列 - 行业应用

| 名称 | 描述 |
| --- | --- |
| [Law-CN-AI](https://github.com/lvwzhen/law-cn-ai) | AI 法律助手，项目开源，可自行部署 |
| [FinChat](https://finchat.io/) | 金融领域的 ChatGPT，非常方便看上市公司的财务分析 |


### 提示词工程

| 名称 | 描述 |
| --- | --- |
| [PromptHero](https://prompthero.com/) | Prompts 网站，适用于 ChatGPT、Midjourney、Stable Diffusion |
| [Awesome-ChatGPT-Prompts](https://prompts.chat/) | 用于 ChatGPT 模型的提示示例, 获得更好的交流体验 |
| [Awesome-ChatGPT-Prompts-ZH](https://chatguide.plexpt.com/) | 用于 ChatGPT 模型的提示示例中文指南 |
| [ChatGPT-Shortcut](https://newzone.top/chatgpt/) | 让生产力加倍的 ChatGPT 快捷指令 |
| [OpenPrompt](https://openprompt.co/) | 创建、分享和使用他人的Prompt |
| [Learning-Prompt](https://learningprompt.wiki/) | 免费 Prompt Engineering 教程 |
| [Prompt-Engineering-Guide](https://github.com/dair-ai/Prompt-Engineering-Guide) | 提示词工程指南，帮助行业相关人员了解提示词工程 |
| [LearnPrompting](https://learnprompting.org/) | 免费的提示工程课程，学习如何同AI交流，并得到你要的结果 |
| [SnackPrompt](https://snackprompt.com/) | Prompt界的Github, 可以创建分享自己的Prompt, 按周、月看热门Prompt |
| [Prompt-Engineering-Note](https://islinxu.github.io/prompt-engineering-note/) | 面向开发者的ChatGPT提问工程学习笔记 |
| [ChatGPT-Prompt-Engineering](https://github.com/GitHubDaily/ChatGPT-Prompt-Engineering-for-Developers-in-Chinese) | 吴恩达与 OpenAI 联手推出的一门面向开发者的技术教程，含中英双语字幕 |
| [Prompt-Engineering](https://github.com/brexhq/prompt-engineering) | 使用大型语言模型（如 OpenAI 的 GPT-4）的提示和技巧 |


### AI 绘图

| 名称 | 描述 |
| --- | --- |
| [Scribble Diffusion](https://scribblediffusion.com/) | 使用 AI 将粗略的草图变成精致的图像 |
| [DALL·E 2](https://labs.openai.com/) | OpenAI 官方 DALL·E 2模型，可以根据自然语言的描述创建逼真的图像和艺术作品 |
| [MochiDiffusion](https://github.com/godly-devotion/MochiDiffusion) | 在 Mac 上本地运行Stable Diffusion |
| [Ml-Stable-Diffusion](https://github.com/apple/ml-stable-diffusion) | 在Apple Silicon上使用 Core ML 运行 Stable Diffusion |
| [Stable Diffusion Web UI](https://github.com/AUTOMATIC1111/stable-diffusion-webui) | Stable Diffusion Web 界面 |
| [MidJourney](https://www.midjourney.com/) | 一款搭载在discord上的AI绘画聊天机器人 |


### LLMs & 模型训练

| 名称 | 描述 |
| --- | --- |
| [Bot-Studio](https://github.com/Privoce/Bot-Studio) | OpenAI 的模型调试工具，带有聊天 UI 的模型仪表板 |
| [Text2vec](https://github.com/shibing624/text2vec) | 文本向量表征工具，把文本转化为向量矩阵，实现相似检索，开箱即用 |
| [GPT4-All](https://github.com/nomic-ai/gpt4all)  | 一个由开源聊天机器人组成的生态系统，接受大量干净的助手数据的训练，包括代码、故事和对话 |
| [DeepSpeed](https://github.com/microsoft/DeepSpeed) | 一键式RLHF训练，让你的类ChatGPT千亿大模型提速省钱15倍 |
| [LawGPT](https://github.com/pengxiao-song/LawGPT) | 中文法律知识的大语言模型，适合用于司法考试 |


### ChatGPT 插件

| 名称 | 描述 |
| --- | --- |
| [ChatGPT-Retrieval-Plugin](https://github.com/openai/chatgpt-retrieval-plugin) | OpenAI 开源的资料托管的插件，构建私有聊天场景 |
| [ChatGPT-Plugins-Collection](https://github.com/logankilpatrick/ChatGPT-Plugins-Collection) | 非官方 ChatGPT 多种编程语言的插件示例 |
| [ChatGPT-Plugin-TS](https://github.com/transitive-bullshit/chatgpt-plugin-ts) | 在 JS/TS 中开始构建 ChatGPT 插件所需的一切 |


### ChatGPT 生态

| 名称 | 描述 |
| --- | --- |
| [Chatgpt-Backup](https://github.com/abacaj/chatgpt-backup) | ChatGPT 的备份工具，可以备份聊天记录 |
| [Auto-GPT](https://github.com/Torantulino/Auto-GPT) | 一个实验性的基于GPT-4驱动的应用程序，可能是世界上第一个AGI |
| [ChatGPT](https://github.com/acheong08/ChatGPT) | ChatGPT的逆向工程API。可扩展用于 Chatbot 等 |
| [Window.AI](https://windowai.io/) | 在网页上使用您自己的 AI 模型 |
| [FreeOpenAI](https://freeopenai.xyz/) | 这里有些免费的OpenAI Key, 大家可测试使用 |
| [Gravatar](https://en.gravatar.com/) | 一个全球通用头像服务，可以在ChatGPT网站上使用 |
| [AgentGPT](https://agentgpt.reworkd.ai/) | 在浏览器中组装、配置和部署自主AI代理 |
| [Cognosys.AI](https://www.cognosys.ai/) | 触手可及的 AI 代理 |
| [KeepChatGPT](https://github.com/xcanwin/KeepChatGPT) | 使用ChatGPT更顺畅，解决ChatGPT网络错误 |
| [GPTZero](https://gptzero.me/) | 检测内容是否由 ChatGPT 生成 |
| [Talk-to-ChatGPT](https://github.com/C-Nedelcu/talk-to-chatgpt) | 一款 Chrome 和 Edge 的扩展，使用您的语音与ChatGPT 进行对话，并通过语音听取回答 |
| [PromptBoost](https://promptboost.streamlit.app/) | 使用 ChatGPT 将一个简单的 Prompt 优化为一个更好的 Prompt |
| [ChatALL](https://github.com/sunner/ChatALL) | 同时与所有 AI 机器人聊天，找到最佳答案 |
| [ShareGPT](https://github.com/domeccleston/sharegpt) | 一个开源的 Chrome 扩展程序，用于分享您与 ChatGPT 的对话 |
| [Fabric](https://github.com/danielmiessler/fabric) | Fabric 是一个开源框架，用于使用 AI 增强人类的能力 |

<br>

OP: 有什么好的想法或者建议，欢迎提交议题。
