import React, { Component } from "react";
import defaultProps from "../defaultProps";
import defaultPropTypes from "../defaultPropTypes";
import pick from "lodash.pick";
import xor from "lodash.xor";
import omit from "lodash.omit";

const pickProperties = ["width", "height", "fillClassName"];
const excludeProperties = xor(Object.keys(defaultProps), pickProperties);

const DEFAULT_PROPS = pick(defaultProps, pickProperties);

const DEFAULT_PROPTYPES = pick(defaultPropTypes, pickProperties);

export default class Code extends Component {
  static defaultProps = DEFAULT_PROPS;
  static propTypes = DEFAULT_PROPTYPES;

  render() {
    const { fillClassName, ...rest } = omit(this.props, excludeProperties);

    return (
      <svg {...rest} viewBox="0 0 18 18">
        <path
          className={fillClassName}
          d="M15.7455357,3.81696429 C15.9330357,4.00446429 16.09375,4.25892857 16.2276786,4.58035714 C16.3616071,4.90178571 16.4285714,5.19642857 16.4285714,5.46428571 L16.4285714,17.0357143 C16.4285714,17.3035714 16.3348214,17.53125 16.1473214,17.71875 C15.9598214,17.90625 15.7321429,18 15.4642857,18 L1.96428571,18 C1.69642857,18 1.46875,17.90625 1.28125,17.71875 C1.09375,17.53125 1,17.3035714 1,17.0357143 L1,0.964285714 C1,0.696428571 1.09375,0.46875 1.28125,0.28125 C1.46875,0.09375 1.69642857,0 1.96428571,0 L10.9642857,0 C11.2321429,0 11.5267857,0.0669642857 11.8482143,0.200892857 C12.1696429,0.334821429 12.4241071,0.495535714 12.6116071,0.683035714 L15.7455357,3.81696429 Z M11.2857143,1.36607143 L11.2857143,5.14285714 L15.0625,5.14285714 C14.9955357,4.94866071 14.921875,4.81138393 14.8415179,4.73102679 L11.6975446,1.58705357 C11.6171875,1.50669643 11.4799107,1.43303571 11.2857143,1.36607143 Z M15.1428571,16.7142857 L15.1428571,6.42857143 L10.9642857,6.42857143 C10.6964286,6.42857143 10.46875,6.33482143 10.28125,6.14732143 C10.09375,5.95982143 10,5.73214286 10,5.46428571 L10,1.28571429 L2.28571429,1.28571429 L2.28571429,16.7142857 L15.1428571,16.7142857 Z M5.82142857,7.71428571 C5.875,7.640625 5.9453125,7.59877232 6.03236607,7.58872768 C6.11941964,7.57868304 6.19977679,7.60044643 6.2734375,7.65401786 L6.78571429,8.03571429 C6.859375,8.08928571 6.90122768,8.15959821 6.91127232,8.24665179 C6.92131696,8.33370536 6.89955357,8.4140625 6.84598214,8.48772321 L5.01785714,10.9285714 L6.84598214,13.3694196 C6.89955357,13.4430804 6.92131696,13.5234375 6.91127232,13.6104911 C6.90122768,13.6975446 6.859375,13.7678571 6.78571429,13.8214286 L6.2734375,14.203125 C6.19977679,14.2566964 6.11941964,14.2784598 6.03236607,14.2684152 C5.9453125,14.2583705 5.875,14.2165179 5.82142857,14.1428571 L3.55133929,11.1194196 C3.45758929,10.9921875 3.45758929,10.8649554 3.55133929,10.7377232 L5.82142857,7.71428571 Z M13.8772321,10.7377232 C13.9709821,10.8649554 13.9709821,10.9921875 13.8772321,11.1194196 L11.6071429,14.1428571 C11.5535714,14.2165179 11.4832589,14.2583705 11.3962054,14.2684152 C11.3091518,14.2784598 11.2287946,14.2566964 11.1551339,14.203125 L10.6428571,13.8214286 C10.5691964,13.7678571 10.5273438,13.6975446 10.5172991,13.6104911 C10.5072545,13.5234375 10.5290179,13.4430804 10.5825893,13.3694196 L12.4107143,10.9285714 L10.5825893,8.48772321 C10.5290179,8.4140625 10.5072545,8.33370536 10.5172991,8.24665179 C10.5273438,8.15959821 10.5691964,8.08928571 10.6428571,8.03571429 L11.1551339,7.65401786 C11.2287946,7.60044643 11.3091518,7.57868304 11.3962054,7.58872768 C11.4832589,7.59877232 11.5535714,7.640625 11.6071429,7.71428571 L13.8772321,10.7377232 Z M7.64955357,15.3683036 C7.5625,15.3549107 7.49386161,15.3113839 7.44363839,15.2377232 C7.39341518,15.1640625 7.375,15.0837054 7.38839286,14.9966518 L8.77455357,6.64955357 C8.78794643,6.5625 8.83147321,6.49386161 8.90513393,6.44363839 C8.97879464,6.39341518 9.05915179,6.375 9.14620536,6.38839286 L9.77901786,6.48883929 C9.86607143,6.50223214 9.93470982,6.54575893 9.98493304,6.61941964 C10.0351562,6.69308036 10.0535714,6.7734375 10.0401786,6.86049107 L8.65401786,15.2075893 C8.640625,15.2946429 8.59709821,15.3632813 8.5234375,15.4135045 C8.44977679,15.4637277 8.36941964,15.4821429 8.28236607,15.46875 L7.64955357,15.3683036 Z"
        />
      </svg>
    );
  }
}
