/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.webrtc.GlGenericDrawer;
import org.webrtc.GlShader;
import org.webrtc.GlTextureFrameBuffer;
import org.webrtc.GlUtil;
import org.webrtc.JavaI420Buffer;
import org.webrtc.JniCommon;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc._$;

public class YuvConverter {
    private static final String FRAGMENT_SHADER = "uniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      sample(tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      sample(tc + 1.5 * xUnit).rgb);\n}\n";
    private final GlGenericDrawer drawer;
    private final GlTextureFrameBuffer i420TextureFrameBuffer;
    private final ShaderCallbacks shaderCallbacks;
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final VideoFrameDrawer videoFrameDrawer;

    public YuvConverter() {
        this(new VideoFrameDrawer());
    }

    public YuvConverter(VideoFrameDrawer videoFrameDrawer) {
        this.i420TextureFrameBuffer = new GlTextureFrameBuffer(6408);
        this.shaderCallbacks = new ShaderCallbacks();
        this.drawer = new GlGenericDrawer(FRAGMENT_SHADER, this.shaderCallbacks);
        this.videoFrameDrawer = videoFrameDrawer;
        this.threadChecker.detachThread();
    }

    static /* synthetic */ void lambda$convert$0(ByteBuffer byteBuffer) {
        JniCommon.nativeFreeByteBuffer(byteBuffer);
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer textureBuffer) {
        this.threadChecker.checkIsOnValidThread();
        textureBuffer = (VideoFrame.TextureBuffer)this.videoFrameDrawer.prepareBufferForViewportSize(textureBuffer, textureBuffer.getWidth(), textureBuffer.getHeight());
        int n2 = textureBuffer.getWidth();
        int n3 = textureBuffer.getHeight();
        int n4 = (n2 + 7) / 8 * 8;
        int n5 = (n3 + 1) / 2;
        int n6 = n3 + n5;
        ByteBuffer byteBuffer = JniCommon.nativeAllocateByteBuffer(n4 * n6);
        int n7 = n4 / 4;
        Object object = new Matrix();
        object.preTranslate(0.5f, 0.5f);
        object.preScale(1.0f, -1.0f);
        object.preTranslate(-0.5f, -0.5f);
        this.i420TextureFrameBuffer.setSize(n7, n6);
        GLES20.glBindFramebuffer((int)36160, (int)this.i420TextureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        this.shaderCallbacks.setPlaneY();
        VideoFrameDrawer.drawTexture(this.drawer, textureBuffer, object, n2, n3, 0, 0, n7, n3);
        this.shaderCallbacks.setPlaneU();
        Object object2 = this.drawer;
        VideoFrameDrawer.drawTexture((RendererCommon.GlDrawer)object2, textureBuffer, object, n2, n3, 0, n3, n7 /= 2, n5);
        this.shaderCallbacks.setPlaneV();
        VideoFrameDrawer.drawTexture(this.drawer, textureBuffer, object, n2, n3, n7, n3, n7, n5);
        GLES20.glReadPixels((int)0, (int)0, (int)this.i420TextureFrameBuffer.getWidth(), (int)this.i420TextureFrameBuffer.getHeight(), (int)6408, (int)5121, (Buffer)byteBuffer);
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        n6 = n4 * n3 + 0;
        int n8 = n4 / 2;
        n7 = n6 + n8;
        byteBuffer.position(0);
        byteBuffer.limit(n6);
        object = byteBuffer.slice();
        byteBuffer.position(n6);
        n5 = (n5 - 1) * n4 + n8;
        byteBuffer.limit(n6 + n5);
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer.position(n7);
        byteBuffer.limit(n7 + n5);
        object2 = byteBuffer.slice();
        textureBuffer.release();
        return JavaI420Buffer.wrap(n2, n3, (ByteBuffer)object, n4, byteBuffer2, n4, (ByteBuffer)object2, n4, (Runnable)new _$.Lambda.YuvConverter.7X4NRtBwZ8S7c3AW7UqovfxQVrk(byteBuffer));
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.drawer.release();
        this.i420TextureFrameBuffer.release();
        this.videoFrameDrawer.release();
        this.threadChecker.detachThread();
    }

    private static class ShaderCallbacks
    implements GlGenericDrawer.ShaderCallbacks {
        private static final float[] uCoeffs;
        private static final float[] vCoeffs;
        private static final float[] yCoeffs;
        private float[] coeffs;
        private int coeffsLoc;
        private float stepSize;
        private int xUnitLoc;

        static {
            yCoeffs = new float[]{0.256788f, 0.504129f, 0.0979059f, 0.0627451f};
            uCoeffs = new float[]{-0.148223f, -0.290993f, 0.439216f, 0.501961f};
            vCoeffs = new float[]{0.439216f, -0.367788f, -0.0714274f, 0.501961f};
        }

        private ShaderCallbacks() {
        }

        @Override
        public void onNewShader(GlShader glShader) {
            this.xUnitLoc = glShader.getUniformLocation("xUnit");
            this.coeffsLoc = glShader.getUniformLocation("coeffs");
        }

        @Override
        public void onPrepareShader(GlShader glShader, float[] fArray, int n2, int n3, int n4, int n5) {
            GLES20.glUniform4fv((int)this.coeffsLoc, (int)1, (float[])this.coeffs, (int)0);
            n3 = this.xUnitLoc;
            float f3 = this.stepSize;
            float f4 = fArray[0];
            float f5 = n2;
            GLES20.glUniform2f((int)n3, (float)(f4 * f3 / f5), (float)(f3 * fArray[1] / f5));
        }

        public void setPlaneU() {
            this.coeffs = uCoeffs;
            this.stepSize = 2.0f;
        }

        public void setPlaneV() {
            this.coeffs = vCoeffs;
            this.stepSize = 2.0f;
        }

        public void setPlaneY() {
            this.coeffs = yCoeffs;
            this.stepSize = 1.0f;
        }
    }
}

