/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.JavaI420Buffer;
import org.webrtc.JniCommon;
import org.webrtc.VideoFrame;

class WrappedNativeI420Buffer
implements VideoFrame.I420Buffer {
    private final ByteBuffer dataU;
    private final ByteBuffer dataV;
    private final ByteBuffer dataY;
    private final int height;
    private final long nativeBuffer;
    private final int strideU;
    private final int strideV;
    private final int strideY;
    private final int width;

    @CalledByNative
    WrappedNativeI420Buffer(int n2, int n3, ByteBuffer byteBuffer, int n4, ByteBuffer byteBuffer2, int n5, ByteBuffer byteBuffer3, int n6, long l3) {
        this.width = n2;
        this.height = n3;
        this.dataY = byteBuffer;
        this.strideY = n4;
        this.dataU = byteBuffer2;
        this.strideU = n5;
        this.dataV = byteBuffer3;
        this.strideV = n6;
        this.nativeBuffer = l3;
        this.retain();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        return JavaI420Buffer.cropAndScaleI420(this, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public ByteBuffer getDataU() {
        return this.dataU.slice();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.dataV.slice();
    }

    @Override
    public ByteBuffer getDataY() {
        return this.dataY.slice();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getStrideU() {
        return this.strideU;
    }

    @Override
    public int getStrideV() {
        return this.strideV;
    }

    @Override
    public int getStrideY() {
        return this.strideY;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void release() {
        JniCommon.nativeReleaseRef(this.nativeBuffer);
    }

    @Override
    public void retain() {
        JniCommon.nativeAddRef(this.nativeBuffer);
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        this.retain();
        return this;
    }
}

