/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.IdentityHashMap;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoSink;

public class VideoTrack
extends MediaStreamTrack {
    private final IdentityHashMap<VideoSink, Long> sinks = new IdentityHashMap();

    public VideoTrack(long l3) {
        super(l3);
    }

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeFreeSink(long var0);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(VideoSink var0);

    public void addSink(VideoSink videoSink) {
        if (videoSink != null) {
            if (!this.sinks.containsKey(videoSink)) {
                long l3 = VideoTrack.nativeWrapSink(videoSink);
                this.sinks.put(videoSink, l3);
                VideoTrack.nativeAddSink(this.getNativeMediaStreamTrack(), l3);
            }
            return;
        }
        throw new IllegalArgumentException("The VideoSink is not allowed to be null");
    }

    @Override
    public void dispose() {
        for (long l3 : this.sinks.values()) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), l3);
            VideoTrack.nativeFreeSink(l3);
        }
        this.sinks.clear();
        super.dispose();
    }

    long getNativeVideoTrack() {
        return this.getNativeMediaStreamTrack();
    }

    public void removeSink(VideoSink object) {
        if ((object = this.sinks.remove(object)) != null) {
            VideoTrack.nativeRemoveSink(this.getNativeMediaStreamTrack(), (Long)object);
            VideoTrack.nativeFreeSink((Long)object);
        }
    }
}

