/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.Objects;
import org.webrtc.CapturerObserver;
import org.webrtc.MediaSource;
import org.webrtc.NativeAndroidVideoTrackSource;
import org.webrtc.VideoFrame;
import org.webrtc.VideoProcessor;
import org.webrtc.VideoProcessor$_CC;
import org.webrtc.VideoSink;
import org.webrtc._$;

public class VideoSource
extends MediaSource {
    private final CapturerObserver capturerObserver;
    private boolean isCapturerRunning;
    private final NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource;
    private VideoProcessor videoProcessor;
    private final Object videoProcessorLock = new Object();

    public VideoSource(long l3) {
        super(l3);
        this.capturerObserver = new CapturerObserver(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onCapturerStarted(boolean bl) {
                VideoSource.this.nativeAndroidVideoTrackSource.setState(bl);
                Object object = VideoSource.this.videoProcessorLock;
                synchronized (object) {
                    VideoSource.access$202(VideoSource.this, bl);
                    if (VideoSource.this.videoProcessor != null) {
                        VideoSource.this.videoProcessor.onCapturerStarted(bl);
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onCapturerStopped() {
                VideoSource.this.nativeAndroidVideoTrackSource.setState(false);
                Object object = VideoSource.this.videoProcessorLock;
                synchronized (object) {
                    VideoSource.access$202(VideoSource.this, false);
                    if (VideoSource.this.videoProcessor != null) {
                        VideoSource.this.videoProcessor.onCapturerStopped();
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onFrameCaptured(VideoFrame videoFrame) {
                VideoProcessor.FrameAdaptationParameters frameAdaptationParameters = VideoSource.this.nativeAndroidVideoTrackSource.adaptFrame(videoFrame);
                Object object = VideoSource.this.videoProcessorLock;
                synchronized (object) {
                    if (VideoSource.this.videoProcessor != null) {
                        VideoSource.this.videoProcessor.onFrameCaptured(videoFrame, frameAdaptationParameters);
                        return;
                    }
                }
                videoFrame = VideoProcessor$_CC.applyFrameAdaptationParameters(videoFrame, frameAdaptationParameters);
                if (videoFrame != null) {
                    VideoSource.this.nativeAndroidVideoTrackSource.onFrameCaptured(videoFrame);
                    videoFrame.release();
                }
            }
        };
        this.nativeAndroidVideoTrackSource = new NativeAndroidVideoTrackSource(l3);
    }

    static /* synthetic */ boolean access$202(VideoSource videoSource, boolean bl) {
        videoSource.isCapturerRunning = bl;
        return bl;
    }

    public void adaptOutputFormat(int n2, int n3, int n4) {
        int n5 = Math.max(n2, n3);
        n2 = Math.min(n2, n3);
        this.adaptOutputFormat(n5, n2, n2, n5, n4);
    }

    public void adaptOutputFormat(int n2, int n3, int n4, int n5, int n6) {
        this.adaptOutputFormat(new AspectRatio(n2, n3), (Integer)(n2 * n3), new AspectRatio(n4, n5), (Integer)(n4 * n5), (Integer)n6);
    }

    public void adaptOutputFormat(AspectRatio aspectRatio, Integer n2, AspectRatio aspectRatio2, Integer n3, Integer n4) {
        this.nativeAndroidVideoTrackSource.adaptOutputFormat(aspectRatio, n2, aspectRatio2, n3, n4);
    }

    @Override
    public void dispose() {
        this.setVideoProcessor(null);
        super.dispose();
    }

    public CapturerObserver getCapturerObserver() {
        return this.capturerObserver;
    }

    long getNativeVideoTrackSource() {
        return this.getNativeMediaSource();
    }

    public void setIsScreencast(boolean bl) {
        this.nativeAndroidVideoTrackSource.setIsScreencast(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVideoProcessor(VideoProcessor videoProcessor) {
        Object object = this.videoProcessorLock;
        synchronized (object) {
            if (this.videoProcessor != null) {
                this.videoProcessor.setSink(null);
                if (this.isCapturerRunning) {
                    this.videoProcessor.onCapturerStopped();
                }
            }
            this.videoProcessor = videoProcessor;
            if (videoProcessor != null) {
                NativeAndroidVideoTrackSource nativeAndroidVideoTrackSource = this.nativeAndroidVideoTrackSource;
                Objects.requireNonNull(nativeAndroidVideoTrackSource);
                _$.Lambda.W__serp744uoGj30B4mOwM7vu2I w__serp744uoGj30B4mOwM7vu2I = new _$.Lambda.W__serp744uoGj30B4mOwM7vu2I(nativeAndroidVideoTrackSource);
                videoProcessor.setSink((VideoSink)w__serp744uoGj30B4mOwM7vu2I);
                if (this.isCapturerRunning) {
                    videoProcessor.onCapturerStarted(true);
                }
            }
            return;
        }
    }

    public static class AspectRatio {
        public static final AspectRatio UNDEFINED = new AspectRatio(0, 0);
        public final int height;
        public final int width;

        public AspectRatio(int n2, int n3) {
            this.width = n2;
            this.height = n3;
        }
    }
}

