/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import android.graphics.Point;
import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.webrtc.GlUtil;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.VideoFrame;
import org.webrtc.YuvHelper;

public class VideoFrameDrawer {
    public static final String TAG = "VideoFrameDrawer";
    static final float[] srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private final float[] dstPoints = new float[6];
    private VideoFrame lastI420Frame;
    private int renderHeight;
    private final Matrix renderMatrix;
    private final Point renderSize = new Point();
    private int renderWidth;
    private final YuvUploader yuvUploader = new YuvUploader();

    public VideoFrameDrawer() {
        this.renderMatrix = new Matrix();
    }

    private void calculateTransformedRenderSize(int n2, int n3, Matrix object) {
        if (object == null) {
            this.renderWidth = n2;
            this.renderHeight = n3;
            return;
        }
        object.mapPoints(this.dstPoints, srcPoints);
        for (int i3 = 0; i3 < 3; ++i3) {
            object = this.dstPoints;
            int n4 = i3 * 2;
            int n5 = n4 + 0;
            object[n5] = object[n5] * (float)n2;
            n5 = n4 + 1;
            object[n5] = object[n5] * (float)n3;
        }
        object = this.dstPoints;
        this.renderWidth = VideoFrameDrawer.distance((float)object[0], (float)object[1], (float)object[2], (float)object[3]);
        object = this.dstPoints;
        this.renderHeight = VideoFrameDrawer.distance((float)object[0], (float)object[1], (float)object[4], (float)object[5]);
    }

    private static int distance(float f3, float f4, float f5, float f6) {
        return (int)Math.round(Math.hypot(f5 - f3, f6 - f4));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void drawTexture(RendererCommon.GlDrawer glDrawer, VideoFrame.TextureBuffer textureBuffer, Matrix object, int n2, int n3, int n4, int n5, int n6, int n7) {
        void var8_9;
        void var7_8;
        void var6_7;
        void var5_6;
        void var4_5;
        void var3_4;
        Matrix matrix = new Matrix(textureBuffer.getTransformMatrix());
        matrix.preConcat(object);
        float[] fArray = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(matrix);
        int n8 = 1.$SwitchMap$org$webrtc$VideoFrame$TextureBuffer$Type[textureBuffer.getType().ordinal()];
        if (n8 != 1) {
            if (n8 != 2) throw new RuntimeException("Unknown texture type.");
            glDrawer.drawRgb(textureBuffer.getTextureId(), fArray, (int)var3_4, (int)var4_5, (int)var5_6, (int)var6_7, (int)var7_8, (int)var8_9);
            return;
        } else {
            glDrawer.drawOes(textureBuffer.getTextureId(), fArray, (int)var3_4, (int)var4_5, (int)var5_6, (int)var6_7, (int)var7_8, (int)var8_9);
        }
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer) {
        this.drawFrame(videoFrame, glDrawer, null);
    }

    public void drawFrame(VideoFrame videoFrame, RendererCommon.GlDrawer glDrawer, Matrix matrix) {
        this.drawFrame(videoFrame, glDrawer, matrix, 0, 0, videoFrame.getRotatedWidth(), videoFrame.getRotatedHeight());
    }

    public void drawFrame(VideoFrame object, RendererCommon.GlDrawer glDrawer, Matrix matrix, int n2, int n3, int n4, int n5) {
        this.calculateTransformedRenderSize(((VideoFrame)object).getRotatedWidth(), ((VideoFrame)object).getRotatedHeight(), matrix);
        if (this.renderWidth > 0 && this.renderHeight > 0) {
            boolean bl = ((VideoFrame)object).getBuffer() instanceof VideoFrame.TextureBuffer;
            this.renderMatrix.reset();
            this.renderMatrix.preTranslate(0.5f, 0.5f);
            if (!bl) {
                this.renderMatrix.preScale(1.0f, -1.0f);
            }
            this.renderMatrix.preRotate((float)((VideoFrame)object).getRotation());
            this.renderMatrix.preTranslate(-0.5f, -0.5f);
            if (matrix != null) {
                this.renderMatrix.preConcat(matrix);
            }
            if (bl) {
                this.lastI420Frame = null;
                VideoFrameDrawer.drawTexture(glDrawer, (VideoFrame.TextureBuffer)((VideoFrame)object).getBuffer(), this.renderMatrix, this.renderWidth, this.renderHeight, n2, n3, n4, n5);
            } else {
                if (object != this.lastI420Frame) {
                    this.lastI420Frame = object;
                    object = ((VideoFrame)object).getBuffer().toI420();
                    this.yuvUploader.uploadFromBuffer((VideoFrame.I420Buffer)object);
                    object.release();
                }
                glDrawer.drawYuv(this.yuvUploader.getYuvTextures(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.renderMatrix), this.renderWidth, this.renderHeight, n2, n3, n4, n5);
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Illegal frame size: ");
        ((StringBuilder)object).append(this.renderWidth);
        ((StringBuilder)object).append("x");
        ((StringBuilder)object).append(this.renderHeight);
        Logging.w(TAG, ((StringBuilder)object).toString());
    }

    public VideoFrame.Buffer prepareBufferForViewportSize(VideoFrame.Buffer buffer, int n2, int n3) {
        buffer.retain();
        return buffer;
    }

    public void release() {
        this.yuvUploader.release();
        this.lastI420Frame = null;
    }

    private static class YuvUploader {
        private ByteBuffer copyBuffer;
        private int[] yuvTextures;

        private YuvUploader() {
        }

        public int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public void release() {
            this.copyBuffer = null;
            int[] nArray = this.yuvTextures;
            if (nArray != null) {
                GLES20.glDeleteTextures((int)3, (int[])nArray, (int)0);
                this.yuvTextures = null;
            }
        }

        public int[] uploadFromBuffer(VideoFrame.I420Buffer i420Buffer) {
            int n2 = i420Buffer.getStrideY();
            int n3 = i420Buffer.getStrideU();
            int n4 = i420Buffer.getStrideV();
            ByteBuffer byteBuffer = i420Buffer.getDataY();
            ByteBuffer byteBuffer2 = i420Buffer.getDataU();
            ByteBuffer byteBuffer3 = i420Buffer.getDataV();
            return this.uploadYuvData(i420Buffer.getWidth(), i420Buffer.getHeight(), new int[]{n2, n3, n4}, new ByteBuffer[]{byteBuffer, byteBuffer2, byteBuffer3});
        }

        public int[] uploadYuvData(int n2, int n3, int[] nArray, ByteBuffer[] byteBufferArray) {
            ByteBuffer byteBuffer;
            int[] nArray2 = new int[3];
            int n4 = 0;
            nArray2[0] = n2;
            nArray2[1] = n2 /= 2;
            nArray2[2] = n2;
            n2 = n3 / 2;
            int[] nArray3 = new int[]{n3, n2, n2};
            n3 = 0;
            for (n2 = 0; n2 < 3; ++n2) {
                int n5 = n3;
                if (nArray[n2] > nArray2[n2]) {
                    n5 = Math.max(n3, nArray2[n2] * nArray3[n2]);
                }
                n3 = n5;
            }
            if (n3 > 0 && ((byteBuffer = this.copyBuffer) == null || byteBuffer.capacity() < n3)) {
                this.copyBuffer = ByteBuffer.allocateDirect(n3);
            }
            n3 = n4;
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                n2 = 0;
                while (true) {
                    n3 = n4;
                    if (n2 >= 3) break;
                    this.yuvTextures[n2] = GlUtil.generateTexture(3553);
                    ++n2;
                }
            }
            while (n3 < 3) {
                GLES20.glActiveTexture((int)(33984 + n3));
                GLES20.glBindTexture((int)3553, (int)this.yuvTextures[n3]);
                if (nArray[n3] == nArray2[n3]) {
                    byteBuffer = byteBufferArray[n3];
                } else {
                    YuvHelper.copyPlane(byteBufferArray[n3], nArray[n3], this.copyBuffer, nArray2[n3], nArray2[n3], nArray3[n3]);
                    byteBuffer = this.copyBuffer;
                }
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)nArray2[n3], (int)nArray3[n3], (int)0, (int)6409, (int)5121, (Buffer)byteBuffer);
                ++n3;
            }
            return this.yuvTextures;
        }
    }
}

