/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.RefCounted;

public class VideoFrame
implements RefCounted {
    private final Buffer buffer;
    private final int rotation;
    private final long timestampNs;

    @CalledByNative
    public VideoFrame(Buffer buffer, int n2, long l3) {
        if (buffer != null) {
            if (n2 % 90 == 0) {
                this.buffer = buffer;
                this.rotation = n2;
                this.timestampNs = l3;
                return;
            }
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        throw new IllegalArgumentException("buffer not allowed to be null");
    }

    @CalledByNative
    public Buffer getBuffer() {
        return this.buffer;
    }

    public int getRotatedHeight() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getHeight();
        }
        return this.buffer.getWidth();
    }

    public int getRotatedWidth() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getWidth();
        }
        return this.buffer.getHeight();
    }

    @CalledByNative
    public int getRotation() {
        return this.rotation;
    }

    @CalledByNative
    public long getTimestampNs() {
        return this.timestampNs;
    }

    @Override
    @CalledByNative
    public void release() {
        this.buffer.release();
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    public static interface Buffer
    extends RefCounted {
        @CalledByNative(value="Buffer")
        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);

        @CalledByNative(value="Buffer")
        public int getHeight();

        @CalledByNative(value="Buffer")
        public int getWidth();

        @Override
        @CalledByNative(value="Buffer")
        public void release();

        @Override
        @CalledByNative(value="Buffer")
        public void retain();

        @CalledByNative(value="Buffer")
        public I420Buffer toI420();
    }

    public static interface I420Buffer
    extends Buffer {
        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I420Buffer")
        public int getStrideU();

        @CalledByNative(value="I420Buffer")
        public int getStrideV();

        @CalledByNative(value="I420Buffer")
        public int getStrideY();
    }

    public static interface TextureBuffer
    extends Buffer {
        public int getTextureId();

        public Matrix getTransformMatrix();

        public Type getType();

        public static final class Type
        extends Enum<Type> {
            private static final /* synthetic */ Type[] $VALUES;
            public static final /* enum */ Type OES;
            public static final /* enum */ Type RGB;
            private final int glTarget;

            static {
                Type type;
                OES = new Type(36197);
                RGB = type = new Type(3553);
                $VALUES = new Type[]{OES, type};
            }

            private Type(int n3) {
                this.glTarget = n3;
            }

            public static Type valueOf(String string2) {
                return Enum.valueOf(Type.class, string2);
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public int getGlTarget() {
                return this.glTarget;
            }
        }
    }
}

