/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.os.Handler;
import android.os.HandlerThread;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import org.webrtc.EglBase;
import org.webrtc.EglBase$_CC;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.YuvConverter;
import org.webrtc.YuvHelper;
import org.webrtc._$;

public class VideoFileRenderer
implements VideoSink {
    private static final String TAG = "VideoFileRenderer";
    private EglBase eglBase;
    private final HandlerThread fileThread;
    private final Handler fileThreadHandler;
    private int frameCount;
    private final int outputFileHeight;
    private final String outputFileName;
    private final int outputFileWidth;
    private final ByteBuffer outputFrameBuffer;
    private final int outputFrameSize;
    private final HandlerThread renderThread;
    private final Handler renderThreadHandler;
    private final FileOutputStream videoOutFile;
    private YuvConverter yuvConverter;

    public VideoFileRenderer(String charSequence, int n2, int n3, final EglBase.Context context) throws IOException {
        if (n2 % 2 != 1 && n3 % 2 != 1) {
            FileOutputStream fileOutputStream;
            int n4;
            this.outputFileName = charSequence;
            this.outputFileWidth = n2;
            this.outputFileHeight = n3;
            this.outputFrameSize = n4 = n2 * n3 * 3 / 2;
            this.outputFrameBuffer = ByteBuffer.allocateDirect(n4);
            this.videoOutFile = fileOutputStream = new FileOutputStream((String)charSequence);
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("YUV4MPEG2 C420 W");
            ((StringBuilder)charSequence).append(n2);
            ((StringBuilder)charSequence).append(" H");
            ((StringBuilder)charSequence).append(n3);
            ((StringBuilder)charSequence).append(" Ip F30:1 A1:1\n");
            fileOutputStream.write(((StringBuilder)charSequence).toString().getBytes(Charset.forName("US-ASCII")));
            charSequence = new HandlerThread("VideoFileRendererRenderThread");
            this.renderThread = charSequence;
            charSequence.start();
            this.renderThreadHandler = new Handler(this.renderThread.getLooper());
            charSequence = new HandlerThread("VideoFileRendererFileThread");
            this.fileThread = charSequence;
            charSequence.start();
            this.fileThreadHandler = new Handler(this.fileThread.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

                @Override
                public void run() {
                    VideoFileRenderer.access$002(VideoFileRenderer.this, EglBase$_CC.create(context, EglBase.CONFIG_PIXEL_BUFFER));
                    VideoFileRenderer.this.eglBase.createDummyPbufferSurface();
                    VideoFileRenderer.this.eglBase.makeCurrent();
                    VideoFileRenderer.access$102(VideoFileRenderer.this, new YuvConverter());
                }
            });
            return;
        }
        throw new IllegalArgumentException("Does not support uneven width or height");
    }

    static /* synthetic */ EglBase access$002(VideoFileRenderer videoFileRenderer, EglBase eglBase) {
        videoFileRenderer.eglBase = eglBase;
        return eglBase;
    }

    static /* synthetic */ YuvConverter access$102(VideoFileRenderer videoFileRenderer, YuvConverter yuvConverter) {
        videoFileRenderer.yuvConverter = yuvConverter;
        return yuvConverter;
    }

    private void renderFrameOnRenderThread(VideoFrame videoFrame) {
        VideoFrame.Buffer buffer = videoFrame.getBuffer();
        int n2 = videoFrame.getRotation() % 180 == 0 ? this.outputFileWidth : this.outputFileHeight;
        int n3 = videoFrame.getRotation() % 180 == 0 ? this.outputFileHeight : this.outputFileWidth;
        float f3 = (float)buffer.getWidth() / (float)buffer.getHeight();
        float f4 = (float)n2 / (float)n3;
        int n4 = buffer.getWidth();
        int n5 = buffer.getHeight();
        if (f4 > f3) {
            n5 = (int)((float)n5 * (f3 / f4));
        } else {
            n4 = (int)((float)n4 * (f4 / f3));
        }
        buffer = buffer.cropAndScale((buffer.getWidth() - n4) / 2, (buffer.getHeight() - n5) / 2, n4, n5, n2, n3);
        videoFrame.release();
        VideoFrame.I420Buffer i420Buffer = buffer.toI420();
        buffer.release();
        this.fileThreadHandler.post((Runnable)new _$.Lambda.VideoFileRenderer.zRQe0q8wC2jUCR9Cw2PQybfFSuQ(this, i420Buffer, videoFrame));
    }

    public /* synthetic */ void lambda$onFrame$0$VideoFileRenderer(VideoFrame videoFrame) {
        this.renderFrameOnRenderThread(videoFrame);
    }

    public /* synthetic */ void lambda$release$2$VideoFileRenderer(CountDownLatch countDownLatch) {
        this.yuvConverter.release();
        this.eglBase.release();
        this.renderThread.quit();
        countDownLatch.countDown();
    }

    public /* synthetic */ void lambda$release$3$VideoFileRenderer() {
        try {
            this.videoOutFile.close();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Video written to disk as ");
            stringBuilder.append(this.outputFileName);
            stringBuilder.append(". The number of frames is ");
            stringBuilder.append(this.frameCount);
            stringBuilder.append(" and the dimensions of the frames are ");
            stringBuilder.append(this.outputFileWidth);
            stringBuilder.append("x");
            stringBuilder.append(this.outputFileHeight);
            stringBuilder.append(".");
            Logging.d(TAG, stringBuilder.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error closing output file", iOException);
        }
        this.fileThread.quit();
    }

    public /* synthetic */ void lambda$renderFrameOnRenderThread$1$VideoFileRenderer(VideoFrame.I420Buffer i420Buffer, VideoFrame videoFrame) {
        YuvHelper.I420Rotate(i420Buffer.getDataY(), i420Buffer.getStrideY(), i420Buffer.getDataU(), i420Buffer.getStrideU(), i420Buffer.getDataV(), i420Buffer.getStrideV(), this.outputFrameBuffer, i420Buffer.getWidth(), i420Buffer.getHeight(), videoFrame.getRotation());
        i420Buffer.release();
        try {
            this.videoOutFile.write("FRAME\n".getBytes(Charset.forName("US-ASCII")));
            this.videoOutFile.write(this.outputFrameBuffer.array(), this.outputFrameBuffer.arrayOffset(), this.outputFrameSize);
            ++this.frameCount;
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error writing video to disk", iOException);
        }
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        videoFrame.retain();
        this.renderThreadHandler.post((Runnable)new _$.Lambda.VideoFileRenderer.bKgq7kthmTRkJZ0wD92QUSGMogk(this, videoFrame));
    }

    public void release() {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.renderThreadHandler.post((Runnable)new _$.Lambda.VideoFileRenderer.O3_FJr8jIW3Oq5g0_9C_SlJYw9E(this, countDownLatch));
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        this.fileThreadHandler.post((Runnable)new _$.Lambda.VideoFileRenderer._Z_EOR6W5DmTV8ot_2YxFLur_yE(this));
        try {
            this.fileThread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            Logging.e(TAG, "Interrupted while waiting for the write to disk to complete.", interruptedException);
        }
    }
}

