/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.EncodedImage;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoFrame;

public interface VideoEncoder {
    @CalledByNative
    public long createNativeVideoEncoder();

    @CalledByNative
    public VideoCodecStatus encode(VideoFrame var1, EncodeInfo var2);

    @CalledByNative
    public String getImplementationName();

    @CalledByNative
    public ResolutionBitrateLimits[] getResolutionBitrateLimits();

    @CalledByNative
    public ScalingSettings getScalingSettings();

    @CalledByNative
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    @CalledByNative
    public boolean isHardwareEncoder();

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus setRateAllocation(BitrateAllocation var1, int var2);

    public static class BitrateAllocation {
        public final int[][] bitratesBbs;

        @CalledByNative(value="BitrateAllocation")
        public BitrateAllocation(int[][] nArray) {
            this.bitratesBbs = nArray;
        }

        public int getSum() {
            int[][] nArray = this.bitratesBbs;
            int n2 = nArray.length;
            int n3 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                int[] nArray2 = nArray[i3];
                int n4 = nArray2.length;
                for (int i4 = 0; i4 < n4; ++i4) {
                    n3 += nArray2[i4];
                }
            }
            return n3;
        }
    }

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, CodecSpecificInfo var2);
    }

    public static class Capabilities {
        public final boolean lossNotification;

        @CalledByNative(value="Capabilities")
        public Capabilities(boolean bl) {
            this.lossNotification = bl;
        }
    }

    public static class CodecSpecificInfo {
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class EncodeInfo {
        public final EncodedImage.FrameType[] frameTypes;

        @CalledByNative(value="EncodeInfo")
        public EncodeInfo(EncodedImage.FrameType[] frameTypeArray) {
            this.frameTypes = frameTypeArray;
        }
    }

    public static class ResolutionBitrateLimits {
        public final int frameSizePixels;
        public final int maxBitrateBps;
        public final int minBitrateBps;
        public final int minStartBitrateBps;

        public ResolutionBitrateLimits(int n2, int n3, int n4, int n5) {
            this.frameSizePixels = n2;
            this.minStartBitrateBps = n3;
            this.minBitrateBps = n4;
            this.maxBitrateBps = n5;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getFrameSizePixels() {
            return this.frameSizePixels;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getMaxBitrateBps() {
            return this.maxBitrateBps;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getMinBitrateBps() {
            return this.minBitrateBps;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getMinStartBitrateBps() {
            return this.minStartBitrateBps;
        }
    }

    public static class ScalingSettings {
        public static final ScalingSettings OFF = new ScalingSettings();
        public final Integer high;
        public final Integer low;
        public final boolean on;

        private ScalingSettings() {
            this.on = false;
            this.low = null;
            this.high = null;
        }

        public ScalingSettings(int n2, int n3) {
            this.on = true;
            this.low = n2;
            this.high = n3;
        }

        @Deprecated
        public ScalingSettings(boolean bl) {
            this.on = bl;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean bl, int n2, int n3) {
            this.on = bl;
            this.low = n2;
            this.high = n3;
        }

        public String toString() {
            CharSequence charSequence;
            if (this.on) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("[ ");
                ((StringBuilder)charSequence).append(this.low);
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(this.high);
                ((StringBuilder)charSequence).append(" ]");
                charSequence = ((StringBuilder)charSequence).toString();
            } else {
                charSequence = "OFF";
            }
            return charSequence;
        }
    }

    public static class Settings {
        public final boolean automaticResizeOn;
        public final Capabilities capabilities;
        public final int height;
        public final int maxFramerate;
        public final int numberOfCores;
        public final int numberOfSimulcastStreams;
        public final int startBitrate;
        public final int width;

        @Deprecated
        public Settings(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
            this(n2, n3, n4, n5, n6, n7, bl, new Capabilities(false));
        }

        @CalledByNative(value="Settings")
        public Settings(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, Capabilities capabilities) {
            this.numberOfCores = n2;
            this.width = n3;
            this.height = n4;
            this.startBitrate = n5;
            this.maxFramerate = n6;
            this.numberOfSimulcastStreams = n7;
            this.automaticResizeOn = bl;
            this.capabilities = capabilities;
        }
    }
}

