/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

public class TimestampAligner {
    private volatile long nativeTimestampAligner = TimestampAligner.nativeCreateTimestampAligner();

    private void checkNativeAlignerExists() {
        if (this.nativeTimestampAligner != 0L) {
            return;
        }
        throw new IllegalStateException("TimestampAligner has been disposed.");
    }

    public static long getRtcTimeNanos() {
        return TimestampAligner.nativeRtcTimeNanos();
    }

    private static native long nativeCreateTimestampAligner();

    private static native void nativeReleaseTimestampAligner(long var0);

    private static native long nativeRtcTimeNanos();

    private static native long nativeTranslateTimestamp(long var0, long var2);

    public void dispose() {
        this.checkNativeAlignerExists();
        TimestampAligner.nativeReleaseTimestampAligner(this.nativeTimestampAligner);
        this.nativeTimestampAligner = 0L;
    }

    public long translateTimestamp(long l3) {
        this.checkNativeAlignerExists();
        return TimestampAligner.nativeTranslateTimestamp(this.nativeTimestampAligner, l3);
    }
}

