/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    public static void awaitUninterruptibly(final CountDownLatch countDownLatch) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                countDownLatch.await();
            }
        });
    }

    public static boolean awaitUninterruptibly(CountDownLatch countDownLatch, long l3) {
        long l4 = SystemClock.elapsedRealtime();
        boolean bl = false;
        long l5 = l3;
        boolean bl2 = false;
        while (true) {
            try {
                boolean bl3;
                bl = bl3 = countDownLatch.await(l5, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                long l6;
                boolean bl4 = true;
                bl2 = true;
                l5 = l6 = l3 - (SystemClock.elapsedRealtime() - l4);
                if (l6 > 0L) continue;
                bl2 = bl4;
            }
            break;
        }
        if (bl2) {
            Thread.currentThread().interrupt();
        }
        return bl;
    }

    public static void checkIsOnMainThread() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            return;
        }
        throw new IllegalStateException("Not on main thread!");
    }

    static StackTraceElement[] concatStackTraces(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[stackTraceElementArray.length + stackTraceElementArray2.length];
        System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray3, 0, stackTraceElementArray.length);
        System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, stackTraceElementArray.length, stackTraceElementArray2.length);
        return stackTraceElementArray3;
    }

    public static void executeUninterruptibly(BlockingOperation blockingOperation) {
        boolean bl = false;
        while (true) {
            try {
                blockingOperation.run();
                if (bl) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                continue;
            }
            break;
        }
    }

    public static <V> V invokeAtFrontUninterruptibly(Handler object, Callable<V> callable) {
        if (object.getLooper().getThread() == Thread.currentThread()) {
            try {
                object = callable.call();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return (V)object;
        }
        Object object2 = new Object(){
            public V value;
        };
        Object object3 = new Object(){
            Exception e;
        };
        CountDownLatch countDownLatch = new CountDownLatch(1);
        object.post(new Runnable(object2, callable, object3, countDownLatch){
            final /* synthetic */ CountDownLatch val$barrier;
            final /* synthetic */ Callable val$callable;
            final /* synthetic */ 1CaughtException val$caughtException;
            final /* synthetic */ 1Result val$result;
            {
                this.val$result = result;
                this.val$callable = callable;
                this.val$caughtException = caughtException;
                this.val$barrier = countDownLatch;
            }

            @Override
            public void run() {
                try {
                    this.val$result.value = this.val$callable.call();
                }
                catch (Exception exception) {
                    this.val$caughtException.e = exception;
                }
                this.val$barrier.countDown();
            }
        });
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        if (object3.e == null) {
            return object2.value;
        }
        object = new RuntimeException(object3.e);
        ((Throwable)object).setStackTrace(ThreadUtils.concatStackTraces(object3.e.getStackTrace(), ((Throwable)object).getStackTrace()));
        throw object;
    }

    public static void invokeAtFrontUninterruptibly(Handler handler, final Runnable runnable) {
        ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<Void>(){

            @Override
            public Void call() {
                runnable.run();
                return null;
            }
        });
    }

    public static void joinUninterruptibly(final Thread thread) {
        ThreadUtils.executeUninterruptibly(new BlockingOperation(){

            @Override
            public void run() throws InterruptedException {
                thread.join();
            }
        });
    }

    public static boolean joinUninterruptibly(Thread thread, long l3) {
        long l4 = SystemClock.elapsedRealtime();
        boolean bl = false;
        long l5 = l3;
        while (l5 > 0L) {
            try {
                thread.join(l5);
                break;
            }
            catch (InterruptedException interruptedException) {
                l5 = l3 - (SystemClock.elapsedRealtime() - l4);
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        return thread.isAlive() ^ true;
    }

    public static interface BlockingOperation {
        public void run() throws InterruptedException;
    }

    public static class ThreadChecker {
        private Thread thread = Thread.currentThread();

        public void checkIsOnValidThread() {
            if (this.thread == null) {
                this.thread = Thread.currentThread();
            }
            if (Thread.currentThread() == this.thread) {
                return;
            }
            throw new IllegalStateException("Wrong thread");
        }

        public void detachThread() {
            this.thread = null;
        }
    }
}

