/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import android.os.Handler;
import org.webrtc.RefCountDelegate;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;
import org.webrtc._$;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int height;
    private final int id;
    private final RefCountDelegate refCountDelegate;
    private final RefCountMonitor refCountMonitor;
    private final Handler toI420Handler;
    private final Matrix transformMatrix;
    private final VideoFrame.TextureBuffer.Type type;
    private final int unscaledHeight;
    private final int unscaledWidth;
    private final int width;
    private final YuvConverter yuvConverter;

    private TextureBufferImpl(int n2, int n3, int n4, int n5, VideoFrame.TextureBuffer.Type type, int n6, Matrix matrix, Handler handler, YuvConverter yuvConverter, RefCountMonitor refCountMonitor) {
        this.unscaledWidth = n2;
        this.unscaledHeight = n3;
        this.width = n4;
        this.height = n5;
        this.type = type;
        this.id = n6;
        this.transformMatrix = matrix;
        this.toI420Handler = handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate((Runnable)new _$.Lambda.TextureBufferImpl.UysfDmDl6RDIIv1f8uPEPSGq3m4(this, refCountMonitor));
        this.refCountMonitor = refCountMonitor;
    }

    public TextureBufferImpl(int n2, int n3, VideoFrame.TextureBuffer.Type type, int n4, Matrix matrix, Handler handler, YuvConverter yuvConverter, final Runnable runnable) {
        this(n2, n3, n2, n3, type, n4, matrix, handler, yuvConverter, new RefCountMonitor(){

            @Override
            public void onDestroy(TextureBufferImpl object) {
                object = runnable;
                if (object != null) {
                    object.run();
                }
            }

            @Override
            public void onRelease(TextureBufferImpl textureBufferImpl) {
            }

            @Override
            public void onRetain(TextureBufferImpl textureBufferImpl) {
            }
        });
    }

    TextureBufferImpl(int n2, int n3, VideoFrame.TextureBuffer.Type type, int n4, Matrix matrix, Handler handler, YuvConverter yuvConverter, RefCountMonitor refCountMonitor) {
        this(n2, n3, n2, n3, type, n4, matrix, handler, yuvConverter, refCountMonitor);
    }

    private TextureBufferImpl applyTransformMatrix(Matrix matrix, int n2, int n3, int n4, int n5) {
        Matrix matrix2 = new Matrix(this.transformMatrix);
        matrix2.preConcat(matrix);
        this.retain();
        return new TextureBufferImpl(n2, n3, n4, n5, this.type, this.id, matrix2, this.toI420Handler, this.yuvConverter, new RefCountMonitor(){

            @Override
            public void onDestroy(TextureBufferImpl textureBufferImpl) {
                TextureBufferImpl.this.release();
            }

            @Override
            public void onRelease(TextureBufferImpl textureBufferImpl) {
                TextureBufferImpl.this.refCountMonitor.onRelease(TextureBufferImpl.this);
            }

            @Override
            public void onRetain(TextureBufferImpl textureBufferImpl) {
                TextureBufferImpl.this.refCountMonitor.onRetain(TextureBufferImpl.this);
            }
        });
    }

    public TextureBufferImpl applyTransformMatrix(Matrix matrix, int n2, int n3) {
        return this.applyTransformMatrix(matrix, n2, n3, n2, n3);
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int n2, int n3, int n4, int n5, int n6, int n7) {
        Matrix matrix = new Matrix();
        int n8 = this.height;
        matrix.preTranslate((float)n2 / (float)this.width, (float)(n8 - (n3 + n5)) / (float)n8);
        matrix.preScale((float)n4 / (float)this.width, (float)n5 / (float)this.height);
        return this.applyTransformMatrix(matrix, Math.round((float)(this.unscaledWidth * n4) / (float)this.width), Math.round((float)(this.unscaledHeight * n5) / (float)this.height), n6, n7);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    public Handler getToI420Handler() {
        return this.toI420Handler;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    public int getUnscaledHeight() {
        return this.unscaledHeight;
    }

    public int getUnscaledWidth() {
        return this.unscaledWidth;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public YuvConverter getYuvConverter() {
        return this.yuvConverter;
    }

    public /* synthetic */ void lambda$new$0$TextureBufferImpl(RefCountMonitor refCountMonitor) {
        refCountMonitor.onDestroy(this);
    }

    public /* synthetic */ VideoFrame.I420Buffer lambda$toI420$1$TextureBufferImpl() throws Exception {
        return this.yuvConverter.convert(this);
    }

    @Override
    public void release() {
        this.refCountMonitor.onRelease(this);
        this.refCountDelegate.release();
    }

    @Override
    public void retain() {
        this.refCountMonitor.onRetain(this);
        this.refCountDelegate.retain();
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, new _$.Lambda.TextureBufferImpl.TZEswaLGgZwDMhjqZ7fKbQLvLlQ(this));
    }

    static interface RefCountMonitor {
        public void onDestroy(TextureBufferImpl var1);

        public void onRelease(TextureBufferImpl var1);

        public void onRetain(TextureBufferImpl var1);
    }
}

