/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.GlRectDrawer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceEglRenderer;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc._$;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
VideoSink,
RendererCommon.RendererEvents {
    private static final String TAG = "SurfaceViewRenderer";
    private final SurfaceEglRenderer eglRenderer;
    private boolean enableFixedSize;
    private RendererCommon.RendererEvents rendererEvents;
    private final String resourceName;
    private int rotatedFrameHeight;
    private int rotatedFrameWidth;
    private int surfaceHeight;
    private int surfaceWidth;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();

    public SurfaceViewRenderer(Context object) {
        super(object);
        object = this.getResourceName();
        this.resourceName = object;
        this.eglRenderer = new SurfaceEglRenderer((String)object);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    public SurfaceViewRenderer(Context object, AttributeSet attributeSet) {
        super(object, attributeSet);
        object = this.getResourceName();
        this.resourceName = object;
        this.eglRenderer = new SurfaceEglRenderer((String)object);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    private String getResourceName() {
        try {
            String string2 = this.getResources().getResourceEntryName(this.getId());
            return string2;
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    private void logD(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.resourceName);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        Logging.d(TAG, stringBuilder.toString());
    }

    private void postOrRun(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.post(runnable);
        }
    }

    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            int n2 = this.rotatedFrameWidth;
            float f3 = n2;
            int n3 = this.rotatedFrameHeight;
            float f4 = (float)this.getWidth() / (float)this.getHeight();
            if (f3 / (float)n3 > f4) {
                n2 = (int)((float)n3 * f4);
            } else {
                n3 = (int)((float)n2 / f4);
            }
            n2 = Math.min(this.getWidth(), n2);
            n3 = Math.min(this.getHeight(), n3);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("updateSurfaceSize. Layout size: ");
            stringBuilder.append(this.getWidth());
            stringBuilder.append("x");
            stringBuilder.append(this.getHeight());
            stringBuilder.append(", frame size: ");
            stringBuilder.append(this.rotatedFrameWidth);
            stringBuilder.append("x");
            stringBuilder.append(this.rotatedFrameHeight);
            stringBuilder.append(", requested surface size: ");
            stringBuilder.append(n2);
            stringBuilder.append("x");
            stringBuilder.append(n3);
            stringBuilder.append(", old surface size: ");
            stringBuilder.append(this.surfaceWidth);
            stringBuilder.append("x");
            stringBuilder.append(this.surfaceHeight);
            this.logD(stringBuilder.toString());
            if (n2 != this.surfaceWidth || n3 != this.surfaceHeight) {
                this.surfaceWidth = n2;
                this.surfaceHeight = n3;
                this.getHolder().setFixedSize(n2, n3);
            }
        } else {
            this.surfaceHeight = 0;
            this.surfaceWidth = 0;
            this.getHolder().setSizeFromLayout();
        }
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f3) {
        this.eglRenderer.addFrameListener(frameListener, f3);
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f3, RendererCommon.GlDrawer glDrawer) {
        this.eglRenderer.addFrameListener(frameListener, f3, glDrawer);
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents) {
        this.init(context, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(context, this, nArray, glDrawer);
    }

    public /* synthetic */ void lambda$onFrameResolutionChanged$0$SurfaceViewRenderer(int n2, int n3) {
        this.rotatedFrameWidth = n2;
        this.rotatedFrameHeight = n3;
        this.updateSurfaceSize();
        this.requestLayout();
    }

    @Override
    public void onFirstFrameRendered() {
        RendererCommon.RendererEvents rendererEvents = this.rendererEvents;
        if (rendererEvents != null) {
            rendererEvents.onFirstFrameRendered();
        }
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        this.eglRenderer.onFrame(videoFrame);
    }

    @Override
    public void onFrameResolutionChanged(int n2, int n3, int n4) {
        RendererCommon.RendererEvents rendererEvents = this.rendererEvents;
        if (rendererEvents != null) {
            rendererEvents.onFrameResolutionChanged(n2, n3, n4);
        }
        int n5 = n4 != 0 && n4 != 180 ? n3 : n2;
        if (n4 == 0 || n4 == 180) {
            n2 = n3;
        }
        this.postOrRun((Runnable)new _$.Lambda.SurfaceViewRenderer.NznHhISA8bkJ9U8moGf2KoEdee4(this, n5, n2));
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(n4 - n2) / (float)(n5 - n3));
        this.updateSurfaceSize();
    }

    protected void onMeasure(int n2, int n3) {
        ThreadUtils.checkIsOnMainThread();
        Point point = this.videoLayoutMeasure.measure(n2, n3, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.setMeasuredDimension(point.x, point.y);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("onMeasure(). New size: ");
        stringBuilder.append(point.x);
        stringBuilder.append("x");
        stringBuilder.append(point.y);
        this.logD(stringBuilder.toString());
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    public void release() {
        this.eglRenderer.release();
    }

    public void removeFrameListener(EglRenderer.FrameListener frameListener) {
        this.eglRenderer.removeFrameListener(frameListener);
    }

    public void setEnableHardwareScaler(boolean bl) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = bl;
        this.updateSurfaceSize();
    }

    public void setFpsReduction(float f3) {
        this.eglRenderer.setFpsReduction(f3);
    }

    public void setMirror(boolean bl) {
        this.eglRenderer.setMirror(bl);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType);
        this.requestLayout();
    }

    public void setScalingType(RendererCommon.ScalingType scalingType, RendererCommon.ScalingType scalingType2) {
        ThreadUtils.checkIsOnMainThread();
        this.videoLayoutMeasure.setScalingType(scalingType, scalingType2);
        this.requestLayout();
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
    }
}

